/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it20;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.lte.rbs.omf.aue.step1.AbstractStep1ConversionAction;

public class AddMissingLdnInReferencesAction
extends AbstractStep1ConversionAction {
    private static final String ARRAY_END_TAG = "</array>";
    private static final String MOREF_END_TAG = "</moref>";
    private static final Class THIS_CLASS = AddMissingLdnInReferencesAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String MO_REF_MOM_TYPE = "moref";
    private final Map froTypeToFroTypeNameMap = new HashMap();
    private final Map froTypeNameToFroIdToLdnMap = new HashMap();
    private int noOfCorrectedReferences = 0;

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        FroVersionsData[] froVersionsDataArray = tableHandler.getFroVersionsTable().getDatas();
        this.initFroTypeToFroTypeNameMap(froVersionsDataArray);
        String string = "";
        for (int i = 0; i < froVersionsDataArray.length; ++i) {
            string = froVersionsDataArray[i].froTypeName;
            TableData tableData = this.getTableData(tableHandler, string);
            if (!tableData.isNotEmpty()) continue;
            this.handleOneMoType(tableHandler, string, tableData);
        }
        logger.traceReturn(THIS_CLASS, "convert has corrected " + this.noOfCorrectedReferences + " references in the FRO database.");
    }

    private void initFroTypeToFroTypeNameMap(FroVersionsData[] froVersionsDataArray) {
        for (int i = 0; i < froVersionsDataArray.length; ++i) {
            this.froTypeToFroTypeNameMap.put(Integer.toString(froVersionsDataArray[i].froType), froVersionsDataArray[i].froTypeName);
        }
    }

    private void handleOneMoType(TableHandler tableHandler, String string, TableData tableData) throws CrbsAueException {
        String[] stringArray = tableData.getAttributeNames();
        String string2 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            Object[] objectArray;
            try {
                string2 = tableData.getMomType(stringArray[i]);
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException("Could not get mom type name for: " + stringArray[i], (Throwable)tableDataException);
            }
            if (MO_REF_MOM_TYPE.equals(string2)) {
                objectArray = this.getAttributeColumn(tableData, string, stringArray[i]);
                this.handleOneAttribute(tableHandler, tableData, string, objectArray, stringArray[i]);
            } else if ("sectorCarrierRef".equals(stringArray[i]) && ("EUtranCellFDD".equals(string) || "EUtranCellTDD".equals(string))) {
                objectArray = this.getAttributeColumn(tableData, string, stringArray[i]);
                this.handleOneArrayOfRefsAttribute(tableHandler, tableData, string, objectArray, stringArray[i]);
            }
            this.froTypeNameToFroIdToLdnMap.clear();
        }
    }

    private void handleOneArrayOfRefsAttribute(TableHandler tableHandler, TableData tableData, String string, Object[] objectArray, String string2) throws CrbsAueException {
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                String string3 = (String)objectArray[i];
                String string4 = this.removeArrayPrefixAndSuffix(string, string2, string3);
                List list = this.getMoRefList(string4);
                String string5 = "";
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string6 = (String)iterator.next();
                    int n = string6.indexOf("<attr name=\"ldn\"");
                    if (n < 0) {
                        String string7 = this.handleOnXmlMoRef(tableHandler, string, string2, string6);
                        string5 = string5 + this.createRefXmlWithLdn(string6, string7);
                        ++this.noOfCorrectedReferences;
                        continue;
                    }
                    string5 = string5 + string6;
                }
                tableData.setAttributeValue(i, string2, (Object)("<array name=\"" + string2 + "\">" + string5 + ARRAY_END_TAG));
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not setAttributes for " + string + "::" + string2, (Throwable)tableDataException);
        }
    }

    private List getMoRefList(String string) {
        String string2 = string;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (string2.indexOf("<moref>") > -1) {
            int n = string2.indexOf(MOREF_END_TAG);
            arrayList.add(string2.substring(0, n + MOREF_END_TAG.length()));
            string2 = string2.substring(n + MOREF_END_TAG.length());
        }
        return arrayList;
    }

    private String removeArrayPrefixAndSuffix(String string, String string2, String string3) throws CrbsAueException {
        String string4 = "<array name=\"" + string2 + "\">";
        int n = string3.indexOf(string4);
        if (n == -1) {
            throw new CrbsAueException("Could not find array start tag in " + string + "::" + string2 + " : " + string3);
        }
        String string5 = string3.substring(n + string4.length());
        int n2 = string5.indexOf(ARRAY_END_TAG);
        if (n2 == -1) {
            throw new CrbsAueException("Could not find array end tag in " + string + "::" + string2 + " : " + string3);
        }
        String string6 = string5.substring(0, n2);
        return string6;
    }

    private void handleOneAttribute(TableHandler tableHandler, TableData tableData, String string, Object[] objectArray, String string2) throws CrbsAueException {
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                String string3 = (String)objectArray[i];
                int n = string3.indexOf("<attr name=\"ldn\"");
                if (n >= 0) continue;
                String string4 = this.handleOnXmlMoRef(tableHandler, string, string2, string3);
                String string5 = this.createRefXmlWithLdn(string3, string4);
                tableData.setAttributeValue(i, string2, (Object)string5);
                ++this.noOfCorrectedReferences;
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not setAttributes for " + string + "::" + string2, (Throwable)tableDataException);
        }
    }

    private String handleOnXmlMoRef(TableHandler tableHandler, String string, String string2, String string3) throws CrbsAueException {
        String string4;
        String string5;
        String string6 = this.getValueOfXmlTagInMoRef(string3, "froType", string, string2);
        String string7 = this.getFroTypeNameForRef(string, string2, string6, string5 = this.getValueOfXmlTagInMoRef(string3, "froId", string, string2));
        Map map = (Map)this.froTypeNameToFroIdToLdnMap.get(string7);
        if (map == null) {
            map = this.createFroIdToLdnMap(tableHandler, string7);
            this.froTypeNameToFroIdToLdnMap.put(string7, map);
        }
        if ((string4 = (String)map.get(Integer.valueOf(string5))) == null) {
            throw new CrbsAueException("Could not find froId " + string5 + " in " + string7 + " table, reference: " + string3);
        }
        return string4;
    }

    private String getFroTypeNameForRef(String string, String string2, String string3, String string4) throws CrbsAueException {
        String string5 = (String)this.froTypeToFroTypeNameMap.get(string3);
        if (this.isAttrParentRefInExternalENodeBFunctionOrEUtranFrequency(string2, string)) {
            string5 = this.updateFroTypeNameToFroIdToLdnMapForEUtraNetwork();
        } else if (this.isAttrParentRefInENodeBFunction(string2, string)) {
            string5 = this.updateFroTypeNameToFroIdToLdnMapForManagedElement();
        } else if ("-1".equals(string3) && "-1".equals(string4)) {
            string5 = this.updateFroTypeNameToFroIdToLdnMapForDefaultRef();
        } else if (string5 == null) {
            throw new CrbsAueException(string + "::" + string2 + ", could not find froTypeName in fro_versions for froType: " + string3);
        }
        return string5;
    }

    private boolean isAttrParentRefInENodeBFunction(String string, String string2) {
        return "parentRef".equals(string) && "ENodeBFunction".equals(string2);
    }

    private boolean isAttrParentRefInExternalENodeBFunctionOrEUtranFrequency(String string, String string2) {
        return "parentRef".equals(string) && ("EUtranFrequency".equals(string2) || "ExternalENodeBFunction".equals(string2));
    }

    private String updateFroTypeNameToFroIdToLdnMapForDefaultRef() {
        String string = "#DefaultRef#";
        HashMap<Integer, String> hashMap = (HashMap<Integer, String>)this.froTypeNameToFroIdToLdnMap.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<Integer, String>();
            hashMap.put(new Integer(-1), "");
            this.froTypeNameToFroIdToLdnMap.put(string, hashMap);
        }
        return string;
    }

    private String updateFroTypeNameToFroIdToLdnMapForEUtraNetwork() {
        String string = "EUtraNetwork";
        HashMap<Integer, String> hashMap = (HashMap<Integer, String>)this.froTypeNameToFroIdToLdnMap.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<Integer, String>();
            hashMap.put(new Integer(-1), "ManagedElement=1,ENodeBFunction=1,EUtraNetwork=1");
            this.froTypeNameToFroIdToLdnMap.put(string, hashMap);
        }
        return string;
    }

    private String updateFroTypeNameToFroIdToLdnMapForManagedElement() {
        String string = "ManagedElement";
        HashMap<Integer, String> hashMap = (HashMap<Integer, String>)this.froTypeNameToFroIdToLdnMap.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<Integer, String>();
            hashMap.put(new Integer(0), "ManagedElement=1");
            this.froTypeNameToFroIdToLdnMap.put(string, hashMap);
        }
        return string;
    }

    private String createRefXmlWithLdn(String string, String string2) {
        int n = string.indexOf(62);
        return string.substring(0, n + 1) + "<attr name=\"ldn\" type=\"STRING\" value=\"" + string2 + "\"/>" + string.substring(n + 1);
    }

    private Map createFroIdToLdnMap(TableHandler tableHandler, String string) throws CrbsAueException {
        HashMap<Object, Object> hashMap;
        TableData tableData = this.getTableData(tableHandler, string);
        if (tableData.isNotEmpty()) {
            Object[] objectArray = this.getAttributeColumn(tableData, string, "froid");
            Object[] objectArray2 = this.getAttributeColumn(tableData, string, "ldn");
            hashMap = new HashMap<Object, Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                hashMap.put(objectArray[i], objectArray2[i]);
            }
        } else {
            throw new CrbsAueException("Table empty for froType: " + string + ", cannot find ldn for froId in reference.");
        }
        return hashMap;
    }

    private String getValueOfXmlTagInMoRef(String string, String string2, String string3, String string4) throws CrbsAueException {
        String string5 = "name=\"" + string2 + "\" type=\"S32\" value=\"";
        int n = string.indexOf(string5);
        if (n == -1) {
            throw new CrbsAueException("Could not find " + string2 + " in mo ref (" + string3 + "::" + string4 + "): " + string);
        }
        int n2 = n + string5.length();
        int n3 = string.indexOf("\"/>", n2);
        return string.substring(n2, n3);
    }
}

