/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it20;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class ConvertCdma1xRttCellIdAction
extends AbstractConversionAction {
    private static final String STRUCT_MEMBER_SECTOR_NUMBER = "sectorNumber";
    private static final String STRUCT_MEMBER_CELL_ID = "cellId";
    private static final String ATTRIBUTE_CELL_IDENTIFIER = "cellIdentifier";
    private static final int STRUCT_ATTRIBUTE_CELL_ID_MAX_VALUE = 4095;
    private static final int STRUCT_ATTRIBUTE_CELL_ID_DECREASE_VALUE = 4096;
    private static final int STRUCT_ATTRIBUTE_SECTOR_NUMBER_MAX_VALUE = 15;
    private static final int STRUCT_ATTRIBUTE_SECTOR_NUMBER_INCREASE_VALUE = 8;
    private static final Class THIS_CLASS = ConvertCdma1xRttCellIdAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        String string = this.getMoTypeToOperateOn();
        TableData tableData = this.getTableData(tableHandler, string);
        if (tableData.isNotEmpty()) {
            Object[] objectArray = this.getAttributeColumn(tableData, string, ATTRIBUTE_CELL_IDENTIFIER);
            try {
                for (int i = 0; i < objectArray.length; ++i) {
                    String string2 = objectArray[i].toString();
                    this.updateCellIdStructIfNeeded(i, tableData, string2);
                }
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException("Caugth exception:", (Throwable)tableDataException);
            }
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private String getMoTypeToOperateOn() throws CrbsAueException {
        return this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
    }

    private void updateStructValue(int n, TableData tableData, String string) throws TableDataException {
        logger.traceEnter(THIS_CLASS, "updateStructValue()");
        tableData.setAttributeValue(n, ATTRIBUTE_CELL_IDENTIFIER, (Object)string);
        logger.traceReturn(THIS_CLASS, "updateStructValue()");
    }

    private void updateCellIdStructIfNeeded(int n, TableData tableData, String string) throws TableDataException {
        logger.traceEnter(THIS_CLASS, "updateCellIdStructIfNeeded()");
        int n2 = this.getValueFromString(STRUCT_MEMBER_CELL_ID, string);
        int n3 = this.getValueFromString(STRUCT_MEMBER_SECTOR_NUMBER, string);
        if (n2 > 4095) {
            n2 -= 4096;
            if ((n3 += 8) > 15) {
                n3 = 15;
            }
            String string2 = "<struct name=\"cellIdentifier\"><attr name=\"cellId\" type=\"S32\" value=\"" + n2 + "\"/>" + "<attr name=\"sectorNumber\" type=\"S32\" value=\"" + n3 + "\"/></struct>";
            this.updateStructValue(n, tableData, string2);
        }
        logger.traceReturn(THIS_CLASS, "updateCellIdStructIfNeeded()");
    }

    private int getValueFromString(String string, String string2) {
        logger.traceEnter(THIS_CLASS, "getValueFromString()");
        int n = string2.indexOf(string);
        String string3 = string2.substring(n);
        int n2 = string3.indexOf("/>");
        String string4 = string3.substring(0, n2);
        int n3 = string4.indexOf("value=\"");
        String string5 = string4.substring(n3 + "value=\"".length());
        int n4 = Integer.parseInt(string5.replace('\"', ' ').trim());
        logger.traceReturn(THIS_CLASS, "getValueFromString(stringToFind[" + string + "] = " + n4 + ")");
        return n4;
    }

    private Object[] getAttributeColumn(TableData tableData, String string, String string2) throws CrbsAueException {
        try {
            return tableData.getAttributeValues(string2);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not get " + string + " " + string2 + " attribute value.", (Throwable)tableDataException);
        }
    }

    private TableData getTableData(TableHandler tableHandler, String string) throws CrbsAueException {
        try {
            return tableHandler.getTableData(string);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not get table data for: " + string, (Throwable)tableDataException);
        }
    }
}

