/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it20;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.actions.TableAlreadyExistsException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.TableDataUtil;

public class ConvertCr1599ToMobCtrlAtPoorCovAction
extends AbstractConversionAction {
    private static final String E_UTRAN_CELL_FDD = "EUtranCellFDD";
    private static final String E_UTRAN_CELL_TDD = "EUtranCellTDD";
    private static final String CR1599_ACTIVE = "1";
    private static final String ZZZ_TEMPORARY3 = "zzzTemporary3";
    private static final String E_NODE_B_FUNCTION = "ENodeBFunction";
    private static final Integer RSRP = new Integer(0);
    private static final String REPORT_CONFIG_E_UTRA_BAD_COV_SEC = "ReportConfigEUtraBadCovSec";
    private static final String REPORT_CONFIG_A1_PRIM = "ReportConfigA1Prim";
    private static final String REPORT_CONFIG_E_UTRA_BAD_COV_PRIM = "ReportConfigEUtraBadCovPrim";
    private static final String REPORT_CONFIG_SEARCH = "ReportConfigSearch";
    private static final String UE_MEAS_CONTROL = "UeMeasControl";
    private static final String HYSTERESIS_A2_CRITICAL_RSRQ = "hysteresisA2CriticalRsrq";
    private static final String HYSTERESIS_A1A2_SEARCH_RSRQ = "hysteresisA1A2SearchRsrq";
    private static final String A2_CRITICAL_THRESHOLD_RSRQ = "a2CriticalThresholdRsrq";
    private static final String A1A2_SEARCH_THRESHOLD_RSRQ = "a1a2SearchThresholdRsrq";
    private static final String HYSTERESIS_A2_PRIM = "hysteresisA2Prim";
    private static final String HYSTERESIS_A2_SEC = "hysteresisA2Sec";
    private static final String A2_THRESHOLD_RSRP_SEC = "a2ThresholdRsrpSec";
    private static final String HYSTERESIS_A1A2_SEARCH_RSRP = "hysteresisA1A2SearchRsrp";
    private static final String HYSTERESIS_A1_PRIM = "hysteresisA1Prim";
    private static final String A2_THRESHOLD_RSRP_PRIM = "a2ThresholdRsrpPrim";
    private static final String A1A2_SEARCH_THRESHOLD_RSRP = "a1a2SearchThresholdRsrp";
    private static final String FEATURE_STATE_MOB_CTRL_AT_POOR_COV = "featureStateMobCtrlAtPoorCov";
    private static final String MOB_CTRL_AT_POOR_COV = "MobCtrlAtPoorCov";
    private static final String A1_THRESHOLD_RSRP_PRIM = "a1ThresholdRsrpPrim";
    private static final String A2_CRITICAL_THRESHOLD_RSRP = "a2CriticalThresholdRsrp";
    private static final String HYSTERESIS_A2_CRITICAL_RSRP = "hysteresisA2CriticalRsrp";
    private static final String TRIGGER_QUANTITY_A2_SEC = "triggerQuantityA2Sec";
    private static final String TRIGGER_QUANTITY_A2_PRIM = "triggerQuantityA2Prim";
    private final Map searchMap = new HashMap();
    private final Map eUtraBadCovPrimMap = new HashMap();
    private final Map a1PrimMap = new HashMap();
    private final Map eUtraBadCovSecMap = new HashMap();
    private TableData searchTableData = null;
    private Object[] a2ThresholdRsrpPrimColumn = null;
    private Object[] hysteresisA2PrimColumn = null;
    private Object[] triggerQuantityA2PrimColumn = null;
    private Object[] hysteresisA1PrimColumn = null;
    private Object[] a1ThresholdRsrpPrimColumn = null;
    private TableData eUtraBadCovSecTableData = null;
    private Object[] a2ThresholdRsrpSecColumn = null;
    private Object[] hysteresisA2SecColumn = null;
    private Object[] triggerQuantityA2SecColumn = null;
    private static final Class THIS_CLASS = ConvertCr1599ToMobCtrlAtPoorCovAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final Integer ACTIVATED = new Integer(1);

    public void convert(AueContext aueContext) throws CrbsAueException, NoSuchTableException, TableAlreadyExistsException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String string = "";
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        if (this.cr1599IsActivated(tableHandler)) {
            try {
                string = "get table data for ReportConfigSearch";
                this.searchTableData = tableHandler.getTableData(REPORT_CONFIG_SEARCH);
                this.mapParentToRow(this.searchTableData, this.searchMap);
                string = "Reading attributes from tables ReportConfigEUtraBadCovPrim";
                TableData tableData = tableHandler.getTableData(REPORT_CONFIG_E_UTRA_BAD_COV_PRIM);
                this.mapParentToRow(tableData, this.eUtraBadCovPrimMap);
                this.a2ThresholdRsrpPrimColumn = tableData.getAttributeValues(A2_THRESHOLD_RSRP_PRIM);
                this.hysteresisA2PrimColumn = tableData.getAttributeValues(HYSTERESIS_A2_PRIM);
                this.triggerQuantityA2PrimColumn = tableData.getAttributeValues(TRIGGER_QUANTITY_A2_PRIM);
                string = "get table data for ReportConfigA1Prim";
                TableData tableData2 = tableHandler.getTableData(REPORT_CONFIG_A1_PRIM);
                this.hysteresisA1PrimColumn = tableData2.getAttributeValues(HYSTERESIS_A1_PRIM);
                this.a1ThresholdRsrpPrimColumn = tableData2.getAttributeValues(A1_THRESHOLD_RSRP_PRIM);
                this.mapParentToRow(tableData2, this.a1PrimMap);
                string = "get table data for ReportConfigEUtraBadCovSec";
                this.eUtraBadCovSecTableData = tableHandler.getTableData(REPORT_CONFIG_E_UTRA_BAD_COV_SEC);
                this.a2ThresholdRsrpSecColumn = this.eUtraBadCovSecTableData.getAttributeValues(A2_THRESHOLD_RSRP_SEC);
                this.hysteresisA2SecColumn = this.eUtraBadCovSecTableData.getAttributeValues(HYSTERESIS_A2_SEC);
                this.triggerQuantityA2SecColumn = this.eUtraBadCovSecTableData.getAttributeValues(TRIGGER_QUANTITY_A2_SEC);
                this.mapParentToRow(this.eUtraBadCovSecTableData, this.eUtraBadCovSecMap);
                Map map = this.buildShouldConvertPerCellMap(this.triggerQuantityA2PrimColumn, this.eUtraBadCovPrimMap, this.triggerQuantityA2SecColumn, this.eUtraBadCovSecMap);
                string = "get table data for UeMeasControl";
                TableData tableData3 = tableHandler.getTableData(UE_MEAS_CONTROL);
                Object[] objectArray = tableData3.getAttributeValues("ldn");
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    String string2 = (String)objectArray[i];
                    Boolean bl = (Boolean)map.get(string2);
                    if (!bl.booleanValue()) continue;
                    this.setMobCtrlAtPoorCovData(string2);
                }
                string = "get table data for MobCtrlAtPoorCov";
                TableData tableData4 = tableHandler.getTableData(MOB_CTRL_AT_POOR_COV);
                this.setMobCtrlAtPoorCovActivated(tableData4);
                string = "get table data for EUtranCellFDD or EUtranCellTDD";
                this.handleSetMobCtrlAtPoorCovActive(tableHandler, map);
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException("Caught exception when trying to " + string, (Throwable)tableDataException);
            }
        } else {
            logger.info(THIS_CLASS, " CR1599 not activated, will not convert to MobCtrlAtPoorCov");
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private Map buildShouldConvertPerCellMap(Object[] objectArray, Map map, Object[] objectArray2, Map map2) {
        HashMap hashMap = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Integer n = (Integer)map.get(k);
            Integer n2 = (Integer)map2.get(k);
            Integer n3 = (Integer)objectArray[n];
            Integer n4 = (Integer)objectArray2[n2];
            boolean bl = n3.equals(RSRP) && n4.equals(RSRP);
            hashMap.put(k, bl);
        }
        return hashMap;
    }

    private void handleSetMobCtrlAtPoorCovActive(TableHandler tableHandler, Map map) throws TableDataException {
        TableData tableData = tableHandler.getTableData(E_UTRAN_CELL_FDD);
        if (tableData != null && tableData.isNotEmpty()) {
            this.setMobCtrlAtPoorCovActiveToTrue(tableData, map);
        }
        if ((tableData = tableHandler.getTableData(E_UTRAN_CELL_TDD)) != null && tableData.isNotEmpty()) {
            this.setMobCtrlAtPoorCovActiveToTrue(tableData, map);
        }
    }

    private void setMobCtrlAtPoorCovActiveToTrue(TableData tableData, Map map) throws TableDataException {
        Map map2 = this.createCellMapFromUeMeasMap(map);
        Object[] objectArray = tableData.getAttributeValues("ldn");
        for (int i = 0; i < objectArray.length; ++i) {
            Boolean bl = (Boolean)map2.get(objectArray[i]);
            if (!bl.booleanValue()) continue;
            tableData.setAttributeValue(i, "mobCtrlAtPoorCovActive", (Object)new Integer(1));
        }
    }

    private Map createCellMapFromUeMeasMap(Map map) {
        HashMap hashMap = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = string.indexOf(",UeMeasControl");
            String string2 = string.substring(0, n);
            hashMap.put(string2, map.get(string));
        }
        return hashMap;
    }

    private boolean cr1599IsActivated(TableHandler tableHandler) throws CrbsAueException {
        boolean bl = false;
        try {
            Object[] objectArray;
            TableData tableData = tableHandler.getTableData(E_NODE_B_FUNCTION);
            if (tableData.isNotEmpty() && CR1599_ACTIVE.equalsIgnoreCase((objectArray = tableData.getAttributeValues(ZZZ_TEMPORARY3))[0].toString())) {
                bl = true;
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not get attribute zzzTemporary3 from ENodeBFunction to decide if CR1599 is activated, will not convert to MobCtrlAtPoorCov", (Throwable)tableDataException);
        }
        return bl;
    }

    private void setMobCtrlAtPoorCovData(String string) throws TableDataException {
        logger.traceEnter(THIS_CLASS, "setMobCtrlAtPoorCovData(" + string + ")");
        int n = (Integer)this.eUtraBadCovPrimMap.get(string);
        int n2 = (Integer)this.a2ThresholdRsrpPrimColumn[n];
        int n3 = (Integer)this.hysteresisA2PrimColumn[n];
        int n4 = (Integer)this.a1PrimMap.get(string);
        int n5 = (Integer)this.a1ThresholdRsrpPrimColumn[n4];
        int n6 = (Integer)this.hysteresisA1PrimColumn[n4];
        int n7 = this.calculateA1A2SearchThresholdRsrp(n2, n3, n5, n6);
        int n8 = (Integer)this.searchMap.get(string);
        this.searchTableData.setAttributeValue(n8, A1A2_SEARCH_THRESHOLD_RSRP, (Object)new Integer(n7));
        int n9 = this.calculateHysteresisA1A2SearchRsrp(n2, n3, n5, n6);
        this.searchTableData.setAttributeValue(n8, HYSTERESIS_A1A2_SEARCH_RSRP, (Object)new Integer(n9));
        int n10 = (Integer)this.eUtraBadCovSecMap.get(string);
        int n11 = (Integer)this.a2ThresholdRsrpSecColumn[n10];
        this.searchTableData.setAttributeValue(n8, A2_CRITICAL_THRESHOLD_RSRP, (Object)new Integer(n11));
        int n12 = (Integer)this.hysteresisA2SecColumn[n10];
        this.searchTableData.setAttributeValue(n8, HYSTERESIS_A2_CRITICAL_RSRP, (Object)new Integer(n12));
        this.searchTableData.setAttributeValue(n8, A1A2_SEARCH_THRESHOLD_RSRQ, (Object)new Integer(-165));
        this.searchTableData.setAttributeValue(n8, A2_CRITICAL_THRESHOLD_RSRQ, (Object)new Integer(-195));
        this.searchTableData.setAttributeValue(n8, HYSTERESIS_A1A2_SEARCH_RSRQ, (Object)new Integer(15));
        this.searchTableData.setAttributeValue(n8, HYSTERESIS_A2_CRITICAL_RSRQ, (Object)new Integer(10));
        logger.traceReturn(THIS_CLASS, "setMobCtrlAtPoorCovData()");
    }

    private int calculateHysteresisA1A2SearchRsrp(int n, int n2, int n3, int n4) {
        float f = n3 * 10 + n4;
        float f2 = n * 10 - n2;
        float f3 = (f - f2) / 2.0f;
        int n5 = Math.round(f3);
        if ((n5 = this.correctResolution(n5)) < 0) {
            n5 = 0;
        } else if (n5 > 150) {
            n5 = 150;
        }
        return n5;
    }

    private int correctResolution(int n) {
        int n2 = n % 5;
        int n3 = n2 == 0 ? n : ((double)n2 < 2.5 ? n - n2 : n + 5 - n2);
        return n3;
    }

    private int calculateA1A2SearchThresholdRsrp(int n, int n2, int n3, int n4) {
        float f = n * 10 - n2;
        float f2 = n3 * 10 + n4;
        float f3 = (f + f2) / 20.0f;
        int n5 = Math.round(f3);
        if (n5 < -140) {
            n5 = -140;
        } else if (n5 > -44) {
            n5 = -44;
        }
        return n5;
    }

    private void mapParentToRow(TableData tableData, Map map) throws CrbsAueException {
        Object[] objectArray;
        int n = tableData.getNumberOfRecords();
        try {
            objectArray = tableData.getAttributeValues("parentRef");
        }
        catch (TableDataException tableDataException) {
            String string = " Unable to get attribute column parentRef for " + tableData.getFroTypeName();
            logger.traceError(THIS_CLASS, string, (Throwable)tableDataException);
            throw new CrbsAueException(THIS_CLASS + string, (Throwable)tableDataException);
        }
        for (int i = 0; i < n; ++i) {
            String string = TableDataUtil.getLdnFromMoRef((String)((String)objectArray[i]));
            map.put(string, new Integer(i));
        }
    }

    private void setMobCtrlAtPoorCovActivated(TableData tableData) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "setMobCtrlAtPoorCovActivated()");
        try {
            tableData.setAttributeValue(0, FEATURE_STATE_MOB_CTRL_AT_POOR_COV, (Object)ACTIVATED);
        }
        catch (TableDataException tableDataException) {
            logger.traceError(THIS_CLASS, "Unable to set attribute featureStateMobCtrlAtPoorCov for a MobCtrlAtPoorCov MO.", (Throwable)tableDataException);
            throw new CrbsAueException("Unable to set attribute featureStateMobCtrlAtPoorCov for a MobCtrlAtPoorCov MO.", (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "setMobCtrlAtPoorCovActivated()");
    }
}

