/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it22;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.TableDataUtil;
import se.ericsson.lte.rbs.omf.aue.step1.AbstractStep1ConversionAction;

public class RemoveExcessiveExternalGeranCellsAction
extends AbstractStep1ConversionAction {
    private static final int MAX_NUMBER_OF_SIBLINGS_16 = 16;
    private static final Class THIS_CLASS = RemoveExcessiveExternalGeranCellsAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String EXTERNAL_GERAN_CELL_MO_TYPE = "ExternalGeranCell";
    private static final String GERAN_CELL_RELATION_MO_TYPE = "GeranCellRelation";
    private static final String EXTERNAL_GERAN_CELL_REF_COLUMN_NAME = "externalGeranCellRef";
    private static final String REMOVING_MONITORING_START_COLUMN_NAME = "removingMonitoringStart";
    private static final String AUE_PERSISTENCY_DBKEY_REMOVE_MO = "RemoveMo_";
    private TableHandler tableHandler = null;

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        this.tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        TableData tableData = this.getTableData(this.tableHandler, EXTERNAL_GERAN_CELL_MO_TYPE);
        if (tableData.isNotEmpty()) {
            Object[] objectArray = this.getAttributeColumn(tableData, EXTERNAL_GERAN_CELL_MO_TYPE, "ldn");
            Map map = this.getGeranFrequencyLdnToChildCountMap(objectArray);
            Map map2 = this.getGeranFrequencyChildMapWithChildCountGreaterThanMax(map);
            map.clear();
            if (this.isAnyGeranFrequencyHavingChildCountGreaterThanMax(map2)) {
                this.updateGeranFrequencyChildMapWithChildMaps(objectArray, map2);
                TableData tableData2 = this.getTableData(this.tableHandler, GERAN_CELL_RELATION_MO_TYPE);
                Object[] objectArray2 = null;
                if (tableData2.isNotEmpty()) {
                    objectArray2 = this.getAttributeColumn(tableData2, GERAN_CELL_RELATION_MO_TYPE, "ldn");
                    this.updateGeranFrequencyChildMapWithGeranCellRelationInfo(tableData2, objectArray2, map2);
                }
                HashMap hashMap = new HashMap();
                this.addToRemoveMapOldestWhenChildCountGreaterThanMax(map2, hashMap);
                this.removeFromFroDatabase(tableData, objectArray, tableData2, objectArray2, hashMap);
                logger.info(THIS_CLASS, "This upgrade action has removed " + hashMap.size() + " ExternalGeranCell and GeranCellRelation MOs");
            } else {
                logger.info(THIS_CLASS, "This upgrade action did not need to remove any MOs.");
            }
        }
        this.tableHandler = null;
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private Map getGeranFrequencyLdnToChildCountMap(Object[] objectArray) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        String string = "";
        String string2 = "";
        for (int i = 0; i < objectArray.length; ++i) {
            string = (String)objectArray[i];
            string2 = LdnUtil.getParentLdn((String)string);
            if (hashMap.containsKey(string2)) {
                hashMap.put(string2, new Integer((Integer)hashMap.get(string2) + 1));
                continue;
            }
            hashMap.put(string2, new Integer(1));
        }
        return hashMap;
    }

    private Map getGeranFrequencyChildMapWithChildCountGreaterThanMax(Map map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = map.keySet().iterator();
        String string = "";
        int n = 0;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            n = (Integer)map.get(string);
            if (n <= 16) continue;
            hashMap.put(string, null);
        }
        return hashMap;
    }

    private boolean isAnyGeranFrequencyHavingChildCountGreaterThanMax(Map map) {
        return !map.isEmpty();
    }

    private void updateGeranFrequencyChildMapWithChildMaps(Object[] objectArray, Map map) {
        String string = "";
        String string2 = "";
        for (int i = 0; i < objectArray.length; ++i) {
            string = (String)objectArray[i];
            string2 = LdnUtil.getParentLdn((String)string);
            if (!map.containsKey(string2)) continue;
            HashMap<String, Object> hashMap = (HashMap<String, Object>)map.get(string2);
            if (hashMap == null) {
                hashMap = new HashMap<String, Object>();
                hashMap.put(string, null);
                map.put(string2, hashMap);
                continue;
            }
            hashMap.put(string, null);
        }
    }

    private void updateGeranFrequencyChildMapWithGeranCellRelationInfo(TableData tableData, Object[] objectArray, Map map) throws CrbsAueException {
        Object[] objectArray2 = this.getAttributeColumn(tableData, GERAN_CELL_RELATION_MO_TYPE, EXTERNAL_GERAN_CELL_REF_COLUMN_NAME);
        Object[] objectArray3 = this.getAttributeColumn(tableData, GERAN_CELL_RELATION_MO_TYPE, REMOVING_MONITORING_START_COLUMN_NAME);
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        GeranCellRelation geranCellRelation = null;
        for (int i = 0; i < objectArray.length; ++i) {
            string = (String)objectArray[i];
            string2 = TableDataUtil.getLdnFromMoRef((String)((String)objectArray2[i]));
            string3 = LdnUtil.getParentLdn((String)string2);
            string4 = (String)objectArray3[i];
            geranCellRelation = new GeranCellRelation(string, string4, string2);
            Map map2 = (Map)map.get(string3);
            if (map2 == null || !map2.containsKey(string2)) continue;
            map2.put(string2, geranCellRelation);
        }
    }

    private void addToRemoveMapOldestWhenChildCountGreaterThanMax(Map map, Map map2) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Map map3 = (Map)map.get(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator2 = map3.keySet().iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                GeranCellRelation geranCellRelation = (GeranCellRelation)map3.get(string2);
                if (geranCellRelation == null) {
                    map2.put(string2, null);
                    this.writeToPersistencyTable(AUE_PERSISTENCY_DBKEY_REMOVE_MO + EXTERNAL_GERAN_CELL_MO_TYPE.toUpperCase(Locale.getDefault()), string2, this.tableHandler);
                    arrayList.add(string2);
                }
                if (map3.size() - arrayList.size() != 16) continue;
                break;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                map3.remove(arrayList.get(i));
            }
            if (map3.size() <= 16) continue;
            this.addToRemoveMapOldestWhenChildCountGreaterThanMaxAccordingToRemovingMonitoringStart(map3, map2);
        }
    }

    private void addToRemoveMapOldestWhenChildCountGreaterThanMaxAccordingToRemovingMonitoringStart(Map map, Map map2) {
        ArrayList<GeranCellRelation> arrayList = new ArrayList<GeranCellRelation>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            GeranCellRelation geranCellRelation = (GeranCellRelation)map.get(string);
            arrayList.add(geranCellRelation);
        }
        Collections.sort(arrayList);
        int n = 0;
        while (arrayList.size() - n > 16) {
            map2.put(((GeranCellRelation)arrayList.get(n)).externalGeranCellLdn, null);
            map2.put(((GeranCellRelation)arrayList.get(n)).geranCellRelationLdn, null);
            this.writeToPersistencyTable(AUE_PERSISTENCY_DBKEY_REMOVE_MO + EXTERNAL_GERAN_CELL_MO_TYPE.toUpperCase(Locale.getDefault()), ((GeranCellRelation)arrayList.get(n)).externalGeranCellLdn, this.tableHandler);
            this.writeToPersistencyTable(AUE_PERSISTENCY_DBKEY_REMOVE_MO + EXTERNAL_GERAN_CELL_MO_TYPE.toUpperCase(Locale.getDefault()), ((GeranCellRelation)arrayList.get(n)).geranCellRelationLdn, this.tableHandler);
            ++n;
        }
    }

    private void removeFromFroDatabase(TableData tableData, Object[] objectArray, TableData tableData2, Object[] objectArray2, Map map) {
        int n;
        for (n = objectArray.length - 1; n >= 0; --n) {
            if (!map.containsKey(objectArray[n])) continue;
            tableData.deleteRowData(n);
        }
        if (objectArray2 != null) {
            for (n = objectArray2.length - 1; n >= 0; --n) {
                if (!map.containsKey(objectArray2[n])) continue;
                tableData2.deleteRowData(n);
            }
        }
    }

    private class GeranCellRelation
    implements Comparable {
        private final String geranCellRelationLdn;
        private final Long time;
        private final String externalGeranCellLdn;

        protected GeranCellRelation(String string, String string2, String string3) {
            Long l;
            String string4 = string2.trim();
            this.externalGeranCellLdn = string3;
            this.geranCellRelationLdn = string;
            if (string4.length() == 0) {
                string4 = "1970-01-01 00:00:00";
            }
            try {
                l = new Long(new SimpleDateFormat("yyyy-mm-dd HH:mm:ss").parse(string4).getTime());
            }
            catch (ParseException parseException) {
                l = new Long(0L);
            }
            this.time = l;
        }

        public int compareTo(Object object) {
            return this.time.compareTo(((GeranCellRelation)object).time);
        }
    }
}

