/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it23;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.MoRepositoryWrapper;
import se.ericsson.crbs.omf.aue.step1.MoRepositoryWrapperFactory;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.lte.rbs.omf.aue.step1.AbstractStep1ConversionAction;

public class ConvertFeatureStateAttributeAction
extends AbstractStep1ConversionAction {
    private static final Class THIS_CLASS = ConvertFeatureStateAttributeAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final int ROW_0 = 0;
    private static final String ATTRIBUTE_FEATURE_STATE_ENH_CELL_ID_IN_TRACE = "featureStateEnhCellIdInTraces";
    private static final String MO_CLASS_SYSTEM_CONSTANTS = "SystemConstants";
    private static final String ATTRIBUTE_SYST_CONSTANTS = "systConstants";
    private static final String SYSTEM_CONSTANTS_LDN = "ManagedElement=1,NodeManagementFunction=1,SystemConstants=1";
    private static final String TIMING_ALIGNEMENT_EVENT_REPORT_SYS_CONST_NUMBER = "503";
    private static final Integer FEATURE_STATE_DEACTIVATED = new Integer(0);
    private static final Integer FEATURE_STATE_ACTIVATED = new Integer(1);
    private static final Integer SYS_CONST_DEFAULT_VALUE_FALSE = FEATURE_STATE_DEACTIVATED;
    private static final int SYS_CONST_VALUE_FALSE = 0;
    private static final int SYS_CONST_VALUE_TRUE = 1;
    private static final Coordinator NO_COORDINATOR = null;

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String string = this.getValueFromModificationFile("Mo");
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        TableData tableData = this.getTableData(tableHandler, string);
        if (tableData.isNotEmpty()) {
            Object[] objectArray = this.getAttributeColumn(tableData, string, ATTRIBUTE_FEATURE_STATE_ENH_CELL_ID_IN_TRACE);
            Integer n = new Integer(objectArray[0].toString());
            Integer n2 = this.getSystemConstValue(TIMING_ALIGNEMENT_EVENT_REPORT_SYS_CONST_NUMBER, SYS_CONST_DEFAULT_VALUE_FALSE);
            if (FEATURE_STATE_ACTIVATED.equals(n) && n2 == 0) {
                this.setAttributeValue(tableData, string, 0, ATTRIBUTE_FEATURE_STATE_ENH_CELL_ID_IN_TRACE, FEATURE_STATE_DEACTIVATED);
            } else if (FEATURE_STATE_DEACTIVATED.equals(n) && n2 == 1) {
                this.setAttributeValue(tableData, string, 0, ATTRIBUTE_FEATURE_STATE_ENH_CELL_ID_IN_TRACE, FEATURE_STATE_ACTIVATED);
            }
        }
        logger.traceReturn(THIS_CLASS, "convert");
    }

    private Integer getSystemConstValue(String string, Integer n) throws CrbsAueException {
        Integer n2 = n;
        MoRepositoryWrapper moRepositoryWrapper = MoRepositoryWrapperFactory.getMoRepositoryWrapper();
        MoIterator moIterator = moRepositoryWrapper.lookupType(MO_CLASS_SYSTEM_CONSTANTS);
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject = (ManagedObject)moIterator.nextElement();
                if (!SYSTEM_CONSTANTS_LDN.equals(managedObject.getLocalDistinguishedName())) continue;
                try {
                    String string2 = (String)managedObject.getAttribute(ATTRIBUTE_SYST_CONSTANTS, NO_COORDINATOR);
                    n2 = this.getSysConstValueInSysConstAttrValue(string, string2, n);
                    break;
                }
                catch (MoAccessException moAccessException) {
                    throw new CrbsAueException("Could not fetch SystemConstants::systConstants", (Throwable)moAccessException);
                }
            }
        }
        return n2;
    }

    private Integer getSysConstValueInSysConstAttrValue(String string, String string2, Integer n) {
        String string3;
        String string4 = string + ":";
        int n2 = string2.indexOf(string4);
        Integer n3 = n;
        String string5 = string3 = "," + string + ":";
        int n4 = string2.indexOf(string5);
        if (n2 == 0) {
            n4 = n2;
            string5 = string4;
        }
        if (n4 > -1) {
            int n5 = string2.indexOf(",", n4 + string5.length());
            String string6 = "";
            string6 = n5 == -1 ? string2.substring(n4 + string5.length()) : string2.substring(n4 + string5.length(), n5);
            n3 = Integer.valueOf(string6);
        }
        return n3;
    }
}

