/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it24;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsData;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsTable;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataImpl;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.lte.rbs.omf.aue.step1.AbstractStep1ConversionAction;

public class CorrectFroVersionsCdmaFroTypeNamesAction
extends AbstractStep1ConversionAction {
    private static final Class THIS_CLASS = CorrectFroVersionsCdmaFroTypeNamesAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final Map oldMoTypeToNewMoTypeMap = new HashMap();
    private final Map oldFroDataTableNamesPrefixToNewNamePrefixMap = new HashMap();

    public CorrectFroVersionsCdmaFroTypeNamesAction() {
        this.oldMoTypeToNewMoTypeMap.put("CDMA2000Network", "Cdma2000Network");
        this.oldMoTypeToNewMoTypeMap.put("CDMA2000FreqBand", "Cdma2000FreqBand");
        this.oldMoTypeToNewMoTypeMap.put("CDMA2000Freq", "Cdma2000Freq");
        this.oldMoTypeToNewMoTypeMap.put("ExternalCDMA2000Cell", "ExternalCdma2000Cell");
        this.oldFroDataTableNamesPrefixToNewNamePrefixMap.put("frodata_CDMA200_", "frodata_Cdma2000FreqBand_");
        this.oldFroDataTableNamesPrefixToNewNamePrefixMap.put("frodata_CDM_", "frodata_Cdma2000Freq_");
        this.oldFroDataTableNamesPrefixToNewNamePrefixMap.put("frodata_ExternalCDM_", "frodata_ExternalCdma2000Cell_");
        this.oldFroDataTableNamesPrefixToNewNamePrefixMap.put("frodata_CDMA2000FreqBand_", "frodata_Cdma2000FreqBand_");
        this.oldFroDataTableNamesPrefixToNewNamePrefixMap.put("frodata_CDMA2000Freq_", "frodata_Cdma2000Freq_");
        this.oldFroDataTableNamesPrefixToNewNamePrefixMap.put("frodata_ExternalCDMA2000Cell_", "frodata_ExternalCdma2000Cell_");
    }

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        FroVersionsTable froVersionsTable = tableHandler.getFroVersionsTable();
        FroVersionsData[] froVersionsDataArray = froVersionsTable.getDatas();
        if (froVersionsDataArray.length > 0) {
            this.cleanUp(tableHandler, froVersionsTable, froVersionsDataArray);
        } else {
            logger.traceDebug(THIS_CLASS, "fro_versions table is empty.");
        }
        froVersionsDataArray = null;
        logger.traceReturn(THIS_CLASS, "convert()");
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void cleanUp(TableHandler tableHandler, FroVersionsTable froVersionsTable, FroVersionsData[] froVersionsDataArray) throws CrbsAueException {
        for (int i = 0; i < froVersionsDataArray.length; ++i) {
            String string = froVersionsDataArray[i].froTypeName;
            if (!this.oldMoTypeToNewMoTypeMap.containsKey(string)) continue;
            String string2 = (String)this.oldMoTypeToNewMoTypeMap.get(string);
            this.updateFroTypeName(froVersionsTable, string, string2);
            this.updateDataTableName(tableHandler, string2);
        }
    }

    private void updateFroTypeName(FroVersionsTable froVersionsTable, String string, String string2) throws CrbsAueException {
        try {
            froVersionsTable.updateFroTypeName(string, string2);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not change fro type name from " + string + " to " + string2 + ".", (Throwable)tableDataException);
        }
    }

    private void updateDataTableName(TableHandler tableHandler, String string) throws CrbsAueException {
        String string2;
        String string3;
        TableData tableData = this.getTableData(tableHandler, string);
        if (tableData.hasColumns() && (string3 = this.getPrefixOfFroDataTableName(string2 = ((TableDataImpl)tableData).getTableName())) != null) {
            String string4 = this.getCorrectedDataTableName(string2, string3);
            try {
                ((TableDataImpl)tableData).setNewTableName(string4);
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException("Could not change fro data table name from " + string2 + " to " + string4 + ".", (Throwable)tableDataException);
            }
        }
    }

    private String getPrefixOfFroDataTableName(String string) {
        String string2 = null;
        Iterator iterator = this.oldFroDataTableNamesPrefixToNewNamePrefixMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (string.indexOf(string3) <= -1) continue;
            string2 = string3;
            break;
        }
        return string2;
    }

    private String getCorrectedDataTableName(String string, String string2) {
        String string3 = string;
        int n = string.indexOf(string2);
        if (n > -1) {
            string3 = this.getNewDataTableNamePrefix(string2) + string.substring(string2.length());
        }
        return string3;
    }

    private String getNewDataTableNamePrefix(String string) {
        return (String)this.oldFroDataTableNamesPrefixToNewNamePrefixMap.get(string);
    }
}

