/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.util;

import java.io.CharArrayReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.lte.rbs.omf.aue.step1.util.MoRef;
import se.ericsson.lte.rbs.omf.aue.step1.util.MoRefArray;

public class MoRefArrayParser
extends DefaultHandler {
    private static final Class THIS_CLASS = MoRefArrayParser.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private MoRefArray moRefArray;
    private MoRef moRef;

    public static MoRefArray parseMoRefArray(String string) throws CrbsAueException {
        try {
            logger.traceEnter(THIS_CLASS, "parseMoRef() " + string);
            CharArrayReader charArrayReader = new CharArrayReader(string.trim().toCharArray());
            InputSource inputSource = new InputSource(charArrayReader);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            MoRefArrayParser moRefArrayParser = new MoRefArrayParser();
            xMLReader.setContentHandler(moRefArrayParser);
            xMLReader.setErrorHandler(moRefArrayParser);
            xMLReader.parse(inputSource);
            return moRefArrayParser.getMoRefArray();
        }
        catch (Exception exception) {
            throw new CrbsAueException("Failed to parse moref " + string, (Throwable)exception);
        }
    }

    protected MoRefArray getMoRefArray() {
        return this.moRefArray;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        logger.traceEnter(this.getClass(), "startElement " + string3);
        if ("ARRAY".equalsIgnoreCase(string3)) {
            this.startArray(attributes);
        } else if ("moref".equalsIgnoreCase(string3)) {
            this.moRef = new MoRef();
            this.moRefArray.addMoRef(this.moRef);
        } else if ("attr".equalsIgnoreCase(string3)) {
            this.startAttr(attributes);
        }
        logger.traceReturn(this.getClass(), "startElement");
    }

    private void startAttr(Attributes attributes) {
        String string = null;
        String string2 = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (attributes.getQName(i).equalsIgnoreCase("name")) {
                string = attributes.getValue(i);
                continue;
            }
            if (!attributes.getQName(i).equalsIgnoreCase("value")) continue;
            string2 = attributes.getValue(i);
        }
        if ("ldn".equalsIgnoreCase(string)) {
            this.moRef.ldn = string2;
        } else if ("frotype".equalsIgnoreCase(string)) {
            this.moRef.froTypeId = Integer.parseInt(string2);
        } else if ("froid".equalsIgnoreCase(string)) {
            this.moRef.froId = Integer.parseInt(string2);
        }
    }

    private void startArray(Attributes attributes) {
        String string = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getQName(i).equalsIgnoreCase("name")) continue;
            string = attributes.getValue(i);
        }
        this.moRefArray = new MoRefArray(string);
    }
}

