/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.pnp.request;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.pnp.proxy.PnpContext;
import se.ericsson.crbs.omf.mao.pnp.request.PnpSubRequest;

public abstract class AbstractPnpSubRequest
implements PnpSubRequest {
    protected static final AbstractLogger logger = LoggingService.getLogger();
    protected final Class loggingClass;
    protected final PnpContext pnpContext;
    protected String ldn;
    protected Object executeResult = null;
    protected String executeResultName = "";
    protected final AttrListImpl attributeList;

    public AbstractPnpSubRequest(Class inputLoggingClass, PnpContext inputPnpContext) {
        this.loggingClass = inputLoggingClass;
        this.pnpContext = inputPnpContext;
        this.attributeList = new AttrListImpl(this.pnpContext.getMoRepositoryWrapper());
    }

    public Object getExecuteResult() {
        return this.executeResult;
    }

    public String getExecuteResultName() {
        return this.executeResultName;
    }

    public String getLdn() {
        return this.ldn;
    }

    public void setLdn(String newLdn) {
        this.ldn = newLdn;
    }

    public AttrListImpl getAttributeList() {
        return this.attributeList;
    }

    public String toString() {
        return " requestType:" + this.getRequestType() + " ldn:" + this.ldn + "\n";
    }

    protected ManagedObject getMo(String localLdn) throws MoAccessException {
        logger.traceEnter(this.loggingClass, "getMo(ldn=" + localLdn + ")");
        ManagedObject managedObject = this.pnpContext.getMoRepositoryWrapper().lookup(localLdn);
        if (managedObject == null) {
            logger.traceAbnormal(this.loggingClass, "Mo not found: " + localLdn);
            throw new MoNotFoundException("Mo not found");
        }
        logger.traceReturn(this.loggingClass, "getMo()");
        return managedObject;
    }

    protected static class LdnSubStrings {
        private final String moType;
        private final String parentLdn;
        private final String moId;

        public LdnSubStrings(String ldn) {
            this.moType = ldn.substring(ldn.lastIndexOf(44) + 1, ldn.lastIndexOf(61));
            this.parentLdn = ldn.substring(0, ldn.lastIndexOf(44));
            this.moId = ldn.substring(ldn.lastIndexOf(61) + 1);
        }

        public String getMoType() {
            return this.moType;
        }

        public String getParentLdn() {
            return this.parentLdn;
        }

        public String getId() {
            return this.moId;
        }
    }
}

