/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.pnp.xml;

import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonif.LdnFinder;
import se.ericsson.crbs.omf.mao.commonmo.StructImpl;
import se.ericsson.crbs.omf.mao.genericmo.xml.MoRefParameter;
import se.ericsson.crbs.omf.mao.pnp.request.PnpActionRequest;
import se.ericsson.crbs.omf.mao.pnp.request.PnpCreateRequest;
import se.ericsson.crbs.omf.mao.pnp.request.PnpDeleteRequest;
import se.ericsson.crbs.omf.mao.pnp.request.PnpRequest;
import se.ericsson.crbs.omf.mao.pnp.request.PnpSetRequest;
import se.ericsson.crbs.omf.mao.pnp.request.PnpSubRequest;
import se.ericsson.crbs.omf.mao.pnp.xml.ArrayCreator;
import se.ericsson.crbs.omf.mao.wrappers.ServiceLocatorWrapper;

public class PnpXmlHandler
extends DefaultHandler
implements ErrorHandler {
    private static final Class THIS_CLASS = PnpXmlHandler.class;
    private static final AbstractLogger logger = LoggingService.getLogger();
    private final PnpRequest pnpRequest;
    private PnpSubRequest pnpSubRequest = null;
    private final transient Stack attributeStackName = new Stack();
    private final transient Stack attributeStackType = new Stack();
    private final transient Stack attributeStackValue = new Stack();
    private boolean insideStruct = false;
    private boolean insideArray = false;
    private boolean insideMoRef = false;

    public PnpXmlHandler(PnpRequest inputPnpRequest) {
        this.pnpRequest = inputPnpRequest;
    }

    private void addCurrEltToCompositeParentElt(String name, Object value) throws SAXException {
        Object parent = this.attributeStackValue.peek();
        if (parent instanceof StructImpl) {
            ((StructImpl)parent).addElement(name, value);
        } else if (parent instanceof ArrayCreator) {
            ((ArrayCreator)parent).addElement(value);
        } else if (parent instanceof MoRefParameter) {
            this.handleEndElementForMoRef(name, value, parent);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String msg = "endElement";
        logger.traceEnter(THIS_CLASS, "endElement");
        if ("create".equalsIgnoreCase(qName)) {
            this.pnpRequest.addSubRequest(this.pnpSubRequest);
        } else if ("delete".equalsIgnoreCase(qName)) {
            this.pnpRequest.addSubRequest(this.pnpSubRequest);
        } else if ("set".equalsIgnoreCase(qName)) {
            this.pnpRequest.addSubRequest(this.pnpSubRequest);
        } else if ("action".equalsIgnoreCase(qName)) {
            PnpActionRequest pnpActionRequest = (PnpActionRequest)this.pnpSubRequest;
            pnpActionRequest.setAttributeTypes(this.attributeStackType);
            this.pnpRequest.addSubRequest(this.pnpSubRequest);
            this.attributeStackType.clear();
        } else if (this.isQNameSupportedType(qName)) {
            this.resetClassVariables(qName);
            if (this.attributeStackValue.isEmpty()) {
                String errMsg = "Attribute stack is empty at end of element: " + qName;
                logger.traceAbnormal(THIS_CLASS, errMsg);
                return;
            }
            String attrName = (String)this.attributeStackName.pop();
            Object attrValue = this.getAttributeValue();
            this.handleAttributeValue(attrName, attrValue);
        }
        logger.traceReturn(THIS_CLASS, "endElement");
    }

    private void resetClassVariables(String qName) {
        if (this.insideStruct && "struct".equals(qName)) {
            this.insideStruct = false;
        } else if (this.insideArray && "array".equals(qName)) {
            this.insideArray = false;
        } else if (this.insideMoRef && "moref".equals(qName)) {
            this.insideMoRef = false;
        }
    }

    private void handleAttributeValue(String attrName, Object attrValue) throws SAXException {
        if (this.attributeStackValue.isEmpty()) {
            if (attrValue instanceof ArrayCreator) {
                this.pnpSubRequest.getAttributeList().addAttribute(attrName, (Object)((ArrayCreator)attrValue).getArray());
            } else {
                this.pnpSubRequest.getAttributeList().addAttribute(attrName, attrValue);
            }
            String genMsg = "Attribute " + attrName + " added to attribute list.";
            logger.traceGeneral(THIS_CLASS, genMsg);
        } else {
            this.addCurrEltToCompositeParentElt(attrName, attrValue);
        }
    }

    private Object getAttributeValue() throws SAXException {
        Object attrValue = this.attributeStackValue.pop();
        if (attrValue instanceof MoRefParameter) {
            try {
                attrValue = this.convertMoRefParameterToMo((MoRefParameter)attrValue);
            }
            catch (MoNotFoundException moNotFoundException) {
                throw new SAXException("The referenced MO could not be found using FroType and FroId", (Exception)((Object)moNotFoundException));
            }
        }
        return attrValue;
    }

    private boolean isQNameSupportedType(String qName) {
        return "s32".equals(qName) || "s64".equals(qName) || "string".equals(qName) || "array".equals(qName) || "struct".equals(qName) || "moref".equals(qName) || "boolean".equals(qName) || "attr".equals(qName);
    }

    private ManagedObject convertMoRefParameterToMo(MoRefParameter attrValue) throws MoNotFoundException {
        String ldn;
        ManagedObject result = null;
        String string = ldn = attrValue.getLdn() != null && attrValue.getLdn().trim().equals("") ? null : attrValue.getLdn();
        if (ldn != null || attrValue.getFroType() != -1 || attrValue.getFroId() != -1) {
            if (ldn == null) {
                ServiceRepository serviceRepository = ServiceLocatorWrapper.getServiceRepository();
                LdnFinder ldnFinder = (LdnFinder)serviceRepository.getService(LdnFinder.class);
                ldn = ldnFinder.getManagedObjectLdn((long)attrValue.getFroType(), (long)attrValue.getFroId());
            }
            if (ldn != null) {
                result = this.pnpRequest.getPnpContext().getMoRepositoryWrapper().lookup(ldn);
            }
            if (result == null) {
                throw new MoNotFoundException("Could not find MO: " + ldn);
            }
        }
        return result;
    }

    private void handleEndElementForMoRef(String name, Object value, Object parent) {
        MoRefParameter moRefParameter = (MoRefParameter)parent;
        if ("ldn".equalsIgnoreCase(name)) {
            moRefParameter.setLdn((String)value);
        } else if ("froType".equalsIgnoreCase(name)) {
            moRefParameter.setFroType(((Integer)value).intValue());
        } else if ("froId".equalsIgnoreCase(name)) {
            moRefParameter.setFroId(((Integer)value).intValue());
        }
    }

    private void pushNameTypeValue(String attrName, String attrType, Object attrValue) {
        this.attributeStackName.push(attrName);
        if ("s32".equalsIgnoreCase(attrType)) {
            this.attributeStackValue.push(new Integer(Integer.parseInt(attrValue.toString())));
        } else if ("s64".equalsIgnoreCase(attrType)) {
            this.attributeStackValue.push(new Long(Long.parseLong(attrValue.toString())));
        } else if ("boolean".equalsIgnoreCase(attrType)) {
            this.attributeStackValue.push(Boolean.valueOf(attrValue.toString()));
        } else {
            this.attributeStackValue.push(attrValue);
        }
        if (!(this.insideArray || this.insideStruct || this.insideMoRef)) {
            this.attributeStackType.push(attrType);
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        String msg = "startElement";
        logger.traceEnter(THIS_CLASS, "startElement");
        if ("pnp".equalsIgnoreCase(qName)) {
            String pnpVersion = attributes.getValue("version");
            this.pnpRequest.setVersion(pnpVersion);
        }
        this.checkAndCreateCreateRequest(qName, attributes);
        this.checkAndCreateDeleteRequest(qName, attributes);
        this.checkAndCreateSetRequest(qName, attributes);
        this.checkAndCreateActionRequest(qName, attributes);
        this.storeAttrType(qName, attributes);
        this.storeS32Type(qName, attributes);
        this.storeS64Type(qName, attributes);
        this.storeBooleanType(qName, attributes);
        this.storeStringType(qName, attributes);
        this.storeStructType(qName, attributes);
        this.storeArrayType(qName, attributes);
        this.storeMoRefType(qName, attributes);
        logger.traceReturn(this.getClass(), "startElement");
    }

    private void storeMoRefType(String qName, Attributes attributes) {
        if ("moref".equalsIgnoreCase(qName)) {
            String attrName = attributes.getValue("name");
            MoRefParameter moRefParameter = new MoRefParameter(attrName == null ? "moref" : attrName);
            this.pushNameTypeValue(attrName, "moref", moRefParameter);
            this.insideMoRef = true;
        }
    }

    private void storeArrayType(String qName, Attributes attributes) {
        if ("array".equalsIgnoreCase(qName)) {
            this.pushNameTypeValue(attributes.getValue("name"), "array", new ArrayCreator());
            this.insideArray = true;
        }
    }

    private void storeStructType(String qName, Attributes attributes) {
        if ("struct".equalsIgnoreCase(qName)) {
            this.pushNameTypeValue(attributes.getValue("name") == null ? "struct" : attributes.getValue("name"), "struct", new StructImpl());
            this.insideStruct = true;
        }
    }

    private void storeStringType(String qName, Attributes attributes) {
        if ("string".equalsIgnoreCase(qName)) {
            this.pushNameTypeValue(attributes.getValue("name"), "string", attributes.getValue("value"));
        }
    }

    private void storeBooleanType(String qName, Attributes attributes) {
        if ("boolean".equalsIgnoreCase(qName)) {
            this.pushNameTypeValue(attributes.getValue("name"), "boolean", attributes.getValue("value"));
        }
    }

    private void storeS64Type(String qName, Attributes attributes) {
        if ("s64".equalsIgnoreCase(qName)) {
            this.pushNameTypeValue(attributes.getValue("name"), "s64", attributes.getValue("value"));
        }
    }

    private void storeS32Type(String qName, Attributes attributes) {
        if ("s32".equalsIgnoreCase(qName)) {
            this.pushNameTypeValue(attributes.getValue("name"), "s32", attributes.getValue("value"));
        }
    }

    private void storeAttrType(String qName, Attributes attributes) {
        if ("attr".equalsIgnoreCase(qName)) {
            this.pushNameTypeValue(attributes.getValue("name"), attributes.getValue("type"), attributes.getValue("value"));
        }
    }

    private void checkAndCreateActionRequest(String qName, Attributes attributes) {
        if ("action".equalsIgnoreCase(qName)) {
            this.attributeStackType.clear();
            this.pnpSubRequest = new PnpActionRequest(this.pnpRequest.getPnpContext());
            this.setLdn(this.pnpSubRequest, qName, attributes);
            this.setActionName((PnpActionRequest)this.pnpSubRequest, attributes);
        }
    }

    private void checkAndCreateSetRequest(String qName, Attributes attributes) {
        if ("set".equalsIgnoreCase(qName)) {
            this.attributeStackType.clear();
            this.pnpSubRequest = new PnpSetRequest(this.pnpRequest.getPnpContext());
            this.setLdn(this.pnpSubRequest, qName, attributes);
        }
    }

    private void checkAndCreateDeleteRequest(String qName, Attributes attributes) {
        if ("delete".equalsIgnoreCase(qName)) {
            this.attributeStackType.clear();
            this.pnpSubRequest = new PnpDeleteRequest(this.pnpRequest.getPnpContext());
            this.setLdn(this.pnpSubRequest, qName, attributes);
        }
    }

    private void checkAndCreateCreateRequest(String qName, Attributes attributes) {
        if ("create".equalsIgnoreCase(qName)) {
            this.attributeStackType.clear();
            this.pnpSubRequest = new PnpCreateRequest(this.pnpRequest.getPnpContext());
            this.setLdn(this.pnpSubRequest, qName, attributes);
        }
    }

    private void setLdn(PnpSubRequest localPnpSubRequest, String qName, Attributes attributes) {
        if (this.pnpRequest == null) {
            String errMsg = "PnP Request XML format error: " + qName;
            logger.traceAbnormal(THIS_CLASS, errMsg);
        } else {
            String attrLdn = attributes.getValue("ldn");
            if (attrLdn == null) {
                String errMsg = "Attribute ldn not found in attr tag: " + qName;
                logger.traceAbnormal(THIS_CLASS, errMsg);
            }
            localPnpSubRequest.setLdn(attrLdn);
        }
    }

    private void setActionName(PnpActionRequest pnpActionRequest, Attributes attributes) {
        if (this.pnpRequest != null) {
            String attrActionName = attributes.getValue("actionName");
            if (attrActionName == null) {
                String errMsg = "Attribute \"actionName\" not found in attr tag: actionName";
                logger.traceAbnormal(THIS_CLASS, "Attribute \"actionName\" not found in attr tag: actionName");
            }
            pnpActionRequest.setActionName(attrActionName);
        }
    }

    public void error(SAXParseException saxparseexception) throws SAXException {
        logger.traceAbnormal(THIS_CLASS, saxparseexception.getMessage());
    }

    public void fatalError(SAXParseException saxparseexception) throws SAXException {
        logger.traceAbnormal(THIS_CLASS, saxparseexception.getMessage());
    }

    public void warning(SAXParseException saxparseexception) throws SAXException {
        logger.traceAbnormal(THIS_CLASS, saxparseexception.getMessage());
    }
}

