/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import java.text.SimpleDateFormat;
import java.util.Date;
import se.ericsson.cello.equipment.EqConst;
import se.ericsson.cello.equipment.EquipmentMo;
import se.ericsson.cello.equipment.osa_equ_equipment_mi;
import se.ericsson.cello.equipment.suaccess.EquipmentMoSU_Access;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandlerFactoryImpl;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.mao.TransactionHelperImpl;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.scheduler.ScheduledTask;
import se.ericsson.cello.support.scheduler.Scheduler;
import se.ericsson.cello.support.scheduler.SchedulerImpl;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.Status;
import se.ericsson.cello.transaction.TransactionRolledBackException;

public class EquipmentMoImpl
extends CelloMao
implements EquipmentMo,
EqConst,
EquipmentMoSU_Access {
    private static final int NO_OF_RETRIES = 5;
    private static final int RETRY_INTERVAL = 2000;
    private static final String equipmentId = "1";
    private StringAttribute userLabel = null;
    private MoData data = null;
    private static EquipmentMoImpl instance = null;
    private StringAttribute straLastHwPiChangeTimestamp = null;
    private static Scheduler sNotificationsDelayScheduler = null;
    private static int NOTIFICATIONS_DELAY = 300000;
    private static final int EQUIPMENT_FRO_ID = 1;
    private MaoFroIndicationHandler indicationHandler = MaoFroIndicationHandlerFactoryImpl.instance().create(osa_equ_equipment_mi.class);
    private static final String[] SUPPORTED_VERSIONS = new String[]{"SU_1", "SU_2"};
    private static final int MO_DATA_REVISION_31 = 3000;
    private static final int MO_DATA_REVISION_CPP8_LSV56 = 8000;
    private static final int MO_DATA_REVISION_LATEST = 8000;

    public String getType() {
        return "Equipment";
    }

    public String getEquipmentId(Coordinator coordinator) throws MoAccessException {
        return equipmentId;
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"Equipment", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public String getLastHwPiChange(Coordinator coordinator) throws MoAccessException {
        String string = "NOT DEFINED";
        if (this.data == null) {
            return string;
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.straLastHwPiChangeTimestamp != null) {
            return this.straLastHwPiChangeTimestamp.getValue(coordinator);
        }
        return string;
    }

    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    static synchronized EquipmentMoImpl instance() {
        try {
            if (instance == null) {
                instance = new EquipmentMoImpl();
            }
        }
        catch (MoNameAlreadyTakenException moNameAlreadyTakenException) {
            MessageLog.traceError((Class)EquipmentMoImpl.class, (String)"Create instance of Equipment MO failed", (Throwable)moNameAlreadyTakenException);
        }
        return instance;
    }

    void recover(MoData moData) {
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(8000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("lastHwPiChange");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.straLastHwPiChangeTimestamp = (StringAttribute)moData.getAttribute("lastHwPiChange");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, 1);
        this.initialize5MinutesDelayTimer();
    }

    private EquipmentMoImpl() throws MoNameAlreadyTakenException {
        super(((SingletonMoFactory)MoFactoryMgr.instance().lookup("ManagedElement")).getMo(), "Equipment", equipmentId, null);
    }

    private void initialize5MinutesDelayTimer() {
        MessageLog.trace((int)5, this.getClass(), (String)("initialize notifications delay scheduler with " + NOTIFICATIONS_DELAY + " millisec"));
        if (sNotificationsDelayScheduler == null) {
            sNotificationsDelayScheduler = SchedulerImpl.instance();
            sNotificationsDelayScheduler.createSchedule("notification delay", new Date(System.currentTimeMillis() + (long)NOTIFICATIONS_DELAY), (ScheduledTask)new EquipmentMoScheduledTask(), false);
        }
    }

    synchronized void registerData() {
        if (this.data == null) {
            try {
                Control control = this.createMyOwnTransaction(3600);
                this.data = new MoData(this.getLocalDistinguishedName(), "Equipment", true, control.getCoordinator());
                this.userLabel = new StringAttribute("userLabel", true, "");
                this.straLastHwPiChangeTimestamp = new StringAttribute("lastHwPiChange", true, this.getCurrentTimeStamp());
                this.data.registerPersistentAttr((Attribute)this.userLabel);
                this.data.registerPersistentAttr((Attribute)this.straLastHwPiChangeTimestamp);
                this.data.handleTransaction(control.getCoordinator(), MoData.WRITE_ACCESS);
                this.data.setRevision(8000);
                this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, 1);
                TransactionHelperImpl.instance().commitTransaction(control);
            }
            catch (Exception exception) {
                MessageLog.traceError(this.getClass(), (String)"start of Equipment failed", (Throwable)exception);
            }
        }
    }

    private Control createMyOwnTransaction(int n) throws TransactionRolledBackException {
        return TransactionHelperImpl.instance().createTransactionWithTimeOut(2000, 5, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void actionTriggerLastHwPiChange(Coordinator coordinator) throws MoAccessException {
        block19: {
            Control control;
            Coordinator coordinator2;
            block18: {
                coordinator2 = null;
                control = null;
                if (coordinator == null) {
                    control = this.createMyOwnTransaction(5000);
                    coordinator2 = control.getCoordinator();
                } else {
                    coordinator2 = coordinator;
                }
                if (sNotificationsDelayScheduler == null) {
                    this.data.handleTransaction(coordinator2, MoData.WRITE_ACCESS);
                    this.straLastHwPiChangeTimestamp.setValue(this.getCurrentTimeStamp());
                } else if (control != null) {
                    control.getTerminator().rollback();
                }
                if (control == null) break block18;
                TransactionHelperImpl.instance().commitTransaction(control);
            }
            Object var6_4 = null;
            try {
                if (control != null && coordinator2.getStatus() != Status.NO_TRANSACTION) {
                    control.getTerminator().rollback();
                }
                break block19;
            }
            catch (Exception exception) {}
            break block19;
            {
                catch (MoAccessException moAccessException) {
                    throw moAccessException;
                }
                catch (Exception exception) {
                    if (sNotificationsDelayScheduler == null) {
                        MessageLog.info(this.getClass(), (String)("failed to issue an AVC on LastHwPiChange, probably due to problems with transaction \n" + exception));
                    }
                    Object var6_5 = null;
                    try {
                        if (control != null && coordinator2.getStatus() != Status.NO_TRANSACTION) {
                            control.getTerminator().rollback();
                        }
                        break block19;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    if (control != null && coordinator2.getStatus() != Status.NO_TRANSACTION) {
                        control.getTerminator().rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private String getCurrentTimeStamp() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMdd-HHmmss");
        return simpleDateFormat.format(new Date());
    }

    private class EquipmentMoScheduledTask
    implements ScheduledTask {
        private EquipmentMoScheduledTask() {
        }

        public boolean runScheduledTask(String string) {
            MessageLog.trace((int)5, this.getClass(), (String)"notifications delay timer has expired, trigger notifications ");
            sNotificationsDelayScheduler = null;
            try {
                EquipmentMoImpl.this.actionTriggerLastHwPiChange(null);
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError(this.getClass(), (String)"Unable to send Sw Inventory change notification due to exception", (Throwable)moAccessException);
            }
            return true;
        }
    }
}

