/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import enea.ose.system.Signal;
import java.util.ArrayList;
import java.util.Iterator;
import se.ericsson.cello.equipment.CppBoardMarker;
import se.ericsson.cello.equipment.GeneralProcessorUnitMo;
import se.ericsson.cello.equipment.IpAccessHostGpbBuildIF;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.equipment.PlugInUnitMoImpl;
import se.ericsson.cello.equipment.fropxy.OsaPiu2GetAttributesRsp;
import se.ericsson.cello.equipment.fropxy.OsaPiuGetDiskDataRsp;
import se.ericsson.cello.equipment.fropxy.OsaPiuMgmntProxy;
import se.ericsson.cello.equipment.fropxy.OsaPiuSetDiskLimitRsp;
import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoCanNotBeDeletedException;
import se.ericsson.cello.mao.MoReservedByOtherUserException;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.Removable;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.transaction.Coordinator;

public class GeneralProcessorUnitMoImpl
extends ManagedObjectBase
implements GeneralProcessorUnitMo,
Removable,
Reservable,
CppBoardMarker {
    private MoData data;
    private StringAttribute userLabel;
    private SequenceAttribute reservedBy;
    private static OsaPiuMgmntProxy PiuProxy = OsaPiuMgmntProxy.instance();
    private static final int MO_DATA_REVISION_42 = 4200;
    private static final int MO_DATA_REVISION_423 = 4230;
    private static final int MO_DATA_REVISION_LATEST = 4230;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        String[] stringArray = new String[]{"Cbu", "PlugInUnit"};
        MoAttributeValidator.checkParents((ManagedObject)managedObject, (String[])stringArray);
        GeneralProcessorUnitMoImpl.checkRole(managedObject, coordinator);
        MoAttributeValidator.checkIdentity((String)"GeneralProcessorUnit", (String)string);
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"GeneralProcessorUnit", (int)1);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"GeneralProcessorUnit", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"minimumHdVolumeDFreespace", (AttrList)attrList, (boolean)false, (int)20, (int)0, (int)999, (String)"GeneralProcessorUnit");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"GeneralProcessorUnit");
        return new GeneralProcessorUnitMoImpl(managedObject, string, string2, n, coordinator);
    }

    private GeneralProcessorUnitMoImpl(ManagedObject managedObject, String string, String string2, int n, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "GeneralProcessorUnit", string, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.userLabel = new StringAttribute("userLabel", true, string2);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.reservedBy = new SequenceAttribute("reservedBy", false);
        this.data.registerPersistentAttr((Attribute)this.reservedBy);
        this.data.setRevision(4230);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.setMinimumHdVolumeDFreespace(n, coordinator);
    }

    public GeneralProcessorUnitMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(4230);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.reservedBy = (SequenceAttribute)moData.getAttribute("reservedBy");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        if (this.getParent().getType().equals("PlugInUnit")) {
            this.doDelete(coordinator);
        } else if (this.getParent().getType().equals("Cbu")) {
            throw new MoCanNotBeDeletedException("GeneralProcessorUnit. Delete of this MO under Cbu is possible by deleting Cbu MO.");
        }
    }

    public void doDelete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedBy(coordinator).length != 0) {
            throw new MoReservedNotDeletableException("GeneralProcessorUnit");
        }
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"GeneralProcessorUnit", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PlugInUnitMo plugInUnitMo = null;
        if (this.getParent().getType().equals("PlugInUnit")) {
            plugInUnitMo = (PlugInUnitMo)this.getParent();
        } else if (this.getParent().getType().equals("Cbu")) {
            plugInUnitMo = (PlugInUnitMo)this.getParent().getParent();
        } else {
            MessageLog.traceError(this.getClass(), (String)("---CMA---getOperationalState(). " + this.getParent()));
        }
        return plugInUnitMo.getOperationalState(coordinator);
    }

    public int getHdVolumeDSize(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaPiuGetDiskDataRsp osaPiuGetDiskDataRsp = this.retrieveFroAttributes(coordinator);
        return osaPiuGetDiskDataRsp.getTotalSizeD();
    }

    public int getHdVolumeDFreespace(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaPiuGetDiskDataRsp osaPiuGetDiskDataRsp = this.retrieveFroAttributes(coordinator);
        return osaPiuGetDiskDataRsp.getFreeSpaceD();
    }

    public int getMinimumHdVolumeDFreespace(Coordinator coordinator) throws MoAccessException {
        int n = 0;
        if (coordinator != null) {
            n = coordinator.getTransactionID();
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n2 = 0;
        if (this.getParent().getType().equals("PlugInUnit")) {
            n2 = ((PlugInUnitMoImpl)this.getParent()).getResourceId(coordinator);
        } else if (this.getParent().getType().equals("Cbu")) {
            n2 = ((PlugInUnitMoImpl)this.getParent().getParent()).getResourceId(coordinator);
        }
        OsaPiu2GetAttributesRsp osaPiu2GetAttributesRsp = PiuProxy.sendOsaPiu2GetAttributesReq(n, n2);
        this.checkSignal((Signal)osaPiu2GetAttributesRsp);
        if (osaPiu2GetAttributesRsp.getResult() != 1) {
            String string = PiuProxy.getResultMsg(osaPiu2GetAttributesRsp.getResult());
            throw new FroRequestFailedException("GeneralProcessorUnit", "PiuFro", "getMinimumHdVolumeDFreespace" + string, osaPiu2GetAttributesRsp.getResult());
        }
        return osaPiu2GetAttributesRsp.getDVolFreeLim();
    }

    private void checkSignal(Signal signal) throws FroNotAccessibleException {
        if (signal == null) {
            throw new FroNotAccessibleException("GeneralProcessorUnit", "PiuFro is not accessible.");
        }
    }

    public void setMinimumHdVolumeDFreespace(int n, Coordinator coordinator) throws MoAccessException {
        if (n < 0 || n > 999) {
            throw new ValueOutOfRangeException("minimumHdVolumeDFreespace", "GeneralProcessorUnit");
        }
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n2 = 0;
        if (this.getParent().getType().equals("PlugInUnit")) {
            n2 = ((PlugInUnitMoImpl)this.getParent()).getResourceId(coordinator);
        } else if (this.getParent().getType().equals("Cbu")) {
            n2 = ((PlugInUnitMoImpl)this.getParent().getParent()).getResourceId(coordinator);
        }
        OsaPiuSetDiskLimitRsp osaPiuSetDiskLimitRsp = PiuProxy.sendOsaPiuSetDiskLimitReq(coordinator.getTransactionID(), n2, n);
        this.checkSignal((Signal)osaPiuSetDiskLimitRsp);
        if (osaPiuSetDiskLimitRsp.getResult() != 1) {
            String string = PiuProxy.getResultMsg(osaPiuSetDiskLimitRsp.getResult());
            throw new FroRequestFailedException("GeneralProcessorUnit", "PiuFro", "setMinimumHdVolumeDFreespace " + string, osaPiuSetDiskLimitRsp.getResult());
        }
        String[] stringArray = new String[]{"minimumHdVolumeDFreespace"};
        Object[] objectArray = new Object[]{new Integer(n)};
        GeneralProcessorUnitMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public int getHdVolumePSize(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaPiuGetDiskDataRsp osaPiuGetDiskDataRsp = this.retrieveFroAttributes(coordinator);
        return osaPiuGetDiskDataRsp.getTotalSizeP();
    }

    public int getHdVolumePFreespace(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaPiuGetDiskDataRsp osaPiuGetDiskDataRsp = this.retrieveFroAttributes(coordinator);
        return osaPiuGetDiskDataRsp.getFreeSpaceP();
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (!this.reservedBy.isEmpty()) {
            throw new MoReservedByOtherUserException(managedObject.getType(), "GeneralProcessorUnit");
        }
        this.reservedBy = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"GeneralProcessorUnit", (MoData)this.data, (SequenceAttribute)this.reservedBy);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.reservedBy = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"GeneralProcessorUnit", (MoData)this.data, (SequenceAttribute)this.reservedBy);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        int n;
        ManagedObject[] managedObjectArray;
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Attribute[] attributeArray = this.reservedBy.getValue(coordinator);
        int n2 = attributeArray.length;
        int n3 = 0;
        ManagedObject[] managedObjectArray2 = this.getReservingIpacHosts(coordinator);
        if (managedObjectArray2 != null) {
            managedObjectArray = new ManagedObject[n2 += managedObjectArray2.length];
            for (n = 0; n < managedObjectArray2.length; ++n) {
                managedObjectArray[n] = managedObjectArray2[n];
            }
            n3 = managedObjectArray2.length;
        } else {
            managedObjectArray = new ManagedObject[n2];
        }
        for (n = n3; n < n2; ++n) {
            managedObjectArray[n] = ((ReferenceAttribute)attributeArray[n - n3]).getValue(coordinator);
        }
        return managedObjectArray;
    }

    public ManagedObject[] getReservingIpacHosts(Coordinator coordinator) throws MoAccessException {
        Iterator iterator = ServiceLocatorFacade.getRepository().getServices(IpAccessHostGpbBuildIF.class);
        if (iterator != null && iterator.hasNext()) {
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                ManagedObject managedObject = ((IpAccessHostGpbBuildIF)e).getActiveGpuId(coordinator);
                if (!managedObject.equals(this)) continue;
                arrayList.add(e);
            }
            if (arrayList.size() > 0) {
                return GeneralProcessorUnitMoImpl.convertListToMOArr(arrayList);
            }
        }
        return null;
    }

    public static ManagedObject[] convertListToMOArr(ArrayList arrayList) {
        ManagedObject[] managedObjectArray = new ManagedObject[arrayList.size()];
        arrayList.toArray(managedObjectArray);
        return managedObjectArray;
    }

    private OsaPiuGetDiskDataRsp retrieveFroAttributes(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = 0;
        if (this.getParent().getType().equals("PlugInUnit")) {
            n = ((PlugInUnitMoImpl)this.getParent()).getResourceId(coordinator);
        } else if (this.getParent().getType().equals("Cbu")) {
            n = ((PlugInUnitMoImpl)this.getParent().getParent()).getResourceId(coordinator);
        }
        OsaPiuGetDiskDataRsp osaPiuGetDiskDataRsp = PiuProxy.sendOsaPiuGetDiskDataReq(n);
        if (osaPiuGetDiskDataRsp == null) {
            throw new FroNotAccessibleException("GeneralProcessorUnit", "OsaPiuMgmntProxy");
        }
        int n2 = osaPiuGetDiskDataRsp.getResult();
        if (n2 != 1) {
            throw new FroRequestFailedException("GeneralProcessorUnit", "OsaPiuMgmnt", "GetOsaPiuDiskDataReq" + PiuProxy.getResultMsg(osaPiuGetDiskDataRsp.getResult()), osaPiuGetDiskDataRsp.getResult());
        }
        return osaPiuGetDiskDataRsp;
    }

    public String getType() {
        return "GeneralProcessorUnit";
    }

    private static void checkRole(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject2 = null;
        if (managedObject.getType().equals("PlugInUnit")) {
            managedObject2 = ((PlugInUnitMo)managedObject).getPiuType(coordinator);
        } else if (managedObject.getType().equals("Cbu")) {
            managedObject2 = ((PlugInUnitMo)managedObject.getParent()).getPiuType(coordinator);
        }
        if (managedObject2 != null) {
            if (((PiuTypeAccess)managedObject2).getRole(coordinator) != 1) {
                throw new IllegalParentException("GeneralProcessorUnit");
            }
        } else {
            throw new ValueOutOfRangeException("checkRole(), piuType reference is null", "GeneralProcessorUnit");
        }
    }

    private static void sendChangeNotification(ManagedObject managedObject, String[] stringArray, Object[] objectArray, Coordinator coordinator) {
        NotificationSender.instance().pushAVC(managedObject, stringArray, objectArray, coordinator);
    }
}

