/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import se.ericsson.cello.equipment.CbuMo;
import se.ericsson.cello.equipment.FastEthernetBuildIF;
import se.ericsson.cello.equipment.MediumAccessUnitMoGen;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoCanNotBeDeletedException;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class MediumAccessUnitMoImpl
extends MediumAccessUnitMoGen
implements FroInfo {
    public MediumAccessUnitMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler);
    }

    public MediumAccessUnitMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        MediumAccessUnitMoImpl.searchForFastEthernet(this.getParent());
        PlugInUnitMo plugInUnitMo = (PlugInUnitMo)this.getPiuMo(this.getParent());
        int n = plugInUnitMo.getResourceId(setRequestContext.getCoordinator());
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("mauPiuId", n));
    }

    private static void searchForFastEthernet(ManagedObject managedObject) throws MoAccessException {
        MoIterator moIterator = managedObject.getChildren();
        ManagedObject managedObject2 = null;
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                managedObject2 = moIterator.nextMo();
                if (!(managedObject2 instanceof FastEthernetBuildIF)) continue;
                throw new ValueOutOfRangeException("Not possible to configure both MediumAccessUnit and FastEthernet under the same GeneralProcessorUnit", "MediumAccessUnit");
            }
        }
    }

    private ManagedObject getPiuMo(ManagedObject managedObject) throws MoAccessException {
        ManagedObject managedObject2 = null;
        if (managedObject.getParent() instanceof PlugInUnitMo) {
            managedObject2 = managedObject.getParent();
        } else if (managedObject.getParent() instanceof CbuMo) {
            managedObject2 = managedObject.getParent().getParent();
        } else {
            MessageLog.traceError(this.getClass(), (String)("---CMA---Unknown grandParent. " + managedObject.getType()));
        }
        return managedObject2;
    }

    protected void validateConnectorLabel(String string, SetRequestContext setRequestContext) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"connectorLabel", (String)"MediumAccessUnit", (int)Integer.MAX_VALUE, (int)0);
    }

    protected void onDelete(Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = MoRepository.instance().lookupType("MediumAccessUnit");
        if (moIterator != null && moIterator.size() == 1) {
            throw new MoCanNotBeDeletedException("The last MediumAccessUnit cannot be deleted");
        }
    }

    public int getMauId(Coordinator coordinator) throws MoAccessException {
        return this.getFroId(coordinator);
    }
}

