/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import java.util.StringTokenizer;
import se.ericsson.cello.equipment.fropxy.OsaPiuOperatorReadRsp;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.support.debug.MessageLog;

public class OperFaultEntry {
    Struct readRepairDelivNoteData;
    private String operPreparedBy;
    private String operCountryCode;
    private String operStateCode;
    private String operDescriptionOfFault;
    private String operTrNumber;
    private String operReference;
    private static final String PREPARED_BY = "preparedBy";
    private static final String COUNTRY_CODE = "countryCode";
    private static final String STATE_CODE = "stateCode";
    private static final String DESC_OF_FAULT = "descriptionOfFault";
    private static final String TR_NO = "trNumber";
    private static final String REFERENCE = "reference";
    private static final String TIME_DATE = "timeDate";
    private static final String[] attrNames = new String[]{"preparedBy", "countryCode", "stateCode", "descriptionOfFault", "trNumber", "reference", "timeDate"};
    private static final String TYPE_NAME = "PlugInUnit";
    private static final int NO_OF_VALUES = 7;
    private static final String FAULT_ENTRY_DELIMITER = ";";
    private static final char NOTE_DELIMITER = ';';
    private static final int PIU_OPER_PREPARED_BY_MIN_LENGTH = 1;
    private static final int PIU_OPER_PREPARED_BY_MAX_LENGTH = 15;
    private static final int PIU_OPER_COUNTRY_CODE_LENGTH = 2;
    private static final String PIU_OPER_STATE_CODE_R = "R";
    private static final String PIU_OPER_STATE_CODE_S = "S";
    private static final String PIU_OPER_STATE_CODE_T = "T";
    private static final int PIU_OPER_DESC_OF_FAULT_MIN_LENGTH = 1;
    private static final int PIU_OPER_DESC_OF_FAULT_MAX_LENGTH = 64;
    private static final int PIU_OPER_TR_NO_MAX_LENGTH = 10;
    private static final int PIU_OPER_REFERENCE_MAX_LENGTH = 8;

    public OperFaultEntry(String string, String string2, String string3, String string4, String string5, String string6) throws MoAccessException {
        this.operPreparedBy = string;
        this.operCountryCode = string2;
        this.operStateCode = string3;
        this.operDescriptionOfFault = string4;
        this.operTrNumber = string5;
        this.operReference = string6;
        this.rangeCheck();
        this.replaceRestrictedCharacters();
    }

    public OperFaultEntry(OsaPiuOperatorReadRsp osaPiuOperatorReadRsp) {
        Object[] objectArray = new String[7];
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(osaPiuOperatorReadRsp.getDeliveryNote(), FAULT_ENTRY_DELIMITER);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                objectArray[n++] = stringTokenizer.nextToken();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            MessageLog.traceError(this.getClass(), (String)"Read Reapir Deliver Note Failed", (Throwable)arrayIndexOutOfBoundsException);
        }
        this.readRepairDelivNoteData = new StructImpl(this.getFieldNames(), objectArray);
    }

    public Struct getStruct() {
        return this.readRepairDelivNoteData;
    }

    private String[] getFieldNames() {
        return attrNames;
    }

    public String getRepairDeliveryNote() {
        String string = this.operPreparedBy + FAULT_ENTRY_DELIMITER + this.operCountryCode + FAULT_ENTRY_DELIMITER + this.operStateCode + FAULT_ENTRY_DELIMITER + this.operDescriptionOfFault + FAULT_ENTRY_DELIMITER + this.operTrNumber + FAULT_ENTRY_DELIMITER + this.operReference;
        return string;
    }

    private void rangeCheck() throws MoAccessException {
        if (this.operPreparedBy == null || this.operPreparedBy.length() < 1 || this.operPreparedBy.length() > 15) {
            throw new ValueOutOfRangeException(PREPARED_BY, TYPE_NAME);
        }
        if (this.operCountryCode == null || this.operCountryCode.length() != 2) {
            throw new ValueOutOfRangeException(COUNTRY_CODE, TYPE_NAME);
        }
        if (this.operStateCode == null || !this.operStateCode.equals(PIU_OPER_STATE_CODE_R) && !this.operStateCode.equals(PIU_OPER_STATE_CODE_S) && !this.operStateCode.equals(PIU_OPER_STATE_CODE_T)) {
            throw new ValueOutOfRangeException(STATE_CODE, TYPE_NAME);
        }
        if (this.operDescriptionOfFault == null || this.operDescriptionOfFault.length() < 1 || this.operDescriptionOfFault.length() > 64) {
            throw new ValueOutOfRangeException(DESC_OF_FAULT, TYPE_NAME);
        }
        if (this.operTrNumber != null && this.operTrNumber.length() > 10) {
            throw new ValueOutOfRangeException(TR_NO, TYPE_NAME);
        }
        if (this.operTrNumber == null) {
            this.operTrNumber = " ";
        }
        if (this.operReference != null && this.operReference.length() > 8) {
            throw new ValueOutOfRangeException(REFERENCE, TYPE_NAME);
        }
        if (this.operReference == null) {
            this.operReference = " ";
        }
    }

    private void replaceRestrictedCharacters() {
        this.operPreparedBy = this.removeDelimiters(this.operPreparedBy);
        this.operCountryCode = this.removeDelimiters(this.operCountryCode);
        this.operStateCode = this.removeDelimiters(this.operStateCode);
        this.operDescriptionOfFault = this.removeDelimiters(this.operDescriptionOfFault);
        this.operTrNumber = this.removeDelimiters(this.operTrNumber);
        this.operReference = this.removeDelimiters(this.operReference);
    }

    private String removeDelimiters(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ';') continue;
            string2 = string2 + string.charAt(i);
        }
        return string2;
    }
}

