/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import enea.ose.system.Signal;
import enea.ose.system.UnlinkedSignal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.common.fropxy.FroLocationFailedException;
import se.ericsson.cello.common.fropxy.FroShutdownException;
import se.ericsson.cello.equipment.Aal5ReservingPiu;
import se.ericsson.cello.equipment.EquipException;
import se.ericsson.cello.equipment.HwLogFullException;
import se.ericsson.cello.equipment.InterPiuLinkMo;
import se.ericsson.cello.equipment.IpRouterBuildIF;
import se.ericsson.cello.equipment.NoAccessToHwLogException;
import se.ericsson.cello.equipment.OperFaultEntry;
import se.ericsson.cello.equipment.PiuMoExtendImpl;
import se.ericsson.cello.equipment.PlugInUnitMoInternal;
import se.ericsson.cello.equipment.PlugInUnitRepositoryImpl;
import se.ericsson.cello.equipment.PlugNPlayListener;
import se.ericsson.cello.equipment.RepairDeliveryNoteAlreadyExistsException;
import se.ericsson.cello.equipment.RepairDeliveryNoteDoesNotExistException;
import se.ericsson.cello.equipment.SetAdministrativeStateException;
import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.equipment.SlotMoImpl;
import se.ericsson.cello.equipment.SlotMoImplInterface;
import se.ericsson.cello.equipment.SlotMoInternal;
import se.ericsson.cello.equipment.SubrackMo;
import se.ericsson.cello.equipment.SubrackMoImpl;
import se.ericsson.cello.equipment.SubrackMoImplInterface;
import se.ericsson.cello.equipment.SubrackMoInternal;
import se.ericsson.cello.equipment.SubrackProdTypeBuildIF;
import se.ericsson.cello.equipment.eqaccess.PIU_AdmStateListenerAcessInterface;
import se.ericsson.cello.equipment.eqaccess.PIU_OperStateListenerAccessInterface;
import se.ericsson.cello.equipment.eqaccess.ProgramHandlerAccess;
import se.ericsson.cello.equipment.eqaccess.ProgramHandlerFactoryAccess;
import se.ericsson.cello.equipment.fropxy.CoreNotifiable;
import se.ericsson.cello.equipment.fropxy.NssPiuMgmntProxy;
import se.ericsson.cello.equipment.fropxy.OsaPiu2GetAttributesRsp;
import se.ericsson.cello.equipment.fropxy.OsaPiu2OperStatePropagation;
import se.ericsson.cello.equipment.fropxy.OsaPiu3GetAttributesRsp;
import se.ericsson.cello.equipment.fropxy.OsaPiu3RestartRsp;
import se.ericsson.cello.equipment.fropxy.OsaPiu4GetAttributesRsp;
import se.ericsson.cello.equipment.fropxy.OsaPiuAutoLockInd;
import se.ericsson.cello.equipment.fropxy.OsaPiuCreateCfm;
import se.ericsson.cello.equipment.fropxy.OsaPiuDeleteCfm;
import se.ericsson.cello.equipment.fropxy.OsaPiuHwTestResultRsp;
import se.ericsson.cello.equipment.fropxy.OsaPiuMgmntProxyInterface;
import se.ericsson.cello.equipment.fropxy.OsaPiuOperatorReadRsp;
import se.ericsson.cello.equipment.fropxy.OsaPiuOperatorWriteRsp;
import se.ericsson.cello.equipment.fropxy.OsaPiuSetAdmStateCfm;
import se.ericsson.cello.equipment.fropxy.OsaPiuSetAllowedRestartsCfm;
import se.ericsson.cello.equipment.fropxy.OsaPiuSetAttributesCfm;
import se.ericsson.cello.equipment.fropxy.OsaPiuSetGroupNumberCfm;
import se.ericsson.cello.equipment.fropxy.OsaPiuSwitchReadyInd;
import se.ericsson.cello.equipment.fropxy.SpasSaiFroCreateRsp;
import se.ericsson.cello.equipment.fropxy.SpasSaiFroSetAdmStateRsp;
import se.ericsson.cello.equipment.fropxy.SpasSaiMgmntProxyInterface;
import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.equipment.osa_equ_PlugInUnit_mi;
import se.ericsson.cello.equipment.osa_pluginunit;
import se.ericsson.cello.equipment.spas_equ_PlugInUnit_mi;
import se.ericsson.cello.equipment.spas_plugin_unit;
import se.ericsson.cello.equipment.suaccess.PiuMoAttributesInformation;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandlerFactoryImpl;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.managedelement.ManagedElementDataMo;
import se.ericsson.cello.managedelement.ManagedElementMo;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.managedelement.PlugInUnitBuildIF;
import se.ericsson.cello.managedelement.PlugInUnitRepository;
import se.ericsson.cello.managedelement.suaccess.FroRequestFailedInformationException;
import se.ericsson.cello.managedelement.suaccess.SU_ConditionalException;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.GenPmMaoHandler;
import se.ericsson.cello.mao.MaoPmStrategyForReqContext;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.PmRequestContextImpl;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.RestartRankEnum;
import se.ericsson.cello.mao.RestartReasonEnum;
import se.ericsson.cello.mao.RestartRejectedException;
import se.ericsson.cello.mao.SeqRestartsEnum;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.proxy.FroProxyFactoryImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.util.library.Lib;

public class PlugInUnitMoImpl
extends CelloMao
implements PlugInUnitMoInternal,
CoreNotifiable,
PlugInUnitMoSU_Access,
PlugInUnitBuildIF {
    private Map myPmProxyFroIdMap = new HashMap();
    private static NotificationSender myNotifSender = NotificationSender.instance();
    private static PlugInUnitRepository myFroIdRepository = PlugInUnitRepositoryImpl.instance();
    private PIU_AdmStateListenerAcessInterface myPIU_AdmStateListenerInterface = null;
    private PIU_OperStateListenerAccessInterface myPIU_OperStateListenerInterface = null;
    private IntegerAttribute resourceId;
    private IntegerAttribute saiResourceId;
    private StringAttribute userLabel;
    private ReferenceAttribute piuType;
    private IntegerAttribute shutDownTimer;
    private SequenceAttribute reservedByList;
    private IntegerAttribute interruptState;
    private MoData myData;
    private OsaPiuMgmntProxyInterface roProxy;
    private SpasSaiMgmntProxyInterface saiProxy;
    private static NssPiuMgmntProxy nssProxy = NssPiuMgmntProxy.instance();
    private FroProxy genericProxyInstance = FroProxyFactoryImpl.getProxy((Class)osa_equ_PlugInUnit_mi.class, (String)"PlugInUnit");
    private MaoFroIndicationHandler indicationHandler = MaoFroIndicationHandlerFactoryImpl.instance().create(spas_equ_PlugInUnit_mi.class);
    private static final int SHUTDOWN_TIMER_DEFAULT = 0;
    private static final int ALLOWED_PIU_GROUP_NUMBER_MIN = 0;
    private static final int ALLOWED_PIU_GROUP_NUMBER_MAX = 65536;
    private static final int MAX_ROUTERS = 31;
    private static final String RESERVED_BY_LIST = "reservedByList";
    private static final String SAI_RESOURCE_ID = "saiResourceId";
    private static final String RESOURCE_ID = "resourceId";
    private static final String SHUT_DOWN_TIMER = "shutDownTimer";
    private static final String SWITCH_PIU_AT_LOCK = "switchPiuAtLock";
    private static final String PIU_RESTART_CAUSE_VALUE = "PiuRestartCausevalue";
    private static final String PIU_RESTART_RANK_VALUE = "PiuRestartRankvalue";
    private static final String PIU_RESTART_REASON_VALUE = "PiuRestartReasonvalue";
    private static final String PIU_RESTART_INFO = "PiuRestartInfo";
    private static final String INTERRUPT_STATE = "interruptState";
    private static final String[] SUPPORTED_VERSIONS = new String[]{"SU_1", "SU_2", "SU_3"};
    private static final int MO_REVISION_5100 = 5100;
    private static final int MO_REVISION_8003 = 8003;
    private static final int MO_REVISION_9000 = 9000;
    private static final int MO_REVISION_LATEST = 9000;

    public PlugInUnitMoImpl(MoData moData, InitialMaoContext initialMaoContext, OsaPiuMgmntProxyInterface osaPiuMgmntProxyInterface, SpasSaiMgmntProxyInterface spasSaiMgmntProxyInterface) throws MoAccessException, MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        super.setPmHandler((GenPmMaoHandler)new MaoPmStrategyForReqContext((ManagedObject)this, this.myPmAppPortal));
        this.roProxy = osaPiuMgmntProxyInterface;
        this.saiProxy = spasSaiMgmntProxyInterface;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"PlugInUnitMoImpl(MoData recoveredData)", (String)("recoveredData: " + moData));
        this.myData = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.myData, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(9000);
        moDataRecoveryHelper.assertAttribute(RESOURCE_ID);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("piuType");
        moDataRecoveryHelper.assertAttribute(SHUT_DOWN_TIMER);
        moDataRecoveryHelper.assertAttribute(RESERVED_BY_LIST);
        moDataRecoveryHelper.assertAttribute(SAI_RESOURCE_ID);
        moDataRecoveryHelper.assertAttribute(INTERRUPT_STATE);
        moDataRecoveryHelper.assertAttribute("positionRef");
        this.resourceId = (IntegerAttribute)moData.getAttribute(RESOURCE_ID);
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.piuType = (ReferenceAttribute)moData.getAttribute("piuType");
        this.shutDownTimer = (IntegerAttribute)moData.getAttribute(SHUT_DOWN_TIMER);
        this.reservedByList = (SequenceAttribute)moData.getAttribute(RESERVED_BY_LIST);
        this.saiResourceId = (IntegerAttribute)moData.getAttribute(SAI_RESOURCE_ID);
        this.interruptState = (IntegerAttribute)moData.getAttribute(INTERRUPT_STATE);
        osaPiuMgmntProxyInterface.registerForNotifications(null, (MaoFroIndicationSubscriber)this, this.resourceId.getValue(null));
        nssProxy.registerForNotifications(null, this, this.resourceId.getValue(null));
        if (this.saiResourceId.getValue(null) != 0) {
            spasSaiMgmntProxyInterface.registerForNotifications(null, this, this.saiResourceId.getValue(null));
            this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, this.saiResourceId.getValue(null));
        }
        myFroIdRepository.addInstance(this.resourceId.getValue(null), (ManagedObject)this);
        this.getMaoContext().getServiceRepository().addService((Object)this, PlugInUnitBuildIF.class, null);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        Object object;
        Object object2;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"delete(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedBy(coordinator).length > 0) {
            throw new MoReservedNotDeletableException("PlugInUnit");
        }
        ManagedObject managedObject = this.getPositionRef(coordinator);
        if (managedObject != null) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        if (this.getAdministrativeState(coordinator) != 0) {
            throw new EquipException("Not possible to delete unlocked PlugInUnit");
        }
        this.deleteChildren(coordinator);
        int n = this.resourceId.getValue(coordinator);
        if (this.connected2SpasSaiFro(coordinator)) {
            int n2 = this.saiResourceId.getValue(coordinator);
            object2 = this.saiProxy.sendSpasSaiFroDeleteReq(coordinator.getTransactionID(), n2);
            this.checkSignal((Signal)object2);
            object = this.saiProxy.getResultMsg(object2.getResult());
            if (object2.getResult() != 1) {
                throw new FroRequestFailedException("PlugInUnit", "sai FRO", "Delete " + (String)object, object2.getResult());
            }
            nssProxy.deregisterForNotifications(coordinator, n);
            this.saiProxy.deregisterForNotifications(coordinator, n2);
            this.indicationHandler.deregisterForNotifications(coordinator, n2);
        }
        OsaPiuDeleteCfm osaPiuDeleteCfm = this.roProxy.sendOsaPiuDeleteReq(coordinator.getTransactionID(), n);
        this.checkSignal((Signal)osaPiuDeleteCfm);
        object2 = this.roProxy.getResultMsg(osaPiuDeleteCfm.getResult());
        if (osaPiuDeleteCfm.getResult() != 1) {
            throw new FroRequestFailedException("PlugInUnit", "osa FRO", "Delete " + (String)object2, osaPiuDeleteCfm.getResult());
        }
        object = (PiuTypeAccess)this.piuType.getValue(coordinator);
        if (object != null) {
            object.release((ManagedObject)this, coordinator);
        }
        this.roProxy.deregisterForNotifications(coordinator, n);
        myFroIdRepository.removeInstance(n, coordinator);
        this.getMaoContext().getServiceRepository().removeService((Object)this, PlugInUnitBuildIF.class, null);
        this.myData.delete(coordinator);
        super.delete(coordinator);
    }

    public int getPmProcessorLoad(Coordinator coordinator) throws MoAccessException {
        PmRequestContextImpl pmRequestContextImpl = new PmRequestContextImpl((ManagedObject)this, this.myPmProxyFroIdMap, coordinator);
        return (Integer)pmRequestContextImpl.getPmAttribute("pmProcessorLoad", INTEGER_PM_TYPE);
    }

    public int[] getPmProcessorCoreLoad(Coordinator coordinator) throws MoAccessException {
        PmRequestContextImpl pmRequestContextImpl = new PmRequestContextImpl((ManagedObject)this, this.myPmProxyFroIdMap, coordinator);
        return this.integerArray2primitiveArray((Integer[])pmRequestContextImpl.getPmAttribute("pmProcessorCoreLoad", INTEGER_ARRAY_PM_TYPE));
    }

    private int[] integerArray2primitiveArray(Integer[] integerArray) {
        int[] nArray = new int[integerArray.length];
        int n = 0;
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = integerArray[n];
        }
        return nArray;
    }

    public int getPmSwitchIngressDiscards(Coordinator coordinator) throws MoAccessException {
        if (this.connected2SpasSaiFro(coordinator)) {
            PmRequestContextImpl pmRequestContextImpl = new PmRequestContextImpl((ManagedObject)this, this.myPmProxyFroIdMap, coordinator);
            return (Integer)pmRequestContextImpl.getPmAttribute("pmSwitchIngressDiscards", INTEGER_PM_TYPE);
        }
        return -2;
    }

    public int getPmSwitchIngressLoad(Coordinator coordinator) throws MoAccessException {
        if (this.connected2SpasSaiFro(coordinator)) {
            PmRequestContextImpl pmRequestContextImpl = new PmRequestContextImpl((ManagedObject)this, this.myPmProxyFroIdMap, coordinator);
            return (Integer)pmRequestContextImpl.getPmAttribute("pmSwitchIngressLoad", INTEGER_PM_TYPE);
        }
        return -2;
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getAdministrativeState(Coordinator c)", (String)("c: " + coordinator));
        return this.getFroAttributes("getAdministrativeState", coordinator).getAdmState();
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAdministrativeState(int admState, Coordinator c)", (String)("admState: " + n + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (n != 0 && n != 1 && n != 2) {
            throw new ValueOutOfRangeException("administrativeState", "PlugInUnit");
        }
        if (this.connected2SpasSaiFro(coordinator)) {
            this.setAdministrativeStateSai(n, coordinator);
        }
        if (n == 1) {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"setAdministrativeState(int admState, Coordinator c)", (String)"Setting administrativeState to UNLOCKED");
            this.sendSetAdministrativeState(n, this.shutDownTimer.getValue(coordinator), 0, coordinator);
        }
        if (n == 2) {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"setAdministrativeState(int admState, Coordinator c)", (String)"Setting administrativeState to SHUTTINGDOWN");
            this.sendSetAdministrativeState(n, this.shutDownTimer.getValue(coordinator), 1, coordinator);
            String[] stringArray = new String[]{"administrativeState"};
            Object[] objectArray = new Object[]{new Integer(2)};
            myNotifSender.pushAVC((ManagedObject)this, stringArray, objectArray);
        }
        if (n == 0) {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"setAdministrativeState(int admState, Coordinator c)", (String)"Setting administrativeState to LOCKED");
            this.sendSetAdministrativeState(n, this.shutDownTimer.getValue(coordinator), 1, coordinator);
        }
    }

    public void setAdministrativeStateSwitch(int n, int n2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAdministrativeStateSwitch( int admState, int switchAtLock, Coordinator context )", (String)("admState: " + n + "\n\tswitchAtLock: " + n2 + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (n != 0 && n != 1 && n != 2) {
            throw new ValueOutOfRangeException("administrativeState", "PlugInUnit");
        }
        if (n2 != 1 && n2 != 2) {
            throw new ValueOutOfRangeException(SWITCH_PIU_AT_LOCK, "PlugInUnit");
        }
        if (this.connected2SpasSaiFro(coordinator)) {
            this.setAdministrativeStateSai(n, coordinator);
        }
        this.sendSetAdministrativeState(n, this.shutDownTimer.getValue(coordinator), n2, coordinator);
    }

    public void setAdministrativeStateSwitchUpgrade(int n, int n2, PIU_AdmStateListenerAcessInterface pIU_AdmStateListenerAcessInterface, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAdministrativeStateSwitchUpgrade( int admState, int aSwitchProperty, PIU_AdmStateListenerInterface aPIU_AdmStateListenerInterface, Coordinator context )", (String)("admState: " + n + "\n\taSwitchProperty: " + n2 + "\n\taPIU_AdmStateListenerInterface: " + pIU_AdmStateListenerAcessInterface + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        String string = null;
        if (n == 0) {
            string = "LOCKED";
        } else if (n == 1) {
            string = "UNLOCKED";
        } else if (n == 2) {
            string = "SHUTTINGDOWN";
        } else {
            UpgradeTrace.error(this.getClass(), (String)"setAdministrativeStateSwitchUpgrade(int anAdmState, int aSwitchProperty PIU_AdmStateListenerInterface aPIU_AdmStateListenerInterface, Coordinator aCoordinator)", (String)("Unexpected value for administrative state received, anAdmState: " + n));
            throw new ValueOutOfRangeException("administrativeState", "PlugInUnit");
        }
        String string2 = null;
        if (n2 == 0) {
            string2 = "NORMALIZATION";
        } else if (n2 == 1) {
            string2 = "SWITCH_AT_LOCK";
        } else if (n2 == 2) {
            string2 = "NOSWITCH_AT_LOCK";
        } else {
            UpgradeTrace.error(this.getClass(), (String)"setAdministrativeStateSwitchUpgrade(int anAdmState, int aSwitchProperty PIU_AdmStateListenerInterface aPIU_AdmStateListenerInterface, Coordinator aCoordinator)", (String)("Unexpected value for switch property received, aSwitchProperty: " + n2));
            throw new ValueOutOfRangeException(SWITCH_PIU_AT_LOCK, "PlugInUnit");
        }
        UpgradeTrace.debug(this.getClass(), (int)72, (String)"setAdministrativeStateSwitchUpgrade(int anAdmState, int aSwitchProperty PIU_AdmStateListenerInterface aPIU_AdmStateListenerInterface, Coordinator aCoordinator)", (String)("anAdmState: " + n + " (= " + string + ")" + "\n\taSwitchProperty: " + n2 + " (= " + string2 + ")" + "\n\taPIU_AdmStateListenerInterface: " + pIU_AdmStateListenerAcessInterface + "\n\taCoordinator: " + coordinator));
        this.myPIU_AdmStateListenerInterface = pIU_AdmStateListenerAcessInterface;
        try {
            if (this.connected2SpasSaiFro(coordinator)) {
                this.setAdministrativeStateSai(n, coordinator);
            }
            this.sendSetAdministrativeState(n, this.shutDownTimer.getValue(coordinator), n2, coordinator);
        }
        catch (MoAccessException moAccessException) {
            this.myPIU_AdmStateListenerInterface = null;
            throw moAccessException;
        }
        catch (Exception exception) {
            this.myPIU_AdmStateListenerInterface = null;
            UpgradeTrace.error(this.getClass(), (String)"setAdministrativeStateSwitchUpgrade(int anAdmState, int aSwitchProperty PIU_AdmStateListenerInterface aPIU_AdmStateListenerInterface, Coordinator aCoordinator)", (String)("Exception caught when trying to set administrative state,\n\tanAdmState: " + n + "\n\taSwitchProperty: " + n2), (Throwable)exception);
            throw new SetAdministrativeStateException("setAdministrativeStateSwitchUpgrade(int anAdmState, int aSwitchProperty PIU_AdmStateListenerInterface aPIU_AdmStateListenerInterface, Coordinator aCoordinator)\n\tException caught when trying to set administrative state,\n\tanAdmState: " + n + "\n\taSwitchProperty: " + n2 + "\n\tCaught Exception: " + exception.toString());
        }
    }

    public void setAdministrativeStateUpgrade(int n, PIU_AdmStateListenerAcessInterface pIU_AdmStateListenerAcessInterface, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAdministrativeStateUpgrade(int anAdmState, PIU_AdmStateListenerInterface aPIU_AdmStateListenerInterface, Coordinator aCoordinator)", (String)("anAdmState: " + n + "\n\taPIU_AdmStateListenerInterface: " + pIU_AdmStateListenerAcessInterface + "\n\taCoordinator: " + coordinator));
        int n2 = -1;
        n2 = n == 1 ? 0 : 1;
        this.setAdministrativeStateSwitchUpgrade(n, n2, pIU_AdmStateListenerAcessInterface, coordinator);
    }

    public void setShutDownTimer(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setShutDownTimer(int timerValue, Coordinator c)", (String)("timerValue: " + n + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        if (n < 0) {
            throw new ValueOutOfRangeException(SHUT_DOWN_TIMER, "PlugInUnit");
        }
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.shutDownTimer.setValue(n);
    }

    public int getShutDownTimer(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getShutDownTimer(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.shutDownTimer.getValue(coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getAvailabilityStatus(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return this.getFroAttributes("getAvailabilityStatus", coordinator).getAvailStatus();
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getOperationalState(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return this.getFroAttributes("getOperationalState", coordinator).getOperState();
    }

    public int getPiuGroupNumber(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getPiuGroupNumber(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return this.getFroAttributes("getPiuGroupNumber", coordinator).getPiuGroupNumber();
    }

    public void setPiuGroupNumber(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setPiuGroupNumber(int piuGN, Coordinator c) ", (String)("piuGN: " + n + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        if (n < 0 || n > 65536) {
            throw new ValueOutOfRangeException("piuGroupNumber", "PlugInUnit");
        }
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaPiuSetGroupNumberCfm osaPiuSetGroupNumberCfm = this.roProxy.sendOsaPiuSetGroupNumberReq(coordinator.getTransactionID(), this.resourceId.getValue(coordinator), n);
        String[] stringArray = new String[]{"piuGroupNumber"};
        Object[] objectArray = new Object[]{new Integer(n)};
        PlugInUnitMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
        this.checkSignal((Signal)osaPiuSetGroupNumberCfm);
    }

    public ManagedObject getPiuType(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getPiuType(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.piuType.getValue(coordinator);
    }

    public void changePiuType(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        String string;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"changePiuType(ManagedObject piuTypeValue, Coordinator c)", (String)("piuTypeValue: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null || !(managedObject instanceof PiuTypeAccess)) {
            throw new ValueOutOfRangeException("piuType", "PlugInUnit");
        }
        ManagedObject managedObject2 = this.getPiuType(coordinator);
        String string2 = managedObject2.getNamingAttributeValue();
        if (!string2.equals(string = managedObject.getNamingAttributeValue())) {
            ManagedObject managedObject3;
            PiuTypeAccess piuTypeAccess = (PiuTypeAccess)managedObject2;
            this.piuType.setValue(managedObject);
            piuTypeAccess.release(this, coordinator);
            ((PiuTypeAccess)managedObject).reserve(this, coordinator);
            MoIterator moIterator = this.getMaoContext().getMoAccessor().lookupType("ManagedElementData");
            if (moIterator != null && moIterator.hasMoreElements() && ((ManagedElementDataMo)(managedObject3 = moIterator.nextMo())).getAutoConfigurationAllowed(coordinator)) {
                PiuMoExtendImpl piuMoExtendImpl = new PiuMoExtendImpl();
                piuMoExtendImpl.updatePiuType(coordinator, managedObject, managedObject2, this);
            }
        }
    }

    public void updateMoConfiguration(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        PiuMoExtendImpl piuMoExtendImpl = new PiuMoExtendImpl();
        piuMoExtendImpl.updateMoConfiguration(coordinator, (PiuTypeAccess)this.getPiuType(coordinator), this);
    }

    public void checkPiuTypeCompliance(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        PiuMoExtendImpl piuMoExtendImpl = new PiuMoExtendImpl();
        piuMoExtendImpl.checkPiuTypeCompliance(coordinator, this);
    }

    public void deleteOldPrograms(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"deleteOldPrograms( Coordinator c, ManagedObject value)", (String)("value: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        PiuMoExtendImpl piuMoExtendImpl = new PiuMoExtendImpl();
        piuMoExtendImpl.deleteOldProgram(coordinator, managedObject, this);
    }

    public void setPiuTypeForSwUpgrade(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setPiuTypeForSwUpgrade(ManagedObject piuTypeSWU, Coordinator c)", (String)("piuTypeSWU: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        PiuTypeAccess piuTypeAccess = (PiuTypeAccess)this.piuType.getValue(coordinator);
        this.piuType.setValue(managedObject);
        if (piuTypeAccess != null) {
            piuTypeAccess.release(this, coordinator);
        }
        if (managedObject != null) {
            ((PiuTypeAccess)managedObject).reserve(this, coordinator);
        }
    }

    public void subscribeForOperStateAVCs(PIU_OperStateListenerAccessInterface pIU_OperStateListenerAccessInterface) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"subscribeForOperStateEnabled( PIU_OperStateListenerInterface aPIU_OperStateListenerInterface )", (String)("\n\taPIU_OperStateListenerInterface: " + pIU_OperStateListenerAccessInterface));
        if (this.myPIU_OperStateListenerInterface != null) {
            UpgradeTrace.info(this.getClass(), (String)"subscribeForOperStateAVCs(PIU_OperStateListenerInterface aPIU_OperStateListenerInterface)", (String)("Two instances are trying to subscribe for operState notification (ignored).\n\taPIU_OperStateListenerInterface: " + pIU_OperStateListenerAccessInterface + "\n\tmyPIU_OperStateListenerInterface: " + this.myPIU_OperStateListenerInterface));
        } else {
            this.myPIU_OperStateListenerInterface = pIU_OperStateListenerAccessInterface;
        }
    }

    public void unSubscribeForOperStateAVCs(PIU_OperStateListenerAccessInterface pIU_OperStateListenerAccessInterface) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"unSubscribeForOperStateEnabled(PIU_OperStateListenerInterface aPIU_OperStateListenerInterface)", (String)("\n\taPIU_OperStateListenerInterface: " + pIU_OperStateListenerAccessInterface));
        if (this.myPIU_OperStateListenerInterface == null) {
            UpgradeTrace.info(this.getClass(), (String)"unSubscribeForOperStateEnabled(PIU_OperStateListenerInterface aPIU_OperStateListenerInterface)", (String)("No instance subscribes for operState notification but one is trying to remove a subscription (ignored).\n\taPIU_OperStateListenerInterface: " + pIU_OperStateListenerAccessInterface));
        } else if (!pIU_OperStateListenerAccessInterface.equals(this.myPIU_OperStateListenerInterface)) {
            UpgradeTrace.info(this.getClass(), (String)"unSubscribeForOperStateEnabled(PIU_OperStateListenerInterface aPIU_OperStateListenerInterface)", (String)("An instance that does not subscribe for operState notification is trying to remove the subscription (ignored).\n\taPIU_OperStateListenerInterface: " + pIU_OperStateListenerAccessInterface));
        } else {
            this.myPIU_OperStateListenerInterface = null;
        }
    }

    public String getPlugInUnitId(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getPlugInUnitId(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getNamingAttributeValue();
    }

    public String getProductType(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductType(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return "HW";
    }

    public String getUnitType(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getUnitType(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((PiuTypeAccess)this.getPiuType(coordinator)).getProductName(coordinator);
    }

    public int getResourceId(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getResourceId(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return this.helpGetFroId(coordinator);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getFroId(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return this.helpGetFroId(coordinator);
    }

    private int helpGetFroId(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.resourceId.getValue(coordinator);
    }

    private int getSaiResourceId(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.saiResourceId.getValue(coordinator);
    }

    public int getResourceIdForME(Coordinator coordinator) throws MoAccessException {
        return this.getResourceId(coordinator);
    }

    public int getAsciPortNumber(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getAsciPortNumber(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return ((SlotMoImplInterface)this.getParent()).getAsciPortNumber(coordinator);
    }

    public int getSwitchModuleNumber(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSwitchModuleNumber(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return ((SubrackMoImpl)((SlotMoImplInterface)this.getParent()).getParent()).getSwitchModuleNumber(coordinator);
    }

    public int getRole(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getRole(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return this.getFroAttributes("getRole", coordinator).getRole();
    }

    public String getType() {
        return "PlugInUnit";
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getUserLabel(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setUserLabel(String value, Coordinator c)", (String)("label: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"PlugInUnit", (int)128, (int)0);
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public void setInterruptState(int n, Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.interruptState.setValue(n);
    }

    public int getInterruptState(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.interruptState.getValue(coordinator);
    }

    public int getAllowedSeqRestarts(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getAllowedSeqRestarts(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        return this.getFroAttributes("getAllowedSeqRestarts", coordinator).getAllowedSeqRestarts();
    }

    public void setAllowedSeqRestarts(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAllowedSeqRestarts(int restartsValue, Coordinator c)", (String)("restartsValue: " + n + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (!SeqRestartsEnum.inRange((int)n)) {
            throw new ValueOutOfRangeException("allowedSeqRestarts", "PlugInUnit");
        }
        OsaPiuSetAllowedRestartsCfm osaPiuSetAllowedRestartsCfm = this.roProxy.sendOsaPiuSetAllowedRestartsReq(coordinator.getTransactionID(), this.resourceId.getValue(coordinator), n);
        this.checkSignal((Signal)osaPiuSetAllowedRestartsCfm);
        if (osaPiuSetAllowedRestartsCfm.getResult() != 1) {
            String string = this.roProxy.getResultMsg(osaPiuSetAllowedRestartsCfm.getResult());
            throw new FroRequestFailedException("PlugInUnit", "set attribute", string, osaPiuSetAllowedRestartsCfm.getResult());
        }
        String[] stringArray = new String[]{"allowedSeqRestarts"};
        Object[] objectArray = new Object[]{new Integer(n)};
        PlugInUnitMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public int getHwTestStatus(Coordinator coordinator) throws MoAccessException {
        return this.getFroAttributes("getHwTestStatus", coordinator).getHwTestStatus();
    }

    public String getHwTestResult(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = 0;
        if (coordinator != null) {
            n = coordinator.getTransactionID();
        }
        OsaPiuHwTestResultRsp osaPiuHwTestResultRsp = this.roProxy.sendOsaPiuHwTestResultReq(n, this.resourceId.getValue(coordinator));
        this.checkSignal((Signal)osaPiuHwTestResultRsp);
        if (osaPiuHwTestResultRsp.getResult() != 1) {
            String string = this.roProxy.getResultMsg(osaPiuHwTestResultRsp.getResult());
            throw new FroRequestFailedException("PlugInUnit", "get attributes", string, osaPiuHwTestResultRsp.getResult());
        }
        return osaPiuHwTestResultRsp.getHwTestResult();
    }

    public int getOperationalIndicator(Coordinator coordinator) throws MoAccessException {
        OsaPiu2GetAttributesRsp osaPiu2GetAttributesRsp = this.getFroAttributes("getOperationalLed", coordinator);
        if (osaPiu2GetAttributesRsp instanceof OsaPiu3GetAttributesRsp) {
            return ((OsaPiu3GetAttributesRsp)osaPiu2GetAttributesRsp).getOperationalIndicator();
        }
        return 0;
    }

    public int getFaultIndicator(Coordinator coordinator) throws MoAccessException {
        OsaPiu2GetAttributesRsp osaPiu2GetAttributesRsp = this.getFroAttributes("getFaultLed", coordinator);
        if (osaPiu2GetAttributesRsp instanceof OsaPiu3GetAttributesRsp) {
            return ((OsaPiu3GetAttributesRsp)osaPiu2GetAttributesRsp).getFaultIndicator();
        }
        return 0;
    }

    public int getMaintenanceIndicator(Coordinator coordinator) throws MoAccessException {
        OsaPiu2GetAttributesRsp osaPiu2GetAttributesRsp = this.getFroAttributes("getMaintenanceLed", coordinator);
        if (osaPiu2GetAttributesRsp instanceof OsaPiu3GetAttributesRsp) {
            return ((OsaPiu3GetAttributesRsp)osaPiu2GetAttributesRsp).getMaintenanceIndicator();
        }
        return 0;
    }

    public int getStatusIndicator(Coordinator coordinator) throws MoAccessException {
        OsaPiu2GetAttributesRsp osaPiu2GetAttributesRsp = this.getFroAttributes("getStatusIndicator", coordinator);
        if (osaPiu2GetAttributesRsp instanceof OsaPiu3GetAttributesRsp) {
            return ((OsaPiu3GetAttributesRsp)osaPiu2GetAttributesRsp).getStatusIndicator();
        }
        return 0;
    }

    public int getGreenLed(Coordinator coordinator) throws MoAccessException {
        return this.getFroAttributes("getGreenLed", coordinator).getGreenLed();
    }

    public int getYellowLed(Coordinator coordinator) throws MoAccessException {
        return this.getFroAttributes("getYellowLed", coordinator).getYellowLed();
    }

    public int getRedLed(Coordinator coordinator) throws MoAccessException {
        return this.getFroAttributes("getRedLed", coordinator).getRedLed();
    }

    public int getSignatureValidationService(Coordinator coordinator) throws MoAccessException {
        OsaPiu2GetAttributesRsp osaPiu2GetAttributesRsp = this.getFroAttributes("getSignatureValidationService", coordinator);
        if (osaPiu2GetAttributesRsp instanceof OsaPiu4GetAttributesRsp) {
            return ((OsaPiu4GetAttributesRsp)osaPiu2GetAttributesRsp).getSignatureValidationService();
        }
        return 0;
    }

    public void actionManualRestart(int n, int n2, String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionManualRestart(int restartRank, int restartReason,String restartInfo, String restartInfoCoordinator c)", (String)("restartRank: " + n + "\n\trestartReason: " + n2 + "\n\trestartInfo: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        if (!RestartReasonEnum.inManualRange((int)n2) && n2 != 30) {
            throw new ValueOutOfRangeException(PIU_RESTART_REASON_VALUE, "PlugInUnit");
        }
        if (!RestartRankEnum.inRange((int)n)) {
            throw new ValueOutOfRangeException(PIU_RESTART_RANK_VALUE, "PlugInUnit");
        }
        if (string.length() > 80) {
            throw new ValueOutOfRangeException(PIU_RESTART_INFO, "PlugInUnit");
        }
        Thread thread = new Thread((Runnable)new RestartDelay(n, n2, string, this.resourceId.getValue(coordinator)), "PlugInUnitRestart");
        thread.start();
    }

    public void actionWriteRepairDelivNote(String string, String string2, String string3, String string4, String string5, String string6, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)" actionWriteRepairDelivNote(String preparedBy, String  countryCode, String  stateCode, String descriptionOfFault,String trNumber, String reference, Coordinator c)", (String)("preparedBy: " + string + "\n\tcountryCode: " + string2 + "\n\tstateCode: " + string3 + "\n\tdescriptionOfFault: " + string4 + "\n\ttrNumber: " + string5 + "\n\treference: " + string6 + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        OperFaultEntry operFaultEntry = new OperFaultEntry(string, string2, string3, string4, string5, string6);
        String string7 = operFaultEntry.getRepairDeliveryNote();
        OsaPiuOperatorWriteRsp osaPiuOperatorWriteRsp = null;
        osaPiuOperatorWriteRsp = this.roProxy.sendOsaWriteRepairDelivNoteReq(string7, this.resourceId.getValue(null));
        this.checkSignal((Signal)osaPiuOperatorWriteRsp);
        if (osaPiuOperatorWriteRsp.getResult() == 22) {
            throw new RepairDeliveryNoteAlreadyExistsException("Repair Delivery Note Already Exists");
        }
        if (osaPiuOperatorWriteRsp.getResult() == 23) {
            throw new NoAccessToHwLogException("No Access To HwLog");
        }
        if (osaPiuOperatorWriteRsp.getResult() == 27) {
            throw new HwLogFullException(" ");
        }
        if (osaPiuOperatorWriteRsp.getResult() != 21) {
            throw new FroRequestFailedException("PlugInUnit", "OsaPiu FRO", "WriteRepairDelivNote", osaPiuOperatorWriteRsp.getResult());
        }
    }

    public Struct actionReadRepairDelivNote(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)" actionReadRepairDelivNote(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        OsaPiuOperatorReadRsp osaPiuOperatorReadRsp = null;
        osaPiuOperatorReadRsp = this.roProxy.sendOsaReadRepairDelivNoteReq(this.resourceId.getValue(null));
        this.checkSignal((Signal)osaPiuOperatorReadRsp);
        if (osaPiuOperatorReadRsp.getResult() == 25) {
            throw new RepairDeliveryNoteDoesNotExistException("Repair Delivery Note Not Exists");
        }
        if (osaPiuOperatorReadRsp.getResult() == 26) {
            throw new NoAccessToHwLogException("No Access To HwLog");
        }
        if (osaPiuOperatorReadRsp.getResult() != 24) {
            throw new FroRequestFailedException("PlugInUnit", "OsaPiu FRO", "ReadRepairDelivNote", osaPiuOperatorReadRsp.getResult());
        }
        OperFaultEntry operFaultEntry = new OperFaultEntry(osaPiuOperatorReadRsp);
        return operFaultEntry.getStruct();
    }

    public void systemInitiatedRestart(int n, int n2, String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionSystemInitiatedRestart(int restartRank, int restartReason,String restartInfo, String restartInfoCoordinator c)", (String)("restartRank: " + n + "\n\trestartReason: " + n2 + "\n\trestartInfo: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        if (!RestartRankEnum.inRange((int)n)) {
            throw new ValueOutOfRangeException(PIU_RESTART_RANK_VALUE, "PlugInUnit");
        }
        if (!RestartReasonEnum.inSystemRange((int)n2)) {
            throw new ValueOutOfRangeException(PIU_RESTART_REASON_VALUE, "PlugInUnit");
        }
        if (string.length() > 80) {
            throw new ValueOutOfRangeException(PIU_RESTART_INFO, "PlugInUnit");
        }
        OsaPiu3RestartRsp osaPiu3RestartRsp = null;
        osaPiu3RestartRsp = this.roProxy.sendOsaPiu3RestartReq(this.resourceId.getValue(coordinator), n, n2, string);
        this.checkSignal((Signal)osaPiu3RestartRsp);
        if (osaPiu3RestartRsp.getResult() == 18) {
            throw new RestartRejectedException("Restart Not allowed");
        }
        if (osaPiu3RestartRsp.getResult() != 1) {
            throw new FroRequestFailedException("PlugInUnit", "OsaPiu FRO", "Restart", osaPiu3RestartRsp.getResult());
        }
    }

    public void actionReconfigureProgramPrepare(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionReconfigureProgramPrepare(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        ProgramHandlerFactoryAccess programHandlerFactoryAccess = (ProgramHandlerFactoryAccess)this.getMaoContext().getServiceRepository().getService(ProgramHandlerFactoryAccess.class);
        ProgramHandlerAccess programHandlerAccess = programHandlerFactoryAccess.getProgramHandlerAccess(this);
        programHandlerAccess.reconfigurePrograms(coordinator);
    }

    public void actionRemoveDisabledPrograms(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionRemoveDisabledPrograms(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        ProgramHandlerFactoryAccess programHandlerFactoryAccess = (ProgramHandlerFactoryAccess)this.getMaoContext().getServiceRepository().getService(ProgramHandlerFactoryAccess.class);
        ProgramHandlerAccess programHandlerAccess = programHandlerFactoryAccess.getProgramHandlerAccess(this);
        programHandlerAccess.removeDisabledPrograms(coordinator);
    }

    public void actionDisablePersistent(Coordinator coordinator) throws MoAccessException {
        this.checkifNodeisIntegrated(coordinator);
        this.genericProxyInstance.actionWithCfm(coordinator, this.getFroId(coordinator), 100, null);
    }

    private void checkifNodeisIntegrated(Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = null;
        MoIterator moIterator = MoRepository.instance().lookupType("Slot");
        if (moIterator != null && moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            int n = ((SlotMoImpl)managedObject).getIntegratedHardware(coordinator);
            if (n != 1) {
                throw new OperationNotAllowedException("RS232 cannot be disabled as the node is not integrated", "PlugInUnit");
            }
            return;
        }
    }

    public ManagedObject getSwAllocation(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSwAllocation(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        return ((SlotMoInternal)this.getParent()).getCalculatedSwAllocationForSU(coordinator);
    }

    public ManagedObject[] getSwAllocations(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSwAllocations(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        return ((SlotMoInternal)this.getParent()).getSwAllocations(coordinator);
    }

    public String getSubrackId(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSubrackId(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        SlotMoImplInterface slotMoImplInterface = (SlotMoImplInterface)this.getParent();
        SubrackMoImpl subrackMoImpl = (SubrackMoImpl)slotMoImplInterface.getParent();
        return subrackMoImpl.getSubrackId(coordinator);
    }

    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    public String[] getCurrentlySupportedVersions() throws SU_ConditionalException {
        return this.getSupportedVersions();
    }

    public int getSlotPosition(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSlotPosition(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        SlotMoImplInterface slotMoImplInterface = (SlotMoImplInterface)this.getParent();
        return slotMoImplInterface.getSlotNumber(coordinator);
    }

    public String getProductName(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductName(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((PiuTypeAccess)this.piuType.getValue(coordinator)).getProductName(coordinator);
    }

    public String getProductNumber(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductNumber(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((PiuTypeAccess)this.piuType.getValue(coordinator)).getProductNumber(coordinator);
    }

    public String getRState(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getRState(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((PiuTypeAccess)this.piuType.getValue(coordinator)).getProductRevision(coordinator);
    }

    public ManagedObject getPositionRef(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getPositionRef(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((ReferenceAttribute)this.myData.getAttribute("positionRef")).getValue(coordinator);
    }

    public void setPositionRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setPositionRef(ManagedObject positionRef, Coordinator c) ", (String)("positionRef: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        PlugInUnitMoImpl.validatePositionRef(managedObject);
        ManagedObject managedObject2 = this.getPositionRef(coordinator);
        this.updateReservedMos(managedObject2, managedObject, coordinator);
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ((ReferenceAttribute)this.myData.getAttribute("positionRef")).setValue(managedObject);
    }

    private void updateReservedMos(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        if (managedObject instanceof Reservable) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        if (managedObject2 instanceof Reservable) {
            ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        }
    }

    public static PlugInUnitMoImpl create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, InitialMaoContext initialMaoContext, OsaPiuMgmntProxyInterface osaPiuMgmntProxyInterface, SpasSaiMgmntProxyInterface spasSaiMgmntProxyInterface) throws MoAccessException {
        UpgradeTrace.debug((Class)PlugInUnitMoImpl.class, (int)70, (String)"create( ManagedObject parent, AttrList attributes, String namingAttributeValue, ManagedObject source, Coordinator c )", (String)("parent: " + managedObject.getType() + "\n\tattributes: " + Lib.toString((AttrList)attrList) + "\n\tnamingAttributeValue: " + string + "\n\tsource: " + managedObject2 + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"PlugInUnit", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"Slot");
        MoIterator moIterator = managedObject.getChildren();
        if (moIterator != null && moIterator.hasMoreElements()) {
            throw new MoCanNotBeCreatedException("PlugInUnit");
        }
        PlugInUnitMoImpl.checkRestrictionsForMicroCPP((SlotMo)managedObject, coordinator);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"administrativeState", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)2, (String)"PlugInUnit");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"PlugInUnit", (int)128, (int)0);
        int n2 = PlugInUnitMoImpl.checkAndGetPiuGroupNumber(attrList);
        PiuTypeAccess piuTypeAccess = PlugInUnitMoImpl.checkAndGetPiuType(attrList);
        int n3 = PlugInUnitMoImpl.checkAndGetShutDownTimer(attrList);
        int n4 = PlugInUnitMoImpl.checkAndGetAllowedSeqRestarts(attrList, piuTypeAccess);
        ManagedObject managedObject3 = PlugInUnitMoImpl.checkAndGetPositionRef(attrList);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"PlugInUnit");
        return new PlugInUnitMoImpl(managedObject, n, string, string2, n2, piuTypeAccess, n3, n4, managedObject3, coordinator, initialMaoContext, osaPiuMgmntProxyInterface, spasSaiMgmntProxyInterface);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        int n;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getReservedBy(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        Attribute[] attributeArray = this.reservedByList.getValue(coordinator);
        ManagedObject[] managedObjectArray = new ManagedObject[attributeArray.length];
        for (n = 0; n < attributeArray.length; ++n) {
            managedObjectArray[n] = ((ReferenceAttribute)attributeArray[n]).getValue(coordinator);
        }
        n = ((PiuTypeAccess)this.getPiuType(coordinator)).getRole(coordinator);
        Iterator iterator = this.getMaoContext().getServiceRepository().getServices(Aal5ReservingPiu.class);
        Aal5ReservingPiu aal5ReservingPiu = null;
        ManagedObject[] managedObjectArray2 = null;
        if (iterator != null && iterator.hasNext() && (n == 1 || n == 2)) {
            aal5ReservingPiu = (Aal5ReservingPiu)iterator.next();
            managedObjectArray2 = aal5ReservingPiu.getReservingAal5CepFroIds(coordinator, this.getResourceId(coordinator), n);
        }
        if (managedObjectArray2 != null) {
            ManagedObject[] managedObjectArray3 = new ManagedObject[managedObjectArray.length + managedObjectArray2.length];
            System.arraycopy(managedObjectArray, 0, managedObjectArray3, 0, managedObjectArray.length);
            System.arraycopy(managedObjectArray2, 0, managedObjectArray3, managedObjectArray.length, managedObjectArray2.length);
            return managedObjectArray3;
        }
        return managedObjectArray;
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        int n;
        if (managedObject instanceof IpRouterBuildIF && (n = ReservableImpl.noOfReservers((SequenceAttribute)this.reservedByList, (String)managedObject.getClass().getName(), (Coordinator)coordinator)) >= 31) {
            throw new OperationNotAllowedException("Only 31 IpRouter Mos are allowed to refer a PlugInUnit ", "PlugInUnit");
        }
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"reserve( ManagedObject mo, Coordinator context )", (String)("userId: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.reservedByList = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"PlugInUnit", (MoData)this.myData, (SequenceAttribute)this.reservedByList);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"release( ManagedObject mo, Coordinator context )", (String)("userId: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.reservedByList = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"PlugInUnit", (MoData)this.myData, (SequenceAttribute)this.reservedByList);
    }

    public PiuMoAttributesInformation getPiuAttributesInformation(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getPiuAttributesInformation ( Coordinator aCoordinator )", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        OsaPiu2GetAttributesRsp osaPiu2GetAttributesRsp = this.getFroAttributes("getPiuAttributesInformation", coordinator);
        return new PiuMoAttributesInformation(osaPiu2GetAttributesRsp.getPiuGroupNumber(), osaPiu2GetAttributesRsp.getAllowedSeqRestarts(), osaPiu2GetAttributesRsp.getAdmState(), osaPiu2GetAttributesRsp.getAdmProductNumber(), osaPiu2GetAttributesRsp.getAdmProductRevision(), osaPiu2GetAttributesRsp.getRole());
    }

    public int getInvalidAdmStateValue() {
        return 12;
    }

    public void setPiuAttributes(int n, String string, String string2, String string3, String string4, String string5, int n2, int n3, int n4, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setPiuAttributes ( int anAdministrativeState, String aProductNumber, String aProductRevision, String aProductName, String aProductionDate, String aSerialNumber, int aPIU_GroupNumber, int anAllowedSeqRestarts, int aPIU_Role )", (String)("anAdministrativeState: " + n + "\n\taProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\taProductName: " + string3 + "\n\taproductionDate: " + string4 + "\n\taSerialNumber: " + string5 + "\n\taPIU_GroupNumber: " + n2 + "\n\tanAllowedSeqRestarts: " + n3 + "\n\taPIU_Role: " + n4 + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        OsaPiuSetAttributesCfm osaPiuSetAttributesCfm = this.roProxy.sendOsaPiuSetAttributesReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.resourceId.getValue(coordinator), n, string, string2, string3, string4, string5, n2, n3, n4);
        this.checkSignal((Signal)osaPiuSetAttributesCfm);
        if (osaPiuSetAttributesCfm.getResult() != 1) {
            String string6 = this.roProxy.getResultMsg(osaPiuSetAttributesCfm.getResult());
            throw new FroRequestFailedException("PlugInUnit", "PIU Fro", "setPiuAttributes " + string6, osaPiuSetAttributesCfm.getResult());
        }
    }

    private PlugInUnitMoImpl(ManagedObject managedObject, int n, String string, String string2, int n2, PiuTypeAccess piuTypeAccess, int n3, int n4, ManagedObject managedObject2, Coordinator coordinator, InitialMaoContext initialMaoContext, OsaPiuMgmntProxyInterface osaPiuMgmntProxyInterface, SpasSaiMgmntProxyInterface spasSaiMgmntProxyInterface) throws MoAccessException {
        super(managedObject, "PlugInUnit", string, coordinator, initialMaoContext);
        ManagedObject managedObject3;
        super.setPmHandler((GenPmMaoHandler)new MaoPmStrategyForReqContext((ManagedObject)this, this.myPmAppPortal));
        this.roProxy = osaPiuMgmntProxyInterface;
        this.saiProxy = spasSaiMgmntProxyInterface;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"PlugInUnitMoImpl(ManagedObject parent, int admState,String namingAttributeValue, String userLabel, int piuGroupNumber, PiuTypeMo piuType, int aShutDownTimer, int allowedSeqRestarts, Coordinator context)", (String)("parent: " + managedObject.getType() + "\n\tadmState" + n + "\n\tnamingAttributeValue: " + string + "\n\tuserL: " + string2 + "\n\tpiuGroupNumber: " + n2 + "\n\tpiuType: " + piuTypeAccess + "\n\taShutDownTimer: " + n3 + "\n\tallowedSeqRestarts: " + n4 + "\n\tpositionRef: " + (managedObject2 == null ? "" : managedObject2.getLocalDistinguishedName()) + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        int n5 = piuTypeAccess.getRole(coordinator);
        SlotMoImplInterface slotMoImplInterface = (SlotMoImplInterface)managedObject;
        long l = slotMoImplInterface.getResourceId(coordinator);
        OsaPiuCreateCfm osaPiuCreateCfm = osaPiuMgmntProxyInterface.sendOsaPiuCreateReq(this.hashCode(), coordinator.getTransactionID(), l, n, n5, piuTypeAccess.getProductNumber(coordinator), piuTypeAccess.getProductRevision(coordinator), piuTypeAccess.getProductName(coordinator), piuTypeAccess.getProductionDate(coordinator), "", n2, n4);
        this.checkSignal((Signal)osaPiuCreateCfm);
        if (osaPiuCreateCfm.getResult() != 1) {
            String string3 = osaPiuMgmntProxyInterface.getResultMsg(osaPiuCreateCfm.getResult());
            throw new FroRequestFailedException("PlugInUnit", "Osa fro ", "create " + string3, osaPiuCreateCfm.getResult());
        }
        int n6 = osaPiuCreateCfm.getFroId();
        myFroIdRepository.addInstance(n6, (ManagedObject)this, coordinator);
        int n7 = 0;
        if (this.connected2SpasSaiFro(coordinator)) {
            int n8 = slotMoImplInterface.getAsciPortNumber(coordinator);
            int n9 = ((SubrackMoInternal)slotMoImplInterface.getParent()).getSwitchModuleNumber(coordinator);
            SpasSaiFroCreateRsp spasSaiFroCreateRsp = spasSaiMgmntProxyInterface.sendSpasSaiFroCreateReq(coordinator.getTransactionID(), n9, n8, n);
            this.checkSignal((Signal)spasSaiFroCreateRsp);
            if (spasSaiFroCreateRsp.getResult() != 1) {
                String string4 = spasSaiMgmntProxyInterface.getResultMsg(spasSaiFroCreateRsp.getResult());
                throw new FroRequestFailedException("PlugInUnit", "saiFRO", "Create fro-sai " + string4, spasSaiFroCreateRsp.getResult());
            }
            n7 = spasSaiFroCreateRsp.getFroId();
            spasSaiMgmntProxyInterface.registerForNotifications(coordinator, this, n7);
            this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n7);
        }
        this.initMoData(n6, n7, string2, piuTypeAccess, n3, managedObject2, coordinator);
        this.getMaoContext().getServiceRepository().addService((Object)this, PlugInUnitBuildIF.class, null);
        piuTypeAccess.reserve(this, coordinator);
        if (managedObject2 instanceof Reservable) {
            ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        }
        osaPiuMgmntProxyInterface.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n6);
        nssProxy.registerForNotifications(coordinator, this, n6);
        MoIterator moIterator = this.getMaoContext().getMoAccessor().lookupType("ManagedElementData");
        if (moIterator != null && moIterator.hasMoreElements() && ((ManagedElementDataMo)(managedObject3 = moIterator.nextMo())).getAutoConfigurationAllowed(coordinator)) {
            this.createChildren(coordinator);
        }
    }

    private void initMoData(int n, int n2, String string, PiuTypeAccess piuTypeAccess, int n3, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"initMoData(int resourceId, int saiFroId, String userLabel, PiuTypeMo piuType, int aShutDownTimer, Coordinator c)", (String)("resourceId: " + n + "\n\tsaiFroId: " + n2 + "\n\tuserLabel: " + string + "\n\tpiuType: " + piuTypeAccess + "\n\taShutDownTimer: " + n3 + "context: " + Lib.toString((Coordinator)coordinator)));
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.resourceId = new IntegerAttribute(RESOURCE_ID, false, n);
        this.myData.registerPersistentAttr((Attribute)this.resourceId);
        this.saiResourceId = new IntegerAttribute(SAI_RESOURCE_ID, false, n2);
        this.myData.registerPersistentAttr((Attribute)this.saiResourceId);
        this.userLabel = new StringAttribute("userLabel", true, string);
        this.myData.registerPersistentAttr((Attribute)this.userLabel);
        this.piuType = new ReferenceAttribute("piuType", true, (ManagedObject)piuTypeAccess);
        this.myData.registerPersistentAttr((Attribute)this.piuType);
        this.reservedByList = new SequenceAttribute(RESERVED_BY_LIST, false);
        this.myData.registerPersistentAttr((Attribute)this.reservedByList);
        this.interruptState = new IntegerAttribute(INTERRUPT_STATE, false, 0);
        this.myData.registerPersistentAttr((Attribute)this.interruptState);
        this.myData.setRevision(9000);
        this.shutDownTimer = new IntegerAttribute(SHUT_DOWN_TIMER, true);
        this.shutDownTimer.setValue(n3);
        this.myData.registerPersistentAttr((Attribute)this.shutDownTimer);
        this.myData.registerPersistentAttr((Attribute)new ReferenceAttribute("positionRef", true, managedObject));
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    private void checkSignal(Signal signal) throws FroNotAccessibleException {
        if (signal != null) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"checkSignal(enea.ose.system.Signal sig)", (String)("sig: " + signal.getSigNo()));
        }
        if (signal == null) {
            throw new FroNotAccessibleException("PlugInUnit", "Resource fRo is not accessible.");
        }
    }

    private static int checkAndGetShutDownTimer(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)PlugInUnitMoImpl.class, (int)70, (String)"checkAndGetShutDownTimer( AttrList attributes )", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = 0;
        int n2 = attrList.indexOf(SHUT_DOWN_TIMER);
        if (n2 == -1) {
            return 0;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException(SHUT_DOWN_TIMER, "PlugInUnit");
        }
        if ((Integer)attrList.getValue(n2) < 0) {
            throw new ValueOutOfRangeException(SHUT_DOWN_TIMER, "PlugInUnit");
        }
        n = (Integer)attrList.getValue(n2);
        attrList.removeElementAt(n2);
        return n;
    }

    private static int checkAndGetPiuGroupNumber(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)PlugInUnitMoImpl.class, (int)70, (String)"checkAndGetPiuGroupNumber( AttrList attributes )", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = 0;
        int n2 = attrList.indexOf("piuGroupNumber");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("piuGroupNumber", "PlugInUnit");
        }
        n = (Integer)attrList.getValue(n2);
        if (n < 0 || n > 65536) {
            throw new ValueOutOfRangeException("piuGroupNumber", "PlugInUnit");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static PiuTypeAccess checkAndGetPiuType(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)PlugInUnitMoImpl.class, (int)70, (String)"checkAndGetPiuType( AttrList attributes )", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        PiuTypeAccess piuTypeAccess = null;
        int n = attrList.indexOf("piuType");
        if (n == -1) {
            throw new AttrMissingAtCreateException("PlugInUnit", "piuType");
        }
        if (!(attrList.getValue(n) instanceof PiuTypeAccess)) {
            throw new WrongAttributeTypeException("piuType", "PlugInUnit");
        }
        piuTypeAccess = (PiuTypeAccess)attrList.getValue(n);
        attrList.removeElementAt(n);
        return piuTypeAccess;
    }

    private static int checkAndGetAllowedSeqRestarts(AttrList attrList, PiuTypeAccess piuTypeAccess) throws MoAccessException {
        UpgradeTrace.debug((Class)PlugInUnitMoImpl.class, (int)70, (String)"checkAndGetAllowedSeqRestarts( AttrList attributes )", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = 0;
        int n2 = attrList.indexOf("allowedSeqRestarts");
        if (n2 == -1) {
            return piuTypeAccess.getDefAllowedSeqRestarts(null);
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("allowedSeqRestarts", "PlugInUnit");
        }
        n = (Integer)attrList.getValue(n2);
        if (!SeqRestartsEnum.inRange((int)n)) {
            throw new ValueOutOfRangeException("allowedSeqRestarts", "PlugInUnit");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static ManagedObject checkAndGetPositionRef(AttrList attrList) throws MoAccessException {
        ManagedObject managedObject = null;
        int n = attrList.indexOf("positionRef");
        if (n >= 0) {
            managedObject = (ManagedObject)attrList.getValue(n);
            PlugInUnitMoImpl.validatePositionRef(managedObject);
        }
        return managedObject;
    }

    private static void validatePositionRef(ManagedObject managedObject) throws MoAccessException {
        if (managedObject != null && !(managedObject instanceof Reservable)) {
            throw new ValueOutOfRangeException("positionRef", "PlugInUnit", "The MO referred to by positionRef must be reservable.");
        }
    }

    private void sendSetAdministrativeState(int n, long l, int n2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"sendSetAdministrativeState(int admState,long timer, int switchAtLock, Coordinator c)", (String)("admState: " + n + "\n\ttimer: " + l + "\n\tswitchAtLock: " + n2 + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        long l2 = 0L;
        if (n == 2) {
            l2 = l;
        } else if (n == 0) {
            l2 = l;
        }
        OsaPiuSetAdmStateCfm osaPiuSetAdmStateCfm = this.roProxy.sendOsaPiuSetAdmStateReq(coordinator.getTransactionID(), this.resourceId.getValue(coordinator), n, l2, n2);
        this.checkSignal((Signal)osaPiuSetAdmStateCfm);
        if (osaPiuSetAdmStateCfm.getResult() != 1) {
            String string = this.roProxy.getResultMsg(osaPiuSetAdmStateCfm.getResult());
            throw new FroRequestFailedInformationException("PlugInUnit", "osa FRO", "setAdministrativeState " + string, osaPiuSetAdmStateCfm.getResult());
        }
    }

    private static void sendChangeNotification(ManagedObject managedObject, String[] stringArray, Object[] objectArray, Coordinator coordinator) {
        UpgradeTrace.debug((Class)PlugInUnitMoImpl.class, (int)70, (String)"sendChangeNotification(ManagedObject mo, String[] attrNames, Object[] newValues, Coordinator context)", (String)("mo: " + managedObject + "\n\tattrNames: " + Lib.toString((String[])stringArray) + "\n\tnewValues: " + objectArray + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        NotificationSender notificationSender = NotificationSender.instance();
        notificationSender.pushAVC(managedObject, stringArray, objectArray, coordinator);
    }

    private void createChildren(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"createChildren(Coordinator c) ", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        PiuMoExtendImpl piuMoExtendImpl = new PiuMoExtendImpl();
        piuMoExtendImpl.createSubordinates(coordinator, this, (PlugNPlayListener)this.getParent());
    }

    private void deleteChildren(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"deleteChildren(Coordinator c) ", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        PiuMoExtendImpl piuMoExtendImpl = new PiuMoExtendImpl();
        piuMoExtendImpl.deleteSubordinates(coordinator, this);
    }

    private void setAdministrativeStateSai(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAdministrativeStateSai(int admState, Coordinator c) ", (String)("admState: " + n + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        int n2 = this.saiResourceId.getValue(coordinator);
        try {
            this.sendSpasSaiFroSetAdmStateReq(coordinator, n2, n);
        }
        catch (FroLocationFailedException froLocationFailedException) {
            try {
                Thread.sleep(30000L);
            }
            catch (Exception exception) {
                UpgradeTrace.error(this.getClass(), (String)"setAdministrativeStateSai(int admState, Coordinator c)", (String)("Exception caught while trying to sleep for 30 seconds.\n\tadmState: " + n + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)), (Throwable)exception);
            }
            this.sendSpasSaiFroSetAdmStateReq(coordinator, n2, n);
        }
        catch (FroShutdownException froShutdownException) {
            this.sendSpasSaiFroSetAdmStateReq(coordinator, n2, n);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            throw froNotAccessibleException;
        }
        catch (FroRequestFailedException froRequestFailedException) {
            throw froRequestFailedException;
        }
    }

    private void sendSpasSaiFroSetAdmStateReq(Coordinator coordinator, long l, int n) throws FroNotAccessibleException, FroRequestFailedException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"sendSpasSaiFroSetAdmStateReq ( Coordinator c, long froId, int admStateSai ) ", (String)("froId: " + l + "\n\tadmStateSai: " + n + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        SpasSaiFroSetAdmStateRsp spasSaiFroSetAdmStateRsp = this.saiProxy.sendSpasSaiFroSetAdmStateReq(coordinator.getTransactionID(), l, n);
        if (spasSaiFroSetAdmStateRsp.getResult() != 1) {
            String string = this.saiProxy.getResultMsg(spasSaiFroSetAdmStateRsp.getResult());
            throw new FroRequestFailedException("PlugInUnit", "PlugInUnit fRo", "Set AdministrativeStateSai" + string, spasSaiFroSetAdmStateRsp.getResult());
        }
    }

    public synchronized void parameterChanged(UnlinkedSignal unlinkedSignal, String string) {
        block13: {
            block14: {
                OsaPiuSwitchReadyInd osaPiuSwitchReadyInd;
                block16: {
                    int n;
                    block15: {
                        block12: {
                            UpgradeTrace.debug(this.getClass(), (int)70, (String)"parameterChanged(UnlinkedSignal parameterChdInd, String proxy)", (String)("parameterChdInd: " + unlinkedSignal + "\n\tproxy: " + string));
                            if (!(unlinkedSignal instanceof OsaPiuAutoLockInd)) break block12;
                            UpgradeTrace.debug(this.getClass(), (int)72, (String)"parameterChanged(UnlinkedSignal parameterChdInd, String proxy)", (String)"PlugInUnit FRO have changed state from shuttingDown to locked (OsaPiuAutoLockInd)");
                            if (this.myPIU_AdmStateListenerInterface != null) {
                                this.myPIU_AdmStateListenerInterface.admStateHasBeenSet(this);
                                this.myPIU_AdmStateListenerInterface = null;
                            }
                            break block13;
                        }
                        if (!(unlinkedSignal instanceof OsaPiuSwitchReadyInd)) break block14;
                        osaPiuSwitchReadyInd = (OsaPiuSwitchReadyInd)unlinkedSignal;
                        n = osaPiuSwitchReadyInd.getPiuSwitchAtLock();
                        if (n != 0) break block15;
                        UpgradeTrace.debug(this.getClass(), (int)72, (String)"parameterChanged(UnlinkedSignal parameterChdInd, String proxy)", (String)"PlugInUnit FRO have changed state from locked to unlocked (OsaPiuSwitchReadyInd)");
                        if (osaPiuSwitchReadyInd.getResult() != 1) {
                            UpgradeTrace.warning(this.getClass(), (String)"parameterChanged(UnlinkedSignal parameterChdInd, String proxy)", (String)"Normalization rejected when PlugInUnit FRO changed state from locked to unlocked.");
                        }
                        if (this.myPIU_AdmStateListenerInterface != null) {
                            this.myPIU_AdmStateListenerInterface.admStateHasBeenSet(this);
                            this.myPIU_AdmStateListenerInterface = null;
                        }
                        String[] stringArray = new String[]{new String("administrativeState")};
                        Object[] objectArray = new Object[]{new Integer(1)};
                        myNotifSender.pushAVC((ManagedObject)this, stringArray, objectArray);
                        break block13;
                    }
                    if (n == 1) break block16;
                    if (n != 2) break block13;
                }
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"parameterChanged(UnlinkedSignal parameterChdInd, String proxy)", (String)"PlugInUnit FRO have changed state from unlocked to locked (OsaPiuSwitchReadyInd)");
                if (osaPiuSwitchReadyInd.getResult() != 1) {
                    UpgradeTrace.warning(this.getClass(), (String)"parameterChanged(UnlinkedSignal parameterChdInd, String proxy)", (String)"Switch rejected when PlugInUnit FRO changed state from unlocked to locked");
                }
                if (this.myPIU_AdmStateListenerInterface != null) {
                    this.myPIU_AdmStateListenerInterface.admStateHasBeenSet(this);
                    this.myPIU_AdmStateListenerInterface = null;
                }
                String[] stringArray = new String[]{new String("administrativeState")};
                Object[] objectArray = new Object[]{new Integer(0)};
                myNotifSender.pushAVC((ManagedObject)this, stringArray, objectArray);
                break block13;
            }
            if (unlinkedSignal instanceof OsaPiu2OperStatePropagation) {
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"parameterChanged(UnlinkedSignal parameterChdInd, String proxy)", (String)"PlugInUnit FRO have changed state (OsaPiu2OperStatePropagation)");
                try {
                    String[] stringArray = new String[]{new String("operationalState"), new String("availabilityStatus")};
                    int n = ((OsaPiu2OperStatePropagation)unlinkedSignal).getOperState();
                    int n2 = ((OsaPiu2OperStatePropagation)unlinkedSignal).getAvailStatus();
                    if (this.myPIU_OperStateListenerInterface != null) {
                        this.myPIU_OperStateListenerInterface.operStateHasBeenSet(this, n);
                    }
                    Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
                    myNotifSender.pushAVC((ManagedObject)this, stringArray, objectArray);
                }
                catch (Exception exception) {
                    UpgradeTrace.error(this.getClass(), (String)"parameterChanged(UnlinkedSignal parameterChdInd, String proxy)", (String)"Exception caught, private attribute operState may contain inconsistent data.", (Throwable)exception);
                }
            } else {
                UpgradeTrace.error(this.getClass(), (String)"parameterChanged(UnlinkedSignal parameterChdInd, String proxy)", (String)("Unexpected type of signal, parameterChdInd: " + unlinkedSignal.toString()));
            }
        }
    }

    private boolean connected2SpasSaiFro(Coordinator coordinator) throws MoAccessException {
        boolean bl;
        int n = this.getSubrackTransmissionType(coordinator);
        if (n == 1 || n == 2) {
            bl = true;
        } else if (n == 3 || n == 4 || n == 5) {
            bl = false;
        } else {
            throw new ValueOutOfRangeException("PlugInUnit", "Unknown TransmissionType, transmissionType: " + n);
        }
        return bl;
    }

    private int getSubrackTransmissionType(Coordinator coordinator) throws MoAccessException {
        SubrackMoImplInterface subrackMoImplInterface = (SubrackMoImplInterface)((SlotMoImplInterface)this.getParent()).getParent();
        SubrackProdTypeBuildIF subrackProdTypeBuildIF = (SubrackProdTypeBuildIF)subrackMoImplInterface.getSubrackProdTypeRef(coordinator);
        if (subrackProdTypeBuildIF != null) {
            return subrackProdTypeBuildIF.getTransmissionType(coordinator);
        }
        return subrackMoImplInterface.getTransmissionTypeFromFro(coordinator);
    }

    private static void checkRestrictionsForMicroCPP(SlotMo slotMo, Coordinator coordinator) throws OperationNotAllowedException, MoAccessException {
        MoIterator moIterator = MoRepository.instance().lookupType("ManagedElement");
        if (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            if (!((ManagedElementMo)managedObject).isIDL1_IDL2(coordinator)) {
                if (((SubrackProdTypeBuildIF)((SubrackMo)slotMo.getParent()).getSubrackProdTypeRef(coordinator)).getTransmissionType(coordinator) == 3) {
                    MoRepository moRepository = MoRepository.instance();
                    MoIterator moIterator2 = moRepository.lookupType("InterPiuLink");
                    if (moIterator2 != null) {
                        boolean bl = false;
                        while (moIterator2.hasMoreElements()) {
                            InterPiuLinkMo interPiuLinkMo = (InterPiuLinkMo)moIterator2.nextMo();
                            if (!slotMo.equals(interPiuLinkMo.getPrimaryPiuSlot(coordinator)) && !slotMo.equals(interPiuLinkMo.getSecondaryPiuSlot(coordinator))) continue;
                            bl = true;
                        }
                        if (!bl) {
                            throw new OperationNotAllowedException("The PlugInUnit can not be created. When transmissionType is ETHERNET_CABLE and there is an InterPiuLink MO on the node, PlugInUnit MOs can only be created for Slot MOs referred to from the InterPiuLink.", "PlugInUnit");
                        }
                    } else {
                        MoIterator moIterator3 = moRepository.lookupType("PlugInUnit");
                        if (moIterator3 != null && moIterator3.hasMoreElements()) {
                            throw new OperationNotAllowedException("The PlugInUnit can not be created.  When transmissionType is ETHERNET_CABLE and there is no InterPiuLink MO on the node, only one PlugInUnit MO is allowed.", "PlugInUnit");
                        }
                    }
                }
            } else {
                MessageLog.info((Class)PlugInUnitMoImpl.class, (String)"Node-type is IDL1_IDL2.");
            }
        }
    }

    private OsaPiu2GetAttributesRsp getFroAttributes(String string, Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaPiu2GetAttributesRsp osaPiu2GetAttributesRsp = this.roProxy.sendOsaPiu2GetAttributesReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.resourceId.getValue(coordinator));
        this.checkSignal((Signal)osaPiu2GetAttributesRsp);
        if (osaPiu2GetAttributesRsp.getResult() != 1) {
            String string2 = this.roProxy.getResultMsg(osaPiu2GetAttributesRsp.getResult());
            throw new FroRequestFailedException("PlugInUnit", "osa FRO", string + " " + string2, osaPiu2GetAttributesRsp.getResult());
        }
        return osaPiu2GetAttributesRsp;
    }

    public int getPmFroId(String string, Coordinator coordinator) throws MoAccessException {
        if (osa_pluginunit.getExtendedMoType(this.getType()).equals(string)) {
            return this.getResourceId(coordinator);
        }
        if (spas_plugin_unit.getExtendedMoType(this.getType()).equals(string)) {
            if (this.connected2SpasSaiFro(coordinator)) {
                return this.getSaiResourceId(coordinator);
            }
            int n = this.getResourceId(coordinator);
            if (n == 1) {
                return Integer.MIN_VALUE;
            }
            return -n;
        }
        return -1;
    }

    private class RestartDelay
    implements Runnable {
        private int restartRank;
        private int restartReason;
        private String restartInfo;
        private int resourceId;

        RestartDelay(int n, int n2, String string, int n3) {
            this.restartRank = n;
            this.restartReason = n2;
            this.restartInfo = string;
            this.resourceId = n3;
        }

        public void run() {
            try {
                Thread.currentThread();
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                OsaPiu3RestartRsp osaPiu3RestartRsp = null;
                osaPiu3RestartRsp = PlugInUnitMoImpl.this.roProxy.sendOsaPiu3RestartReq(this.resourceId, this.restartRank, this.restartReason, this.restartInfo);
                PlugInUnitMoImpl.this.checkSignal((Signal)osaPiu3RestartRsp);
                int n = osaPiu3RestartRsp.getResult();
                PlugInUnitMoImpl.this.roProxy;
                if (n == 18) {
                    throw new RestartRejectedException("Restart not allowed");
                }
                int n2 = osaPiu3RestartRsp.getResult();
                PlugInUnitMoImpl.this.roProxy;
                if (n2 != 1) {
                    throw new FroRequestFailedException("PlugInUnit", "OsaPiu FRO", "Restart", osaPiu3RestartRsp.getResult());
                }
            }
            catch (Exception exception) {
                MessageLog.traceError(this.getClass(), (String)"RestartDelay run(), restart failed with exception", (Throwable)exception);
            }
            catch (Error error) {
                MessageLog.traceError(this.getClass(), (String)"RestartDelay run(), restart failed with error", (Throwable)error);
            }
        }
    }
}

