/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import enea.ose.system.Signal;
import se.ericsson.cello.equipment.EquipException;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.equipment.LoadModuleBuildIF;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.equipment.ProgramHeapAndPoolSizeInterfaceBase;
import se.ericsson.cello.equipment.ProgramInstances;
import se.ericsson.cello.equipment.ProgramMo;
import se.ericsson.cello.equipment.ProgramMoInternal;
import se.ericsson.cello.equipment.eqaccess.MO_HandlerFactoryAccess;
import se.ericsson.cello.equipment.eqaccess.RPU_MO_HandlerAccess;
import se.ericsson.cello.equipment.fropxy.OsaFanPgmGetAttributesRsp;
import se.ericsson.cello.equipment.fropxy.OsaFanPgmMgmntProxy;
import se.ericsson.cello.equipment.fropxy.OsaFanPgmSetStartStateCfm;
import se.ericsson.cello.equipment.fropxy.OsaPgm3GetAttributeRsp;
import se.ericsson.cello.equipment.fropxy.OsaPgmMgmntProxy;
import se.ericsson.cello.equipment.fropxy.OsaPgmSetHeapSizeCfm;
import se.ericsson.cello.equipment.fropxy.OsaPgmSetPoolSizeCfm;
import se.ericsson.cello.equipment.fropxy.OsaPgmSetStartStateCfm;
import se.ericsson.cello.equipment.fropxy.OsaPgmUpgradeRsp;
import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.equipment.suaccess.ProgramMoSU_Access;
import se.ericsson.cello.equipment.suaccess.StartOpState;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.ActionNotAllowedException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.AccessControlHelper;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.FilterSyntaxException;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.LongAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.util.library.Lib;

public class ProgramMoImpl
extends ManagedObjectBase
implements ProgramMoInternal,
ProgramMoSU_Access,
ProgramHeapAndPoolSizeInterfaceBase {
    private MoData data;
    private LongAttribute resourceId;
    private StringAttribute userLabel;
    private ReferenceAttribute loadModule;
    private BooleanAttribute isUpgradePersistent;
    private OsaPgmMgmntProxy roProxy = OsaPgmMgmntProxy.getPgmProxy();
    private OsaFanPgmMgmntProxy fanPgmProxy = OsaFanPgmMgmntProxy.instance();
    private static final String JVM_PRODUCT_NUMBER = "CXC1320784";
    private static final String J9_PRODUCT_NUMBER = "CXC1732844";
    private static final int JVM_RESTART_TIMER_INITIAL_VALUE = 900;
    public static final int STARTSTATE_ENABLED = 1;
    public static final int STARTSTATE_DISABLED = 0;
    public static final int NOT_INSTALLED = 0;
    protected static final String[] SUPPORTED_VERSIONS = new String[]{"SU_1", "SU_2", "SU_3"};

    static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        ProgramMo programMo;
        UpgradeTrace.debug((Class)ProgramMoImpl.class, (int)70, (String)"create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator c)", (String)("parent: " + managedObject + "\n\tattributes: " + Lib.toString((AttrList)attrList) + "\n\tidentity: " + string + "\n\tsource: " + managedObject2 + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"Program", (String)string);
        String[] stringArray = new String[]{"PlugInUnit", "Fan", "PfmUnit"};
        MoAttributeValidator.checkParents((ManagedObject)managedObject, (String[])stringArray);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"Program", (int)128, (int)0);
        LoadModuleBuildIF loadModuleBuildIF = (LoadModuleBuildIF)MoAttributeValidator.checkAndGetReferenceAttribute((String)"loadModule", (AttrList)attrList, (boolean)true, (String[])LM_CLASSNAME, (String)"Program");
        if (loadModuleBuildIF.getFileState(coordinator) == 0) {
            throw new OperationNotAllowedException("Configuration of the program is not possible as LoadModule is not installed", "Program");
        }
        int n = ProgramMoImpl.checkAndGetLoaderType(managedObject, loadModuleBuildIF, attrList, coordinator);
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"startState", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)1, (String)"Program");
        if (managedObject instanceof PlugInUnitMo && n2 == 1 && (programMo = ProgramMoImpl.getExistingEnabledProgram(managedObject, (ManagedObject)loadModuleBuildIF, coordinator)) != null && !ProgramMoImpl.checkIfDeviceAndOSEloader(n, programMo.getLoaderType(coordinator))) {
            throw new ValueOutOfRangeException("startState", "Program", "A program with startState enabled already exist under PIU: " + managedObject.getLocalDistinguishedName());
        }
        boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"isUpgradePersistent", (AttrList)attrList, (boolean)false, (boolean)false, (String)"Program");
        int n3 = ProgramMoImpl.checkAndGetHeapSize(attrList, loadModuleBuildIF, coordinator);
        int n4 = ProgramMoImpl.checkAndGetPoolSize(attrList, loadModuleBuildIF, coordinator);
        int n5 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"restartTimer", (AttrList)attrList, (boolean)false, (int)60, (int)-1, (int)65535, (String)"Program");
        int n6 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"restartCounterLimit", (AttrList)attrList, (boolean)false, (int)3, (int)-1, (int)65535, (String)"Program");
        ProgramInstances programInstances = ProgramMoImpl.checkAndGetProgramInstances(attrList, managedObject);
        String string3 = ProgramMoImpl.checkAndGetDeviceLoaderName(loadModuleBuildIF, attrList, coordinator);
        String string4 = ProgramMoImpl.checkAndGetDeviceLoaderInformation(loadModuleBuildIF, attrList, coordinator);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"Program");
        return new ProgramMoImpl(managedObject, string2, loadModuleBuildIF, n2, n3, n4, n5, n6, n, string, bl, programInstances, string3, string4, coordinator);
    }

    private ProgramMoImpl(ManagedObject managedObject, String string, LoadModuleBuildIF loadModuleBuildIF, int n, long l, long l2, int n2, int n3, int n4, String string2, boolean bl, ProgramInstances programInstances, String string3, String string4, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "Program", string2, coordinator);
        int n5;
        Object object;
        UpgradeTrace.debug((Class)ProgramMoImpl.class, (int)70, (String)"ProgramMoImpl(ManagedObject parent, String userLabel, LoadModuleBuildIF lmMo, int startState, int heapSize, int poolSize, int restartTimer, int restartCounterLimit, int loadModuleType, String identity, boolean upgradePersistent, Coordinator c)", (String)("parent: " + managedObject + "\n\tuserLabel: " + string + "\n\tlmMo: " + loadModuleBuildIF + "\n\tstartState: " + n + "\n\theapSize: " + l + "\n\tpoolSize: " + l2 + "\n\trestartTimer: " + n2 + "\n\trestartCounterLimit: " + n3 + "\n\tloadModuleType: " + n4 + "\n\tidentity: " + string2 + "\n\tupgradePersistent: " + bl + "\n\tprogramInstances: " + programInstances.toString() + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        long l3 = 0L;
        if (managedObject instanceof GenericUpgradeablePlugInUnit) {
            l3 = ((GenericUpgradeablePlugInUnit)managedObject).getResourceId(coordinator);
        } else {
            UpgradeTrace.error(this.getClass(), (String)"ProgramMoImpl(ManagedObject parent, String userLabel, LoadModuleBuildIF lmMo, int startState, int heapSize, int poolSize, int restartTimer, int restartCounterLimit, int loadModuleType, String identity, boolean upgradePersistent, Coordinator c)", (String)("Parent Id not instanciated,\n\tparent: " + managedObject + "\n\tparent type: " + managedObject.getType()));
        }
        String string5 = loadModuleBuildIF.getProductNumber(coordinator);
        String string6 = loadModuleBuildIF.getProductRevision(coordinator);
        if (n2 < 900 && (object = MoAttributeValidator.formatProductNumber((String)string5)) != null && (object.equals(JVM_PRODUCT_NUMBER) || object.equals(J9_PRODUCT_NUMBER))) {
            n2 = 900;
        }
        if (managedObject.getType().equals("Fan") || managedObject.getType().equals("PfmUnit")) {
            object = null;
            for (n5 = 0; n5 < 2 && object == null; ++n5) {
                object = this.fanPgmProxy.sendOsaFanPgmCreateReq(coordinator.getTransactionID(), l3, string5, string6, loadModuleBuildIF.getLoadModuleFilePath(coordinator));
            }
            n5 = 0;
            ProgramMoImpl.checkSignal((Signal)object);
            this.checkResult(object.getResult(), "CreateFroReq: ");
            this.initMoData(object.getFroId(), string, loadModuleBuildIF, bl, coordinator);
            if (n == 1) {
                this.setStartStateInFro(1, coordinator);
            }
        } else {
            object = null;
            for (n5 = 0; n5 < 2 && object == null; ++n5) {
                object = this.roProxy.sendOsaPgm3CreateReq(this.hashCode(), n3, n2, coordinator.getTransactionID(), loadModuleBuildIF.getOseProgramLoadClass(coordinator), l3, l, l2, n4, string5, string6, loadModuleBuildIF.getFuncId(coordinator), loadModuleBuildIF.getLoadModuleFilePath(coordinator), string3, string4, programInstances);
            }
            n5 = 0;
            ProgramMoImpl.checkSignal((Signal)object);
            this.checkResult(object.getResult(), "CreateFroReq: ");
            this.initMoData(object.getFroId(), string, loadModuleBuildIF, bl, coordinator);
            if (n == 1) {
                this.setStartStateInFro(1, coordinator);
            }
        }
        if (ProgramMoImpl.isParentMp(managedObject, coordinator) && !(object = loadModuleBuildIF.getReliableProgramLabel(coordinator)).equals("")) {
            MO_HandlerFactoryAccess mO_HandlerFactoryAccess = (MO_HandlerFactoryAccess)ServiceLocatorFacade.getRepository().getService(MO_HandlerFactoryAccess.class);
            RPU_MO_HandlerAccess rPU_MO_HandlerAccess = mO_HandlerFactoryAccess.getRPU_MO_HandlerAccess();
            rPU_MO_HandlerAccess.reliableProgramCreated(this, coordinator);
        }
    }

    private void initMoData(long l, String string, LoadModuleBuildIF loadModuleBuildIF, boolean bl, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug((Class)ProgramMoImpl.class, (int)70, (String)"initMoData(long resId, String label, LoadModuleBuildIF lmMo, boolean upgradePersistent, Coordinator c)", (String)("resId: " + l + "\n\tlabel: " + string + "\n\tlmMo: " + loadModuleBuildIF + "\n\tupgradePersistent: " + bl + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.data.setRevision(6000);
        this.isUpgradePersistent = new BooleanAttribute("isUpgradePersistent", false, bl);
        this.data.registerPersistentAttr((Attribute)this.isUpgradePersistent);
        this.resourceId = new LongAttribute("resourceId", false);
        this.resourceId.setValue(l);
        this.data.registerPersistentAttr((Attribute)this.resourceId);
        this.userLabel = new StringAttribute("userLabel", true);
        this.userLabel.setValue(string);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.loadModule = new ReferenceAttribute("loadModule", false);
        this.loadModule.setValue((ManagedObject)loadModuleBuildIF);
        this.data.registerPersistentAttr((Attribute)this.loadModule);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public ProgramMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"ProgramMoImpl(MoData recoveredData)", (String)("recoveredData: " + moData));
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(6000);
        moDataRecoveryHelper.assertAttribute("resourceId");
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("loadModule");
        moDataRecoveryHelper.assertAttribute("isUpgradePersistent");
        this.resourceId = (LongAttribute)moData.getAttribute("resourceId");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.loadModule = (ReferenceAttribute)moData.getAttribute("loadModule");
        this.isUpgradePersistent = (BooleanAttribute)moData.getAttribute("isUpgradePersistent");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        Object object;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"delete(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ManagedObject managedObject = this.loadModule.getValue(coordinator);
        if (managedObject instanceof LoadModuleBuildIF) {
            if (ProgramMoImpl.isParentMp(this.getParent(), coordinator) && ((LoadModuleBuildIF)managedObject).getReliableProgramLabel(coordinator).compareTo("") != 0) {
                object = (MO_HandlerFactoryAccess)ServiceLocatorFacade.getRepository().getService(MO_HandlerFactoryAccess.class);
                RPU_MO_HandlerAccess rPU_MO_HandlerAccess = object.getRPU_MO_HandlerAccess();
                rPU_MO_HandlerAccess.reliableProgramDeleted(this, coordinator);
            }
        } else {
            UpgradeTrace.error(this.getClass(), (String)"delete(Coordinator c)", (String)("No LoadModule reference present, " + this.toString() + " Forced: program IS deleted"));
        }
        if (this.getParent().getType().equals("Fan") || this.getParent().getType().equals("PfmUnit")) {
            object = this.fanPgmProxy.sendOsaFanPgmDeleteReq(coordinator.getTransactionID(), this.resourceId.getValue(coordinator));
            ProgramMoImpl.checkSignal((Signal)object);
            this.checkResult(object.getResult(), "DeleteFroReq: ");
        } else {
            object = this.roProxy.sendOsaPgmDeleteReq(coordinator.getTransactionID(), this.resourceId.getValue(coordinator));
            ProgramMoImpl.checkSignal((Signal)object);
            this.checkResult(object.getResult(), "DeleteFroReq: ");
        }
        this.data.delete(coordinator);
        super.delete(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getUserLabel(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setUserLabel(String value, Coordinator c)", (String)("value: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"Program", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public int getLoaderType(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getLoaderType(Coordinator aCoordinator)", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.getParent().getType().equals("PlugInUnit")) {
            OsaPgm3GetAttributeRsp osaPgm3GetAttributeRsp = this.roProxy.sendOsaPgmGetAttributeReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.resourceId.getValue(coordinator));
            ProgramMoImpl.checkSignal((Signal)osaPgm3GetAttributeRsp);
            this.checkResult(osaPgm3GetAttributeRsp.getResult(), "GetAttrReq: ");
            return osaPgm3GetAttributeRsp.getloadModuleType();
        }
        return ((LoadModuleBuildIF)this.getLoadModule(coordinator)).getLoaderType(coordinator);
    }

    public String getDeviceLoaderName(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getDeviceLoaderName(Coordinator aCoordinator)", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.getParent().getType().equals("PlugInUnit")) {
            OsaPgm3GetAttributeRsp osaPgm3GetAttributeRsp = this.roProxy.sendOsaPgmGetAttributeReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.resourceId.getValue(coordinator));
            ProgramMoImpl.checkSignal((Signal)osaPgm3GetAttributeRsp);
            this.checkResult(osaPgm3GetAttributeRsp.getResult(), "GetAttrReq: ");
            return osaPgm3GetAttributeRsp.getdeviceLoaderName();
        }
        return ((LoadModuleBuildIF)this.getLoadModule(coordinator)).getDeviceLoaderName(coordinator);
    }

    public String getDeviceLoaderInformation(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getDeviceLoaderInformation(Coordinator aCoordinator)", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.getParent().getType().equals("PlugInUnit")) {
            OsaPgm3GetAttributeRsp osaPgm3GetAttributeRsp = this.roProxy.sendOsaPgmGetAttributeReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.resourceId.getValue(coordinator));
            ProgramMoImpl.checkSignal((Signal)osaPgm3GetAttributeRsp);
            this.checkResult(osaPgm3GetAttributeRsp.getResult(), "GetAttrReq: ");
            return osaPgm3GetAttributeRsp.getdeviceLoaderInformation();
        }
        return ((LoadModuleBuildIF)this.getLoadModule(coordinator)).getDeviceLoaderInformation(coordinator);
    }

    public ManagedObject getLoadModule(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getLoadModule(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.loadModule.getValue(coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getOperationalState(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = 0;
        if (coordinator != null) {
            n = coordinator.getTransactionID();
        }
        if (this.getParent().getType().equals("Fan") || this.getParent().getType().equals("PfmUnit")) {
            OsaFanPgmGetAttributesRsp osaFanPgmGetAttributesRsp = this.fanPgmProxy.sendOsaFanPgmGetAttributesReq(n, this.resourceId.getValue(coordinator));
            ProgramMoImpl.checkSignal((Signal)osaFanPgmGetAttributesRsp);
            this.checkResult(osaFanPgmGetAttributesRsp.getResult(), "GetAttrReq: ");
            return osaFanPgmGetAttributesRsp.getOperState();
        }
        OsaPgm3GetAttributeRsp osaPgm3GetAttributeRsp = this.roProxy.sendOsaPgmGetAttributeReq(n, this.resourceId.getValue(coordinator));
        ProgramMoImpl.checkSignal((Signal)osaPgm3GetAttributeRsp);
        this.checkResult(osaPgm3GetAttributeRsp.getResult(), "GetAttrReq: ");
        return osaPgm3GetAttributeRsp.getOperState();
    }

    public int getStartState(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getStartState(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = 0;
        if (coordinator != null) {
            n = coordinator.getTransactionID();
        }
        if (this.getParent().getType().equals("Fan") || this.getParent().getType().equals("PfmUnit")) {
            OsaFanPgmGetAttributesRsp osaFanPgmGetAttributesRsp = this.fanPgmProxy.sendOsaFanPgmGetAttributesReq(n, this.resourceId.getValue(coordinator));
            ProgramMoImpl.checkSignal((Signal)osaFanPgmGetAttributesRsp);
            this.checkResult(osaFanPgmGetAttributesRsp.getResult(), "GetAttrReq: ");
            return osaFanPgmGetAttributesRsp.getStartState();
        }
        OsaPgm3GetAttributeRsp osaPgm3GetAttributeRsp = this.roProxy.sendOsaPgmGetAttributeReq(n, this.resourceId.getValue(coordinator));
        ProgramMoImpl.checkSignal((Signal)osaPgm3GetAttributeRsp);
        this.checkResult(osaPgm3GetAttributeRsp.getResult(), "GetAttrReq: ");
        return osaPgm3GetAttributeRsp.getStartState();
    }

    public StartOpState getStartOpState(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getStartOpState(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = 0;
        if (coordinator != null) {
            n = coordinator.getTransactionID();
        }
        if (this.getParent().getType().equals("Fan") || this.getParent().getType().equals("PfmUnit")) {
            OsaFanPgmGetAttributesRsp osaFanPgmGetAttributesRsp = this.fanPgmProxy.sendOsaFanPgmGetAttributesReq(n, this.resourceId.getValue(coordinator));
            ProgramMoImpl.checkSignal((Signal)osaFanPgmGetAttributesRsp);
            this.checkResult(osaFanPgmGetAttributesRsp.getResult(), "GetAttrReq: ");
            return new StartOpState(osaFanPgmGetAttributesRsp.getStartState(), osaFanPgmGetAttributesRsp.getOperState());
        }
        OsaPgm3GetAttributeRsp osaPgm3GetAttributeRsp = this.roProxy.sendOsaPgmGetAttributeReq(n, this.resourceId.getValue(coordinator));
        ProgramMoImpl.checkSignal((Signal)osaPgm3GetAttributeRsp);
        this.checkResult(osaPgm3GetAttributeRsp.getResult(), "GetAttrReq: ");
        return new StartOpState(osaPgm3GetAttributeRsp.getStartState(), osaPgm3GetAttributeRsp.getOperState());
    }

    public void setStartState(int n, Coordinator coordinator) throws MoAccessException {
        String[] stringArray;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setStartState(int value, Coordinator c)", (String)("value: " + n + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n != 1 && n != 0) {
            throw new ValueOutOfRangeException("startState", "Program");
        }
        if (this.getParent() instanceof PlugInUnitMo && n == 1 && (stringArray = ProgramMoImpl.getExistingEnabledProgram(this.getParent(), this.getLoadModule(coordinator), coordinator)) != null && !ProgramMoImpl.checkIfDeviceAndOSEloader(this.getLoaderType(coordinator), stringArray.getLoaderType(coordinator))) {
            throw new ValueOutOfRangeException("startState", "Program", "A program with startState enabled already exist under PIU: " + this.getParent().getLocalDistinguishedName());
        }
        this.setStartStateInFro(n, coordinator);
        stringArray = new String[]{"startState"};
        Object[] objectArray = new Object[]{new Integer(n)};
        ProgramMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public void setStartStateInFro(int n, Coordinator coordinator) throws MoAccessException {
        if (this.getParent().getType().equals("Fan") || this.getParent().getType().equals("PfmUnit")) {
            int n2;
            OsaFanPgmSetStartStateCfm osaFanPgmSetStartStateCfm = null;
            for (n2 = 0; n2 < 2 && osaFanPgmSetStartStateCfm == null; ++n2) {
                osaFanPgmSetStartStateCfm = this.fanPgmProxy.sendOsaFanPgmSetStartStateReq(coordinator.getTransactionID(), this.resourceId.getValue(coordinator), n);
            }
            n2 = 0;
            ProgramMoImpl.checkSignal(osaFanPgmSetStartStateCfm);
            this.checkResult(osaFanPgmSetStartStateCfm.getResult(), "SetAttrReq: ");
        } else {
            int n3;
            OsaPgmSetStartStateCfm osaPgmSetStartStateCfm = null;
            for (n3 = 0; n3 < 2 && osaPgmSetStartStateCfm == null; ++n3) {
                osaPgmSetStartStateCfm = this.roProxy.sendOsaPgmSetStartStateReq(coordinator.getTransactionID(), this.resourceId.getValue(coordinator), n);
            }
            n3 = 0;
            ProgramMoImpl.checkSignal(osaPgmSetStartStateCfm);
            this.checkResult(osaPgmSetStartStateCfm.getResult(), "SetAttrReq: ");
        }
    }

    public int getHeapSize(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getHeapSize(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (!this.getParent().getType().equals("PlugInUnit")) {
            return 0;
        }
        OsaPgm3GetAttributeRsp osaPgm3GetAttributeRsp = this.roProxy.sendOsaPgmGetAttributeReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.resourceId.getValue(coordinator));
        ProgramMoImpl.checkSignal((Signal)osaPgm3GetAttributeRsp);
        this.checkResult(osaPgm3GetAttributeRsp.getResult(), "GetAttrReq: ");
        return (int)osaPgm3GetAttributeRsp.getHeapSize();
    }

    public void setHeapSize(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setHeapSize(int value, Coordinator c)", (String)("value: " + n + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        if (!this.getParent().getType().equals("PlugInUnit")) {
            return;
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n < 0) {
            throw new ValueOutOfRangeException("heapSize", "Program");
        }
        OsaPgmSetHeapSizeCfm osaPgmSetHeapSizeCfm = this.roProxy.sendOsaPgmSetHeapSizeReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.resourceId.getValue(coordinator), n);
        ProgramMoImpl.checkSignal((Signal)osaPgmSetHeapSizeCfm);
        this.checkResult(osaPgmSetHeapSizeCfm.getResult(), "SetAttrReq: ");
        String[] stringArray = new String[]{"heapSize"};
        Object[] objectArray = new Object[]{new Integer(n)};
        ProgramMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public int getPoolSize(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getPoolSize(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        if (!this.getParent().getType().equals("PlugInUnit")) {
            return 0;
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaPgm3GetAttributeRsp osaPgm3GetAttributeRsp = this.roProxy.sendOsaPgmGetAttributeReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.resourceId.getValue(coordinator));
        ProgramMoImpl.checkSignal((Signal)osaPgm3GetAttributeRsp);
        this.checkResult(osaPgm3GetAttributeRsp.getResult(), "GetAttrReq: ");
        return (int)osaPgm3GetAttributeRsp.getPoolSize();
    }

    public void setPoolSize(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setPoolSize(int value, Coordinator c)", (String)("value: " + n + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        if (!this.getParent().getType().equals("PlugInUnit")) {
            return;
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n < 0) {
            throw new ValueOutOfRangeException("poolSize", "Program");
        }
        OsaPgmSetPoolSizeCfm osaPgmSetPoolSizeCfm = this.roProxy.sendOsaPgmSetPoolSizeReq(coordinator.getTransactionID(), this.resourceId.getValue(coordinator), n);
        ProgramMoImpl.checkSignal((Signal)osaPgmSetPoolSizeCfm);
        this.checkResult(osaPgmSetPoolSizeCfm.getResult(), "SetAttrReq: ");
        String[] stringArray = new String[]{"poolSize"};
        Object[] objectArray = new Object[]{new Integer(n)};
        ProgramMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public int getRestartTimer(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getRestartTimer(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.getParent().getType().equals("PlugInUnit")) {
            OsaPgm3GetAttributeRsp osaPgm3GetAttributeRsp = this.roProxy.sendOsaPgmGetAttributeReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.resourceId.getValue(coordinator));
            ProgramMoImpl.checkSignal((Signal)osaPgm3GetAttributeRsp);
            this.checkResult(osaPgm3GetAttributeRsp.getResult(), "GetAttrReq: ");
            return osaPgm3GetAttributeRsp.getRestartTimer();
        }
        return 60;
    }

    public void setRestartTimer(int n, Coordinator coordinator) throws MoAccessException {
        String[] stringArray;
        Object[] objectArray;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setRestartTimer(int value, Coordinator c)", (String)("value: " + n + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        if (!this.getParent().getType().equals("PlugInUnit")) {
            return;
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n < 0 && n != -1) {
            throw new ValueOutOfRangeException("restartTimer", "Program");
        }
        if (this.getParent().getType().equals("PlugInUnit")) {
            if (n < 900 && (objectArray = MoAttributeValidator.formatProductNumber((String)(stringArray = ((LoadModuleBuildIF)this.loadModule.getValue(coordinator)).getProductNumber(coordinator)))) != null && (objectArray.equals(JVM_PRODUCT_NUMBER) || objectArray.equals(J9_PRODUCT_NUMBER))) {
                n = 900;
            }
        } else {
            return;
        }
        stringArray = this.roProxy.sendOsaPgmSetRestartTimerReq(coordinator.getTransactionID(), this.resourceId.getValue(coordinator), n);
        ProgramMoImpl.checkSignal((Signal)stringArray);
        this.checkResult(stringArray.getResult(), "SetAttrReq: ");
        stringArray = new String[]{"restartTimer"};
        objectArray = new Object[]{new Integer(n)};
        ProgramMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public int getRestartCounterLimit(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getRestartCounterLimit(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.getParent().getType().equals("PlugInUnit")) {
            OsaPgm3GetAttributeRsp osaPgm3GetAttributeRsp = this.roProxy.sendOsaPgmGetAttributeReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.resourceId.getValue(coordinator));
            ProgramMoImpl.checkSignal((Signal)osaPgm3GetAttributeRsp);
            this.checkResult(osaPgm3GetAttributeRsp.getResult(), "GetAttrReq: ");
            return osaPgm3GetAttributeRsp.getRestartCounterLimit();
        }
        return 3;
    }

    public void setRestartCounterLimit(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setRestartCounterLimit(int value, Coordinator c)", (String)("value: " + n + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        if (!this.getParent().getType().equals("PlugInUnit")) {
            return;
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n < 0 && n != -1) {
            throw new ValueOutOfRangeException("restartCounterLimit", "Program");
        }
        if (!this.getParent().getType().equals("PlugInUnit")) {
            return;
        }
        String[] stringArray = this.roProxy.sendOsaPgmSetRestartCounterLimitReq(coordinator.getTransactionID(), this.resourceId.getValue(coordinator), n);
        ProgramMoImpl.checkSignal((Signal)stringArray);
        this.checkResult(stringArray.getResult(), "SetAttrReq: ");
        stringArray = new String[]{"restartCounterLimit"};
        Object[] objectArray = new Object[]{new Integer(n)};
        ProgramMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public String getProgramId(Coordinator coordinator) throws MoAccessException {
        return this.getNamingAttributeValue();
    }

    public int getProgramFroId(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProgramFroId(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return (int)this.resourceId.getValue(coordinator);
    }

    public boolean getIsUpgradePersistent(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getIsUpgradePersistent(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.isUpgradePersistent.getValue(coordinator);
    }

    public void setIsUpgradePersistent(boolean bl, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setIsUpgradePersistent(boolean value, Coordinator context)", (String)("value: " + bl + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.isUpgradePersistent.setValue(bl);
    }

    public Struct[] getProgramInstances(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProgramInstances(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.getParent().getType().equals("PlugInUnit")) {
            OsaPgm3GetAttributeRsp osaPgm3GetAttributeRsp = this.roProxy.sendOsaPgmGetAttributeReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.resourceId.getValue(coordinator));
            ProgramMoImpl.checkSignal((Signal)osaPgm3GetAttributeRsp);
            this.checkResult(osaPgm3GetAttributeRsp.getResult(), "GetAttrReq: ");
            return osaPgm3GetAttributeRsp.getProgramInstances();
        }
        return new Struct[0];
    }

    public void actionRestart(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionRestart(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        AccessControlHelper.performAccessControl();
        if (this.getParent().getType().equals("Fan") || this.getParent().getType().equals("PfmUnit") ? this.fanPgmProxy.sendOsaFanPgmRestartReq(this.resourceId.getValue(coordinator)) == -1 : this.roProxy.sendOsaPgmRestartReq(this.resourceId.getValue(coordinator)) == -1) {
            throw new FroNotAccessibleException("Program", "Resource FRO is not accessible.");
        }
    }

    public void actionStopImmediate(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionStopImmediate(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        AccessControlHelper.performAccessControl();
        if (this.getParent().getType().equals("Fan") || this.getParent().getType().equals("PfmUnit")) {
            throw new ActionNotAllowedException("Program", "This action is not valid for programs on this board: " + this.getParent().getType());
        }
        if (this.roProxy.sendOsaPgmStopImmediateReq(this.resourceId.getValue(coordinator)) == -1) {
            throw new FroNotAccessibleException("Program", "Resource FRO is not accessible.");
        }
    }

    public void actionStartImmediate(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionStartImmediate(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        AccessControlHelper.performAccessControl();
        if (this.getParent().getType().equals("Fan") || this.getParent().getType().equals("PfmUnit")) {
            throw new ActionNotAllowedException("Program", "This action is not valid for programs on this board: " + this.getParent().getType());
        }
        if (this.roProxy.sendOsaPgmStartImmediateReq(this.resourceId.getValue(coordinator)) == -1) {
            throw new FroNotAccessibleException("Program", "Resource FRO is not accessible.");
        }
    }

    public void programUpgrade(long l, int n) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"programUpgrade(long anOldPgmInstanceId, int aMethod)", (String)("anOldPgmInstanceId: " + l + "\n\taMethod: " + n));
        OsaPgmUpgradeRsp osaPgmUpgradeRsp = null;
        OsaPgmMgmntProxy osaPgmMgmntProxy = this.roProxy;
        osaPgmUpgradeRsp = osaPgmMgmntProxy.sendOsaPgmUpgradeReq(l, this.resourceId.getValue(null), n);
        ProgramMoImpl.checkSignal((Signal)osaPgmUpgradeRsp);
        this.checkResult(osaPgmUpgradeRsp.getResult(), "PgmUpgradeReq: ");
        if (osaPgmUpgradeRsp.getResult() != 1) {
            throw new EquipException("Program or RPU not foundProgram");
        }
    }

    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    public String getType() {
        return "Program";
    }

    private static int checkAndGetLoaderType(ManagedObject managedObject, LoadModuleBuildIF loadModuleBuildIF, AttrList attrList, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug((Class)ProgramMoImpl.class, (int)70, (String)"checkAndGetLoaderType(ManagedObject parent, LoadModuleBuildIF lmMo, AttrList attributes, Coordinator c)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = attrList.indexOf("loaderType");
        if (managedObject.getType().equals("PlugInUnit")) {
            int n2 = 0;
            if (n != -1) {
                if (!(attrList.getValue(n) instanceof Integer)) {
                    throw new WrongAttributeTypeException("loaderType", "Program");
                }
                n2 = (Integer)attrList.getValue(n);
                if (n2 != 0 && n2 != 6) {
                    throw new ValueOutOfRangeException("loaderType", "Program");
                }
                attrList.removeElementAt(n);
                return n2;
            }
            int n3 = loadModuleBuildIF.getLoaderType(coordinator);
            if (n3 == 0 || n3 == 6) {
                return n3;
            }
            throw new ValueOutOfRangeException("loadModule", "Program");
        }
        if (managedObject.getType().equals("Fan") || managedObject.getType().equals("PfmUnit")) {
            if (n != -1) {
                if (!(attrList.getValue(n) instanceof Integer)) {
                    throw new WrongAttributeTypeException("loaderType", "Program");
                }
                attrList.removeElementAt(n);
            }
        } else {
            throw new ValueOutOfRangeException("loadModule", "Program");
        }
        return 0;
    }

    private static String checkAndGetDeviceLoaderName(LoadModuleBuildIF loadModuleBuildIF, AttrList attrList, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug((Class)ProgramMoImpl.class, (int)70, (String)"checkAndGetDeviceLoaderName(LoadModuleBuildIF lmMo, AttrList attributes, Coordinator c)", (String)("lmMo: " + loadModuleBuildIF + "\n\tattributes: " + Lib.toString((AttrList)attrList)));
        String string = "";
        int n = attrList.indexOf("deviceLoaderName");
        string = n != -1 ? MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"deviceLoaderName", (AttrList)attrList, (boolean)false, (String)"", (String)"Program", (int)80, (int)0) : loadModuleBuildIF.getDeviceLoaderName(coordinator);
        return string;
    }

    private static String checkAndGetDeviceLoaderInformation(LoadModuleBuildIF loadModuleBuildIF, AttrList attrList, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug((Class)ProgramMoImpl.class, (int)70, (String)"checkAndGetDeviceLoaderInformation(LoadModuleBuildIF lmMo, AttrList attributes, Coordinator c)", (String)("lmMo: " + loadModuleBuildIF + "\n\tattributes: " + Lib.toString((AttrList)attrList)));
        String string = "";
        int n = attrList.indexOf("deviceLoaderInformation");
        string = n != -1 ? MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"deviceLoaderInformation", (AttrList)attrList, (boolean)false, (String)"", (String)"Program", (int)255, (int)0) : loadModuleBuildIF.getDeviceLoaderInformation(coordinator);
        return string;
    }

    private static int checkAndGetHeapSize(AttrList attrList, LoadModuleBuildIF loadModuleBuildIF, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug((Class)ProgramMoImpl.class, (int)70, (String)"checkAndGetHeapSize(AttrList attributes, LoadModuleBuildIF aLoadModule, Coordinator context)", (String)("attributes: " + Lib.toString((AttrList)attrList) + "\n\taLoadModule: " + loadModuleBuildIF + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        LoadModuleBuildIF loadModuleBuildIF2 = loadModuleBuildIF;
        int n = 0;
        int n2 = attrList.indexOf("heapSize");
        int n3 = loadModuleBuildIF2.getOseProgramHeapSize(coordinator);
        if (n2 == -1) {
            if (n3 != 0) {
                n = n3;
            }
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("heapSize", "Program");
        }
        n = (Integer)attrList.getValue(n2);
        if (n < 0) {
            throw new ValueOutOfRangeException("heapSize", "Program");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static int checkAndGetPoolSize(AttrList attrList, LoadModuleBuildIF loadModuleBuildIF, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug((Class)ProgramMoImpl.class, (int)70, (String)"checkAndGetPoolSize(AttrList attributes, LoadModuleBuildIF aLoadModule, Coordinator context)", (String)("attributes: " + Lib.toString((AttrList)attrList) + "\n\taLoadModule: " + loadModuleBuildIF + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        LoadModuleBuildIF loadModuleBuildIF2 = loadModuleBuildIF;
        int n = 0;
        int n2 = attrList.indexOf("poolSize");
        int n3 = loadModuleBuildIF2.getOseProgramPoolSize(coordinator);
        if (n2 == -1) {
            if (n3 != 0) {
                n = n3;
            }
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("poolSize", "Program");
        }
        n = (Integer)attrList.getValue(n2);
        if (n < 0) {
            throw new ValueOutOfRangeException("poolSize", "Program");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static int checkAndGetRestartTimer(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)ProgramMoImpl.class, (int)70, (String)"checkAndGetRestartTimer(AttrList attributes)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = 60;
        int n2 = attrList.indexOf("restartTimer");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("restartTimer", "Program");
        }
        n = (Integer)attrList.getValue(n2);
        if (n <= 0 && n != -1) {
            throw new ValueOutOfRangeException("restartTimer", "Program");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static int checkAndGetRestartCounterLimit(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)ProgramMoImpl.class, (int)70, (String)"checkAndGetRestartCounterLimit(AttrList attributes)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = 3;
        int n2 = attrList.indexOf("restartCounterLimit");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("restartCounterLimit", "Program");
        }
        n = (Integer)attrList.getValue(n2);
        if (n <= 0 && n != -1) {
            throw new ValueOutOfRangeException("restartCounterLimit", "Program");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static ProgramInstances checkAndGetProgramInstances(AttrList attrList, ManagedObject managedObject) throws MoAccessException {
        int n = attrList.indexOf("programInstances");
        if (-1 == n) {
            return new ProgramInstances();
        }
        if (!(managedObject instanceof PlugInUnitMo)) {
            attrList.removeElementAt(n);
            return new ProgramInstances();
        }
        if (!(attrList.getValue(n) instanceof Struct[])) {
            throw new WrongAttributeTypeException("programInstances", "Program");
        }
        Struct[] structArray = (Struct[])attrList.getValue(n);
        attrList.removeElementAt(n);
        return new ProgramInstances(structArray);
    }

    private void checkResult(int n, String string) throws FroRequestFailedException, MoAccessException {
        UpgradeTrace.debug((Class)ProgramMoImpl.class, (int)70, (String)"checkResult(int result)", (String)("result: " + n));
        if (n != 1) {
            throw new FroRequestFailedException("Program", "Program", string + this.getResultMsg(n), n);
        }
    }

    private String getResultMsg(int n) {
        if (this.getParent().getType().equals("PlugInUnit")) {
            return OsaPgmMgmntProxy.getResultMsg(n);
        }
        return this.fanPgmProxy.getResultMsg(n);
    }

    private static void checkSignal(Signal signal) throws FroNotAccessibleException {
        UpgradeTrace.debug((Class)ProgramMoImpl.class, (int)70, (String)"checkSignal(enea.ose.system.Signal sig)", (String)("sig: " + signal));
        if (signal == null) {
            throw new FroNotAccessibleException("Program", "Resource FRO is not accessible.");
        }
    }

    private static boolean isParentMp(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject2;
        UpgradeTrace.debug((Class)ProgramMoImpl.class, (int)70, (String)"isParentMp(ManagedObject parent, Coordinator c)", (String)("parent: " + managedObject + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        return managedObject.getType().equals("PlugInUnit") && ((PiuTypeAccess)(managedObject2 = ((PlugInUnitMo)managedObject).getPiuType(coordinator))).getRole(coordinator) == 1;
    }

    private static ProgramMo getExistingEnabledProgram(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug((Class)ProgramMoImpl.class, (int)70, (String)"getExistingEnabledProgram(ManagedObject parent,ManagedObject aLoadModule, Coordinator c)", (String)("parent: " + managedObject + "\n\taLoadModule: " + managedObject2));
        ProgramMo programMo = null;
        MoIterator moIterator = null;
        try {
            moIterator = MoRepository.instance().select(managedObject, 1, null, "Program", "");
        }
        catch (FilterSyntaxException filterSyntaxException) {
            UpgradeTrace.error((Class)ProgramMoImpl.class, (String)"getExistingEnabledProgram(ManagedObject parent,ManagedObject aLoadModule, Coordinator c)", (String)"FilterSyntaxException catched", (Throwable)filterSyntaxException);
            throw new ValueOutOfRangeException(filterSyntaxException.toString(), "Program");
        }
        if (moIterator != null) {
            String string = managedObject2.getLocalDistinguishedName();
            String string2 = null;
            while (moIterator.hasMoreElements() && (!string.equalsIgnoreCase(string2 = (programMo = (ProgramMo)moIterator.nextMo()).getLoadModule(coordinator).getLocalDistinguishedName()) || programMo.getStartState(coordinator) != 1)) {
                programMo = null;
            }
        }
        UpgradeTrace.debug((Class)ProgramMoImpl.class, (int)71, (String)"getExistingEnabledProgram(ManagedObject parent,ManagedObject aLoadModule, Coordinator c)", (String)("Returning - theExistingEnabledProgram: " + programMo));
        return programMo;
    }

    private static boolean checkIfDeviceAndOSEloader(int n, int n2) {
        boolean bl = false;
        if (n == 0) {
            if (n2 == 6) {
                bl = true;
            }
        } else if (n == 6 && n2 == 0) {
            bl = true;
        }
        return bl;
    }

    private static void sendChangeNotification(ManagedObject managedObject, String[] stringArray, Object[] objectArray, Coordinator coordinator) {
        UpgradeTrace.debug((Class)ProgramMoImpl.class, (int)70, (String)"sendChangeNotification(ManagedObject mo, String[] attrNames, Object[] newValues, Coordinator context)", (String)("mo: " + managedObject + "\n\tattrNames: " + Lib.toString((String[])stringArray) + "\n\tnewValues: " + objectArray + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        NotificationSender notificationSender = NotificationSender.instance();
        notificationSender.pushAVC(managedObject, stringArray, objectArray, coordinator);
    }
}

