/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import java.util.StringTokenizer;
import se.ericsson.cello.equipment.ProductNumberAndRevisionNotAllowedException;
import se.ericsson.cello.equipment.SubrackProdTypeMoImpl;
import se.ericsson.cello.equipment.suaccess.SubrackProdTypeMoFactorySU_Access;
import se.ericsson.cello.equipment.suaccess.SubrackProdTypeMoSU_Access;
import se.ericsson.cello.mao.AttrValueNotUniqueException;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.util.library.Lib;

public class SubrackProdTypeMoFactory
implements MoFactory,
SubrackProdTypeMoFactorySU_Access {
    private static SubrackProdTypeMoFactory instance = null;
    public static final String WILDCARD = "*";

    public static synchronized SubrackProdTypeMoFactory instance() {
        if (instance == null) {
            instance = new SubrackProdTypeMoFactory();
        }
        return instance;
    }

    public ManagedObject createMoAtUpgrade(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"createMoAtUpgrade(ManagedObject aParent, AttrList anAttributes, String anIdentity, Coordinator aCoordinator)", (String)("aParent: " + managedObject + "\n\tanAttributes: " + Lib.toString((AttrList)attrList) + "\n\tanIdentity: " + string + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        return SubrackProdTypeMoImpl.createAtUpgrade(managedObject, attrList, string, coordinator);
    }

    public SubrackProdTypeMoSU_Access createMoAtUpgrade2(ManagedObject managedObject, String string, String string2, String string3, String string4, int n, int n2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"createMoAtUpgrade2(ManagedObject aParent, String anIdentity, String aProductNumber, String aProductRevision, String anUserLabel, int aTransmissionType, int aFanConfiguration, Coordinator aCoordinator)", (String)("aParent: " + managedObject + "\n\tanIdentity: " + string + "\n\taProductNumber: " + string2 + "\n\taProductRevision: " + string3 + "\n\tanUserLabel: " + string4 + "\n\taTransmissionType: " + n + "\n\taFanConfiguration: " + n2 + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        return SubrackProdTypeMoImpl.createAtUpgrade(managedObject, string, string2, string3, string4, n, n2, coordinator);
    }

    public ManagedObject createMo(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"createMo( ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context )", (String)("parent: " + managedObject + "\n\tattributes: " + Lib.toString((AttrList)attrList) + "\n\tidentity: " + string + "\n\tsource: " + managedObject2 + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        return SubrackProdTypeMoImpl.create(managedObject, attrList, string, managedObject2, coordinator);
    }

    public ManagedObject recoverMo(MoData moData) throws MoNameAlreadyTakenException {
        try {
            SubrackProdTypeMoImpl subrackProdTypeMoImpl = new SubrackProdTypeMoImpl(moData);
            return subrackProdTypeMoImpl;
        }
        catch (MoNameAlreadyTakenException moNameAlreadyTakenException) {
            throw moNameAlreadyTakenException;
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Recover failed", (Throwable)moAccessException);
            return null;
        }
    }

    public String getMoTypeName() {
        return "SubrackProdType";
    }

    public String[] getSupportedVersions() {
        return SubrackProdTypeMoImpl.SUPPORTED_VERSIONS;
    }

    public void registerFactory() {
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
    }

    public void verifyThatProductNumberAndRevisionIsAllowed(String string, String string2) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"verifyThatProductNumberAndRevisionIsAllowed(String aProductNumber, String aProductRevision)", (String)("aProductNumber: " + string + "\n\taProductRevision: " + string2));
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("SubrackProdType");
            if (moIterator != null) {
                String string3 = this.removeWhiteSpaces(string);
                String string4 = this.removeWhiteSpaces(string2);
                SubrackProdTypeMoSU_Access subrackProdTypeMoSU_Access = null;
                String string5 = null;
                String string6 = null;
                while (moIterator.hasMoreElements()) {
                    subrackProdTypeMoSU_Access = (SubrackProdTypeMoSU_Access)moIterator.nextMo();
                    string5 = subrackProdTypeMoSU_Access.getProductNumber(null);
                    string6 = subrackProdTypeMoSU_Access.getProductRevision(null);
                    if (!this.removeWhiteSpaces(string5).equalsIgnoreCase(string3)) continue;
                    if (string6.equalsIgnoreCase(string4)) {
                        UpgradeTrace.debug(this.getClass(), (int)72, (String)"verifyThatProductNumberAndRevisionIsAllowed(String aProductNumber, String aProductRevision)", (String)("SubrackProdType MO containing the requested product number and revision already exists,\n\texisting product number: " + string5 + "\n\texisting product revision: " + string6));
                        throw new ProductNumberAndRevisionNotAllowedException("SubrackProdType", "verifyThatProductNumberAndRevisionIsAllowed(String aProductNumber, String aProductRevision)\n\tSubrackProdType MO containing the requested product number and revision already exists,\n\trequested product number: " + string + "\n\trequested product revision: " + string2 + "\n\texisting product number: " + string5 + "\n\texisting product revision: " + string6);
                    }
                    if (string2.equals(WILDCARD)) {
                        UpgradeTrace.debug(this.getClass(), (int)72, (String)"verifyThatProductNumberAndRevisionIsAllowed(String aProductNumber, String aProductRevision)", (String)("SubrackProdType MO containing the requested product number and a specific revision already exists,\n\tcreation of SubrackProdType MO containing wildcard revision is not allowed in this case.\n\texisting product number: " + string5 + "\n\texisting product revision: " + string6));
                        throw new ProductNumberAndRevisionNotAllowedException("SubrackProdType", "verifyThatProductNumberAndRevisionIsAllowed(String aProductNumber, String aProductRevision)\n\tSubrackProdType MO containing the requested product number and a specific revision already exists.\n\tcreation of SubrackProdType MO containing WILDCARD revision is not allowed in this case.\n\trequested product number: " + string + "\n\trequested product revision: " + string2 + "\n\texisting product number: " + string5 + "\n\texisting product revision: " + string6);
                    }
                    if (!string6.equals(WILDCARD)) continue;
                    UpgradeTrace.debug(this.getClass(), (int)72, (String)"verifyThatProductNumberAndRevisionIsAllowed(String aProductNumber, String aProductRevision)", (String)("SubrackProdType MO containing the requested product number and wildcard revision already exists,\n\tcreation of SubrackProdType MO containing specific revision is not allowed in this case.\n\texisting product number: " + string5 + "\n\texisting product revision: " + string6));
                    throw new ProductNumberAndRevisionNotAllowedException("SubrackProdType", "verifyThatProductNumberAndRevisionIsAllowed(String aProductNumber, String aProductRevision)\n\tSubrackProdType MO containing the requested product number and WILDCARD revision already exists.\n\tcreation of SubrackProdType MO containing specific revision is not allowed in this case.\n\trequested product number: " + string + "\n\trequested product revision: " + string2 + "\n\texisting product number: " + string5 + "\n\texisting product revision: " + string6);
                }
            }
        }
        catch (ProductNumberAndRevisionNotAllowedException productNumberAndRevisionNotAllowedException) {
            throw productNumberAndRevisionNotAllowedException;
        }
        catch (Exception exception) {
            UpgradeTrace.error(this.getClass(), (String)"verifyThatProductNumberAndRevisionIsAllowed(String aProductNumber, String aProductRevision)", (String)("Exception caught.\n\taProductNumber: " + string + "\n\taProductRevision: " + string2 + "Exception: " + exception.toString()), (Throwable)exception);
            throw new AttrValueNotUniqueException("verifyThatProductNumberAndRevisionIsAllowed(String aProductNumber, String aProductRevision)Exception caught.\n\taProductNumber: " + string + "\n\taProductRevision: " + string2 + "Exception: " + exception.toString(), "SubrackProdType");
        }
    }

    private String removeWhiteSpaces(String string) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"removeWhiteSpaces(String aString)", (String)("aString: " + string));
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + stringTokenizer.nextToken();
        }
        return string2;
    }
}

