/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment.fropxy;

import enea.ose.system.AttachSignal;
import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import java.util.Hashtable;
import se.ericsson.cello.common.fropxy.CmaPortManager;
import se.ericsson.cello.common.fropxy.CmaSignalPort;
import se.ericsson.cello.common.fropxy.FroEmptySignal;
import se.ericsson.cello.common.fropxy.FroLocationFailedException;
import se.ericsson.cello.common.fropxy.FroProxy;
import se.ericsson.cello.common.fropxy.FroReqU32U32;
import se.ericsson.cello.common.fropxy.FroReqU32U32U16;
import se.ericsson.cello.common.fropxy.FroShutdownException;
import se.ericsson.cello.common.fropxy.FroSignalHandling;
import se.ericsson.cello.equipment.fropxy.SpasSaiFroCreateReq;
import se.ericsson.cello.equipment.fropxy.SpasSaiFroCreateRsp;
import se.ericsson.cello.equipment.fropxy.SpasSaiFroDeleteRsp;
import se.ericsson.cello.equipment.fropxy.SpasSaiFroFaultCeasedInd;
import se.ericsson.cello.equipment.fropxy.SpasSaiFroFaultInd;
import se.ericsson.cello.equipment.fropxy.SpasSaiFroSetAdmStateRsp;
import se.ericsson.cello.equipment.fropxy.SpasSaiGetAttrRsp;
import se.ericsson.cello.equipment.fropxy.SpasSaiMgmntProxyInterface;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.OseNameServer;
import se.ericsson.cello.support.sigutil.PortManager;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.cello.support.sigutil.SignalObserver;
import se.ericsson.cello.support.sigutil.SignalPort;
import se.ericsson.cello.support.sigutil.SubscriptionObserver;

public class SpasSaiMgmntProxy
extends FroProxy
implements SpasSaiMgmntProxyInterface {
    private static SpasSaiMgmntProxy instance = null;
    private SignalPort signalPort = PortManager.instance();
    private CmaSignalPort cmaSignalPort = CmaPortManager.instance();
    private OseProcess op = null;
    public static String SPAS_SRI_SERVICE_NAME = "SRI_SERVICE";
    private boolean unpublishedWhileWaitingForResponse = false;

    public void subscribeService() {
        MessageLog.trace((int)5, this.getClass(), (String)"subscribeService() ");
        OseNameServer.addSubscriptionObserver((String)SPAS_SRI_SERVICE_NAME, (SubscriptionObserver)this);
    }

    public void signalReceived(InSignal inSignal) {
        FroSignalHandling.run((InSignal)inSignal, (Hashtable)this.subscriptions, this.getClass());
    }

    public void serviceAdded(String string) {
        MessageLog.trace((int)5, this.getClass(), (String)("serviceAdded(), serviceTag: " + string));
        this.sendSpasSaiFroNotifSubscribeReq();
    }

    public SpasSaiFroCreateRsp sendSpasSaiFroCreateReq(long l, int n, int n2, int n3) {
        SpasSaiFroCreateReq spasSaiFroCreateReq = new SpasSaiFroCreateReq(l, n, n2, n3);
        if (this.op == null && !this.init()) {
            return null;
        }
        SpasSaiFroCreateRsp spasSaiFroCreateRsp = (SpasSaiFroCreateRsp)SignalHelper.sendAndReceive((OseProcess)this.op, (Signal)spasSaiFroCreateReq, (Class)SpasSaiFroCreateRsp.class);
        return spasSaiFroCreateRsp;
    }

    public SpasSaiFroDeleteRsp sendSpasSaiFroDeleteReq(long l, long l2) {
        FroReqU32U32 froReqU32U32 = new FroReqU32U32(231170, (int)l, (int)l2);
        if (this.op == null && !this.init()) {
            return null;
        }
        SpasSaiFroDeleteRsp spasSaiFroDeleteRsp = (SpasSaiFroDeleteRsp)SignalHelper.sendAndReceive((OseProcess)this.op, (Signal)froReqU32U32, (Class)SpasSaiFroDeleteRsp.class);
        return spasSaiFroDeleteRsp;
    }

    public SpasSaiFroSetAdmStateRsp sendSpasSaiFroSetAdmStateReq(long l, long l2, int n) throws FroNotAccessibleException {
        FroReqU32U32U16 froReqU32U32U16 = new FroReqU32U32U16(231172, (int)l, (int)l2, n);
        if (this.op == null && !this.init()) {
            throw new FroLocationFailedException("The SAI FRO was not available (not published) when attempting to send signal SpasSaiFroSetAdmStateReq with data \n\ttxId: " + l + "\n\tfroId: " + l2 + "\n\tadmStateSai: " + n);
        }
        this.unpublishedWhileWaitingForResponse = false;
        SpasSaiFroSetAdmStateRsp spasSaiFroSetAdmStateRsp = (SpasSaiFroSetAdmStateRsp)SignalHelper.sendAndReceive((OseProcess)this.op, (Signal)froReqU32U32U16, (Class)SpasSaiFroSetAdmStateRsp.class);
        if (spasSaiFroSetAdmStateRsp != null) {
            this.unpublishedWhileWaitingForResponse = false;
            return spasSaiFroSetAdmStateRsp;
        }
        if (this.unpublishedWhileWaitingForResponse) {
            this.unpublishedWhileWaitingForResponse = false;
            throw new FroShutdownException("The SAI FRO has unpublished itself while waiting for response on request signal SpasSaiFroSetAdmStateReq with data \n\ttxId: " + l + "\n\tfroId: " + l2 + "\n\tadmStateSai: " + n);
        }
        throw new FroNotAccessibleException("SpasSaiMgmntProxyNo response from the SAI FRO (time out) after sending signal SpasSaiFroSetAdmStateReq with data \n\ttxId: " + l + "\n\tfroId: " + l2 + "\n\tadmStateSai: " + n, SPAS_SRI_SERVICE_NAME);
    }

    public SpasSaiGetAttrRsp spasSaiGetAttrReq(long l, long l2) {
        FroReqU32U32 froReqU32U32 = new FroReqU32U32(231175, (int)l, (int)l2);
        if (this.op == null && !this.init()) {
            return null;
        }
        Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)this.op, (Signal)froReqU32U32, (Class)SpasSaiGetAttrRsp.class, (int)SignalHelper.getTimeOut());
        if (signal == null || signal instanceof AttachSignal) {
            return null;
        }
        return (SpasSaiGetAttrRsp)signal;
    }

    public void sendSpasSaiFroNotifSubscribeReq() {
        FroEmptySignal froEmptySignal = new FroEmptySignal(231176);
        OseProcess oseProcess = this.signalPort.getOseProcess();
        if (this.op == null && !this.init()) {
            return;
        }
        SignalHelper.sendWithSender((OseProcess)this.op, (OseProcess)oseProcess, (Signal)froEmptySignal);
    }

    public String getResultMsg(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "SPAS_RESULT_OK";
                break;
            }
            case 2: {
                string = "SPAS_RESULT_NOT_OK";
                break;
            }
            default: {
                string = "UNKNOWN RESULT CODE: " + n;
            }
        }
        return string;
    }

    public static SpasSaiMgmntProxyInterface instance() {
        if (instance == null) {
            instance = new SpasSaiMgmntProxy();
        }
        return instance;
    }

    private SpasSaiMgmntProxy() {
        this.cmaSignalPort.addSignalObserver((SignalObserver)this, SpasSaiFroFaultInd.class);
        this.cmaSignalPort.addSignalObserver((SignalObserver)this, SpasSaiFroFaultCeasedInd.class);
    }

    public void serviceRemoved(String string) {
        MessageLog.trace((int)5, this.getClass(), (String)("serviceRemoved(), serviceTag: " + string));
        this.unpublishedWhileWaitingForResponse = true;
        this.op = null;
        super.serviceRemoved(string);
    }

    private boolean init() {
        this.op = OseNameServer.lookup((String)SPAS_SRI_SERVICE_NAME);
        if (this.op == null) {
            MessageLog.trace((int)5, this.getClass(), (String)"init() , op = null ");
            return false;
        }
        MessageLog.trace((int)5, this.getClass(), (String)("init() , op: " + this.op.getPID()));
        return true;
    }
}

