/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configirpimpl;

import BasicConfig.AlreadyDefined;
import BasicConfig.BasicConfiguration;
import BasicConfig.BasicConfigurationHelper;
import BasicConfig.Filter;
import BasicConfig.MIBRef;
import BasicConfig.MOidpair;
import BasicConfig.NameValue;
import BasicConfig.NotAccepted;
import BasicConfig.NotDefined;
import BasicConfig.ProcessingFailure;
import BasicConfig.SecurityViolation;
import BasicConfig.Session;
import BasicConfig.UnsupportedQoS;
import ConfigExtended.ConfigurationExtended;
import ConfigExtended.ConfigurationExtendedHelper;
import ConfigExtended.MIBInfoExt;
import ConfigExtended.MOInfo;
import ConfigExtended.MOInfoSeqHolder;
import ConfigExtended.NotificationProducer;
import ConfigExtended.RequestedAttributes;
import ConfigExtended.ReturnedAttributes;
import ConfigExtended.SessionExtended;
import ConfigExtended.SessionExtendedHelper;
import java.util.LinkedList;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NameComponent;
import se.ericsson.cello.configirpimpl.AnyMapping;
import se.ericsson.cello.configirpimpl.BasicConfigImpl;
import se.ericsson.cello.configirpimpl.EasyNaming;
import se.ericsson.cello.configirpimpl.MoIteratorMgr;
import se.ericsson.cello.configirpimpl.MoRefMgr;
import se.ericsson.cello.configirpimpl.NotificationProducerImpl;
import se.ericsson.cello.configirpimpl.SessionImpl;
import se.ericsson.cello.moframework.FilterSyntaxException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.Mib;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.support.corba.CelloOrb;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.debug.Util;
import se.ericsson.cello.support.services.ServiceProvider;
import se.ericsson.cello.support.services.ServiceStateManager;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.security.corba.Current;

public class ConfigExtendedImpl
extends BasicConfigImpl {
    private static ConfigExtendedImpl theOneAndOnly;
    private static final int TRACE_GROUP = 5;
    private static int serviceProviderState;
    private static ServiceProvider serviceProvider;

    public static ConfigExtendedImpl instance() {
        if (theOneAndOnly == null) {
            try {
                theOneAndOnly = new ConfigExtendedImpl();
            }
            catch (NullPointerException nullPointerException) {
                MessageLog.traceError(theOneAndOnly.getClass(), (String)"NullpointerException: ", (Throwable)nullPointerException);
            }
        }
        return theOneAndOnly;
    }

    public static void restoreSubscriptions() {
        NotificationProducerImpl.restoreSubscriptions();
    }

    public static void init() {
        try {
            CelloOrb.instance().connect("CelloConfigurationService", theOneAndOnly);
            NameComponent[] nameComponentArray = new NameComponent[]{new NameComponent("CelloConfigurationService", "")};
            CelloOrb.instance().rebind(nameComponentArray, theOneAndOnly.getConfigExtendedRef());
        }
        catch (UserException userException) {
            Assert.cppAssert((boolean)false, (String)("Can not register simple config service in name server :" + (Object)((Object)userException)));
        }
        catch (NullPointerException nullPointerException) {
            MessageLog.traceError(theOneAndOnly.getClass(), (String)"NullpointerException: ", (Throwable)nullPointerException);
        }
        try {
            current = (Current)CelloOrb.instance().getOrb().resolve_initial_references("OMSecSecurityCurrent");
        }
        catch (InvalidName invalidName) {
            current = null;
        }
        if (serviceProvider == null) {
            serviceProvider = new ServiceProviderImpl();
            ServiceStateManager.getInstance().registerService(serviceProvider);
        }
        serviceProviderState = 1;
        ServiceStateManager.getInstance().updateServiceProviderState(serviceProvider);
    }

    BasicConfiguration getBasicConfigRef() {
        return BasicConfigurationHelper.narrow(CelloOrb.instance().servant_to_reference(this));
    }

    ConfigurationExtended getConfigExtendedRef() {
        return ConfigurationExtendedHelper.narrow(CelloOrb.instance().servant_to_reference(this));
    }

    private ConfigExtendedImpl() {
    }

    public String[] get_CS_interface_version() {
        String[] stringArray = new String[]{"1c1", "1c2", "1c3", "1c4", "1c5", "1c6"};
        return stringArray;
    }

    public MOInfo get_root_MO(Session session) throws NotDefined, ProcessingFailure {
        try {
            Mib mib = this.getMib();
            ManagedObject managedObject = mib.getRootMo();
            Assert.cppAssert((Object)managedObject, (String)"Root == null");
            return this.createMoInfo(managedObject);
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)ConfigExtendedImpl.class, (String)"get_root_MO: ", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError: " + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)ConfigExtendedImpl.class, (String)"get_root_MO: ", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    public NotificationProducer get_notification_producer() {
        return NotificationProducerImpl.instance().getNotificationProducerRef();
    }

    public MOInfo get_MO_info_by_name(String string, Session session) throws NotDefined, ProcessingFailure {
        try {
            ManagedObject managedObject = MoRefMgr.lookup(string);
            return this.createMoInfo(managedObject);
        }
        catch (MoNotFoundException moNotFoundException) {
            MessageLog.trace((int)5, this.getClass(), (String)("get_MO_info_by_name: " + Util.stack2string((Throwable)moNotFoundException)));
            throw new NotDefined(moNotFoundException.toString());
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)ConfigExtendedImpl.class, (String)"get_MO_info_by_name: ", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError: " + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)ConfigExtendedImpl.class, (String)"get_MO_info_by_name: ", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    public MOInfo get_MO_info_by_id(long l, Session session) throws NotDefined, ProcessingFailure {
        try {
            ManagedObject managedObject = MoRepository.instance().lookup((int)l);
            if (managedObject == null) {
                throw new NotDefined("MO not found");
            }
            return this.createMoInfo(managedObject);
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)ConfigExtendedImpl.class, (String)"get_MO_info_by_id: ", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError: " + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)ConfigExtendedImpl.class, (String)"get_MO_info_by_id: ", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    public MOInfo get_MO_parent(String string, Session session) throws NotDefined, ProcessingFailure {
        try {
            ManagedObject managedObject;
            try {
                managedObject = MoRefMgr.lookup(string);
            }
            catch (MoNotFoundException moNotFoundException) {
                throw new NotDefined(moNotFoundException.toString());
            }
            ManagedObject managedObject2 = managedObject.getParent();
            if (managedObject2 == null) {
                throw new NotDefined("MO is root");
            }
            return this.createMoInfo(managedObject2);
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)ConfigExtendedImpl.class, (String)"get_MO_parent: ", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError: " + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)ConfigExtendedImpl.class, (String)"get_MO_parent: ", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    public int get_MO_containment(String string, int n, Filter filter, Session session) throws NotDefined, ProcessingFailure {
        MessageLog.traceEnter(this.getClass(), (String)("get_MO_containment: baseMO = " + string));
        try {
            Object object;
            Coordinator coordinator;
            ManagedObject managedObject = MoRefMgr.lookup(string);
            if (session == null) {
                coordinator = null;
            } else {
                object = (SessionImpl)CelloOrb.instance().reference_to_servant(session);
                if (object == null) {
                    throw new ProcessingFailure("Invalid session object");
                }
                coordinator = ((SessionImpl)object).getCoordinator();
            }
            object = MoRepository.instance().select(managedObject, n, coordinator, filter.type, filter.constraint);
            int n2 = MoIteratorMgr.instance().register((MoIterator)object);
            MessageLog.traceReturn(this.getClass(), (String)"get_MO_containment");
            return n2;
        }
        catch (MoNotFoundException moNotFoundException) {
            MessageLog.trace((int)5, this.getClass(), (String)("get_MO_containment: " + Util.stack2string((Throwable)moNotFoundException)));
            throw new NotDefined(moNotFoundException.toString());
        }
        catch (FilterSyntaxException filterSyntaxException) {
            MessageLog.trace((int)5, this.getClass(), (String)("get_MO_containment: " + Util.stack2string((Throwable)filterSyntaxException)));
            throw new ProcessingFailure(filterSyntaxException.toString());
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)ConfigExtendedImpl.class, (String)"get_MO_containment: ", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError: " + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)ConfigExtendedImpl.class, (String)"get_MO_containment: ", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    public boolean next_MO_info(int n, int n2, Session session, MOInfoSeqHolder mOInfoSeqHolder) throws NotDefined, SecurityViolation, ProcessingFailure {
        try {
            Object object;
            int n3;
            MoIterator moIterator = MoIteratorMgr.instance().lookup(n);
            if (moIterator == null) {
                throw new NotDefined("");
            }
            LinkedList<MOInfo> linkedList = new LinkedList<MOInfo>();
            for (n3 = 0; n3 < n2 && moIterator.hasMoreElements(); ++n3) {
                object = moIterator.nextMo();
                linkedList.add(this.createMoInfo((ManagedObject)object));
            }
            object = linkedList.toArray();
            mOInfoSeqHolder.value = new MOInfo[((Object[])object).length];
            for (n3 = 0; n3 < ((Object[])object).length; ++n3) {
                mOInfoSeqHolder.value[n3] = (MOInfo)object[n3];
            }
            if (!moIterator.hasMoreElements()) {
                MoIteratorMgr.instance().deregister(n);
            }
            return moIterator.hasMoreElements();
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)ConfigExtendedImpl.class, (String)"next_MO_info: ", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError: " + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)ConfigExtendedImpl.class, (String)"next_MO_info: ", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    public void delete_MO_info_iter(int n, Session session) {
        MoIteratorMgr.instance().deregister(n);
    }

    public void create_softlink(MOidpair mOidpair, CosNaming.NameComponent[] nameComponentArray, String string, Session session) throws UnsupportedQoS, AlreadyDefined, NotAccepted, SecurityViolation, ProcessingFailure {
        throw new UnsupportedQoS(new short[0]);
    }

    public void delete_softlink(MOidpair mOidpair, MOidpair mOidpair2, Session session) throws UnsupportedQoS, NotDefined, SecurityViolation, ProcessingFailure {
        throw new UnsupportedQoS(new short[0]);
    }

    public ReturnedAttributes[] get_MO_attributes(RequestedAttributes[] requestedAttributesArray, Session session) throws NotAccepted, ProcessingFailure {
        MessageLog.traceEnter(this.getClass(), (String)"get_MO_attributes");
        try {
            Coordinator coordinator;
            ReturnedAttributes[] returnedAttributesArray = new ReturnedAttributes[requestedAttributesArray.length];
            if (session == null) {
                coordinator = null;
            } else {
                SessionImpl sessionImpl = (SessionImpl)CelloOrb.instance().reference_to_servant(session);
                if (sessionImpl == null) {
                    throw new ProcessingFailure("Invalid session object");
                }
                coordinator = sessionImpl.getCoordinator();
            }
            for (int i = 0; i < requestedAttributesArray.length; ++i) {
                Object[] objectArray;
                ManagedObject managedObject;
                try {
                    managedObject = MoRefMgr.lookup(requestedAttributesArray[i].moName);
                }
                catch (MoNotFoundException moNotFoundException) {
                    throw new NotAccepted(moNotFoundException.toString());
                }
                try {
                    objectArray = managedObject.getAttributes(requestedAttributesArray[i].attributes, coordinator);
                }
                catch (MoAccessException moAccessException) {
                    throw new NotAccepted(moAccessException.toString());
                }
                NameValue[] nameValueArray = new NameValue[requestedAttributesArray[i].attributes.length];
                for (int j = 0; j < requestedAttributesArray[i].attributes.length; ++j) {
                    nameValueArray[j] = new NameValue(requestedAttributesArray[i].attributes[j], AnyMapping.object2any(objectArray[j]));
                }
                returnedAttributesArray[i] = new ReturnedAttributes(nameValueArray);
            }
            MessageLog.traceReturn(this.getClass(), (String)"get_MO_attributes");
            return returnedAttributesArray;
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)ConfigExtendedImpl.class, (String)"get_MO_attributes: ", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError: " + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)ConfigExtendedImpl.class, (String)"get_MO_attributes: ", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    public MIBInfoExt get_MIB_info_ext(MIBRef mIBRef, Session session) throws NotDefined, ProcessingFailure {
        try {
            Mib mib = MibMgr.instance().getMib();
            if (mib == null || MibMgr.instance().getMibId() != (int)mIBRef.oid) {
                throw new NotDefined("");
            }
            CosNaming.NameComponent[] nameComponentArray = EasyNaming.str2name(mib.getMibPrefix());
            return new MIBInfoExt((int)mIBRef.oid, mib.getMibName(), mib.getModelType(), 0L, mib.getModelVersion(), mib.getModelRelease(), nameComponentArray);
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)ConfigExtendedImpl.class, (String)"get_MIB_info_ext :", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError: " + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)ConfigExtendedImpl.class, (String)"get_MIB_info_ext :", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    public SessionExtended create_extended_session(String string, int n) throws ProcessingFailure {
        try {
            SessionImpl sessionImpl = new SessionImpl(string, n);
            return SessionExtendedHelper.narrow(CelloOrb.instance().addressDependentServantToReference(sessionImpl));
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)ConfigExtendedImpl.class, (String)"create_extended_session: ", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError: " + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)ConfigExtendedImpl.class, (String)"create_extended_session: ", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    private MOInfo createMoInfo(ManagedObject managedObject) throws NotDefined {
        Mib mib = this.getMib();
        return new MOInfo(managedObject.getId().intValue(), managedObject.getType(), managedObject.getLocalDistinguishedName(), mib.getMibPrefix());
    }

    private Mib getMib() throws NotDefined {
        Mib mib = MibMgr.instance().getMib();
        if (mib == null) {
            throw new NotDefined("No MIB registerred");
        }
        return mib;
    }

    public int get_mo_instance_count() {
        return MoRepository.instance().getNumberOfRegisteredInstances();
    }

    static {
        serviceProviderState = 2;
    }

    private static class ServiceProviderImpl
    implements ServiceProvider {
        public String getServiceName() {
            return "CPP.OAM.CONFIGURATIONSERVICE";
        }

        public int getState() {
            return serviceProviderState;
        }
    }
}

