/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configirpimpl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;

public class MoTxCollector
implements Resource {
    private static Map moMap = new HashMap();
    private Coordinator coordinator;

    public MoTxCollector(Coordinator coordinator) {
        this.coordinator = coordinator;
    }

    public static void storeMOAndCoordinator(String string, Coordinator coordinator) {
        MoTxCollector moTxCollector = new MoTxCollector(coordinator);
        try {
            coordinator.registerResource((Resource)moTxCollector);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.info((String)"Could not register MoTxCollector in transaction ");
        }
        moMap.put(string, coordinator);
    }

    public void commit() {
        this.removeMoTransaction(this.coordinator);
    }

    public boolean prepare() {
        return true;
    }

    public void rollback() {
        this.removeMoTransaction(this.coordinator);
    }

    public static boolean checkMoInTransaction(ManagedObject managedObject, Coordinator coordinator) {
        boolean bl = false;
        Iterator iterator = moMap.entrySet().iterator();
        String string = managedObject.getLocalDistinguishedName();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (string.equals(entry.getKey()) && coordinator.equals(entry.getValue())) {
                bl = true;
                continue;
            }
            if (!string.equals(entry.getKey()) || coordinator.equals(entry.getValue())) continue;
            bl = false;
        }
        return bl;
    }

    public synchronized void removeMoTransaction(Coordinator coordinator) {
        Iterator iterator = moMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!coordinator.equals(entry.getValue())) continue;
            iterator.remove();
        }
    }
}

