/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configirpimpl;

import BasicConfig.ProcessingFailure;
import BasicConfig.TransactionFailure;
import ConfigExtended.SessionExtendedPOA;
import se.ericsson.cello.configirpimpl.AsynchronousTxCollector;
import se.ericsson.cello.configirpimpl.SessionManager;
import se.ericsson.cello.support.corba.CelloOrb;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.debug.Util;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Status;
import se.ericsson.cello.transaction.Terminator;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class SessionImpl
extends SessionExtendedPOA {
    private static final int ASYNC_COMMIT_DELAY_IN_MS = 200;
    private Control control;
    protected Coordinator coordinator;
    private String sessionId;
    private int timeout;
    private int size = 0;
    private static final int DEFAULT_TIMEOUT = 20;

    public SessionImpl(String string, int n) throws ProcessingFailure {
        CelloOrb.instance().connect(this);
        this.sessionId = string;
        this.timeout = n == -1 ? 20 : n;
        try {
            this.startTransaction(this.timeout);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.info(this.getClass(), (String)("create exception: " + inactiveTransactionException.toString()));
            throw new ProcessingFailure("create_session: " + (Object)((Object)inactiveTransactionException));
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            MessageLog.info(this.getClass(), (String)("create exception: " + transactionRolledBackException.toString()));
            throw new ProcessingFailure("create_session: " + (Object)((Object)transactionRolledBackException));
        }
        SessionManager.instance().addSession(this);
    }

    public void restart() throws ProcessingFailure {
        try {
            this.startTransaction(this.timeout);
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            MessageLog.info(this.getClass(), (String)("restart exception: " + transactionRolledBackException.toString()));
            throw new ProcessingFailure("TransactionRolledBackException: " + transactionRolledBackException.reason);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.info(this.getClass(), (String)("restart exception: " + inactiveTransactionException.toString()));
            throw new ProcessingFailure("InactiveTransactionException: " + inactiveTransactionException.reason);
        }
        catch (RuntimeException runtimeException) {
            Assert.cppAssert((boolean)false, (String)("Runtime exception" + runtimeException));
        }
    }

    private synchronized void startTransaction(int n) throws TransactionRolledBackException, InactiveTransactionException {
        TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
        this.control = transactionFactory.create(n);
        this.coordinator = this.control.getCoordinator();
        MessageLog.trace((int)5, this.getClass(), (String)("SessionId = " + this.sessionId + ", Cello_OMS txId = " + this.coordinator.getTransactionID() + ", timeout = " + n));
    }

    public String getTransactionSize() {
        int n = 0;
        try {
            n = this.coordinator.getTransactionSize();
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            // empty catch block
        }
        return Integer.toString(n);
    }

    public String get_session_id() {
        return this.sessionId;
    }

    public void begin(int n) throws ProcessingFailure {
        try {
            this.startTransaction(n);
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            MessageLog.info(this.getClass(), (String)("begin exception: " + transactionRolledBackException.toString()));
            throw new ProcessingFailure("TransactionRolledBackException: " + transactionRolledBackException.reason);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.info(this.getClass(), (String)("begin exception: " + inactiveTransactionException.toString()));
            throw new ProcessingFailure("InactiveTransactionException: " + inactiveTransactionException.reason);
        }
        catch (RuntimeException runtimeException) {
            Assert.cppAssert((boolean)false, (String)("Runtime exception" + runtimeException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() throws TransactionFailure {
        if (this.control == null) {
            throw new TransactionFailure("NoTransactionActive");
        }
        try {
            block8: {
                try {
                    final Terminator terminator = this.control.getTerminator();
                    MessageLog.trace((int)5, this.getClass(), (String)("Committing session " + this.sessionId + " (tx:" + this.get_transaction_id() + ")."));
                    if (AsynchronousTxCollector.instance().lookup(this.get_transaction_id())) {
                        MessageLog.trace((int)5, this.getClass(), (String)"Asynchronous commit() will be performed.");
                        new Thread(new Runnable(){

                            public void run() {
                                try {
                                    try {
                                        Thread.sleep(200L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    terminator.commit();
                                }
                                catch (TransactionRolledBackException transactionRolledBackException) {
                                    MessageLog.info(this.getClass(), (String)("commit exception: " + transactionRolledBackException.toString()));
                                }
                                catch (InactiveTransactionException inactiveTransactionException) {
                                    MessageLog.info(this.getClass(), (String)("commit exception: " + inactiveTransactionException.toString()));
                                }
                            }
                        }).start();
                        break block8;
                    }
                    terminator.commit();
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    MessageLog.info(this.getClass(), (String)("commit exception: " + inactiveTransactionException.toString()));
                    throw new TransactionFailure("InactiveTransactionException: " + inactiveTransactionException.reason);
                }
                catch (TransactionRolledBackException transactionRolledBackException) {
                    MessageLog.info(this.getClass(), (String)("commit exception: " + transactionRolledBackException.toString()));
                    throw new TransactionFailure("TransactionRolledBackException: " + transactionRolledBackException.reason);
                }
                catch (Throwable throwable) {
                    Assert.cppAssert((boolean)false, (String)("Commit failure: " + Util.stack2string((Throwable)throwable)));
                    Object var3_6 = null;
                    this.control = null;
                    this.coordinator = null;
                    this.size = 0;
                }
            }
            Object var3_5 = null;
            this.control = null;
            this.coordinator = null;
            this.size = 0;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.control = null;
            this.coordinator = null;
            this.size = 0;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void rollback() throws TransactionFailure {
        Control control = this.control;
        try {
            try {
                if (control != null) {
                    MessageLog.trace((int)5, (Class)SessionImpl.class, (String)("Rollback tx =  " + control.getCoordinator().getTransactionID()));
                    Status status = control.getCoordinator().getStatus();
                    if (status == Status.NO_TRANSACTION) {
                        MessageLog.trace((int)5, (Class)SessionImpl.class, (String)("Transaction " + control.getCoordinator().getTransactionID() + " has already been rolled back"));
                        Object var4_5 = null;
                        this.control = null;
                        this.coordinator = null;
                        this.size = 0;
                        return;
                    }
                    control.getTerminator().rollback();
                }
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                MessageLog.info(this.getClass(), (String)("rollback exception: " + inactiveTransactionException.toString()));
                throw new TransactionFailure("InactiveTransactionException: " + inactiveTransactionException.reason);
            }
            catch (Throwable throwable) {
                Assert.cppAssert((boolean)false, (String)("Rollback failure: " + Util.stack2string((Throwable)throwable)));
                Object var4_7 = null;
                this.control = null;
                this.coordinator = null;
                this.size = 0;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.control = null;
            this.coordinator = null;
            this.size = 0;
            control = null;
            throw throwable;
        }
        Object var4_6 = null;
        this.control = null;
        this.coordinator = null;
        this.size = 0;
    }

    public Coordinator getCoordinator() {
        return this.coordinator;
    }

    public synchronized void end() throws TransactionFailure {
        MessageLog.trace((int)5, (Class)SessionImpl.class, (String)("end session = " + this.sessionId));
        CelloOrb.instance().disconnect(this);
        this.rollback();
        SessionManager.instance().removeSession(this);
    }

    public int get_transaction_size() throws TransactionFailure {
        try {
            if (this.coordinator == null) {
                throw new TransactionFailure("No transaction started");
            }
            this.size = this.coordinator.getTransactionSize();
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            throw new TransactionFailure("InactiveTransactionException: " + inactiveTransactionException.reason);
        }
        return this.size;
    }

    public int get_maximum_transaction_size() throws TransactionFailure {
        return TransactionServiceImpl.instance().getMaximumTransactionSize();
    }

    public int get_transaction_id() throws TransactionFailure {
        if (this.coordinator != null) {
            return this.coordinator.getTransactionID();
        }
        throw new TransactionFailure("No transaction started");
    }

    public String[] get_CS_session_interface_version() {
        String[] stringArray = new String[]{"1c0"};
        return stringArray;
    }
}

