/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.faultmanagement;

import java.util.GregorianCalendar;
import java.util.Hashtable;
import se.ericsson.cello.faultmanagement.Alarm;
import se.ericsson.cello.faultmanagement.TogglingInfo;
import se.ericsson.cello.faultmanagement.TogglingTimer;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.thread.ActionListener;

class TogglingController {
    static final int TRACE_GROUP = 3;
    private static final int MAX_NUMBER_OF_TOGGLING_THREADS = 5;
    private static final int DEFAULT_BUSY_TIME = 60000;
    private static final int DEFAULT_QUIET_TIME = 180000;
    private static TogglingController instance = new TogglingController();
    private Hashtable togglingCheckedAlarms = new Hashtable();
    private Hashtable activeTogglingAlarms = new Hashtable(5);
    private int busyTime = 60000;
    private int quietTime = 180000;

    private TogglingController() {
    }

    static TogglingController getInstance() {
        return instance;
    }

    synchronized int getBusyTime() {
        return this.busyTime;
    }

    synchronized void setBusyTime(int n) {
        this.busyTime = n;
    }

    synchronized Hashtable getActiveTogglingAlarms() {
        return this.activeTogglingAlarms;
    }

    synchronized int getQuietTime() {
        return this.quietTime;
    }

    synchronized void setQuietTime(int n) {
        this.quietTime = n;
    }

    synchronized Hashtable getTogglingCheckedAlarms() {
        return this.togglingCheckedAlarms;
    }

    synchronized boolean isAlarmSuppressedAtChange(Alarm alarm) {
        String string = this.getTogglingIdForAlarm(alarm);
        if (string == null) {
            return false;
        }
        TogglingInfo togglingInfo = (TogglingInfo)this.togglingCheckedAlarms.get(string);
        if (togglingInfo != null && togglingInfo.isToggling()) {
            MessageLog.trace((int)3, this.getClass(), (String)("Suppression at change for alarm = " + alarm.getAlarmId() + ", toggling alarm = " + togglingInfo.getTogglingAlarmId()));
            return true;
        }
        return false;
    }

    synchronized String getTogglingIdForAlarm(Alarm alarm) {
        return alarm.getManagedObjectInstance() + alarm.getSpecificProblem();
    }

    synchronized boolean isAlarmSuppressedAtCreate(Alarm alarm) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        String string = this.getTogglingIdForAlarm(alarm);
        if (string == null) {
            return false;
        }
        TogglingInfo togglingInfo = (TogglingInfo)this.togglingCheckedAlarms.get(string);
        long l = gregorianCalendar.getTime().getTime();
        String string2 = alarm.getAlarmId();
        if (togglingInfo == null) {
            togglingInfo = new TogglingInfo(l);
            togglingInfo.setAlarmId1(string2);
            this.togglingCheckedAlarms.put(string, togglingInfo);
        } else {
            long l2 = togglingInfo.getTimestamp1();
            long l3 = togglingInfo.getTimestamp2();
            int n = togglingInfo.getNumberOfAlarms();
            String string3 = togglingInfo.getAlarmId1();
            String string4 = togglingInfo.getAlarmId2();
            if (n >= 3) {
                MessageLog.trace((int)3, this.getClass(), (String)("Suppression at create for alarm = " + string2 + ", toggling alarm = " + togglingInfo.getTogglingAlarmId()));
                togglingInfo.setTimestamp1(l);
                togglingInfo.setLatestAlarm(alarm);
                togglingInfo.setAlarmCleared(false);
                se.ericsson.cello.support.thread.Alarm alarm2 = (se.ericsson.cello.support.thread.Alarm)this.activeTogglingAlarms.get(string);
                if (alarm2 != null) {
                    alarm2.start();
                }
            } else if (n < 2) {
                if (Math.abs(l - l2) > (long)this.busyTime) {
                    togglingInfo.setTimestamp1(l);
                    togglingInfo.setAlarmId1(string2);
                } else {
                    togglingInfo.setTimestamp2(l);
                    togglingInfo.setAlarmId2(string2);
                    togglingInfo.incrementNumberOfAlarms();
                }
            } else if (Math.abs(l - l3) > (long)this.busyTime) {
                togglingInfo.setTimestamp1(l);
                togglingInfo.setTimestamp2(0L);
                togglingInfo.setAlarmId1(string2);
                togglingInfo.setNumberOfAlarms(1);
            } else if (Math.abs(l - l2) > (long)this.busyTime) {
                togglingInfo.setTimestamp1(l3);
                togglingInfo.setTimestamp2(l);
                togglingInfo.setAlarmId1(string4);
                togglingInfo.setAlarmId2(string2);
            } else {
                if (this.activeTogglingAlarms.size() < 5) {
                    String string5 = alarm.getAdditionalText();
                    alarm.setAdditionalTextByTogglingController(string5 + " The alarm is currently toggling.");
                    MessageLog.trace((int)3, this.getClass(), (String)("Toggling started for alarm = " + string2 + ", first initiating alarm = " + string3 + ", second = " + string4));
                    togglingInfo.incrementNumberOfAlarms();
                    togglingInfo.setToggling(true);
                    togglingInfo.setTimestamp1(l);
                    togglingInfo.setAdditionalText(string5);
                    togglingInfo.setLatestAlarm(alarm);
                    togglingInfo.setTogglingAlarmId(string2);
                    togglingInfo.setAlarmCleared(false);
                    int n2 = this.getQuietTime();
                    se.ericsson.cello.support.thread.Alarm alarm3 = new se.ericsson.cello.support.thread.Alarm(n2, se.ericsson.cello.support.thread.Alarm.ONE_SHOT);
                    this.activeTogglingAlarms.put(string, alarm3);
                    alarm3.addActionListener((ActionListener)new TogglingTimer(alarm));
                    alarm3.start();
                } else {
                    MessageLog.trace((int)3, this.getClass(), (String)("Toggling timers list is full for alarm = " + string2));
                    togglingInfo.setTimestamp1(l3);
                    togglingInfo.setTimestamp2(l);
                    togglingInfo.setAlarmId1(string4);
                    togglingInfo.setAlarmId2(string2);
                    togglingInfo.setNumberOfAlarms(2);
                }
                return false;
            }
        }
        return togglingInfo.isToggling();
    }

    synchronized boolean isAlarmSuppressedAtClear(Alarm alarm) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        String string = this.getTogglingIdForAlarm(alarm);
        if (string == null) {
            return false;
        }
        TogglingInfo togglingInfo = (TogglingInfo)this.togglingCheckedAlarms.get(string);
        long l = gregorianCalendar.getTime().getTime();
        if (togglingInfo != null && togglingInfo.isToggling()) {
            MessageLog.trace((int)3, this.getClass(), (String)("Suppression at clear for alarm = " + alarm.getAlarmId() + ", toggling alarm = " + togglingInfo.getTogglingAlarmId()));
            togglingInfo.setTimestamp1(l);
            togglingInfo.setAlarmCleared(true);
            return true;
        }
        return false;
    }
}

