/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.FloatAttribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.LongAttribute;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.StringRepository;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.stringhandlers.StructStringHandler;
import se.ericsson.cello.recovery.AttributeLookUp;
import se.ericsson.cello.recovery.AttributeLookupFactory;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.transaction.Coordinator;

public class StructAttribute
extends Attribute
implements Serializable {
    static final long serialVersionUID = -1504871491009003745L;
    private Vector myValue;
    private transient Vector myValueBackup = null;

    public StructAttribute(String string, boolean bl) {
        super(string, bl);
        this.myValue = new Vector();
    }

    public StructAttribute(String string, String string2) {
        super(string, string2.charAt(1));
        AttributeLookUp attributeLookUp = AttributeLookupFactory.instance();
        StringRepository.instance();
        this.myValue = new Vector();
        StructStringHandler structStringHandler = new StructStringHandler(string2.substring(2));
        int n = Integer.parseInt(structStringHandler.nextSubstring());
        String string3 = StringRepository.fixString(structStringHandler.nextSubstring());
        for (int i = 0; i < n; ++i) {
            String string4;
            char c;
            if (!string3.equalsIgnoreCase("")) {
                string3 = attributeLookUp.lookup(Integer.parseInt(string3));
            }
            if ((c = (string4 = StringRepository.fixString(structStringHandler.nextSubstring())).charAt(0)) == 's') {
                this.addElement(new StringAttribute(string3, string4));
            } else if (c == 'i') {
                this.addElement(new IntegerAttribute(string3, string4));
            } else if (c == 'l') {
                this.addElement(new LongAttribute(string3, string4));
            } else if (c == 'b') {
                this.addElement(new BooleanAttribute(string3, string4));
            } else if (c == 'f') {
                this.addElement(new FloatAttribute(string3, string4));
            } else if (c == 'r') {
                this.addElement(new ReferenceAttribute(string3, string4));
            } else if (c == 'q') {
                this.addElement(new SequenceAttribute(string3, string4));
            } else if (c == 't') {
                string4 = string4 + '\u00a4' + structStringHandler.nextSubstringForStruct();
                this.addElement(new StructAttribute(string3, string4));
            }
            string3 = StringRepository.fixString(structStringHandler.nextSubstring());
        }
    }

    public synchronized Struct getValue(Coordinator coordinator) {
        Vector vector = coordinator == null && this.myValueBackup != null ? this.myValueBackup : this.myValue;
        String[] stringArray = new String[vector.size()];
        Object[] objectArray = new Object[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            Attribute attribute = (Attribute)vector.elementAt(i);
            stringArray[i] = attribute.getName();
            objectArray[i] = attribute.getValueAsObject(coordinator);
        }
        return new StructImpl(stringArray, objectArray);
    }

    public synchronized Attribute[] getElements(Coordinator coordinator) {
        if (coordinator == null && this.myValueBackup != null) {
            Object[] objectArray = new Attribute[this.myValueBackup.size()];
            this.myValueBackup.copyInto(objectArray);
            return objectArray;
        }
        Object[] objectArray = new Attribute[this.myValue.size()];
        this.myValue.copyInto(objectArray);
        return objectArray;
    }

    public synchronized Attribute getElement(String string, Coordinator coordinator) {
        if (coordinator == null && this.myValueBackup != null) {
            return this.lookup(string, this.myValueBackup);
        }
        return this.lookup(string, this.myValue);
    }

    private Attribute lookup(String string, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Attribute attribute = (Attribute)vector.elementAt(i);
            if (!attribute.getName().equals(string)) continue;
            return attribute;
        }
        return null;
    }

    public synchronized void addElement(Attribute attribute) {
        Assert.cppAssert((Object)attribute, (String)("Element in StructAttribute: " + this.getName() + " is null."));
        Assert.cppAssert((this.getElement(attribute.getName(), null) == null ? 1 : 0) != 0, (String)"Element already registered");
        this.myValue.addElement(attribute);
    }

    public synchronized boolean removeElement(Attribute attribute) {
        return this.myValue.removeElement(attribute);
    }

    public synchronized boolean isEmpty() {
        return this.myValue.isEmpty();
    }

    public synchronized Enumeration elements() {
        return this.myValue.elements();
    }

    public synchronized int size() {
        return this.myValue.size();
    }

    synchronized void startTransaction() {
        this.myValueBackup = (Vector)this.myValue.clone();
        Enumeration enumeration = this.myValue.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            attribute.startTransaction();
        }
    }

    synchronized void commit() {
        this.myValueBackup = null;
        Enumeration enumeration = this.myValue.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            attribute.commit();
        }
    }

    synchronized void rollback() {
        this.myValue = this.myValueBackup;
        this.myValueBackup = null;
        if (this.myValue == null) {
            this.myValue = new Vector();
        }
        Enumeration enumeration = this.myValue.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            attribute.rollback();
        }
    }

    Object getValueAsObject(Coordinator coordinator) {
        Vector vector = coordinator == null && this.myValueBackup != null ? this.myValueBackup : this.myValue;
        String[] stringArray = new String[vector.size()];
        Object[] objectArray = new Object[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            Attribute attribute = (Attribute)vector.elementAt(i);
            stringArray[i] = attribute.getName();
            objectArray[i] = attribute.getValueAsObject(coordinator);
        }
        return new StructImpl(stringArray, objectArray);
    }

    Object getBackUpValueAsObject(Coordinator coordinator) {
        Vector vector = this.myValueBackup;
        String[] stringArray = new String[vector.size()];
        Object[] objectArray = new Object[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            Attribute attribute = (Attribute)vector.elementAt(i);
            stringArray[i] = attribute.getName();
            objectArray[i] = attribute.getValueAsObject(coordinator);
        }
        return new StructImpl(stringArray, objectArray);
    }

    boolean isModified() {
        Enumeration enumeration = this.myValue.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (!attribute.isModified()) continue;
            return true;
        }
        return false;
    }

    public String buildString() {
        AttributeLookUp attributeLookUp = AttributeLookupFactory.instance();
        String string = this.getName();
        if (!string.equalsIgnoreCase("")) {
            string = "" + attributeLookUp.lookup(string);
        }
        return string + this.buildValueString();
    }

    public String buildValueString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (this.getNotificationType() != 0) {
            stringBuffer.append("T");
        } else {
            stringBuffer.append("F");
        }
        stringBuffer.append(this.size());
        stringBuffer.append("\u00a4");
        for (int i = 0; i < this.myValue.size(); ++i) {
            Attribute attribute = (Attribute)this.myValue.elementAt(i);
            stringBuffer.append(attribute.buildString());
            stringBuffer.append("\u00a4");
        }
        return "^t" + stringBuffer.toString().replace('^', '\u00a4');
    }
}

