/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework.csnotifications;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.moframework.csnotifications.CSMosiSubscriber;
import se.ericsson.cello.moframework.csnotifications.CSNotificationSubscriber;
import se.ericsson.cello.moframework.csnotifications.CSNotificationSubscriberMgr;
import se.ericsson.cello.moframework.csnotifications.MibPrefixChangedSubscriber;
import se.ericsson.cello.moframework.csnotifications.OrbRestartSubscriber;
import se.ericsson.cello.moframework.csnotifications.SubscriptionFilter;
import se.ericsson.cello.moframework.csnotifications.TopologyAndAVCSubscriber;
import se.ericsson.cello.moframework.csnotifications.TopologyAndAVCSubscription;
import se.ericsson.cello.support.debug.MessageLog;

public class CSNotificationSubscriberMgrImpl
implements CSNotificationSubscriberMgr {
    private List mibPrefixSubscribers = new ArrayList();
    private List orbRestartSubscribers = new ArrayList();
    private List topologyAndAVCChangeSubscribers = new ArrayList();

    protected CSNotificationSubscriberMgrImpl() {
    }

    public synchronized void register(CSNotificationSubscriber cSNotificationSubscriber) {
        if (cSNotificationSubscriber instanceof MibPrefixChangedSubscriber) {
            MessageLog.trace((int)5, this.getClass(), (String)"register MibPrefixChangedSubscriber");
            this.mibPrefixSubscribers.add(new CSMosiSubscriber(cSNotificationSubscriber));
        }
        if (cSNotificationSubscriber instanceof OrbRestartSubscriber) {
            MessageLog.trace((int)5, this.getClass(), (String)"register OrbRestartSubscriber");
            this.orbRestartSubscribers.add(new CSMosiSubscriber(cSNotificationSubscriber));
        }
    }

    public void register(TopologyAndAVCSubscriber topologyAndAVCSubscriber, SubscriptionFilter subscriptionFilter) {
        MessageLog.trace((int)5, this.getClass(), (String)"register TopologyAndAVCSubscriber");
        TopologyAndAVCSubscription topologyAndAVCSubscription = new TopologyAndAVCSubscription(topologyAndAVCSubscriber);
        if (subscriptionFilter != null) {
            topologyAndAVCSubscription.setFilter(subscriptionFilter);
            MessageLog.trace((int)5, this.getClass(), (String)("Subscription filter: " + subscriptionFilter.toString()));
        }
        this.topologyAndAVCChangeSubscribers.add(topologyAndAVCSubscription);
    }

    public synchronized void deregister(CSNotificationSubscriber cSNotificationSubscriber) {
        int n;
        if (cSNotificationSubscriber instanceof MibPrefixChangedSubscriber) {
            for (n = 0; n < this.mibPrefixSubscribers.size(); ++n) {
                if (((CSMosiSubscriber)this.mibPrefixSubscribers.get(n)).getSubscriber() != cSNotificationSubscriber) continue;
                MessageLog.trace((int)5, this.getClass(), (String)"deregister MibPrefixChangedSubscriber");
                this.mibPrefixSubscribers.remove(n);
            }
        }
        if (cSNotificationSubscriber instanceof OrbRestartSubscriber) {
            for (n = 0; n < this.orbRestartSubscribers.size(); ++n) {
                if (((CSMosiSubscriber)this.orbRestartSubscribers.get(n)).getSubscriber() != cSNotificationSubscriber) continue;
                MessageLog.trace((int)5, this.getClass(), (String)"deregister OrbRestartSubscriber");
                this.orbRestartSubscribers.remove(n);
            }
        }
        if (cSNotificationSubscriber instanceof TopologyAndAVCSubscriber) {
            for (n = 0; n < this.topologyAndAVCChangeSubscribers.size(); ++n) {
                if (((TopologyAndAVCSubscription)this.topologyAndAVCChangeSubscribers.get(n)).getSubscriber() != cSNotificationSubscriber) continue;
                MessageLog.trace((int)5, this.getClass(), (String)"deregister TopologyAndAVCSubscriber");
                ((TopologyAndAVCSubscription)this.topologyAndAVCChangeSubscribers.get(n)).stopSubscription();
                this.topologyAndAVCChangeSubscribers.remove(n);
            }
        }
    }

    public List getMibPrefixSubscribers() {
        return new ArrayList(this.mibPrefixSubscribers);
    }

    public List getOrbRestartSubscribers() {
        return new ArrayList(this.orbRestartSubscribers);
    }

    public List getTopologyAndAVCChangeSubscribers() {
        return new ArrayList(this.topologyAndAVCChangeSubscribers);
    }
}

