/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework.csnotifications;

import se.ericsson.cello.moframework.csnotifications.CSNotificationSubscriber;
import se.ericsson.cello.moframework.csnotifications.NotificationElement;
import se.ericsson.cello.moframework.csnotifications.SubscriptionFilter;
import se.ericsson.cello.moframework.csnotifications.TopologyAndAVCDistributor;
import se.ericsson.cello.moframework.csnotifications.TopologyAndAVCSubscriber;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.util.BlockingQueue;

public class TopologyAndAVCSubscription {
    private static final int DEFAULT_QUEUE_SIZE = 1000;
    private BlockingQueue notificationQueue;
    private CSNotificationSubscriber subscriber;
    private SubscriptionFilter filter;
    private TopologyAndAVCDistributor consumer;

    TopologyAndAVCSubscription(CSNotificationSubscriber cSNotificationSubscriber) {
        int n = 1000;
        this.subscriber = cSNotificationSubscriber;
        this.notificationQueue = new BlockingQueue(n);
        this.consumer = new TopologyAndAVCDistributor(this, cSNotificationSubscriber);
        this.consumer.start();
    }

    public CSNotificationSubscriber getSubscriber() {
        return this.subscriber;
    }

    public void avcTopologyChange(NotificationElement notificationElement) {
        if (this.isSubscribed(notificationElement)) {
            try {
                if (!this.notificationQueue.enqueue(notificationElement)) {
                    this.handleQueueFull();
                }
            }
            catch (BlockingQueue.ClosedException closedException) {
                MessageLog.trace((int)5, this.getClass(), (String)("Failed to add element to notification queue. " + closedException));
            }
        }
    }

    public boolean isSubscribed(NotificationElement notificationElement) {
        boolean bl = false;
        if (this.filter == null || this.filter.getMoTypes().length == 0) {
            bl = true;
        } else {
            for (int i = 0; i < this.filter.getMoTypes().length; ++i) {
                if (!this.filter.getMoTypes()[i].equals(notificationElement.getMoType())) continue;
                bl = true;
                break;
            }
        }
        if (this.filter == null) {
            MessageLog.trace((int)5, this.getClass(), (String)("Filter is: null, matches = " + bl));
        } else {
            MessageLog.trace((int)5, this.getClass(), (String)("Filter is: " + this.filter.toString() + ", matches = " + bl));
        }
        return bl;
    }

    public void setFilter(SubscriptionFilter subscriptionFilter) {
        this.filter = subscriptionFilter;
    }

    public SubscriptionFilter getFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NotificationElement dequeue() throws BlockingQueue.ClosedException {
        BlockingQueue blockingQueue = this.notificationQueue;
        synchronized (blockingQueue) {
            return (NotificationElement)this.notificationQueue.dequeue();
        }
    }

    void stopSubscription() {
        this.consumer.stopSubscription();
        this.notificationQueue.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQueueFull() throws BlockingQueue.ClosedException {
        MessageLog.trace((int)5, this.getClass(), (String)"handleQueueFull()");
        BlockingQueue blockingQueue = this.notificationQueue;
        synchronized (blockingQueue) {
            this.notificationQueue.clear();
            ((TopologyAndAVCSubscriber)this.subscriber).queueOverflow();
        }
    }
}

