/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import se.ericsson.cello.moframework.Mopplet;
import se.ericsson.cello.moframework.internal.CircularMoppletDependencyException;
import se.ericsson.cello.moframework.internal.DependencyAwareMopplet;
import se.ericsson.cello.moframework.internal.MoppletId;
import se.ericsson.cello.support.debug.MessageLog;

public class SortedMopplets {
    private Set markedMopplets = new HashSet();
    private List unsortedMopplets = new Vector();
    private Collection sortedMopplets = new Vector();
    private Collection ordinaryMopplets = new Vector();

    public void add(Mopplet mopplet) throws CircularMoppletDependencyException {
        if (mopplet instanceof DependencyAwareMopplet) {
            DependencyAwareMopplet dependencyAwareMopplet = (DependencyAwareMopplet)mopplet;
            try {
                this.sort(dependencyAwareMopplet);
            }
            catch (CircularMoppletDependencyException circularMoppletDependencyException) {
                this.unsortedMopplets.remove(dependencyAwareMopplet);
                MessageLog.traceError(this.getClass(), (String)("Mopplet " + dependencyAwareMopplet.getClass().getName() + " (" + dependencyAwareMopplet.getMoppletId() + ") causes a circular dependency, " + "will be ignored."));
            }
        } else {
            this.ordinaryMopplets.add(mopplet);
        }
    }

    public Iterator iterator() {
        Object object;
        if (!this.unsortedMopplets.isEmpty()) {
            object = "The following mopplets have unresolved dependencies and will not be included:\n";
            Iterator iterator = this.unsortedMopplets.iterator();
            while (iterator.hasNext()) {
                DependencyAwareMopplet dependencyAwareMopplet = (DependencyAwareMopplet)iterator.next();
                object = (String)object + "    " + dependencyAwareMopplet.getClass().getName() + " (" + dependencyAwareMopplet.getMoppletId() + ")\n";
            }
            MessageLog.traceError(this.getClass(), (String)object);
        }
        object = new Vector();
        object.addAll(this.sortedMopplets);
        object.addAll(this.ordinaryMopplets);
        return object.iterator();
    }

    private void sort(DependencyAwareMopplet dependencyAwareMopplet) throws CircularMoppletDependencyException {
        if (this.allDependenciesSorted(dependencyAwareMopplet)) {
            this.addToSorted(dependencyAwareMopplet);
        } else if (this.markedMopplets.contains(dependencyAwareMopplet)) {
            if (this.noMissingDependencies()) {
                throw new CircularMoppletDependencyException();
            }
        } else {
            this.addToUnsorted(dependencyAwareMopplet);
        }
    }

    private boolean allDependenciesSorted(DependencyAwareMopplet dependencyAwareMopplet) {
        MoppletId[] moppletIdArray = dependencyAwareMopplet.getDependencies();
        for (int i = 0; i < moppletIdArray.length; ++i) {
            if (!this.notInCollection(moppletIdArray[i], this.sortedMopplets)) continue;
            return false;
        }
        return true;
    }

    private boolean noMissingDependencies() {
        Iterator iterator = this.unsortedMopplets.iterator();
        while (iterator.hasNext()) {
            if (this.allDependenciesAdded((DependencyAwareMopplet)iterator.next())) continue;
            return false;
        }
        return true;
    }

    private boolean allDependenciesAdded(DependencyAwareMopplet dependencyAwareMopplet) {
        MoppletId[] moppletIdArray = dependencyAwareMopplet.getDependencies();
        for (int i = 0; i < moppletIdArray.length; ++i) {
            if (!this.notInCollection(moppletIdArray[i], this.unsortedMopplets) || !this.notInCollection(moppletIdArray[i], this.sortedMopplets)) continue;
            return false;
        }
        return true;
    }

    private boolean notInCollection(MoppletId moppletId, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (((DependencyAwareMopplet)iterator.next()).getMoppletId() != moppletId) continue;
            return false;
        }
        return true;
    }

    private void addToUnsorted(DependencyAwareMopplet dependencyAwareMopplet) {
        if (this.unsortedMopplets.contains(dependencyAwareMopplet)) {
            this.unsortedMopplets.remove(dependencyAwareMopplet);
        }
        this.unsortedMopplets.add(dependencyAwareMopplet);
        this.markedMopplets.add(dependencyAwareMopplet);
        if (this.unsortedMopplets.size() > 1) {
            this.sort((DependencyAwareMopplet)this.unsortedMopplets.get(0));
        }
    }

    private void addToSorted(DependencyAwareMopplet dependencyAwareMopplet) {
        this.unsortedMopplets.remove(dependencyAwareMopplet);
        this.sortedMopplets.add(dependencyAwareMopplet);
        this.markedMopplets.clear();
        if (this.unsortedMopplets.size() > 0) {
            this.sort((DependencyAwareMopplet)this.unsortedMopplets.get(0));
        }
    }
}

