/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.oms;

import java.net.InetAddress;
import java.net.UnknownHostException;
import se.ericsson.cello.nia.NIAAddressInfo;
import se.ericsson.cello.nia.NIAListener;
import se.ericsson.cello.nia.NIAMgr;
import se.ericsson.cello.nia.NIAMgrFactory;
import se.ericsson.cello.oms.ORBRestartManager;
import se.ericsson.cello.support.debug.MessageLog;

public class NodeIpAddressSubscriber
implements NIAListener {
    static boolean isStartingWithNoIpAddress = false;
    private static NodeIpAddressSubscriber instance;
    private static final int MAX_NO_OF_RETRIES = 40;
    private static final int RETRY_INTERVAL = 2000;
    private static final int TRACE_GROUP = 5;

    public static NodeIpAddressSubscriber getInstance() {
        return instance;
    }

    public void init() {
        NIAMgr nIAMgr = NIAMgrFactory.createNIAMgr();
        nIAMgr.registerSubscriber((NIAListener)this);
    }

    public void notifyIpAddressChanged(String string, String string2) {
        String string3 = "";
        boolean bl = true;
        int n = 0;
        MessageLog.trace((int)5, this.getClass(), (String)("notifyIpAddressChanged: newIpAddress = " + string + ", nodeInterfaceName = " + string2 + "."));
        try {
            string3 = InetAddress.getLocalHost().getHostAddress();
            while (!string3.equals(string) && n < 40) {
                string3 = InetAddress.getLocalHost().getHostAddress();
                ++n;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (UnknownHostException unknownHostException) {
            MessageLog.traceError(this.getClass(), (String)("notifyIpAddressChanged, caught exception: " + unknownHostException + ". ORB will not be restarted."));
            bl = false;
        }
        if (!string3.equals(string)) {
            MessageLog.traceError(this.getClass(), (String)("notifyIpAddressChanged called, but JVM never changed address. New IP address: " + string + ". Old IP address: " + string3 + ". Interface name: " + string2 + ". ORB will not be restarted:"));
            bl = false;
        }
        if (isStartingWithNoIpAddress) {
            bl = true;
            isStartingWithNoIpAddress = false;
        }
        if (bl) {
            MessageLog.info(this.getClass(), (String)"Node IP address has been changed, ORB will be restarted");
            ORBRestartManager.instance().restartORB();
        }
    }

    public void notifyIpAddressChanged(NIAAddressInfo[] nIAAddressInfoArray) {
        MessageLog.trace((int)5, this.getClass(), (String)"notifyIpAddressChanged");
        boolean bl = false;
        for (int i = 0; i < nIAAddressInfoArray.length; ++i) {
            MessageLog.trace((int)5, this.getClass(), (String)("Interface/isChanged/isValid: " + nIAAddressInfoArray[i].getnodeInterfaceName() + "/" + nIAAddressInfoArray[i].isChanged() + "/" + nIAAddressInfoArray[i].isValid()));
            if (nIAAddressInfoArray[i].isChanged() && nIAAddressInfoArray[i].isValid()) {
                bl = true;
            }
            if (!isStartingWithNoIpAddress) continue;
            bl = true;
            isStartingWithNoIpAddress = false;
        }
        if (bl) {
            MessageLog.info(this.getClass(), (String)"Node IP address has been changed, ORB will be restarted");
            ORBRestartManager.instance().restartORB();
        }
    }

    private NodeIpAddressSubscriber() {
    }

    static {
        try {
            if (InetAddress.getLocalHost().isLoopbackAddress()) {
                isStartingWithNoIpAddress = true;
            }
            MessageLog.trace((int)5, (Class)NodeIpAddressSubscriber.class, (String)("Starting with IP address " + InetAddress.getLocalHost()));
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        instance = new NodeIpAddressSubscriber();
    }
}

