/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.event;

import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import java.util.Enumeration;
import java.util.Vector;
import se.ericsson.cello.pms.event.EventAttribute;
import se.ericsson.cello.pms.event.ServiceNotCompleteException;
import se.ericsson.cello.pms.event.SubscriptionContent;
import se.ericsson.cello.pms.event.SubscriptionFailureException;
import se.ericsson.cello.pms.event.signal.PmDistributorProxy;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.OseNameServer;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.cello.support.sigutil.SubscriptionObserver;
import se.ericsson.cello.support.sigutil.signals.NsGetServicePidReply;
import se.ericsson.cello.support.sigutil.signals.NsGetServicePidReq;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class EventSubscription
implements SubscriptionContent {
    private String oseNsServiceTag;
    private int scannerPid;
    private long resource;
    private EventScannerObserver observer;
    private Vector eventAttributes = new Vector();
    private Vector removedAttributes = new Vector();
    private boolean isActive = false;
    private static final String C_PART_SERVICE_TAG = "CelloPms";
    private static final int TRANSACTION_TIME_OUT_SECONDS = 60;

    public static EventSubscription create(String string, long l) throws ServiceNotCompleteException, SubscriptionFailureException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (OseNameServer.lookup((String)C_PART_SERVICE_TAG) == null) {
            throw new ServiceNotCompleteException();
        }
        return new EventSubscription(string, EventSubscription.getServicePid(string), l);
    }

    public synchronized void start() throws SubscriptionFailureException {
        if (!this.isActive) {
            this.observer = new EventScannerObserver();
            PmDistributorProxy.instance().sendAddSubscription(this);
            this.setAttributesOn();
            this.isActive = true;
        }
    }

    public synchronized void stop() {
        if (this.isActive) {
            this.observer.destroy();
            PmDistributorProxy.instance().sendDeleteSubscription(this);
            this.setAttributesOff();
            this.isActive = false;
        }
    }

    public long addEventAttribute(String string, String string2) {
        EventAttribute eventAttribute = EventAttribute.create(string, string2);
        if (!this.eventAttributes.contains(eventAttribute)) {
            this.eventAttributes.addElement(eventAttribute);
        }
        return eventAttribute.getId();
    }

    public void removeEventAttribute(long l) {
        EventAttribute eventAttribute = EventAttribute.lookup(l);
        if (eventAttribute != null && this.eventAttributes.contains(eventAttribute)) {
            if (this.isActive) {
                this.eventAttributes.removeElement(eventAttribute);
                this.removedAttributes.addElement(eventAttribute);
            } else {
                this.eventAttributes.removeElement(eventAttribute);
                EventAttribute.remove(eventAttribute);
            }
        }
    }

    public int getScannerPid() {
        return this.scannerPid;
    }

    public long getResourceId() {
        return this.resource;
    }

    public long[] getAttributes() {
        return this.getEventAttributeIdList();
    }

    private EventSubscription(String string, int n, long l) {
        this.oseNsServiceTag = string;
        this.scannerPid = n;
        this.resource = l;
    }

    private long[] getEventAttributeIdList() {
        long[] lArray = new long[this.eventAttributes.size() + this.removedAttributes.size()];
        int n = 0;
        Enumeration enumeration = this.eventAttributes.elements();
        while (enumeration.hasMoreElements()) {
            lArray[n++] = ((EventAttribute)enumeration.nextElement()).getId();
        }
        enumeration = this.removedAttributes.elements();
        while (enumeration.hasMoreElements()) {
            lArray[n++] = ((EventAttribute)enumeration.nextElement()).getId();
        }
        return lArray;
    }

    private static int getServicePid(String string) throws SubscriptionFailureException {
        NsGetServicePidReq nsGetServicePidReq = new NsGetServicePidReq(string);
        NsGetServicePidReply nsGetServicePidReply = (NsGetServicePidReply)SignalHelper.sendAndReceive((OseProcess)OseNameServer.getOseNs(), (Signal)nsGetServicePidReq, (Class)NsGetServicePidReply.class);
        if (nsGetServicePidReply == null) {
            throw new SubscriptionFailureException();
        }
        int n = nsGetServicePidReply.getServicePid();
        return n;
    }

    private void setAttributesOn() {
        Control control = this.createTransaction();
        Enumeration enumeration = this.eventAttributes.elements();
        while (enumeration.hasMoreElements()) {
            ((EventAttribute)enumeration.nextElement()).setOn(control.getCoordinator());
        }
        this.commitTransaction(control);
    }

    private void setAttributesOff() {
        Control control = this.createTransaction();
        Enumeration enumeration = this.eventAttributes.elements();
        while (enumeration.hasMoreElements()) {
            ((EventAttribute)enumeration.nextElement()).setOff(control.getCoordinator());
        }
        enumeration = this.removedAttributes.elements();
        while (enumeration.hasMoreElements()) {
            EventAttribute eventAttribute = (EventAttribute)enumeration.nextElement();
            eventAttribute.setOff(control.getCoordinator());
            EventAttribute.remove(eventAttribute);
        }
        this.removedAttributes = new Vector();
        this.commitTransaction(control);
    }

    private Control createTransaction() {
        try {
            Control control = TransactionServiceImpl.instance().getTransactionFactory().create(60);
            Coordinator coordinator = control.getCoordinator();
            MessageLog.trace((int)5, this.getClass(), (String)("Cello_OMS txId = " + coordinator.getTransactionID() + ", timeout = " + 60));
            return control;
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            MessageLog.traceError(this.getClass(), (String)"Transaction", (Throwable)transactionRolledBackException);
            throw new RuntimeException("Failed create transaction when setting event attributes.");
        }
    }

    private void commitTransaction(Control control) {
        try {
            control.getTerminator().commit();
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            MessageLog.traceError(this.getClass(), (String)"commit failed - rollback", (Throwable)transactionRolledBackException);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.traceError(this.getClass(), (String)"commit failed - inactive", (Throwable)inactiveTransactionException);
        }
    }

    private void serviceAdded(String string) {
    }

    private void serviceRemoved(String string) {
        if (string == this.oseNsServiceTag) {
            Thread thread = new Thread((Runnable)new Stopper(), "Oms_scanner_proc_observer");
            thread.start();
        }
    }

    private class Stopper
    implements Runnable {
        private Stopper() {
        }

        public void run() {
            EventSubscription.this.stop();
        }
    }

    private class EventScannerObserver
    implements SubscriptionObserver {
        EventScannerObserver() {
            OseNameServer.addSubscriptionObserver((String)EventSubscription.this.oseNsServiceTag, (SubscriptionObserver)this);
        }

        void destroy() {
            OseNameServer.removeSubscriptionObserver((String)EventSubscription.this.oseNsServiceTag, (SubscriptionObserver)this);
        }

        public void serviceAdded(String string) {
            EventSubscription.this.serviceAdded(string);
        }

        public void serviceRemoved(String string) {
            EventSubscription.this.serviceRemoved(string);
        }
    }
}

