/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import CommonIRPConstDefs.Signal;
import PerformanceIRPConstDefs.Destination;
import PerformanceIRPConstDefs.DestinationHolder;
import PerformanceIRPConstDefs.FailureInformation;
import PerformanceIRPConstDefs.FailureInformationHolder;
import PerformanceIRPConstDefs.FilterHolder;
import PerformanceIRPConstDefs.ObservationClassListHolder;
import PerformanceIRPConstDefs.ObservationObjectHolder;
import PerformanceIRPConstDefs.ObservationObjectListHolder;
import PerformanceIRPConstDefs.PerformanceMonitoring;
import PerformanceIRPConstDefs.PerformanceMonitoringIdListHolder;
import PerformanceIRPConstDefs.PerformanceMonitoringListHolder;
import PerformanceIRPConstDefs.PerformanceMonitoringReportHolder;
import PerformanceIRPConstDefs.PerformanceMonitoringStateHolder;
import PerformanceIRPConstDefs.RecordingTypeHolder;
import PerformanceIRPConstDefs.Schedule;
import PerformanceIRPConstDefs.ScheduleHolder;
import PerformanceIRPConstDefs.TimeWindowHolder;
import PmServiceExtended.DestinationAddressHolder;
import PmServiceExtended.OutputModeHolder;
import PmServiceExtended.PerformanceMonitoringExtendedOperations;
import java.util.Enumeration;
import java.util.LinkedList;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.StringHolder;
import org.omg.TimeBase.UtcT;
import org.threegppsa5.PerformanceIRPSystem.DestinationNotSupportedException;
import org.threegppsa5.PerformanceIRPSystem.GranularityNotSupportedException;
import org.threegppsa5.PerformanceIRPSystem.InvalidNetworkElement;
import org.threegppsa5.PerformanceIRPSystem.InvalidObservationClassException;
import org.threegppsa5.PerformanceIRPSystem.InvalidParameterException;
import org.threegppsa5.PerformanceIRPSystem.InvalidReportingPeriodException;
import org.threegppsa5.PerformanceIRPSystem.InvalidScheduleException;
import org.threegppsa5.PerformanceIRPSystem.NoSuchIdException;
import org.threegppsa5.PerformanceIRPSystem.OptionalOperationNotSupportedException;
import org.threegppsa5.PerformanceIRPSystem.OptionalParameterNotSupportedException;
import org.threegppsa5.PerformanceIRPSystem.ProcessingErrorException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.pms.generic.DestinationAddress;
import se.ericsson.cello.pms.generic.FailedException;
import se.ericsson.cello.pms.generic.Filter;
import se.ericsson.cello.pms.generic.FilterInfo;
import se.ericsson.cello.pms.generic.GranularityAndAttributeActivationException;
import se.ericsson.cello.pms.generic.GranularityPeriodNotSupportedException;
import se.ericsson.cello.pms.generic.InvalidFilterException;
import se.ericsson.cello.pms.generic.InvalidGranularityPeriodException;
import se.ericsson.cello.pms.generic.InvalidObservationObjectListException;
import se.ericsson.cello.pms.generic.InvalidPerformanceMonitoringTypeException;
import se.ericsson.cello.pms.generic.InvalidTriggeringObjectException;
import se.ericsson.cello.pms.generic.MonitoringTask;
import se.ericsson.cello.pms.generic.MonitoringTaskAccess;
import se.ericsson.cello.pms.generic.MonitoringTaskInfo;
import se.ericsson.cello.pms.generic.MonitoringTaskMgr;
import se.ericsson.cello.pms.generic.NumberOfCountersExceededException;
import se.ericsson.cello.pms.generic.NumberOfMonitorsExceededException;
import se.ericsson.cello.pms.generic.ObjectRepository;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.ObservationObject;
import se.ericsson.cello.pms.generic.OperationFailedException;
import se.ericsson.cello.pms.generic.OutputMode;
import se.ericsson.cello.pms.generic.OverloadException;
import se.ericsson.cello.pms.generic.ParameterNotAcceptedException;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.pms.generic.RecordingType;
import se.ericsson.cello.pms.generic.ScannerAccess;
import se.ericsson.cello.pms.generic.ScannerInfo;
import se.ericsson.cello.pms.generic.ScannerRepository;
import se.ericsson.cello.pms.generic.SystemSuspendedException;
import se.ericsson.cello.pms.generic.TransactionHelper;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;

class BasicPerformanceMonitoringOperationsImpl {
    private static String[] emptyArrayValue = new String[]{""};
    private static Schedule emptySchedule;
    private static PerformanceMonitoringExtendedOperations theInstance;

    static PerformanceMonitoringExtendedOperations instance() {
        return theInstance;
    }

    private BasicPerformanceMonitoringOperationsImpl() {
    }

    static {
        theInstance = new Servant();
    }

    private static class Servant
    implements PerformanceMonitoringExtendedOperations {
        private Servant() {
        }

        public Signal create_performance_monitoring(PerformanceIRPConstDefs.ObservationClass[] observationClassArray, PerformanceIRPConstDefs.ObservationObject[] observationObjectArray, int n, Schedule schedule, int n2, Destination destination, String string, PerformanceIRPConstDefs.PerformanceMonitoringState performanceMonitoringState, IntHolder intHolder, FailureInformationHolder failureInformationHolder) throws OptionalOperationNotSupportedException, OptionalParameterNotSupportedException, org.threegppsa5.PerformanceIRPSystem.InvalidObservationObjectListException, InvalidObservationClassException, org.threegppsa5.PerformanceIRPSystem.InvalidGranularityPeriodException, InvalidParameterException, InvalidScheduleException, InvalidReportingPeriodException, DestinationNotSupportedException, ProcessingErrorException, org.threegppsa5.PerformanceIRPSystem.NumberOfCountersExceededException, org.threegppsa5.PerformanceIRPSystem.NumberOfMonitorsExceededException, org.threegppsa5.PerformanceIRPSystem.OverloadException, GranularityNotSupportedException, org.threegppsa5.PerformanceIRPSystem.GranularityAndAttributeActivationException {
            this.checkRegisteredObservationClasses(observationClassArray);
            return this.createPerformanceMonitoring(observationClassArray, observationObjectArray, n, schedule, n2, destination, string, performanceMonitoringState, intHolder, failureInformationHolder);
        }

        public Signal create_generic_performance_monitoring(PerformanceIRPConstDefs.ObservationClass[] observationClassArray, PerformanceIRPConstDefs.ObservationObject[] observationObjectArray, int n, Schedule schedule, int n2, Destination destination, String string, PerformanceIRPConstDefs.PerformanceMonitoringState performanceMonitoringState, IntHolder intHolder, FailureInformationHolder failureInformationHolder) throws OptionalOperationNotSupportedException, OptionalParameterNotSupportedException, org.threegppsa5.PerformanceIRPSystem.InvalidObservationObjectListException, InvalidObservationClassException, org.threegppsa5.PerformanceIRPSystem.InvalidGranularityPeriodException, InvalidParameterException, InvalidScheduleException, InvalidReportingPeriodException, DestinationNotSupportedException, ProcessingErrorException, org.threegppsa5.PerformanceIRPSystem.NumberOfCountersExceededException, org.threegppsa5.PerformanceIRPSystem.NumberOfMonitorsExceededException, org.threegppsa5.PerformanceIRPSystem.OverloadException, GranularityNotSupportedException, org.threegppsa5.PerformanceIRPSystem.GranularityAndAttributeActivationException {
            PerformanceIRPConstDefs.ObservationClass[] observationClassArray2 = this.getRegisteredObservationClasses(observationClassArray);
            return this.createPerformanceMonitoring(observationClassArray2, observationObjectArray, n, schedule, n2, destination, string, performanceMonitoringState, intHolder, failureInformationHolder);
        }

        private Signal createPerformanceMonitoring(PerformanceIRPConstDefs.ObservationClass[] observationClassArray, PerformanceIRPConstDefs.ObservationObject[] observationObjectArray, int n, Schedule schedule, int n2, Destination destination, String string, PerformanceIRPConstDefs.PerformanceMonitoringState performanceMonitoringState, IntHolder intHolder, FailureInformationHolder failureInformationHolder) throws OptionalOperationNotSupportedException, OptionalParameterNotSupportedException, org.threegppsa5.PerformanceIRPSystem.InvalidObservationObjectListException, InvalidObservationClassException, org.threegppsa5.PerformanceIRPSystem.InvalidGranularityPeriodException, InvalidParameterException, InvalidScheduleException, InvalidReportingPeriodException, DestinationNotSupportedException, ProcessingErrorException, org.threegppsa5.PerformanceIRPSystem.NumberOfCountersExceededException, org.threegppsa5.PerformanceIRPSystem.NumberOfMonitorsExceededException, org.threegppsa5.PerformanceIRPSystem.OverloadException, GranularityNotSupportedException, org.threegppsa5.PerformanceIRPSystem.GranularityAndAttributeActivationException {
            if (!(observationObjectArray != null && observationObjectArray.length != 0 || observationClassArray != null && observationClassArray.length != 0)) {
                PerformanceIRPConstDefs.ObservationClass observationClass = new PerformanceIRPConstDefs.ObservationClass("", emptyArrayValue);
                PerformanceIRPConstDefs.ObservationClass[] observationClassArray2 = new PerformanceIRPConstDefs.ObservationClass[]{observationClass};
                throw new InvalidObservationClassException(observationClassArray2);
            }
            this.checkObservationClass(observationClassArray);
            this.checkObservationObject(observationObjectArray);
            this.checkMeasurementName(string);
            ObservationClass[] observationClassArray3 = this.convertToPmsClass(observationClassArray);
            ObservationObject[] observationObjectArray2 = this.convertToPmsObject(observationObjectArray);
            PerformanceMonitoringState performanceMonitoringState2 = this.convertToPmsState(performanceMonitoringState);
            Control control = null;
            try {
                control = TransactionHelper.create();
                MonitoringTask monitoringTask = MonitoringTaskMgr.instance().createMonitoringTask(observationClassArray3, observationObjectArray2, n, n2, string, performanceMonitoringState2, control.getCoordinator());
                intHolder.value = monitoringTask.getScannerId().intValue();
                failureInformationHolder.value = FailureInformation.NO_FAILURE;
                control.getTerminator().commit();
                MessageLog.trace((int)8, this.getClass(), (String)("create (" + monitoringTask.getScannerId().intValue() + ")"));
            }
            catch (InvalidGranularityPeriodException invalidGranularityPeriodException) {
                TransactionHelper.rollback(control);
                throw new org.threegppsa5.PerformanceIRPSystem.InvalidGranularityPeriodException();
            }
            catch (NumberOfCountersExceededException numberOfCountersExceededException) {
                TransactionHelper.rollback(control);
                throw new org.threegppsa5.PerformanceIRPSystem.NumberOfCountersExceededException();
            }
            catch (NumberOfMonitorsExceededException numberOfMonitorsExceededException) {
                TransactionHelper.rollback(control);
                throw new org.threegppsa5.PerformanceIRPSystem.NumberOfMonitorsExceededException();
            }
            catch (GranularityAndAttributeActivationException granularityAndAttributeActivationException) {
                TransactionHelper.rollback(control);
                throw new org.threegppsa5.PerformanceIRPSystem.GranularityAndAttributeActivationException(this.convertFromPmsClass(granularityAndAttributeActivationException.getObservationClassList()));
            }
            catch (OverloadException overloadException) {
                TransactionHelper.rollback(control);
                throw new org.threegppsa5.PerformanceIRPSystem.OverloadException();
            }
            catch (GranularityPeriodNotSupportedException granularityPeriodNotSupportedException) {
                TransactionHelper.rollback(control);
                throw new GranularityNotSupportedException();
            }
            catch (ParameterNotAcceptedException parameterNotAcceptedException) {
                TransactionHelper.rollback(control);
                throw new InvalidParameterException(parameterNotAcceptedException.reason());
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                MessageLog.traceError(this.getClass(), (String)"Processing failure due to inactive transaction.", (Throwable)inactiveTransactionException);
                throw new ProcessingErrorException(inactiveTransactionException.toString());
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                MessageLog.traceError(this.getClass(), (String)"Processing failure due to inactive transaction.", (Throwable)transactionRolledBackException);
                throw new ProcessingErrorException(transactionRolledBackException.toString());
            }
            catch (SystemSuspendedException systemSuspendedException) {
                MessageLog.info(this.getClass(), (String)"Create request rejected due to that all monitorings are currently system suspended.");
                throw new ProcessingErrorException("Create request rejected due to that all monitorings are currently system suspended.");
            }
            catch (RuntimeException runtimeException) {
                TransactionHelper.rollback(control);
                MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)runtimeException);
                throw new ProcessingErrorException(runtimeException.toString());
            }
            catch (Error error) {
                TransactionHelper.rollback(control);
                MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)error);
                throw new ProcessingErrorException(error.toString());
            }
            return Signal.OK;
        }

        public Signal lookup_performance_monitoring(int n, ObservationClassListHolder observationClassListHolder, ObservationObjectListHolder observationObjectListHolder, IntHolder intHolder, ScheduleHolder scheduleHolder, IntHolder intHolder2, DestinationHolder destinationHolder, PerformanceMonitoringStateHolder performanceMonitoringStateHolder, StringHolder stringHolder) throws OptionalOperationNotSupportedException, NoSuchIdException, ProcessingErrorException, InvalidParameterException {
            try {
                Object object = ScannerRepository.instance().lookup(n);
                if (object == null) {
                    throw new NoSuchIdException();
                }
                if (object instanceof ScannerAccess) {
                    ScannerInfo scannerInfo = ((ScannerAccess)object).getScannerInfo();
                    observationClassListHolder.value = scannerInfo.getObservationClassList();
                    observationObjectListHolder.value = scannerInfo.getObservationObjectList();
                    intHolder.value = scannerInfo.getGranularityPeriod();
                    scheduleHolder.value = this.createEmptySchedule();
                    intHolder2.value = scannerInfo.getGranularityPeriod();
                    destinationHolder.value = Destination.FILE;
                    performanceMonitoringStateHolder.value = scannerInfo.getScannerState();
                    stringHolder.value = scannerInfo.getMeasurementName();
                } else if (object instanceof MonitoringTaskAccess) {
                    MonitoringTaskInfo monitoringTaskInfo = ((MonitoringTaskAccess)object).getTaskInfo();
                    observationClassListHolder.value = this.convertFromPmsClass(monitoringTaskInfo.getObservationClassList());
                    observationObjectListHolder.value = this.convertFromPmsObject(monitoringTaskInfo.getObservationObjectList());
                    intHolder.value = monitoringTaskInfo.getGranularityPeriodInSeconds();
                    scheduleHolder.value = this.createEmptySchedule();
                    intHolder2.value = monitoringTaskInfo.getReportingPeriodInSeconds();
                    destinationHolder.value = Destination.FILE;
                    performanceMonitoringStateHolder.value = this.convertFromPmsState(monitoringTaskInfo.getState());
                    stringHolder.value = monitoringTaskInfo.getName();
                }
            }
            catch (RuntimeException runtimeException) {
                MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)runtimeException);
                throw new ProcessingErrorException(runtimeException.toString());
            }
            catch (Error error) {
                MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)error);
                throw new ProcessingErrorException(error.toString());
            }
            return Signal.OK;
        }

        public Signal list_performance_monitorings(String[] stringArray, PerformanceMonitoringListHolder performanceMonitoringListHolder) throws OptionalOperationNotSupportedException, OptionalParameterNotSupportedException, InvalidNetworkElement, InvalidParameterException {
            try {
                LinkedList linkedList = this.getAllScanners();
                performanceMonitoringListHolder.value = this.convertPerformanceMonitoring(linkedList);
            }
            catch (RuntimeException runtimeException) {
                MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)runtimeException);
                return Signal.Failure;
            }
            catch (Error error) {
                MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)error);
                return Signal.Failure;
            }
            return Signal.OK;
        }

        private LinkedList getAllScanners() {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            Enumeration enumeration = ScannerRepository.instance().lookupAll();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof ScannerAccess) {
                    linkedList.add(((ScannerAccess)e).getScannerInfo());
                    continue;
                }
                linkedList.add(((MonitoringTaskAccess)e).getTaskInfo());
            }
            return linkedList;
        }

        public Signal delete_performance_monitoring(int n) throws OptionalOperationNotSupportedException, NoSuchIdException, ProcessingErrorException, org.threegppsa5.PerformanceIRPSystem.InvalidPerformanceMonitoringTypeException, InvalidParameterException {
            block13: {
                MessageLog.trace((int)8, this.getClass(), (String)("delete request (" + n + ")"));
                Control control = null;
                try {
                    Object object = ScannerRepository.instance().lookup(n);
                    if (object == null) {
                        throw new NoSuchIdException();
                    }
                    if (!(object instanceof MonitoringTaskAccess)) {
                        throw new org.threegppsa5.PerformanceIRPSystem.InvalidPerformanceMonitoringTypeException();
                    }
                    if (object instanceof MonitoringTask) {
                        control = TransactionHelper.create();
                        try {
                            MonitoringTaskMgr.instance().deleteMonitoringTask((MonitoringTask)object, control.getCoordinator());
                            control.getTerminator().commit();
                            break block13;
                        }
                        catch (InactiveTransactionException inactiveTransactionException) {
                            MessageLog.traceError(this.getClass(), (String)"Processing failure due to inactive transaction.", (Throwable)inactiveTransactionException);
                            throw new ProcessingErrorException(inactiveTransactionException.toString());
                        }
                        catch (TransactionRolledBackException transactionRolledBackException) {
                            MessageLog.traceError(this.getClass(), (String)"Processing failure due to transaction rollback.", (Throwable)transactionRolledBackException);
                            throw new ProcessingErrorException(transactionRolledBackException.toString());
                        }
                    }
                    try {
                        ((MonitoringTaskAccess)object).delete();
                    }
                    catch (InvalidPerformanceMonitoringTypeException invalidPerformanceMonitoringTypeException) {
                        throw new org.threegppsa5.PerformanceIRPSystem.InvalidPerformanceMonitoringTypeException();
                    }
                }
                catch (RuntimeException runtimeException) {
                    if (control != null) {
                        TransactionHelper.rollback(control);
                    }
                    MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)runtimeException);
                    throw new ProcessingErrorException(runtimeException.toString());
                }
                catch (Error error) {
                    if (control != null) {
                        TransactionHelper.rollback(control);
                    }
                    MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)error);
                    throw new ProcessingErrorException(error.toString());
                }
            }
            return Signal.OK;
        }

        public Signal suspend_performance_monitoring(int[] nArray, PerformanceMonitoringIdListHolder performanceMonitoringIdListHolder) throws OptionalOperationNotSupportedException, ProcessingErrorException, NoSuchIdException, InvalidParameterException {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append(nArray[i]);
                if (i == nArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            MessageLog.trace((int)8, this.getClass(), (String)("suspend request (" + stringBuffer.toString() + ")"));
            Signal signal = Signal.OK;
            LinkedList<Integer> linkedList = new LinkedList<Integer>();
            int[] nArray2 = new int[]{};
            performanceMonitoringIdListHolder.value = new int[0];
            Control control = null;
            try {
                int n;
                for (n = 0; n < nArray.length; ++n) {
                    int n2 = nArray[n];
                    Object object = ScannerRepository.instance().lookup(n2);
                    if (object == null) {
                        linkedList.add(new Integer(n2));
                        continue;
                    }
                    if (object instanceof ScannerAccess) {
                        try {
                            ((ScannerAccess)object).setScannerState(PerformanceIRPConstDefs.PerformanceMonitoringState.SUSPENDED);
                        }
                        catch (FailedException failedException) {
                            linkedList.add(new Integer(n2));
                            MessageLog.info(this.getClass(), (String)("Suspend failed - FailedException thrown by ScannerAccess (" + n2 + ")"));
                        }
                        continue;
                    }
                    if (!(object instanceof MonitoringTaskAccess)) continue;
                    if (object instanceof MonitoringTask) {
                        control = TransactionHelper.create();
                        try {
                            ((MonitoringTask)object).setMonitoringState(PerformanceMonitoringState.SUSPENDED, control.getCoordinator());
                            control.getTerminator().commit();
                            continue;
                        }
                        catch (OverloadException overloadException) {
                            linkedList.add(new Integer(n2));
                            MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)overloadException);
                            TransactionHelper.rollback(control);
                            continue;
                        }
                        catch (GranularityAndAttributeActivationException granularityAndAttributeActivationException) {
                            linkedList.add(new Integer(n2));
                            MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)granularityAndAttributeActivationException);
                            TransactionHelper.rollback(control);
                            continue;
                        }
                        catch (InactiveTransactionException inactiveTransactionException) {
                            MessageLog.traceError(this.getClass(), (String)("Processing failure due to inactive transaction. Monitoring id = " + n2), (Throwable)inactiveTransactionException);
                            throw new ProcessingErrorException(inactiveTransactionException.toString());
                        }
                        catch (TransactionRolledBackException transactionRolledBackException) {
                            MessageLog.traceError(this.getClass(), (String)("Processing failure due to inactive transaction. Monitoring id = " + n2), (Throwable)transactionRolledBackException);
                            throw new ProcessingErrorException(transactionRolledBackException.toString());
                        }
                        finally {
                            control = null;
                        }
                    }
                    try {
                        ((MonitoringTaskAccess)object).setState(PerformanceMonitoringState.SUSPENDED);
                        continue;
                    }
                    catch (OverloadException overloadException) {
                        linkedList.add(new Integer(n2));
                        MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)overloadException);
                        continue;
                    }
                    catch (OperationFailedException operationFailedException) {
                        linkedList.add(new Integer(n2));
                        MessageLog.info(this.getClass(), (String)("Suspend failed - OperationFailedException thrown by MonitoringTaskAccess (" + n2 + "). Reason: " + operationFailedException.getMessage()));
                    }
                }
                if (linkedList.size() == nArray.length) {
                    throw new NoSuchIdException();
                }
                if (linkedList.size() != 0) {
                    nArray2 = new int[linkedList.size()];
                    for (n = 0; n < linkedList.size(); ++n) {
                        nArray2[n] = (Integer)linkedList.get(n);
                    }
                    performanceMonitoringIdListHolder.value = nArray2;
                    signal = Signal.PartialFailure;
                }
            }
            catch (RuntimeException runtimeException) {
                if (control != null) {
                    TransactionHelper.rollback(control);
                }
                MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)runtimeException);
                throw new ProcessingErrorException(runtimeException.toString());
            }
            catch (Error error) {
                if (control != null) {
                    TransactionHelper.rollback(control);
                }
                MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)error);
                throw new ProcessingErrorException(error.toString());
            }
            return signal;
        }

        public Signal resume_performance_monitoring(int[] nArray, PerformanceMonitoringIdListHolder performanceMonitoringIdListHolder, PerformanceMonitoringIdListHolder performanceMonitoringIdListHolder2) throws OptionalOperationNotSupportedException, ProcessingErrorException, org.threegppsa5.PerformanceIRPSystem.NumberOfCountersExceededException, org.threegppsa5.PerformanceIRPSystem.NumberOfMonitorsExceededException, InvalidParameterException, NoSuchIdException, org.threegppsa5.PerformanceIRPSystem.OverloadException, org.threegppsa5.PerformanceIRPSystem.GranularityAndAttributeActivationException {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append(nArray[i]);
                if (i == nArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            MessageLog.trace((int)8, this.getClass(), (String)("resume request (" + stringBuffer.toString() + ")"));
            Signal signal = Signal.OK;
            LinkedList<Integer> linkedList = new LinkedList<Integer>();
            LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
            int[] nArray2 = new int[]{};
            int[] nArray3 = new int[]{};
            performanceMonitoringIdListHolder.value = new int[0];
            performanceMonitoringIdListHolder2.value = new int[0];
            Control control = null;
            try {
                int n;
                for (n = 0; n < nArray.length; ++n) {
                    int n2 = nArray[n];
                    Object object = ScannerRepository.instance().lookup(n2);
                    if (object == null) {
                        linkedList.add(new Integer(n2));
                        continue;
                    }
                    if (object instanceof ScannerAccess) {
                        try {
                            ((ScannerAccess)object).setScannerState(PerformanceIRPConstDefs.PerformanceMonitoringState.ACTIVE);
                        }
                        catch (FailedException failedException) {
                            linkedList2.add(new Integer(n2));
                            MessageLog.info(this.getClass(), (String)("Resume failed - FailedException thrown by ScannerAccess (" + n2 + ")"));
                        }
                        continue;
                    }
                    if (!(object instanceof MonitoringTaskAccess)) continue;
                    if (object instanceof MonitoringTask) {
                        control = TransactionHelper.create();
                        try {
                            MonitoringTaskMgr.instance().resumeMonitoringTask((MonitoringTask)object, control.getCoordinator());
                            control.getTerminator().commit();
                            continue;
                        }
                        catch (NumberOfCountersExceededException numberOfCountersExceededException) {
                            linkedList2.add(new Integer(n2));
                            MessageLog.info(this.getClass(), (String)("Resume rejected due to number of counters exceeded exception for performance monitoring, id = " + n2));
                            continue;
                        }
                        catch (NumberOfMonitorsExceededException numberOfMonitorsExceededException) {
                            linkedList2.add(new Integer(n2));
                            MessageLog.info(this.getClass(), (String)("Resume rejected due to number of monitors exceeded exception for performance monitoring, id = " + n2));
                            continue;
                        }
                        catch (OverloadException overloadException) {
                            linkedList2.add(new Integer(n2));
                            MessageLog.info(this.getClass(), (String)("Resume rejected due to overload exception for performance monitoring, id = " + n2));
                            TransactionHelper.rollback(control);
                            continue;
                        }
                        catch (GranularityAndAttributeActivationException granularityAndAttributeActivationException) {
                            linkedList2.add(new Integer(n2));
                            MessageLog.info(this.getClass(), (String)("Resume rejected due to granularity and attribute activation exception for performance monitoring, id = " + n2));
                            TransactionHelper.rollback(control);
                            continue;
                        }
                        catch (InactiveTransactionException inactiveTransactionException) {
                            MessageLog.traceError(this.getClass(), (String)("Processing failure due to inactive transaction. Monitoring id = " + n2), (Throwable)inactiveTransactionException);
                            throw new ProcessingErrorException(inactiveTransactionException.toString());
                        }
                        catch (TransactionRolledBackException transactionRolledBackException) {
                            MessageLog.traceError(this.getClass(), (String)("Processing failure due to inactive transaction. Monitoring id = " + n2), (Throwable)transactionRolledBackException);
                            throw new ProcessingErrorException(transactionRolledBackException.toString());
                        }
                        catch (SystemSuspendedException systemSuspendedException) {
                            MessageLog.info(this.getClass(), (String)"Resume rejected due to that all monitorings are currently system suspended.");
                            throw new ProcessingErrorException("Resume rejected due to that all monitorings are currently system suspended.");
                        }
                        finally {
                            control = null;
                        }
                    }
                    try {
                        ((MonitoringTaskAccess)object).setState(PerformanceMonitoringState.ACTIVE);
                        continue;
                    }
                    catch (OverloadException overloadException) {
                        linkedList2.add(new Integer(n2));
                        MessageLog.info(this.getClass(), (String)("Resume failed - OverloadException thrown by MonitoringTaskAccess (" + n2 + ")"));
                        continue;
                    }
                    catch (OperationFailedException operationFailedException) {
                        linkedList2.add(new Integer(n2));
                        MessageLog.info(this.getClass(), (String)("Suspend failed - OperationFailedException thrown by MonitoringTaskAccess (" + n2 + "). Reason: " + operationFailedException.getMessage()));
                    }
                }
                if (linkedList.size() == nArray.length) {
                    throw new NoSuchIdException();
                }
                if (linkedList2.size() == nArray.length) {
                    throw new org.threegppsa5.PerformanceIRPSystem.OverloadException();
                }
                if (linkedList.size() != 0 || linkedList2.size() != 0) {
                    nArray3 = new int[linkedList2.size()];
                    for (n = 0; n < linkedList2.size(); ++n) {
                        nArray3[n] = (Integer)linkedList2.get(n);
                    }
                    performanceMonitoringIdListHolder2.value = nArray3;
                    nArray2 = new int[linkedList.size()];
                    for (n = 0; n < linkedList.size(); ++n) {
                        nArray2[n] = (Integer)linkedList.get(n);
                    }
                    performanceMonitoringIdListHolder.value = nArray2;
                    signal = Signal.PartialFailure;
                }
            }
            catch (RuntimeException runtimeException) {
                if (control != null) {
                    TransactionHelper.rollback(control);
                }
                MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)runtimeException);
                throw new ProcessingErrorException(runtimeException.toString());
            }
            catch (Error error) {
                if (control != null) {
                    TransactionHelper.rollback(control);
                }
                MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)error);
                throw new ProcessingErrorException(error.toString());
            }
            return signal;
        }

        public Signal get_performance_monitoring_report(int n, PerformanceMonitoringReportHolder performanceMonitoringReportHolder) throws OptionalOperationNotSupportedException, ProcessingErrorException, NoSuchIdException, InvalidParameterException {
            throw new OptionalOperationNotSupportedException();
        }

        public Signal filter_performance_monitoring_report(int[] nArray, PerformanceIRPConstDefs.RecordingType recordingType, PerformanceIRPConstDefs.ObservationObject observationObject, PerformanceIRPConstDefs.ObservationObject[] observationObjectArray, PerformanceIRPConstDefs.Filter filter, int[] nArray2, int n, PerformanceMonitoringIdListHolder performanceMonitoringIdListHolder) throws OptionalOperationNotSupportedException, OptionalParameterNotSupportedException, org.threegppsa5.PerformanceIRPSystem.InvalidPerformanceMonitoringTypeException, ProcessingErrorException, InvalidParameterException, org.threegppsa5.PerformanceIRPSystem.InvalidObservationObjectListException, org.threegppsa5.PerformanceIRPSystem.InvalidFilterException, org.threegppsa5.PerformanceIRPSystem.InvalidTriggeringObjectException {
            block13: {
                performanceMonitoringIdListHolder.value = new int[0];
                if (nArray.length > 1 || nArray.length == 0) {
                    throw new InvalidParameterException("id_list out of range");
                }
                try {
                    Object object = ScannerRepository.instance().lookup(nArray[0]);
                    if (object == null) {
                        throw new InvalidParameterException("id does not exist");
                    }
                    if (object instanceof ScannerAccess) {
                        try {
                            ((ScannerAccess)object).setFilter(recordingType, observationObject, observationObjectArray, filter, nArray2, n);
                            break block13;
                        }
                        catch (FailedException failedException) {
                            throw new InvalidParameterException(failedException.toString());
                        }
                    }
                    if (!(object instanceof MonitoringTaskAccess)) break block13;
                    try {
                        ((MonitoringTaskAccess)object).setFilter(this.convertToFilterInfo(recordingType, observationObject, observationObjectArray, filter, nArray2, n));
                    }
                    catch (InvalidPerformanceMonitoringTypeException invalidPerformanceMonitoringTypeException) {
                        throw new org.threegppsa5.PerformanceIRPSystem.InvalidPerformanceMonitoringTypeException();
                    }
                    catch (InvalidObservationObjectListException invalidObservationObjectListException) {
                        throw new org.threegppsa5.PerformanceIRPSystem.InvalidObservationObjectListException(this.convertFromPmsObject(invalidObservationObjectListException.getObservationObjectList()));
                    }
                    catch (InvalidFilterException invalidFilterException) {
                        throw new org.threegppsa5.PerformanceIRPSystem.InvalidFilterException();
                    }
                    catch (InvalidTriggeringObjectException invalidTriggeringObjectException) {
                        ObservationObject observationObject2 = invalidTriggeringObjectException.getObservationObject();
                        throw new org.threegppsa5.PerformanceIRPSystem.InvalidTriggeringObjectException(new PerformanceIRPConstDefs.ObservationObject(observationObject2.instance_list, observationObject2.instance_attribute_list));
                    }
                }
                catch (RuntimeException runtimeException) {
                    MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)runtimeException);
                    throw new ProcessingErrorException(runtimeException.toString());
                }
                catch (Error error) {
                    MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)error);
                    throw new ProcessingErrorException(error.toString());
                }
            }
            return Signal.OK;
        }

        public Signal filter_performance_monitoring_report_ext(int[] nArray, PerformanceIRPConstDefs.RecordingType recordingType, PerformanceIRPConstDefs.ObservationObject observationObject, PerformanceIRPConstDefs.ObservationObject[] observationObjectArray, PerformanceIRPConstDefs.Filter filter, int[] nArray2, int n, PmServiceExtended.OutputMode outputMode, PmServiceExtended.DestinationAddress destinationAddress, String string, PerformanceMonitoringIdListHolder performanceMonitoringIdListHolder) throws InvalidParameterException, org.threegppsa5.PerformanceIRPSystem.InvalidPerformanceMonitoringTypeException, org.threegppsa5.PerformanceIRPSystem.InvalidTriggeringObjectException, org.threegppsa5.PerformanceIRPSystem.InvalidFilterException, OptionalOperationNotSupportedException, org.threegppsa5.PerformanceIRPSystem.InvalidObservationObjectListException, ProcessingErrorException, OptionalParameterNotSupportedException {
            block11: {
                performanceMonitoringIdListHolder.value = new int[0];
                if (nArray.length > 1 || nArray.length == 0) {
                    throw new InvalidParameterException("id_list out of range");
                }
                try {
                    Object object = ScannerRepository.instance().lookup(nArray[0]);
                    if (object == null) {
                        throw new InvalidParameterException("id does not exist");
                    }
                    if (object instanceof MonitoringTaskAccess) {
                        try {
                            ((MonitoringTaskAccess)object).setFilter(this.convertToFilterInfo(recordingType, observationObject, observationObjectArray, filter, nArray2, n, outputMode, destinationAddress, string));
                            break block11;
                        }
                        catch (InvalidPerformanceMonitoringTypeException invalidPerformanceMonitoringTypeException) {
                            throw new org.threegppsa5.PerformanceIRPSystem.InvalidPerformanceMonitoringTypeException();
                        }
                        catch (InvalidObservationObjectListException invalidObservationObjectListException) {
                            throw new org.threegppsa5.PerformanceIRPSystem.InvalidObservationObjectListException(this.convertFromPmsObject(invalidObservationObjectListException.getObservationObjectList()));
                        }
                        catch (InvalidFilterException invalidFilterException) {
                            throw new org.threegppsa5.PerformanceIRPSystem.InvalidFilterException();
                        }
                        catch (InvalidTriggeringObjectException invalidTriggeringObjectException) {
                            ObservationObject observationObject2 = invalidTriggeringObjectException.getObservationObject();
                            throw new org.threegppsa5.PerformanceIRPSystem.InvalidTriggeringObjectException(new PerformanceIRPConstDefs.ObservationObject(observationObject2.instance_list, observationObject2.instance_attribute_list));
                        }
                    }
                    throw new org.threegppsa5.PerformanceIRPSystem.InvalidPerformanceMonitoringTypeException();
                }
                catch (RuntimeException runtimeException) {
                    MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)runtimeException);
                    throw new ProcessingErrorException(runtimeException.toString());
                }
                catch (Error error) {
                    MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)error);
                    throw new ProcessingErrorException(error.toString());
                }
            }
            return Signal.OK;
        }

        public Signal lookup_filter_performance_monitoring_report(int n, RecordingTypeHolder recordingTypeHolder, ObservationObjectHolder observationObjectHolder, ObservationObjectListHolder observationObjectListHolder, FilterHolder filterHolder, TimeWindowHolder timeWindowHolder, IntHolder intHolder) throws OptionalOperationNotSupportedException, NoSuchIdException, org.threegppsa5.PerformanceIRPSystem.InvalidPerformanceMonitoringTypeException, ProcessingErrorException, InvalidParameterException {
            block10: {
                try {
                    Object object = ScannerRepository.instance().lookup(n);
                    if (object == null) {
                        throw new NoSuchIdException();
                    }
                    if (object instanceof ScannerAccess) {
                        try {
                            ((ScannerAccess)object).lookupFilter(recordingTypeHolder, observationObjectHolder, observationObjectListHolder, filterHolder, timeWindowHolder, intHolder);
                            break block10;
                        }
                        catch (FailedException failedException) {
                            throw new InvalidParameterException(failedException.toString());
                        }
                    }
                    if (!(object instanceof MonitoringTaskAccess)) break block10;
                    try {
                        FilterInfo filterInfo = ((MonitoringTaskAccess)object).lookupFilter();
                        if (filterInfo == null) {
                            throw new ProcessingErrorException("filter is null");
                        }
                        recordingTypeHolder.value = this.convertFromPmsRecordingType(filterInfo.getRecordingType());
                        observationObjectHolder.value = new PerformanceIRPConstDefs.ObservationObject(filterInfo.getTriggeringObject().instance_list, filterInfo.getTriggeringObject().instance_attribute_list);
                        observationObjectListHolder.value = this.convertFromPmsObject(filterInfo.getObservationObjectList());
                        filterHolder.value = new PerformanceIRPConstDefs.Filter(filterInfo.getFilter().attribute_name, filterInfo.getFilter().attribute_value);
                        timeWindowHolder.value = filterInfo.getTimeWindow();
                        intHolder.value = filterInfo.getSamplingRate();
                    }
                    catch (InvalidPerformanceMonitoringTypeException invalidPerformanceMonitoringTypeException) {
                        throw new org.threegppsa5.PerformanceIRPSystem.InvalidPerformanceMonitoringTypeException();
                    }
                }
                catch (RuntimeException runtimeException) {
                    MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)runtimeException);
                    throw new ProcessingErrorException(runtimeException.toString());
                }
                catch (Error error) {
                    MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)error);
                    throw new ProcessingErrorException(error.toString());
                }
            }
            return Signal.OK;
        }

        public Signal lookup_filter_performance_monitoring_report_ext(int n, RecordingTypeHolder recordingTypeHolder, ObservationObjectHolder observationObjectHolder, ObservationObjectListHolder observationObjectListHolder, FilterHolder filterHolder, TimeWindowHolder timeWindowHolder, IntHolder intHolder, OutputModeHolder outputModeHolder, DestinationAddressHolder destinationAddressHolder, StringHolder stringHolder) throws InvalidParameterException, org.threegppsa5.PerformanceIRPSystem.InvalidPerformanceMonitoringTypeException, OptionalOperationNotSupportedException, ProcessingErrorException, NoSuchIdException {
            block8: {
                try {
                    Object object = ScannerRepository.instance().lookup(n);
                    if (object == null) {
                        throw new NoSuchIdException();
                    }
                    if (object instanceof MonitoringTaskAccess) {
                        try {
                            FilterInfo filterInfo = ((MonitoringTaskAccess)object).lookupFilter();
                            if (filterInfo == null) {
                                throw new ProcessingErrorException("filter is null");
                            }
                            recordingTypeHolder.value = this.convertFromPmsRecordingType(filterInfo.getRecordingType());
                            observationObjectHolder.value = new PerformanceIRPConstDefs.ObservationObject(filterInfo.getTriggeringObject().instance_list, filterInfo.getTriggeringObject().instance_attribute_list);
                            observationObjectListHolder.value = this.convertFromPmsObject(filterInfo.getObservationObjectList());
                            filterHolder.value = new PerformanceIRPConstDefs.Filter(filterInfo.getFilter().attribute_name, filterInfo.getFilter().attribute_value);
                            timeWindowHolder.value = filterInfo.getTimeWindow();
                            intHolder.value = filterInfo.getSamplingRate();
                            outputModeHolder.value = this.convertFromPmsOutputMode(filterInfo.getOutputMode());
                            destinationAddressHolder.value = this.convertFromPmsDestinationAddress(filterInfo.getDestinationAddress());
                            stringHolder.value = filterInfo.getTraceReference();
                            break block8;
                        }
                        catch (InvalidPerformanceMonitoringTypeException invalidPerformanceMonitoringTypeException) {
                            throw new org.threegppsa5.PerformanceIRPSystem.InvalidPerformanceMonitoringTypeException();
                        }
                    }
                    throw new org.threegppsa5.PerformanceIRPSystem.InvalidPerformanceMonitoringTypeException();
                }
                catch (RuntimeException runtimeException) {
                    MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)runtimeException);
                    throw new ProcessingErrorException(runtimeException.toString());
                }
                catch (Error error) {
                    MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)error);
                    throw new ProcessingErrorException(error.toString());
                }
            }
            return Signal.OK;
        }

        private Schedule createEmptySchedule() {
            if (emptySchedule == null) {
                emptySchedule = new Schedule();
                int[] nArray = new int[]{0};
                emptySchedule.start_time = new UtcT();
                emptySchedule.end_time = new UtcT();
                emptySchedule.repeated_intervals = nArray;
            }
            return emptySchedule;
        }

        private PerformanceMonitoring[] convertPerformanceMonitoring(LinkedList linkedList) {
            PerformanceMonitoring[] performanceMonitoringArray = new PerformanceMonitoring[linkedList.size()];
            for (int i = 0; i < linkedList.size(); ++i) {
                Object e = linkedList.get(i);
                if (e instanceof ScannerInfo) {
                    performanceMonitoringArray[i] = new PerformanceMonitoring();
                    performanceMonitoringArray[i].performance_monitoring_id = ((ScannerInfo)e).getPmId().intValue();
                    performanceMonitoringArray[i].measurement_name = ((ScannerInfo)e).getMeasurementName();
                    performanceMonitoringArray[i].state = ((ScannerInfo)e).getScannerState();
                    continue;
                }
                if (!(e instanceof MonitoringTaskInfo)) continue;
                performanceMonitoringArray[i] = new PerformanceMonitoring();
                performanceMonitoringArray[i].performance_monitoring_id = ((MonitoringTaskInfo)e).getId().intValue();
                performanceMonitoringArray[i].measurement_name = ((MonitoringTaskInfo)e).getName();
                performanceMonitoringArray[i].state = this.convertFromPmsState(((MonitoringTaskInfo)e).getState());
            }
            return performanceMonitoringArray;
        }

        private boolean classHasInstances(ObservationClass[] observationClassArray) {
            boolean bl = true;
            for (int i = 0; i < observationClassArray.length; ++i) {
                String string = observationClassArray[i].object_class_name;
                if (MoRepository.instance().lookupType(string) != null) continue;
                bl = false;
            }
            return bl;
        }

        private void checkObservationClass(PerformanceIRPConstDefs.ObservationClass[] observationClassArray) throws InvalidObservationClassException {
            LinkedList<PerformanceIRPConstDefs.ObservationClass> linkedList = new LinkedList<PerformanceIRPConstDefs.ObservationClass>();
            for (int i = 0; i < observationClassArray.length; ++i) {
                String string = observationClassArray[i].object_class_name;
                String[] stringArray = this.checkAttributes(string, observationClassArray[i].class_attribute_list);
                if (stringArray.length == 0) continue;
                linkedList.add(new PerformanceIRPConstDefs.ObservationClass(string, stringArray));
            }
            this.createInvalidObservationClassException(linkedList);
        }

        private void checkRegisteredObservationClasses(PerformanceIRPConstDefs.ObservationClass[] observationClassArray) throws InvalidObservationClassException {
            LinkedList<PerformanceIRPConstDefs.ObservationClass> linkedList = new LinkedList<PerformanceIRPConstDefs.ObservationClass>();
            for (int i = 0; i < observationClassArray.length; ++i) {
                String string = observationClassArray[i].object_class_name;
                if (MoFactoryMgr.instance().lookup(string) != null) continue;
                linkedList.add(observationClassArray[i]);
            }
            this.createInvalidObservationClassException(linkedList);
        }

        private PerformanceIRPConstDefs.ObservationClass[] getRegisteredObservationClasses(PerformanceIRPConstDefs.ObservationClass[] observationClassArray) {
            LinkedList<PerformanceIRPConstDefs.ObservationClass> linkedList = new LinkedList<PerformanceIRPConstDefs.ObservationClass>();
            for (int i = 0; i < observationClassArray.length; ++i) {
                String string = observationClassArray[i].object_class_name;
                if (MoFactoryMgr.instance().lookup(string) == null) {
                    MessageLog.info(this.getClass(), (String)("MO " + string + " is not registered in the MO factory and will be excluded from the Performance Monitoring."));
                    continue;
                }
                linkedList.add(observationClassArray[i]);
            }
            if (linkedList.size() != observationClassArray.length) {
                PerformanceIRPConstDefs.ObservationClass[] observationClassArray2 = new PerformanceIRPConstDefs.ObservationClass[linkedList.size()];
                for (int i = 0; i < linkedList.size(); ++i) {
                    observationClassArray2[i] = (PerformanceIRPConstDefs.ObservationClass)linkedList.get(i);
                }
                return observationClassArray2;
            }
            return observationClassArray;
        }

        private void createInvalidObservationClassException(LinkedList linkedList) throws InvalidObservationClassException {
            if (linkedList.size() > 0) {
                PerformanceIRPConstDefs.ObservationClass[] observationClassArray = new PerformanceIRPConstDefs.ObservationClass[linkedList.size()];
                for (int i = 0; i < linkedList.size(); ++i) {
                    observationClassArray[i] = (PerformanceIRPConstDefs.ObservationClass)linkedList.get(i);
                }
                throw new InvalidObservationClassException(observationClassArray);
            }
        }

        private void checkObservationObject(PerformanceIRPConstDefs.ObservationObject[] observationObjectArray) throws org.threegppsa5.PerformanceIRPSystem.InvalidObservationObjectListException {
            LinkedList<PerformanceIRPConstDefs.ObservationObject> linkedList = new LinkedList<PerformanceIRPConstDefs.ObservationObject>();
            for (int i = 0; i < observationObjectArray.length; ++i) {
                String[] stringArray = observationObjectArray[i].instance_attribute_list;
                String[] stringArray2 = observationObjectArray[i].instance_list;
                if (stringArray2 == null || stringArray2.length == 0) {
                    linkedList.add(new PerformanceIRPConstDefs.ObservationObject(emptyArrayValue, emptyArrayValue));
                }
                for (int j = 0; j < observationObjectArray[i].instance_list.length; ++j) {
                    String string = observationObjectArray[i].instance_list[j];
                    ManagedObject managedObject = MoRepository.instance().lookup(string);
                    if (managedObject == null) {
                        linkedList.add(observationObjectArray[i]);
                        continue;
                    }
                    String[] stringArray3 = this.checkAttributes(managedObject.getType(), stringArray);
                    if (stringArray3.length == 0) continue;
                    linkedList.add(new PerformanceIRPConstDefs.ObservationObject(observationObjectArray[i].instance_list, stringArray3));
                }
            }
            if (linkedList.size() > 0) {
                PerformanceIRPConstDefs.ObservationObject[] observationObjectArray2 = new PerformanceIRPConstDefs.ObservationObject[linkedList.size()];
                for (int i = 0; i < linkedList.size(); ++i) {
                    observationObjectArray2[i] = (PerformanceIRPConstDefs.ObservationObject)linkedList.get(i);
                }
                throw new org.threegppsa5.PerformanceIRPSystem.InvalidObservationObjectListException(observationObjectArray2);
            }
        }

        private void checkMeasurementName(String string) throws InvalidParameterException {
            MessageLog.trace((int)8, this.getClass(), (String)("Checking if there exists another PM with name " + string));
            LinkedList linkedList = this.getAllScanners();
            PerformanceMonitoring[] performanceMonitoringArray = this.convertPerformanceMonitoring(linkedList);
            for (int i = 0; i < performanceMonitoringArray.length; ++i) {
                if (!performanceMonitoringArray[i].measurement_name.equals(string)) continue;
                MessageLog.trace((int)8, this.getClass(), (String)"Existing PM with same found. Rejecting request.");
                throw new InvalidParameterException("There already exists a monitoring with the name " + string);
            }
            MessageLog.trace((int)8, this.getClass(), (String)("No another PM with name " + string + " found."));
        }

        private String[] checkAttributes(String string, String[] stringArray) {
            if (stringArray == null || stringArray.length == 0) {
                return emptyArrayValue;
            }
            return ObjectRepository.instance().checkAttributes(string, stringArray);
        }

        private ObservationClass[] convertToPmsClass(PerformanceIRPConstDefs.ObservationClass[] observationClassArray) {
            ObservationClass[] observationClassArray2 = new ObservationClass[observationClassArray.length];
            for (int i = 0; i < observationClassArray.length; ++i) {
                observationClassArray2[i] = new ObservationClass(observationClassArray[i].object_class_name, observationClassArray[i].class_attribute_list);
            }
            return observationClassArray2;
        }

        private ObservationObject[] convertToPmsObject(PerformanceIRPConstDefs.ObservationObject[] observationObjectArray) {
            ObservationObject[] observationObjectArray2 = new ObservationObject[observationObjectArray.length];
            for (int i = 0; i < observationObjectArray.length; ++i) {
                observationObjectArray2[i] = new ObservationObject(observationObjectArray[i].instance_list, observationObjectArray[i].instance_attribute_list);
            }
            return observationObjectArray2;
        }

        private PerformanceMonitoringState convertToPmsState(PerformanceIRPConstDefs.PerformanceMonitoringState performanceMonitoringState) {
            if (performanceMonitoringState.value() == 0) {
                return PerformanceMonitoringState.ACTIVE;
            }
            return PerformanceMonitoringState.SUSPENDED;
        }

        private PerformanceIRPConstDefs.ObservationClass[] convertFromPmsClass(ObservationClass[] observationClassArray) {
            PerformanceIRPConstDefs.ObservationClass[] observationClassArray2 = null;
            if (observationClassArray != null) {
                observationClassArray2 = new PerformanceIRPConstDefs.ObservationClass[observationClassArray.length];
                for (int i = 0; i < observationClassArray.length; ++i) {
                    observationClassArray2[i] = new PerformanceIRPConstDefs.ObservationClass(observationClassArray[i].object_class_name, observationClassArray[i].class_attribute_list);
                }
            } else {
                observationClassArray2 = new PerformanceIRPConstDefs.ObservationClass[]{};
            }
            return observationClassArray2;
        }

        private PerformanceIRPConstDefs.ObservationObject[] convertFromPmsObject(ObservationObject[] observationObjectArray) {
            PerformanceIRPConstDefs.ObservationObject[] observationObjectArray2 = null;
            if (observationObjectArray != null) {
                observationObjectArray2 = new PerformanceIRPConstDefs.ObservationObject[observationObjectArray.length];
                for (int i = 0; i < observationObjectArray.length; ++i) {
                    observationObjectArray2[i] = new PerformanceIRPConstDefs.ObservationObject(observationObjectArray[i].instance_list, observationObjectArray[i].instance_attribute_list);
                }
            } else {
                observationObjectArray2 = new PerformanceIRPConstDefs.ObservationObject[]{};
            }
            return observationObjectArray2;
        }

        private PerformanceIRPConstDefs.PerformanceMonitoringState convertFromPmsState(PerformanceMonitoringState performanceMonitoringState) {
            if (performanceMonitoringState.value() == 0) {
                return PerformanceIRPConstDefs.PerformanceMonitoringState.ACTIVE;
            }
            return PerformanceIRPConstDefs.PerformanceMonitoringState.SUSPENDED;
        }

        private PerformanceIRPConstDefs.RecordingType convertFromPmsRecordingType(RecordingType recordingType) {
            if (recordingType.value() == 0) {
                return PerformanceIRPConstDefs.RecordingType.EVENT_DATA;
            }
            if (recordingType.value() == 1) {
                return PerformanceIRPConstDefs.RecordingType.MEASUREMENT_DATA;
            }
            return PerformanceIRPConstDefs.RecordingType.EVENT_AND_MESUREMENT_DATA;
        }

        private PmServiceExtended.OutputMode convertFromPmsOutputMode(OutputMode outputMode) {
            if (outputMode.value() == 0) {
                return PmServiceExtended.OutputMode.FILE;
            }
            if (outputMode.value() == 1) {
                return PmServiceExtended.OutputMode.STREAMING;
            }
            return PmServiceExtended.OutputMode.FILE_AND_STREAMING;
        }

        private PmServiceExtended.DestinationAddress convertFromPmsDestinationAddress(DestinationAddress destinationAddress) {
            return new PmServiceExtended.DestinationAddress(destinationAddress.ip_address, destinationAddress.port);
        }

        private FilterInfo convertToFilterInfo(PerformanceIRPConstDefs.RecordingType recordingType, PerformanceIRPConstDefs.ObservationObject observationObject, PerformanceIRPConstDefs.ObservationObject[] observationObjectArray, PerformanceIRPConstDefs.Filter filter, int[] nArray, int n) {
            return new FilterInfo(new RecordingType(recordingType.value()), new ObservationObject(observationObject.instance_list, observationObject.instance_attribute_list), this.convertToPmsObject(observationObjectArray), new Filter(filter.attribute_name, filter.attribute_value), nArray, n);
        }

        private FilterInfo convertToFilterInfo(PerformanceIRPConstDefs.RecordingType recordingType, PerformanceIRPConstDefs.ObservationObject observationObject, PerformanceIRPConstDefs.ObservationObject[] observationObjectArray, PerformanceIRPConstDefs.Filter filter, int[] nArray, int n, PmServiceExtended.OutputMode outputMode, PmServiceExtended.DestinationAddress destinationAddress, String string) {
            return new FilterInfo(new RecordingType(recordingType.value()), new ObservationObject(observationObject.instance_list, observationObject.instance_attribute_list), this.convertToPmsObject(observationObjectArray), new Filter(filter.attribute_name, filter.attribute_value), nArray, n, new OutputMode(outputMode.value()), new DestinationAddress(destinationAddress.ip_address, destinationAddress.port), string);
        }
    }
}

