/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import java.io.File;
import java.io.FilenameFilter;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.PmDataConsumer;
import se.ericsson.cello.pms.generic.PmsContext;
import se.ericsson.cello.support.debug.MessageLog;

public class DiskCleaner {
    private static final int TRACE_GROUP = 8;
    private static DiskCleaner instance;
    private PmsContext pmsContext;

    public static DiskCleaner instance() {
        if (instance == null) {
            MessageLog.traceError((Class)DiskCleaner.class, (String)"no instance of DiskCleaner exists");
        }
        return instance;
    }

    public void clean() {
        this.clean(this.getMaxNoOfPmFiles() - this.getNoOfReportingFiles(), this.getPerformanceDataPath());
    }

    void clean(int n, String string) {
        File file = new File(string);
        if (!file.isDirectory()) {
            return;
        }
        PMFilesFilter pMFilesFilter = new PMFilesFilter();
        String[] stringArray = this.sort(file.list(pMFilesFilter));
        if (stringArray.length < n) {
            return;
        }
        int n2 = stringArray.length - n;
        for (int i = 0; i < n2; ++i) {
            File file2 = new File(string + stringArray[i]);
            if (!file2.exists()) continue;
            file2.delete();
        }
    }

    private String[] sort(String[] stringArray) {
        for (int i = 0; i < stringArray.length - 1; ++i) {
            for (int j = i + 1; j < stringArray.length; ++j) {
                if (stringArray[i].substring(1).compareTo(stringArray[j].substring(1)) <= 0) continue;
                String string = stringArray[i];
                stringArray[i] = stringArray[j];
                stringArray[j] = string;
            }
        }
        return stringArray;
    }

    private String getPerformanceDataPath() {
        return this.pmsContext.getPerformanceDataPath();
    }

    private int getMaxNoOfPmFiles() {
        return this.pmsContext.getMaxNoOfPmFiles();
    }

    private int getNoOfReportingFiles() {
        PmDataConsumer pmDataConsumer;
        PmDataConsumer pmDataConsumer2;
        int n = 0;
        int n2 = PmDataConsumer.calculateCurrentSeqNo();
        PmDataConsumer pmDataConsumer3 = (PmDataConsumer)PmDataConsumer.consumers.get(GranularityPeriod.MINUTES_5);
        if (pmDataConsumer3 != null && pmDataConsumer3.producers.size() > 0) {
            ++n;
        }
        if ((pmDataConsumer2 = (PmDataConsumer)PmDataConsumer.consumers.get(GranularityPeriod.MINUTES_15)) != null && pmDataConsumer2.producers.size() > 0 && (n2 == 3 || n2 == 6 || n2 == 9 || n2 == 12)) {
            ++n;
        }
        if ((pmDataConsumer = (PmDataConsumer)PmDataConsumer.consumers.get(GranularityPeriod.HOURS_1)) != null && pmDataConsumer.producers.size() > 0 && n2 == 12) {
            ++n;
        }
        return n;
    }

    protected void cleanTemporaryFiles() {
        this.cleanTemporaryFiles(this.getPerformanceDataPath());
    }

    private void cleanTemporaryFiles(String string) {
        File file = new File(string);
        if (!file.isDirectory()) {
            return;
        }
        TempFilesFilter tempFilesFilter = new TempFilesFilter();
        String[] stringArray = file.list(tempFilesFilter);
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(string + stringArray[i]);
            if (!file2.exists()) continue;
            MessageLog.trace((int)8, this.getClass(), (String)"Deleteing temporary PM file");
            file2.delete();
        }
    }

    DiskCleaner(PmsContext pmsContext) {
        this.pmsContext = pmsContext;
        instance = this;
    }

    class TempFilesFilter
    implements FilenameFilter {
        TempFilesFilter() {
        }

        public boolean accept(File file, String string) {
            return string.startsWith("tmp");
        }
    }

    class PMFilesFilter
    implements FilenameFilter {
        PMFilesFilter() {
        }

        public boolean accept(File file, String string) {
            return string.startsWith("A2") && string.endsWith(".xml") || string.startsWith("A2") && string.endsWith(".xml.gz") || string.startsWith("A1") && string.endsWith(".xml") || string.startsWith("A1") && string.endsWith(".xml.gz") || string.startsWith("C2") && string.endsWith(".xml") || string.startsWith("C2") && string.endsWith(".xml.gz") || string.startsWith("C1") && string.endsWith(".xml") || string.startsWith("C1") && string.endsWith(".xml.gz");
        }
    }
}

