/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import se.ericsson.cello.pms.generic.DiskCleaner;
import se.ericsson.cello.pms.generic.PmAttributeSettingListenerMgr;
import se.ericsson.cello.pms.generic.PmsContext;
import se.ericsson.cello.pms.ne.PmAttributeSetting;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;

class PmAttributeSettingImpl
implements PmAttributeSetting {
    private PmsContext pmsContext;
    private static final String TRACE_MSG_MONITORS = " is suspended due to re-configuration of max number of monitors.";
    private static final String TRACE_MSG_COUNTERS = " is Suspended due to re-configuration of max number of counters.";
    private static final String TRACE_MSG_THRESHOLD = " is Suspended due to re-configuration of Warning alarm threshold level.";
    private static final String TRACE_MSG_CEASING_LEVEL = " is Suspended due to re-configuration of warning alarm ceasing level.";
    private int myMaxNoOfFiles = -1;
    private int myMaxNoOfMonitors = -1;
    private String myPerformanceDataPath = null;
    private int myTransactionTimeout = -1;
    private int myMaxNoOfCounters = -1;
    private int myWarningAlarmThreshold = -1;
    private int myWarningAlarmCeasingLevel = -1;
    private int myMinorAlarmCeasingLevel = -1;
    private boolean isMaxNoOfCtrValueChanged = false;
    private boolean isAlarmThresholdChanged = false;
    private boolean isAlarmCeasingLevelChanged = false;
    private PmAttributeSettingListenerMgr pmAttributeSettingListenerMgr;

    PmAttributeSettingImpl(PmsContext pmsContext) {
        this.pmsContext = pmsContext;
        ServiceLocatorFacade.getRepository().addService(this, PmAttributeSetting.class, null);
        this.pmAttributeSettingListenerMgr = PmAttributeSettingListenerMgr.getInstance();
    }

    public void setMaxNoOfPmFiles(int n) {
        MessageLog.trace((int)8, this.getClass(), (String)("setMaxNoOfFiles: " + n));
        int n2 = this.myMaxNoOfFiles;
        this.myMaxNoOfFiles = n;
        if (n < n2 && this.myPerformanceDataPath != null) {
            DiskCleaner.instance().clean(n, this.myPerformanceDataPath);
        }
        this.pmAttributeSettingListenerMgr.setMaxNoOfPmFiles(n);
    }

    public int getMaxNoOfPmFiles() {
        if (this.myMaxNoOfFiles == -1) {
            MessageLog.traceError(this.getClass(), (String)"maxNoOfPmFiles not initialized");
        }
        return this.myMaxNoOfFiles;
    }

    public void setMaxNoOfMonitors(int n) {
        MessageLog.trace((int)8, this.getClass(), (String)("setMaxNoOfMonitors: " + n));
        int n2 = this.myMaxNoOfMonitors;
        this.myMaxNoOfMonitors = n;
        if (n < n2) {
            this.pmsContext.reloadMonitors(TRACE_MSG_MONITORS);
        }
    }

    public int getMaxNoOfMonitors() {
        if (this.myMaxNoOfMonitors == -1) {
            MessageLog.traceError(this.getClass(), (String)"maxNoOfMonitors not initialized");
        }
        return this.myMaxNoOfMonitors;
    }

    public void setPerformanceDataPath(String string) {
        MessageLog.trace((int)8, this.getClass(), (String)("setPerformanceDataPath: " + string));
        this.myPerformanceDataPath = string;
        this.pmAttributeSettingListenerMgr.setPerformanceDataPath(string);
    }

    public String getPerformanceDataPath() {
        if (this.myPerformanceDataPath == null) {
            MessageLog.traceError(this.getClass(), (String)"performanceDataPath not initialized");
        }
        return this.myPerformanceDataPath;
    }

    public void setTransactionTimeout(int n) {
        MessageLog.trace((int)8, this.getClass(), (String)("setTransactionTimeout: " + n));
        this.myTransactionTimeout = n;
    }

    public int getTransactionTimeout() {
        return this.myTransactionTimeout;
    }

    public void setMaxNoOfCounters(int n) {
        MessageLog.trace((int)8, this.getClass(), (String)("setMaxNoOfCounters: " + n));
        int n2 = this.myMaxNoOfCounters;
        this.myMaxNoOfCounters = n;
        MessageLog.trace((int)8, this.getClass(), (String)("Previous no. Of counter were: " + n2 + "And the Maximum no. Of counters are: " + this.myMaxNoOfCounters));
        if (n != n2) {
            MessageLog.trace((int)8, this.getClass(), (String)"Reloading monitors because the current no. of counters are different from previous counter value");
            this.isMaxNoOfCtrValueChanged = true;
            this.pmsContext.reloadMonitors(TRACE_MSG_COUNTERS);
        }
    }

    public void setMaxNoOfCountersChanged(boolean bl) {
        this.isMaxNoOfCtrValueChanged = bl;
    }

    public void setAlarmThresholdChanged(boolean bl) {
        this.isAlarmThresholdChanged = bl;
    }

    public int getMaxNoOfCounters() {
        if (this.myMaxNoOfCounters == -1) {
            MessageLog.traceError(this.getClass(), (String)"maxNoOfCounters not initialized");
        }
        MessageLog.trace((int)8, this.getClass(), (String)("The maximum number of counters are: " + this.myMaxNoOfCounters));
        return this.myMaxNoOfCounters;
    }

    public boolean isMaxNoOfCtrValueCahnged() {
        return this.isMaxNoOfCtrValueChanged;
    }

    public void setWarningAlarmThreshold(int n) {
        MessageLog.trace((int)8, this.getClass(), (String)("setWarningAlarmThreshold: " + n));
        int n2 = this.myWarningAlarmThreshold;
        this.myWarningAlarmThreshold = n;
        MessageLog.trace((int)8, this.getClass(), (String)("Previous Threshold was: " + n2 + "And the new Threshold is: " + this.myWarningAlarmThreshold));
        if (n != n2) {
            MessageLog.trace((int)8, this.getClass(), (String)"Reloading monitors because the Threshold changed");
            this.isAlarmThresholdChanged = true;
            this.pmsContext.reloadMonitors(TRACE_MSG_THRESHOLD);
        }
    }

    public int getWarningAlarmThreshold() {
        if (this.myWarningAlarmThreshold == -1) {
            MessageLog.traceError(this.getClass(), (String)"warningAlarmThreshold not initialized");
        }
        return this.myWarningAlarmThreshold;
    }

    public boolean isAlarmThresholdChanged() {
        return this.isAlarmThresholdChanged;
    }

    public void setWarningAlarmCeasingLevel(int n) {
        MessageLog.trace((int)8, this.getClass(), (String)("setWarningAlarmCeasingLevel: " + n));
        int n2 = this.myWarningAlarmCeasingLevel;
        this.myWarningAlarmCeasingLevel = n;
        if (n != n2) {
            MessageLog.trace((int)8, this.getClass(), (String)"Reloading monitors because the ceasing level changed");
            this.isAlarmCeasingLevelChanged = true;
            this.pmsContext.reloadMonitors(TRACE_MSG_CEASING_LEVEL);
        }
        this.myWarningAlarmCeasingLevel = n;
    }

    public int getWarningAlarmCeasingLevel() {
        if (this.myWarningAlarmCeasingLevel == -1) {
            MessageLog.traceError(this.getClass(), (String)"warningAlarmCeasingLevel not initialized");
        }
        return this.myWarningAlarmCeasingLevel;
    }

    public void setAlarmCeasingLevelChanged(boolean bl) {
        this.isAlarmCeasingLevelChanged = bl;
    }

    public boolean isAlarmCeasingLevelChanged() {
        return this.isAlarmCeasingLevelChanged;
    }

    public void setMinorAlarmCeasingLevel(int n) {
        MessageLog.trace((int)8, this.getClass(), (String)("setMinorAlarmCeasingLevel: " + n));
        this.myMinorAlarmCeasingLevel = n;
    }

    public int getMinorAlarmCeasingLevel() {
        if (this.myMinorAlarmCeasingLevel == -1) {
            MessageLog.traceError(this.getClass(), (String)"minorAlarmCeasingLevel not initialized");
        }
        return this.myMinorAlarmCeasingLevel;
    }
}

