/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import se.ericsson.cello.faultmanagement.notification.AlarmNotification;
import se.ericsson.cello.faultmanagement.notification.LargeNumberOfCountersAlarm;
import se.ericsson.cello.faultmanagement.notification.MaxCounterLimitExceededAlarm;
import se.ericsson.cello.moframework.csnotifications.CSNotificationSubscriberMgr;
import se.ericsson.cello.moframework.csnotifications.CSNotificationSubscriberMgrFactory;
import se.ericsson.cello.moframework.csnotifications.SubscriptionFilter;
import se.ericsson.cello.moframework.csnotifications.TopologyAndAVCSubscriber;
import se.ericsson.cello.pms.generic.CounterCalculator;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.ObservationObject;
import se.ericsson.cello.pms.generic.PmLoadControl;
import se.ericsson.cello.pms.generic.PmsContext;
import se.ericsson.cello.support.debug.MessageLog;

class PmLoadControlImpl
implements PmLoadControl {
    private static CSSubscriber csSubscriber;
    private static final int PUSH_TIMEOUT = 30000;
    private static final String TRACE_MSG_SUSPEND = " is suspended due to overload";
    private PmsContext pmsContext;
    private AlarmNotification warningAlarm = null;
    private AlarmNotification minorAlarm = null;
    private List filter = new Vector();
    private Thread triggeredLoadControl = null;

    public synchronized void registerCounterCalculator(String[] stringArray, CounterCalculator counterCalculator) {
        this.pmsContext.registerCounterCalculator(stringArray, counterCalculator);
    }

    public synchronized void deregisterCounterCalculator(CounterCalculator counterCalculator) {
        this.pmsContext.deregisterCounterCalculator(counterCalculator);
    }

    public void setWarningLimit(int n) {
    }

    public int getWarningLimit() {
        return -1;
    }

    public void setWarningLimitDelta(int n) {
    }

    public int getWarningLimitDelta() {
        return -1;
    }

    public void setAlarmLimitMin(int n) {
    }

    public int getAlarmLimitMin() {
        return -1;
    }

    public void setMaxCounterLimit(int n) {
    }

    public int getMaxCounterLimit() {
        return -1;
    }

    public void triggerPmLoadControl() {
        if (this.triggeredLoadControl == null || !this.triggeredLoadControl.isAlive()) {
            this.triggeredLoadControl = new Thread((Runnable)new Timer(this), "Oms_pms_loadcontrol_triggered_thread");
            this.triggeredLoadControl.start();
            MessageLog.trace((int)8, this.getClass(), (String)"checkLoad requested from triggerPmLoadControl");
        }
    }

    synchronized void addObservations(ObservationClass[] observationClassArray, ObservationObject[] observationObjectArray) {
        int n;
        if (observationClassArray.length > 0) {
            for (n = 0; n < observationClassArray.length; ++n) {
                this.filter.add(observationClassArray[n].object_class_name);
            }
            this.setupSubscription(this.toArrayWithoutDuplicates(this.filter));
        }
        n = this.pmsContext.getNoOfActiveCounters();
        int n2 = this.pmsContext.getNoOfCountersForObservations(observationClassArray, observationObjectArray);
        this.checkWarningAlarm(n + n2);
    }

    synchronized void removeObservations(ObservationClass[] observationClassArray, ObservationObject[] observationObjectArray) {
        int n;
        if (observationClassArray.length > 0) {
            for (n = 0; n < observationClassArray.length; ++n) {
                this.filter.remove(observationClassArray[n].object_class_name);
            }
            this.setupSubscription(this.toArrayWithoutDuplicates(this.filter));
        }
        if (this.warningAlarm != null || this.minorAlarm != null) {
            n = this.pmsContext.getNoOfActiveCounters();
            int n2 = this.pmsContext.getNoOfCountersForObservations(observationClassArray, observationObjectArray);
            this.checkMinorAlarm(n - n2);
        }
    }

    synchronized void checkLoad() {
        this.checkMinorAlarm(this.pmsContext.getNoOfActiveCounters());
    }

    synchronized void checkWarningAlarm(int n) {
        MessageLog.trace((int)8, this.getClass(), (String)("check warning alarm: noOfCtrs = " + n + ", maxNoOfCtrs = " + this.pmsContext.getMaxNoOfCounters()));
        if (this.warningAlarm == null && this.minorAlarm == null) {
            Integer n2 = new Integer(this.pmsContext.getWarningAlarmThreshold());
            if ((float)n > n2.floatValue() / 100.0f * (float)this.pmsContext.getMaxNoOfCounters()) {
                this.createWarningAlarm();
            }
        } else if (this.warningAlarm != null) {
            Integer n3 = new Integer(this.pmsContext.getWarningAlarmCeasingLevel());
            if ((float)n <= n3.floatValue() / 100.0f * (float)this.pmsContext.getMaxNoOfCounters()) {
                this.ceaseWarningAlarm();
            }
        }
    }

    private void checkMinorAlarm(int n) {
        MessageLog.trace((int)8, this.getClass(), (String)("check minor alarm: noOfCtrs = " + n + ", maxNoOfCtrs = " + this.pmsContext.getMaxNoOfCounters()));
        if (this.minorAlarm == null) {
            if (n > this.pmsContext.getMaxNoOfCounters()) {
                if (this.warningAlarm != null) {
                    this.ceaseWarningAlarm();
                }
                this.createMinorAlarm();
                this.pmsContext.reloadMonitors(TRACE_MSG_SUSPEND);
                n = this.pmsContext.getNoOfActiveCounters();
                MessageLog.trace((int)8, this.getClass(), (String)("check minor alarm after suspend: noOfActiveCtrs = " + n + ", maxNoOfCtrs = " + this.pmsContext.getMaxNoOfCounters()));
                Integer n2 = new Integer(this.pmsContext.getMinorAlarmCeasingLevel());
                if ((float)n <= n2.floatValue() / 100.0f * (float)this.pmsContext.getMaxNoOfCounters()) {
                    this.ceaseMinorAlarm();
                }
            }
        } else if (this.minorAlarm != null) {
            Integer n3 = new Integer(this.pmsContext.getMinorAlarmCeasingLevel());
            if ((float)n <= n3.floatValue() / 100.0f * (float)this.pmsContext.getMaxNoOfCounters()) {
                this.ceaseMinorAlarm();
            }
        }
        this.checkWarningAlarm(n);
    }

    PmLoadControlImpl(PmsContext pmsContext) {
        this.pmsContext = pmsContext;
        this.createCSRef();
    }

    private void createCSRef() {
        csSubscriber = new CSSubscriber(this);
    }

    private void createWarningAlarm() {
        this.warningAlarm = new LargeNumberOfCountersAlarm();
        MessageLog.trace((int)8, this.getClass(), (String)"Large Number of Counters alarm created");
    }

    private void ceaseWarningAlarm() {
        if (this.warningAlarm != null) {
            this.warningAlarm.cease();
            this.warningAlarm = null;
            MessageLog.trace((int)8, this.getClass(), (String)"Large Number of Counters alarm ceased");
        }
    }

    protected void createMinorAlarm() {
        if (this.minorAlarm == null) {
            this.minorAlarm = new MaxCounterLimitExceededAlarm();
            MessageLog.trace((int)8, this.getClass(), (String)"Maximum Number of Counters Exceeded alarm created");
        }
    }

    private void ceaseMinorAlarm() {
        if (this.minorAlarm != null) {
            this.minorAlarm.cease();
            this.minorAlarm = null;
            MessageLog.trace((int)8, this.getClass(), (String)"Maximum Number of Counters Exceeded alarm ceased");
        }
    }

    private String[] toArrayWithoutDuplicates(List list) {
        HashSet hashSet = new HashSet();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        String[] stringArray = new String[hashSet.size()];
        stringArray = hashSet.toArray(new String[0]);
        return stringArray;
    }

    private synchronized void setupSubscription(String[] stringArray) {
        CSNotificationSubscriberMgr cSNotificationSubscriberMgr = CSNotificationSubscriberMgrFactory.createCSNotificationSubscriberMgr();
        cSNotificationSubscriberMgr.deregister(csSubscriber);
        if (stringArray.length > 0) {
            SubscriptionFilter subscriptionFilter = new SubscriptionFilter();
            subscriptionFilter.setMoTypes(stringArray);
            cSNotificationSubscriberMgr.register(csSubscriber, subscriptionFilter);
        }
    }

    private static class Timer
    implements Runnable {
        private PmLoadControlImpl pmCtrl;

        Timer(PmLoadControlImpl pmLoadControlImpl) {
            this.pmCtrl = pmLoadControlImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Timer timer = this;
                synchronized (timer) {
                    try {
                        this.wait(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.pmCtrl.checkLoad();
            }
            catch (Exception exception) {
                MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)exception);
            }
            catch (Error error) {
                MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)error);
            }
        }
    }

    private static class CSSubscriber
    implements TopologyAndAVCSubscriber {
        private Thread loadControl = null;
        private PmLoadControlImpl pmCtrl;

        CSSubscriber(PmLoadControlImpl pmLoadControlImpl) {
            this.pmCtrl = pmLoadControlImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startLoadControl() {
            CSSubscriber cSSubscriber = this;
            synchronized (cSSubscriber) {
                if (this.loadControl == null || !this.loadControl.isAlive()) {
                    this.loadControl = new Thread((Runnable)new Timer(this.pmCtrl), "Oms_pms_loadcontrol_thread");
                    this.loadControl.start();
                    MessageLog.trace((int)8, this.getClass(), (String)"checkLoad due to MO changes in the MIB");
                }
            }
        }

        public void moCreated(String string) {
            this.startLoadControl();
        }

        public void moDeleted(String string) {
            this.startLoadControl();
        }

        public void moChanged(String string, List list) {
        }

        public void queueOverflow() {
            MessageLog.trace((int)5, this.getClass(), (String)"Notification queue full");
            this.startLoadControl();
        }
    }
}

