/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.productinventory;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

class FileGarbageCollector {
    private static final int MAX_NO_OF_PI_FILES = 10;
    private static FileGarbageCollector theOneAndOnly = new FileGarbageCollector();

    static FileGarbageCollector instance() {
        return theOneAndOnly;
    }

    synchronized void clean(String string) {
        this.clean(new File(string));
    }

    synchronized void clean(File file) {
        int n;
        PIFilesFilter pIFilesFilter = new PIFilesFilter();
        File[] fileArray = file.listFiles(pIFilesFilter);
        if (fileArray.length < 10) {
            return;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (n = 0; n < fileArray.length; ++n) {
            arrayList.add(fileArray[n]);
        }
        Collections.sort(arrayList, new FileDateComparator());
        n = arrayList.size() - 9;
        for (int i = 0; i < n; ++i) {
            File file2 = (File)arrayList.remove(0);
            file2.delete();
        }
    }

    private FileGarbageCollector() {
    }

    static class FileDateComparator
    implements Comparator {
        FileDateComparator() {
        }

        public int compare(Object object, Object object2) {
            return (int)(((File)object).lastModified() - ((File)object2).lastModified());
        }

        public boolean equals(Object object) {
            return this.compare(this, object) == 0;
        }
    }

    static class PIFilesFilter
    implements FilenameFilter {
        PIFilesFilter() {
        }

        public boolean accept(File file, String string) {
            return string.startsWith("PI") && string.endsWith(".xml");
        }
    }
}

