/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.corba;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import org.jacorb.orb.ORB;
import se.ericsson.cello.support.corba.CelloOrb;
import se.ericsson.cello.support.corba.IORUpdater;
import se.ericsson.cello.support.corba.IpAddressHelper;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.security.corba.ORBInit;

public class IORManager {
    private static final String HOST_PATH = "/host";
    private static final String TARGET_PATH = "/c";
    private static final String IOR_FILE_URL_PATH = "/public_html/cello/ior_files/";
    private static final String ROOT_NAMING_CONTEXT_FILENAME = "nameroot.ior";
    private static final String IPV6_ROOT_NAMING_CONTEXT_FILENAME = "ipv6_nameroot.ior";
    private static final String JACORB_IOR_PROXY_HOST = "jacorb.ior_proxy_host";
    private String objectReference;
    private String ipv6ObjectReference;
    private IpAddressHelper ipAddressHelper;

    public IORManager() {
        this.ipAddressHelper = IpAddressHelper.instance();
    }

    public IORManager(IpAddressHelper ipAddressHelper) {
        this.ipAddressHelper = ipAddressHelper;
    }

    public boolean storeReference() {
        boolean bl = false;
        try {
            this.deleteIOR(ROOT_NAMING_CONTEXT_FILENAME);
            this.deleteIOR(IPV6_ROOT_NAMING_CONTEXT_FILENAME);
            this.storeDefaultIOR();
            Properties properties = ORBInit.getOrbProperties();
            if (!properties.containsKey(JACORB_IOR_PROXY_HOST)) {
                if (this.ipAddressHelper.getIpv4Address() != null) {
                    bl = this.storeIPv4IOR();
                }
                if (this.ipAddressHelper.getIPv6Address() != null) {
                    bl = this.storeIPv6IOR();
                }
            } else {
                MessageLog.info((Class)IORManager.class, (String)"jacorb.ior_proxy_host property is set");
            }
            bl = true;
        }
        catch (Exception exception) {
            MessageLog.info((Class)IORManager.class, (String)("Could not create all IOR files, " + exception.getMessage()));
        }
        return bl;
    }

    private File getIORFile(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.pathPrefix());
        stringBuffer.append(IOR_FILE_URL_PATH).append(string);
        return new File(stringBuffer.toString());
    }

    private void deleteIOR(String string) {
        File file = this.getIORFile(string);
        this.ensureDirectory(file);
        if (file.exists()) {
            MessageLog.trace((int)5, this.getClass(), (String)("Deleting file " + file.getName()));
            file.delete();
        }
    }

    public boolean storeDefaultIOR() {
        File file = this.getIORFile(ROOT_NAMING_CONTEXT_FILENAME);
        return this.storeReferenceToFile(file, this.objectReference);
    }

    private boolean storeIPv6IOR() {
        File file = this.getIORFile(IPV6_ROOT_NAMING_CONTEXT_FILENAME);
        String string = IORUpdater.updateIor(this.ipv6ObjectReference, (ORB)CelloOrb.instance().getOrb(), this.ipAddressHelper.getIPv6Address(), 0);
        return this.storeReferenceToFile(file, string);
    }

    private boolean storeIPv4IOR() {
        File file = this.getIORFile(ROOT_NAMING_CONTEXT_FILENAME);
        String string = IORUpdater.updateIor(this.objectReference, (ORB)CelloOrb.instance().getOrb(), this.ipAddressHelper.getIpv4Address(), 0);
        return this.storeReferenceToFile(file, string);
    }

    private boolean storeReferenceToFile(File file, String string) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string, 0, string.length());
            fileWriter.close();
            MessageLog.trace((int)5, this.getClass(), (String)("Storing reference " + string + " to " + file.getName()));
            return true;
        }
        catch (IOException iOException) {
            MessageLog.traceError(this.getClass(), (String)"writeFile()", (Throwable)iOException);
            return false;
        }
    }

    private String pathPrefix() {
        if (System.getProperty("SIM") == null) {
            return TARGET_PATH;
        }
        return System.getProperty("oms.javasim.root.dir", HOST_PATH);
    }

    private void ensureDirectory(File file) {
        String string;
        String string2 = file.getName();
        if (!string2.equals(string = file.getPath())) {
            File file2 = new File(string.substring(0, string.length() - string2.length()));
            file2.mkdirs();
        }
    }

    public String getIpv6ObjectReference() {
        return this.ipv6ObjectReference;
    }

    public void setIpv6ObjectReference(String string) {
        this.ipv6ObjectReference = string;
    }

    public String getObjectReference() {
        return this.objectReference;
    }

    public void setObjectReference(String string) {
        this.objectReference = string;
    }
}

