/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.corba;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import se.ericsson.cello.nia.NIAAddressInfo;
import se.ericsson.cello.nia.NIAListener;
import se.ericsson.cello.nia.NIAMgr;
import se.ericsson.cello.nia.NIAMgrFactory;
import se.ericsson.cello.oms.Oms;
import se.ericsson.cello.support.debug.MessageLog;

public class IpAddressHelper
implements NIAListener {
    private String ipv4Address;
    private String ipv6Address;
    private NIAMgr niaMgr = NIAMgrFactory.createNIAMgr();
    private static IpAddressHelper instance = new IpAddressHelper();

    public static IpAddressHelper instance() {
        return instance;
    }

    private IpAddressHelper() {
        this.niaMgr.registerSubscriber((NIAListener)this);
        this.resolveIpAddresses();
    }

    private void resolveIpAddresses() {
        NIAAddressInfo[] nIAAddressInfoArray = this.niaMgr.getNodeIpAddress();
        this.resolveIpAddresses(nIAAddressInfoArray);
    }

    private void resolveIpAddresses(NIAAddressInfo[] nIAAddressInfoArray) {
        if (nIAAddressInfoArray == null) {
            MessageLog.info((Class)IpAddressHelper.class, (String)"Could not get addresses from NIA, attempting to resolve from JVM");
            this.resolveIpAdressesFromJVM();
        } else {
            for (int i = 0; i < nIAAddressInfoArray.length; ++i) {
                if (nIAAddressInfoArray[i].isIPv4Address() && nIAAddressInfoArray[i].isValid()) {
                    this.ipv4Address = nIAAddressInfoArray[i].getNodeAddress();
                    MessageLog.info((Class)(class$se$ericsson$cello$support$corba$IpAddressHelper == null ? IpAddressHelper.class$("se.ericsson.cello.support.corba.IpAddressHelper") : class$se$ericsson$cello$support$corba$IpAddressHelper), (String)("Found IPV4:" + this.ipv4Address));
                    continue;
                }
                if (nIAAddressInfoArray[i].isIPv4Address() || !nIAAddressInfoArray[i].isValid()) continue;
                this.ipv6Address = nIAAddressInfoArray[i].getNodeAddress();
                MessageLog.info((Class)(class$se$ericsson$cello$support$corba$IpAddressHelper == null ? IpAddressHelper.class$("se.ericsson.cello.support.corba.IpAddressHelper") : class$se$ericsson$cello$support$corba$IpAddressHelper), (String)("Found IPV6:" + this.ipv6Address));
            }
        }
    }

    private void resolveIpAdressesFromJVM() {
        MessageLog.info((Class)IpAddressHelper.class, (String)"Starting IP check");
        try {
            InetAddress[] inetAddressArray = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            for (int i = 0; i < inetAddressArray.length; ++i) {
                InetAddress inetAddress = inetAddressArray[i];
                if (inetAddress instanceof Inet4Address) {
                    if (this.ipv4Address == null) {
                        this.ipv4Address = inetAddress.getHostAddress();
                        MessageLog.info((Class)(class$se$ericsson$cello$support$corba$IpAddressHelper == null ? IpAddressHelper.class$("se.ericsson.cello.support.corba.IpAddressHelper") : class$se$ericsson$cello$support$corba$IpAddressHelper), (String)("Found IPV4:" + this.ipv4Address));
                        continue;
                    }
                    MessageLog.info((Class)(class$se$ericsson$cello$support$corba$IpAddressHelper == null ? IpAddressHelper.class$("se.ericsson.cello.support.corba.IpAddressHelper") : class$se$ericsson$cello$support$corba$IpAddressHelper), (String)("Ignoring address: " + inetAddress.getHostAddress()));
                    continue;
                }
                if (inetAddress instanceof Inet6Address) {
                    if (this.ipv6Address == null) {
                        this.ipv6Address = inetAddress.getHostAddress();
                        MessageLog.info((Class)(class$se$ericsson$cello$oms$Oms == null ? IpAddressHelper.class$("se.ericsson.cello.oms.Oms") : class$se$ericsson$cello$oms$Oms), (String)("Found IPV6 :" + this.ipv6Address));
                        continue;
                    }
                    MessageLog.info((Class)(class$se$ericsson$cello$support$corba$IpAddressHelper == null ? IpAddressHelper.class$("se.ericsson.cello.support.corba.IpAddressHelper") : class$se$ericsson$cello$support$corba$IpAddressHelper), (String)("Ignoring address: " + inetAddress.getHostAddress()));
                    continue;
                }
                MessageLog.info((Class)(class$se$ericsson$cello$oms$Oms == null ? IpAddressHelper.class$("se.ericsson.cello.oms.Oms") : class$se$ericsson$cello$oms$Oms), (String)("Found something unexpeted:" + inetAddress.getClass()));
            }
        }
        catch (UnknownHostException unknownHostException) {
            MessageLog.traceError((Class)Oms.class, (String)"IP check failed", (Throwable)unknownHostException);
        }
    }

    public String getIpv4Address() {
        return this.ipv4Address;
    }

    public String getIPv6Address() {
        return this.ipv6Address;
    }

    public static boolean isIPv6(String string) {
        try {
            string = string.substring(0, string.lastIndexOf(":"));
            if (InetAddress.getByName(string) instanceof Inet4Address) {
                return false;
            }
        }
        catch (UnknownHostException unknownHostException) {
            MessageLog.trace((int)5, (Class)Oms.class, (String)("Address: " + string + " is not an known host."));
            return false;
        }
        return true;
    }

    public void notifyIpAddressChanged(NIAAddressInfo[] nIAAddressInfoArray) {
        this.resolveIpAddresses(nIAAddressInfoArray);
    }

    public void notifyIpAddressChanged(String string, String string2) {
        this.resolveIpAddresses();
    }
}

