/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.corba;

import com.prismtech.cos.CosNamingME.NameServerIpv6;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import se.ericsson.cello.support.corba.IORManager;
import se.ericsson.cello.support.corba.IORUpdater;
import se.ericsson.cello.support.corba.IpAddressHelper;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.support.debug.MessageLog;

public class NameServer {
    private NamingContext rootContext;
    private ORB myOrb;
    private IpAddressHelper ipAddressHelper = IpAddressHelper.instance();
    private static NameServer instance;
    private NamingContext rootContextIPv6;

    static synchronized NameServer instance() {
        if (instance == null) {
            instance = new NameServer();
        }
        return instance;
    }

    public NamingContext getRootNamingContext(ORB oRB) {
        return this.rootContext;
    }

    public void rebind(NameComponent[] nameComponentArray, Object object, ORB oRB) throws NotFound, CannotProceed, InvalidName {
        if (this.rootContext != null) {
            this.getRootNamingContext(oRB).rebind(nameComponentArray, object);
        }
        if (this.rootContextIPv6 != null) {
            String string = IORUpdater.updateIor(oRB.object_to_string(object), (org.jacorb.orb.ORB)oRB, this.ipAddressHelper.getIPv6Address(), 0);
            this.getRootNamingContextIpv6(oRB).rebind(nameComponentArray, oRB.string_to_object(string));
        }
    }

    NamingContext getRootNamingContextIpv6(ORB oRB) {
        if (this.rootContextIPv6 == null) {
            this.myOrb = oRB;
            this.start(this.myOrb);
        }
        return this.rootContextIPv6;
    }

    ORB getOrb() {
        return this.myOrb;
    }

    synchronized void stop() {
        this.stop(this.rootContext);
        if (this.rootContextIPv6 != null) {
            this.stop(this.rootContextIPv6);
        }
        instance = null;
        this.myOrb = null;
        this.rootContext = null;
        this.rootContextIPv6 = null;
    }

    private void stop(NamingContext namingContext) {
        NameComponent[] nameComponentArray = new NameComponent[1];
        String string = "CelloConfigurationService";
        String string2 = "CelloPmNotifications";
        String string3 = "CelloPerformanceMonitoring";
        String string4 = "CelloInventoryService";
        String string5 = "ALARM_IRP_VERSION_1_1";
        String string6 = "NOTIFICATION_IRP_VERSION_1_1";
        try {
            nameComponentArray[0] = new NameComponent(string, "");
            namingContext.unbind(nameComponentArray);
            nameComponentArray[0] = new NameComponent(string2, "");
            namingContext.unbind(nameComponentArray);
            nameComponentArray[0] = new NameComponent(string3, "");
            namingContext.unbind(nameComponentArray);
            nameComponentArray[0] = new NameComponent(string4, "");
            namingContext.unbind(nameComponentArray);
            nameComponentArray[0] = new NameComponent(string5, "");
            namingContext.unbind(nameComponentArray);
            nameComponentArray[0] = new NameComponent(string6, "");
            namingContext.unbind(nameComponentArray);
            namingContext.destroy();
        }
        catch (Exception exception) {
            MessageLog.info(this.getClass(), (String)("Exception caught when destroying rootContext: " + exception));
        }
    }

    synchronized void start(ORB oRB) {
        if (this.rootContext != null) {
            return;
        }
        this.myOrb = oRB;
        this.rootContextIPv6 = null;
        IORManager iORManager = new IORManager(this.ipAddressHelper);
        try {
            this.rootContext = NamingContextHelper.narrow((Object)com.prismtech.cos.CosNamingME.NameServer.init((ORB)this.myOrb));
            iORManager.setObjectReference(this.myOrb.object_to_string((Object)this.rootContext));
            if (this.ipAddressHelper.getIPv6Address() != null && this.ipAddressHelper.getIpv4Address() != null) {
                MessageLog.info(this.getClass(), (String)"IPv6 address detected. Starting NameServer for IPv6 references");
                this.rootContextIPv6 = NameServerIpv6.startNameServer(this.myOrb);
                iORManager.setIpv6ObjectReference(this.myOrb.object_to_string((Object)this.rootContextIPv6));
            }
            if (iORManager.storeReference()) {
                MessageLog.info(this.getClass(), (String)"Reference to CORBA NameServer stored.");
            } else {
                MessageLog.traceError(this.getClass(), (String)"Could not store CORBA NameServer reference in IOR");
            }
        }
        catch (AdapterAlreadyExists adapterAlreadyExists) {
            Assert.cppAssert(null, (String)adapterAlreadyExists.toString());
        }
        catch (ObjectAlreadyActive objectAlreadyActive) {
            Assert.cppAssert(null, (String)objectAlreadyActive.toString());
        }
        catch (ObjectNotActive objectNotActive) {
            Assert.cppAssert(null, (String)objectNotActive.toString());
        }
        catch (ServantAlreadyActive servantAlreadyActive) {
            Assert.cppAssert(null, (String)servantAlreadyActive.toString());
        }
        catch (AdapterInactive adapterInactive) {
            Assert.cppAssert(null, (String)adapterInactive.toString());
        }
        catch (InvalidPolicy invalidPolicy) {
            Assert.cppAssert(null, (String)invalidPolicy.toString());
        }
        catch (WrongPolicy wrongPolicy) {
            Assert.cppAssert(null, (String)wrongPolicy.toString());
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
            Assert.cppAssert(null, (String)invalidName.toString());
        }
    }

    private NameServer() {
    }
}

