/*
 *  COPYRIGHT
 *  ---------
 *  Copyright (C) 2008-2010 by
 *  Ericsson AB
 *
 *  The program may be used and/or copied only with the written
 *  permission from Ericsson AB, or in
 *  accordance with the terms and conditions stipulated in the
 *  agreement/contract under which the program has been supplied.
 *
 *  All rights reserved.
 *  
 *  REVISION HISTORY
 *  ----------------
 *
 *  2010-09-01 ehsake HM11102 Added to be able to run JUnit.
 *
 */

package se.ericsson.cello.viewfilecreator.log;

import se.ericsson.cello.support.debug.MessageLog;

public class Logger {
	
	

	private static final String VIEWFILECREATOR_LOG = "se.ericsson.cello.viewfilecreator.log";
	private static final int TRACE_GROUP = 1;
	
	// By default log to MessageLog. Property needs to be set to be able to run in JUnit
	private static final boolean logEnabled = !System.getProperty(VIEWFILECREATOR_LOG,"on").equalsIgnoreCase("off");
	
	private Logger() {
		
	}

	public static void trace(Class clazz, String message) {
		
		if(logEnabled) {
			MessageLog.trace(TRACE_GROUP, clazz, message);
		}
	}
	
	public static void traceError(Class clazz, String message, Exception e) {
		
		if(logEnabled) {
			MessageLog.traceError(clazz, message, e);
		}
	}
	
	public static void error(Class clazz, String message) {
		if(logEnabled) {
			MessageLog.traceError(clazz, message);
		}
	}


	public static void info(Class clazz, String message) {
		
		if(logEnabled) {
			MessageLog.info(clazz,message);
		}



		
	}

	
	



}
