/*
 *  COPYRIGHT
 *  ---------
 *  Ericsson AB 2008 All rights reserved.
 *
 * The information in this document is the property of Ericsson.
 * Except as specifically authorized in writing by Ericsson, the
 * receiver of this document shall keep the information contained
 * herein confidential and shall protect the same in whole or in
 * part from disclosure and dissemination to third parties.
 * Disclosure and disseminations to the receiver's employees shall
 * only be made on a strict need to know basis.
 *
 *
 *  REVISION HISTORY
 *  ----------------
 *
 *  Revised: Johan Flinck 14 Feb 2008
 *  Changes: First revision.
 *
 *  2008-08-11 qdengra UABtr63853 Catch a NoUpException if there is no Up (no view files either). Log this as info
 *  instead of Error.
 *
 *  2008-09-05 uabflik UABtr62664 CPPClientConfig.xml should be generated on target
 *
 *  2010-09-01 ehsake HM11102 Refactoring to separate ViewList and CPPClientConfig
 *
 *  Revised: Mats Hellberg 2011-05-23
 *  Changes: HN81332 - added xml file for loadmodules
 *  
 *  Revised: Sandeep Rana 2014-01-20
 *  Changes: HS17745 - Added filter in constructor of FilePathCreator() to avoid unwanted files in view list.
 *
 */

package se.ericsson.cello.viewfilecreator.mao;

import java.io.File;
import java.util.ArrayList;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.swmanagement.LoadModuleMo;
import se.ericsson.cello.viewfilecreator.log.Logger;


public class ViewFileProducer {

	private String viewListFileDir;
	private static final String WEB_PATH = "/cello/emas/";
	private static final String VIEW_LIST_FILE_NAME = "viewlist.txt";
	private static final String VIEW_LIST_XML_FILE_NAME = "viewlist.xml";
	private static final String VIEW_FILE_LOADER_NAME = "ViewFile";
	public static final int LoadModuleMoOTHER = 99;



	public ViewFileProducer()
	{
		viewListFileDir = System.getProperty("http.root") + WEB_PATH;

	}


	public void createViewFileList(ManagedObject[] loadModules) throws Exception
	{

		Logger.trace(getClass(), "Starting to create viewlist files");
		try {

			ArrayList viewLmFilePaths = extractViewLoadModulePaths(loadModules);
			Logger.trace(this.getClass(),"Creating directory structure for " + viewListFileDir);
			File filePath = new File(viewListFileDir);
			filePath.mkdirs();
			ViewFileListWriter viewFileListWriter = new ViewFileListWriter(new File(viewListFileDir + VIEW_LIST_FILE_NAME));
			viewFileListWriter.writeToFile(viewLmFilePaths);
			Logger.info(this.getClass(),"Viewlist file successfully created.");

			ArrayList viewLmData = extractViewLoadModuleData(loadModules);
			ViewFileListWriter viewFileListWriterXml = new ViewFileListWriter(new File(viewListFileDir + VIEW_LIST_XML_FILE_NAME));
			viewFileListWriterXml.writeToXmlFile(viewLmData);
			Logger.info(this.getClass(),"Viewlist xml file successfully created.");


		} catch (MoAccessException e) {
			Logger.traceError(getClass(), "Unable to create viewlist files", e);
			throw new Exception(e);
		}
	}

	private ArrayList extractViewLoadModulePaths(ManagedObject[] loadModules)
	throws MoAccessException {

		Logger.trace(getClass(), "Extract file paths for view LMs");
		ArrayList pathList = new ArrayList();
		FilePathCreator filePathCreator = new FilePathCreator(FilePathCreator.FILTER_JAR_FILES);
		for (int i = 0; i < loadModules.length; i++) {
			LoadModuleMo loadModule = (LoadModuleMo)loadModules[i];
			if((loadModule.getLoaderType(null) == LoadModuleMoOTHER) && (loadModule.getOtherLoaderName(null).equals(VIEW_FILE_LOADER_NAME)))
			{
				String loadModuleFilePath = loadModule.getLoadModuleFilePath(null);
				Logger.trace(this.getClass(),"Adding file path: " + loadModuleFilePath);
				pathList.add(filePathCreator.getPath(loadModuleFilePath));
			}
		}

		return pathList;
	}

	private ArrayList extractViewLoadModuleData(ManagedObject[] loadModules)
	throws MoAccessException {

		Logger.trace(getClass(), "Extract file paths for view LMs");
		ArrayList loadModuleData = new ArrayList();
		FilePathCreator filePathCreator = new FilePathCreator(FilePathCreator.FILTER_JAR_FILES);
		for (int i = 0; i < loadModules.length; i++) {
			LoadModuleMo loadModule = (LoadModuleMo)loadModules[i];
			if((loadModule.getLoaderType(null) == LoadModuleMoOTHER) && (loadModule.getOtherLoaderName(null).equals(VIEW_FILE_LOADER_NAME)))
			{
				String loadModuleFilePath = loadModule.getLoadModuleFilePath(null);
				Struct productData = (Struct)loadModule.getProductData(null);
				String productNumber = (String)productData.getValue(LoadModuleMo.PRODUCT_NUMBER);
				String productName = (String)productData.getValue(LoadModuleMo.PRODUCT_NAME);
				String productRevision = (String)productData.getValue(LoadModuleMo.PRODUCT_REVISION);
				LoadModuleData lmData = new LoadModuleData(filePathCreator.getPath(loadModuleFilePath),
						productName,
						productNumber,
						productRevision);
				Logger.trace(this.getClass(),"Adding file path: " + loadModuleFilePath);
				loadModuleData.add(lmData);
			}
		}

		return loadModuleData;
	}

}
