/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.state;

import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.model.DomainExtensionImpl;
import se.ericsson.cello.mimparser.model.MomBiDirectionalAssociationImpl;
import se.ericsson.cello.mimparser.model.MomContainmentImpl;
import se.ericsson.cello.mimparser.model.MomRelationshipImpl;
import se.ericsson.cello.mimparser.model.MomSoftLinkImpl;
import se.ericsson.cello.mimparser.model.MomSupportImpl;
import se.ericsson.cello.mimparser.model.MomUniDirectionalAssociationImpl;
import se.ericsson.cello.mimparser.state.BiDirectionalAssociationState;
import se.ericsson.cello.mimparser.state.ContainmentState;
import se.ericsson.cello.mimparser.state.DomainExtensionState;
import se.ericsson.cello.mimparser.state.MomBaseState;
import se.ericsson.cello.mimparser.state.SoftLinkState;
import se.ericsson.cello.mimparser.state.SupportState;
import se.ericsson.cello.mimparser.state.UniDirectionalAssociationState;
import se.ericsson.cello.mimparser.statemachine.StateMachine;

class RelationshipState
extends MomBaseState {
    private MomRelationshipImpl momRelationship;
    public static final String RELATIONSHIP_TAG = "relationship";
    private String[] allPossibleAssociationTypes = new String[]{"biDirectionalAssociation", "uniDirectionalAssociation", "containment", "softLink", "support"};

    public RelationshipState(MomRelationshipImpl momRelationshipImpl) {
        super(RELATIONSHIP_TAG);
        this.momRelationship = momRelationshipImpl;
    }

    public void startElement(StateMachine stateMachine, String string, Attributes attributes) {
        super.startElement(stateMachine, string, this.momRelationship);
        if (this.isAssociationType(string)) {
            this.momRelationship.setAssociationType(string);
        }
        if (string.equals("containment")) {
            MomContainmentImpl momContainmentImpl = new MomContainmentImpl(string, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            momContainmentImpl.setName(this.momRelationship.getName());
            stateMachine.getParseInfo().getMimModel().addRelationshipToBeResolved(momContainmentImpl);
            stateMachine.getParseInfo().getMimModel().addContainmentRelationshipToBeResolved(momContainmentImpl);
            stateMachine.pushState(new ContainmentState(momContainmentImpl, this.momRelationship));
        } else if (string.equals("uniDirectionalAssociation")) {
            MomUniDirectionalAssociationImpl momUniDirectionalAssociationImpl = new MomUniDirectionalAssociationImpl(string, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            momUniDirectionalAssociationImpl.setName(this.momRelationship.getName());
            stateMachine.getParseInfo().getMimModel().addRelationshipToBeResolved(momUniDirectionalAssociationImpl);
            stateMachine.getParseInfo().getMimModel().addUniDirectionalRelationShipToBeResolved(momUniDirectionalAssociationImpl);
            stateMachine.pushState(new UniDirectionalAssociationState(momUniDirectionalAssociationImpl, this.momRelationship));
        } else if (string.equals("biDirectionalAssociation")) {
            MomBiDirectionalAssociationImpl momBiDirectionalAssociationImpl = new MomBiDirectionalAssociationImpl(string, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            momBiDirectionalAssociationImpl.setName(this.momRelationship.getName());
            stateMachine.getParseInfo().getMimModel().addRelationshipToBeResolved(momBiDirectionalAssociationImpl);
            stateMachine.getParseInfo().getMimModel().addBiDirectionalAssociationToBeResolved(momBiDirectionalAssociationImpl);
            stateMachine.pushState(new BiDirectionalAssociationState(momBiDirectionalAssociationImpl, this.momRelationship));
        } else if (string.equals("softLink")) {
            MomSoftLinkImpl momSoftLinkImpl = new MomSoftLinkImpl(string, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            momSoftLinkImpl.setName(this.momRelationship.getName());
            stateMachine.getParseInfo().getMimModel().addRelationshipToBeResolved(momSoftLinkImpl);
            stateMachine.getParseInfo().getMimModel().addSoftLinkRelationShipToBeResolved(momSoftLinkImpl);
            stateMachine.pushState(new SoftLinkState(momSoftLinkImpl, this.momRelationship));
        } else if (string.equals("support")) {
            MomSupportImpl momSupportImpl = new MomSupportImpl(string, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            momSupportImpl.setName(this.momRelationship.getName());
            stateMachine.getParseInfo().getMimModel().addRelationshipToBeResolved(momSupportImpl);
            stateMachine.getParseInfo().getMimModel().addSupportRelationShipToBeResolved(momSupportImpl);
            stateMachine.pushState(new SupportState(momSupportImpl, this.momRelationship));
        } else if (string.equals("domainExtension")) {
            DomainExtensionImpl domainExtensionImpl = new DomainExtensionImpl(string, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.momRelationship.setDomain(domainExtensionImpl);
            stateMachine.pushState(new DomainExtensionState(domainExtensionImpl));
        }
    }

    private boolean isAssociationType(String string) {
        boolean bl = false;
        for (int i = 0; i < this.allPossibleAssociationTypes.length; ++i) {
            if (!string.equals(this.allPossibleAssociationTypes[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void endElement(StateMachine stateMachine, String string) {
        if (string.equals(this.getReturnTag())) {
            this.momRelationship.synchronizeAssociationClassAttributes();
            stateMachine.popState();
        }
    }
}

