/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import se.ericsson.cello.ncli.server.completion.Completer;
import se.ericsson.cello.ncli.server.completion.CompleterFactory;
import se.ericsson.cello.ncli.server.completion.CompletionHandling;
import se.ericsson.cello.ncli.server.completion.CompletionHandlingListener;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.logging.Log;

public class CompletionHandler
implements CompletionHandling {
    public void executeCompletion(String string, CompletionHandlingListener completionHandlingListener, NodeServices nodeServices) {
        Log.trace(CompletionHandler.class, "executeCompletion(" + string + ")");
        Completer completer = CompleterFactory.createCommandCompleter(nodeServices);
        try {
            completer.completeString(string);
        }
        catch (Exception exception) {
            completionHandlingListener.sendCompletionResponse(string, null);
            return;
        }
        String string2 = completer.getCompletedString();
        ArrayList arrayList = completer.getCompletionOptionList();
        String string3 = this.formatCompletionOptions(arrayList);
        completionHandlingListener.sendCompletionResponse(string2, string3);
    }

    protected String formatCompletionOptions(ArrayList arrayList) {
        if (arrayList == null) {
            return null;
        }
        Collections.sort(arrayList);
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("   ");
            stringBuffer.append((String)iterator.next());
            stringBuffer.append("\n");
        }
        if (stringBuffer.length() <= 0) {
            return null;
        }
        return stringBuffer.toString();
    }
}

