/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.cs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MoRef;
import se.ericsson.cello.mimparser.MomAction;
import se.ericsson.cello.mimparser.MomAttribute;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.MomCorbaTypeAttribute;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnum;
import se.ericsson.cello.mimparser.MomEnumRef;
import se.ericsson.cello.mimparser.MomParameter;
import se.ericsson.cello.mimparser.MomRelationship;
import se.ericsson.cello.mimparser.MomSequence;
import se.ericsson.cello.mimparser.MomStruct;
import se.ericsson.cello.mimparser.MomStructMember;
import se.ericsson.cello.mimparser.MomStructRef;
import se.ericsson.cello.ncli.server.command.mogroup.MoGroup;
import se.ericsson.cello.ncli.server.cs.NameValueHelper;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.exceptions.ResolveFailureException;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.NameValueFactory;
import se.ericsson.cello.neal.cm.Struct;

public class TypeResolver {
    private NodeServices nodeServices;
    public static final String RESOLVE_PREFIX = "-=NCLI=-";

    public TypeResolver(NodeServices nodeServices) {
        this.nodeServices = nodeServices;
    }

    public void resolveAttributeType(String string, ArrayList arrayList) throws ResolveFailureException {
        MimModel mimModel = null;
        try {
            mimModel = this.nodeServices.getMimModel();
        }
        catch (Exception exception) {
            throw new ResolveFailureException(exception.getMessage());
        }
        MomClass momClass = this.findClass(string, mimModel);
        MomAttribute momAttribute = null;
        NameValue nameValue = null;
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            bl = false;
            nameValue = (NameValue)arrayList.get(i);
            if (!this.resolveNeeded(nameValue)) continue;
            Iterator iterator = momClass.getAttributes();
            while (iterator.hasNext()) {
                momAttribute = (MomAttribute)iterator.next();
                if (!momAttribute.getName().equalsIgnoreCase(nameValue.getName())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new ResolveFailureException("The attribute " + nameValue.getName() + " could not be found in the class " + momClass.getName());
            }
            nameValue = this.getResolvedNameValue(momAttribute.getType(), nameValue);
            arrayList.set(i, nameValue);
        }
    }

    public void resolveParameterType(String string, String string2, ArrayList arrayList) throws ResolveFailureException {
        String string3;
        MomAction momAction = null;
        MimModel mimModel = null;
        try {
            mimModel = this.nodeServices.getMimModel();
        }
        catch (Exception exception) {
            throw new ResolveFailureException(exception);
        }
        MomClass momClass = this.findClass(string, mimModel);
        Iterator iterator = momClass.getActions();
        while (iterator.hasNext()) {
            string3 = ((MomEntity)iterator.next()).getName();
            if (!string3.toLowerCase().equals(string2.toLowerCase())) continue;
            momAction = momClass.getAction(string3);
            break;
        }
        if (momAction == null) {
            throw new ResolveFailureException("The action " + string2 + " could not be found in the class " + momClass.getName());
        }
        string3 = null;
        Iterator iterator2 = momAction.getParameters();
        for (int i = 0; i < arrayList.size(); ++i) {
            MomParameter momParameter = (MomParameter)iterator2.next();
            string3 = (NameValue)arrayList.get(i);
            if (!this.resolveNeeded((NameValue)string3)) continue;
            string3 = this.getResolvedNameValue(momParameter.getType(), (NameValue)string3);
            arrayList.set(i, string3);
        }
    }

    public String resolveGroupMoType() throws ResolveFailureException {
        try {
            MoGroup moGroup = this.nodeServices.getMoGroupHandler().getDefaultGroup();
            List list = moGroup.getGroupMembers();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (string == null) continue;
                return this.resolveMoType(string, false);
            }
            throw new ResolveFailureException("Could not resolve LDN. The group does not contain any valid MO.");
        }
        catch (Exception exception) {
            throw new ResolveFailureException(exception);
        }
    }

    public String resolveGroupRangeMoType(String string) throws ResolveFailureException {
        try {
            MoGroup moGroup = this.nodeServices.getMoGroupHandler().getDefaultGroup();
            int n = moGroup.getSize();
            int[] nArray = this.nodeServices.getAddressResolver().resolveIndexFromRange(string, n);
            for (int i = 0; i < nArray.length; ++i) {
                String string2 = moGroup.getLdnAtIndex(nArray[i]);
                if (string2 == null) continue;
                return this.resolveMoType(string2, false);
            }
            throw new ResolveFailureException("Could not resolve LDN. The group member index range does not address any valid MO.");
        }
        catch (Exception exception) {
            throw new ResolveFailureException(exception);
        }
    }

    public String resolveMoType(String string, boolean bl) throws ResolveFailureException {
        String string2 = null;
        String[] stringArray = null;
        if (!bl) {
            string2 = this.nodeServices.getAddressResolver().resolveAddress(string);
        } else {
            stringArray = this.nodeServices.getAddressResolver().getGlobalAddress(string);
            if (stringArray != null && stringArray.length > 0) {
                string2 = stringArray[0];
            }
        }
        if (string2 == null) {
            throw new ResolveFailureException("Could not resolve LDN. Illegal or non-existing MO address");
        }
        String string3 = string2;
        Mo mo = this.nodeServices.getCm().getMo(string3);
        return mo.getType();
    }

    protected NameValue getResolvedNameValue(MomEntity momEntity, NameValue nameValue) throws ResolveFailureException {
        NameValueHelper nameValueHelper = new NameValueHelper(this.nodeServices);
        nameValue = this.removePrefix(nameValue);
        int n = this.getNameValueType(momEntity);
        if (n == 13) {
            n = this.getNameValueType(((MomSequence)momEntity).getType());
            ArrayList<Object> arrayList = null;
            if (n == 11) {
                Struct[] structArray = nameValue.getStructArrayValue();
                arrayList = new ArrayList<Object>(structArray.length);
                NameValueFactory nameValueFactory = this.nodeServices.getCm().getNameValueFactory();
                for (int i = 0; i < structArray.length; ++i) {
                    NameValue nameValue2 = nameValueFactory.create(nameValue.getName(), structArray[i]);
                    NameValue nameValue3 = this.getResolvedNameValue(((MomSequence)momEntity).getType(), nameValue2);
                    arrayList.add(nameValue3.getStructValue());
                }
            } else {
                String[] stringArray = nameValue.getStringArrayValue();
                arrayList = new ArrayList(stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList.add(stringArray[i]);
                }
            }
            return nameValueHelper.createArrayNameValue(nameValue.getName(), n, arrayList);
        }
        if (n == 11) {
            NameValue[] nameValueArray = nameValue.getStructValue().getNameValueArray();
            NameValue[] nameValueArray2 = new NameValue[nameValueArray.length];
            for (int i = 0; i < nameValueArray.length; ++i) {
                Iterator iterator = ((MomStructRef)momEntity).getStruct().getMembers();
                while (iterator.hasNext()) {
                    MomStructMember momStructMember = (MomStructMember)iterator.next();
                    if (!momStructMember.getName().equals(nameValueArray[i].getName())) continue;
                    nameValueArray2[i] = this.getResolvedNameValue(momStructMember, nameValueArray[i]);
                }
            }
            Struct struct = new Struct(nameValueArray2);
            return this.nodeServices.getCm().getNameValueFactory().create(nameValue.getName(), struct);
        }
        return nameValueHelper.createSimpleNameValue(nameValue.getName(), n, nameValue.getStringValue());
    }

    protected MomClass findClass(String string, MimModel mimModel) throws ResolveFailureException {
        Iterator iterator = mimModel.getClasses();
        boolean bl = false;
        MomClass momClass = null;
        while (iterator.hasNext()) {
            momClass = (MomClass)iterator.next();
            if (!momClass.getName().equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            Log.trace(TypeResolver.class, "The class " + string + " could not be found in the MOM");
            throw new ResolveFailureException("The class " + string + " could not be found in the MOM");
        }
        return momClass;
    }

    public boolean resolveNeeded(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!this.resolveNeeded((NameValue)arrayList.get(i))) continue;
            Log.trace(TypeResolver.class, "At least one attribute is not type specified. Resolving required");
            return true;
        }
        Log.trace(TypeResolver.class, "All attributes are type specified. No resolving required");
        return false;
    }

    protected boolean resolveNeeded(NameValue nameValue) {
        boolean bl;
        block3: {
            block4: {
                block2: {
                    bl = false;
                    if (nameValue.getType() != 9) break block2;
                    if (!nameValue.getStringValue().startsWith(RESOLVE_PREFIX)) break block3;
                    bl = true;
                    break block3;
                }
                if (nameValue.getType() != 13 || nameValue.getArrayType() != 9 || nameValue.getStringArrayValue().length <= 0) break block4;
                if (!nameValue.getStringArrayValue()[0].startsWith(RESOLVE_PREFIX)) break block3;
                bl = true;
                break block3;
            }
            if (nameValue.getType() == 11) {
                NameValue[] nameValueArray = nameValue.getStructValue().getNameValueArray();
                for (int i = 0; i < nameValueArray.length; ++i) {
                    if (!this.resolveNeeded(nameValueArray[i])) continue;
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    protected NameValue removePrefix(NameValue nameValue) {
        if (this.resolveNeeded(nameValue)) {
            if (nameValue.getType() == 9) {
                String string = nameValue.getStringValue();
                string = string.substring(RESOLVE_PREFIX.length());
                nameValue.setStringValue(string);
            } else if (nameValue.getType() == 13) {
                String[] stringArray = nameValue.getStringArrayValue();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = stringArray[i].substring(RESOLVE_PREFIX.length());
                }
                nameValue.setStringArrayValue(stringArray);
            } else if (nameValue.getType() == 11) {
                NameValue[] nameValueArray = nameValue.getStructValue().getNameValueArray();
                for (int i = 0; i < nameValueArray.length; ++i) {
                    nameValueArray[i] = this.removePrefix(nameValueArray[i]);
                }
                nameValue.setStructValue(new Struct(nameValueArray));
            }
        }
        return nameValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getNameValueType(MomEntity momEntity) throws ResolveFailureException {
        int n = 0;
        if (momEntity instanceof MomCorbaTypeAttribute) {
            String string = momEntity.getXmlType();
            if (string.equals("string")) {
                return 9;
            }
            if (string.equals("long")) {
                return 5;
            }
            if (string.equals("boolean")) {
                return 1;
            }
            if (string.equals("float")) {
                return 7;
            }
            if (!string.equals("longlong")) throw new ResolveFailureException("Unsupported MomCorbaTypeAttribute type. XML type is " + momEntity.getXmlType());
            return 6;
        }
        if (momEntity instanceof MomStruct) return 11;
        if (momEntity instanceof MomStructRef) {
            return 11;
        }
        if (momEntity instanceof MomEnum) {
            return 5;
        }
        if (momEntity instanceof MomEnumRef) {
            return 5;
        }
        if (momEntity instanceof MomRelationship) {
            return 12;
        }
        if (momEntity instanceof MomClass) return 12;
        if (momEntity instanceof MoRef) {
            return 12;
        }
        if (momEntity instanceof MomSequence) {
            return 13;
        }
        if (!(momEntity instanceof MomStructMember)) throw new ResolveFailureException("Unsupported attribute type. XML type is " + momEntity.getXmlType());
        return this.getNameValueType(((MomStructMember)momEntity).getValue());
    }
}

