/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.session;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import se.ericsson.cello.ncli.server.exceptions.NcliException;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.ncli.server.session.Message;
import se.ericsson.cello.ncli.server.session.SignalProtocolListener;

public class MessageHandler {
    protected DataInputStream input;
    protected DataOutputStream output;
    protected Message message;
    protected SignalProtocolListener protocolListener;
    protected BufferedReader dataReader;
    protected char[] recBuf;
    protected Socket socket;
    protected String prompt = "\u0003>";
    private int payLoadCounter = 0;
    private boolean initialized = false;

    public MessageHandler(Socket socket) {
        this.socket = socket;
        this.message = new Message();
        this.recBuf = new char[16400];
    }

    public void actOnInput() throws NcliException {
        Log.trace(MessageHandler.class, "actOnInput()");
        switch (this.message.getSignal()) {
            case 1: {
                this.protocolListener.onConnReq(this.message.getData());
                break;
            }
            case 3: {
                this.protocolListener.onCmdReq(this.message.getData());
                break;
            }
            case 9: {
                this.protocolListener.onComplReq(this.message.getData());
                break;
            }
            case 5: {
                this.protocolListener.onDiscReq();
                break;
            }
            case 12: {
                this.protocolListener.onHistoryUp();
                break;
            }
            case 13: {
                this.protocolListener.onHistoryDown();
                break;
            }
            case 15: {
                break;
            }
            default: {
                throw new NcliException("Unknown signal: " + this.message.getSignal());
            }
        }
    }

    public void createConnAckBuffer(int n, String string) {
        this.setMessageData(2, 1, n, string);
    }

    public void createDiscAckBuffer() {
        this.setMessageData(6, 1, 0, null);
    }

    public void createCmdAckBuffer(int n, String string) throws NcliException {
        if (string == null && n == 0) {
            throw new NcliException("Empty answer buffer");
        }
        this.setMessageData(4, 1, n, string);
    }

    public void createCancelAckBuffer(int n) {
        this.setMessageData(16, 1, n, "EOT DURING PRINTOUT");
    }

    public void createPromptBuffer(String string) throws NcliException {
        if (string == null) {
            throw new NcliException("Prompt prefix is null");
        }
        this.prompt = string + "\u0003>";
        this.setMessageData(0, 1, 0, this.prompt);
    }

    public void createConfirmReqBuffer(String string) throws NcliException {
        if (string == null) {
            throw new NcliException("Invalid command string");
        }
        this.setMessageData(7, 1, 0, string);
    }

    public void createDiscReqBuffer(String string) {
        this.setMessageData(5, 1, 0, string);
    }

    public void createComplCmdLineAckBuffer(String string) {
        this.setMessageData(10, 1, 0, string);
    }

    public void createComplOptionListAckBuffer(String string) {
        this.setMessageData(11, 1, 0, string);
    }

    public void createHistoryBrowseAckBuffer(String string) {
        this.setMessageData(14, 1, 0, string);
    }

    public void readMessage() throws IOException {
        this.readMessage(this.message);
    }

    protected void readMessage(Message message) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Log.trace(MessageHandler.class, "Waiting for message");
        message.setSignal(this.input.readInt());
        message.setVersion(this.input.readInt());
        message.setError(this.input.readInt());
        message.setLength(this.input.readInt());
        n3 = message.getLength();
        Log.trace(MessageHandler.class, "readMessage(): msglength = " + n3);
        if (n3 > 16384) {
            Log.error(MessageHandler.class, "Payload exceeds max size, ignoring");
            message.setData(null);
        } else if (n3 > 0) {
            while (n < n3) {
                n2 = this.dataReader.read(this.recBuf, n, n3 - n);
                Log.trace(class$se$ericsson$cello$ncli$server$session$MessageHandler == null ? MessageHandler.class$("se.ericsson.cello.ncli.server.session.MessageHandler") : class$se$ericsson$cello$ncli$server$session$MessageHandler, "### bytesRead = " + n2 + " ####");
                Log.trace(class$se$ericsson$cello$ncli$server$session$MessageHandler == null ? MessageHandler.class$("se.ericsson.cello.ncli.server.session.MessageHandler") : class$se$ericsson$cello$ncli$server$session$MessageHandler, "### totalBytesRead = " + (n += n2) + " ####");
            }
            message.setData(String.valueOf(this.recBuf, 0, n3 - 1));
        } else {
            message.setData(null);
        }
    }

    public void readSpecificMessage(int n) throws IOException, NcliException {
        this.readMessage();
        if (this.message.getSignal() != n && this.message.getSignal() != 5) {
            throw new NcliException("Ncli Server received an unexpected signal " + this.message.getSignal() + " when expecting " + n);
        }
    }

    public void writeMessage() throws IOException {
        Log.trace(MessageHandler.class, "Entering writeMessage(): sending header");
        if (this.message.getLength() <= 16384) {
            this.writeMessageToStream(this.message.getSignal(), this.message.getVersion(), this.message.getError(), this.message.getData());
        } else {
            String string;
            while ((string = this.getNextPartOfPayload()) != null) {
                if (this.checkCancellation()) {
                    Log.trace(MessageHandler.class, "User has sent cancel request");
                    this.createCancelAckBuffer(0);
                    this.writeMessageToStream(this.message.getSignal(), this.message.getVersion(), this.message.getError(), this.message.getData());
                    this.payLoadCounter = 0;
                    break;
                }
                this.writeMessageToStream(this.message.getSignal(), this.message.getVersion(), this.message.getError(), string);
            }
        }
        Log.trace(MessageHandler.class, "Leaving writeMessage()");
    }

    protected boolean checkCancellation() throws IOException {
        if (this.anyMessageAvailable()) {
            Log.trace(MessageHandler.class, "Message available");
            Message message = new Message();
            this.readMessage(message);
            if (message.getSignal() == 15) {
                return true;
            }
            Log.trace(MessageHandler.class, "false");
            return false;
        }
        return false;
    }

    protected void writeMessageToStream(int n, int n2, int n3, String string) throws IOException {
        int n4 = this.output.size();
        int n5 = string == null ? 0 : string.length();
        this.output.writeInt(n);
        this.output.writeInt(n2);
        this.output.writeInt(n3);
        this.output.writeInt(n5);
        if (n5 > 0) {
            n4 = this.output.size();
            this.output.writeBytes(string);
            Log.trace(MessageHandler.class, "bytes written = " + (this.output.size() - n4));
        }
    }

    protected void setMessageData(int n, int n2, int n3, String string) {
        this.message.setSignal(n);
        this.message.setVersion(n2);
        this.message.setError(n3);
        if (string != null) {
            this.message.setLength(string.length());
            this.message.setData(string);
        } else {
            this.message.setLength(0);
            this.message.setData(null);
        }
    }

    public Message getMessage() {
        return this.message;
    }

    public boolean isConfirmationAckMessage() {
        Log.trace(MessageHandler.class, "isConfirmationAckMessage()");
        return this.message != null && this.message.getSignal() == 8;
    }

    public boolean isDisconnectRequestMessage() {
        Log.trace(MessageHandler.class, "isDisconnectRequestMessage()");
        return this.message != null && this.message.getSignal() == 5;
    }

    public boolean anyMessageAvailable() throws IOException {
        return this.input.available() > 0;
    }

    public boolean isCancelRequestMessage() {
        Log.trace(MessageHandler.class, "isCancelRequestMessage()");
        return this.message != null && this.message.getSignal() == 15;
    }

    public synchronized void init(SignalProtocolListener signalProtocolListener) throws IOException {
        if (!this.initialized) {
            this.protocolListener = signalProtocolListener;
            this.input = new DataInputStream(this.socket.getInputStream());
            this.output = new DataOutputStream(this.socket.getOutputStream());
            this.dataReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.initialized = true;
        }
    }

    public synchronized void terminate() {
        if (this.initialized) {
            try {
                this.input.close();
                this.output.close();
                this.dataReader.close();
                this.initialized = false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getNextPartOfPayload() {
        int n = this.payLoadCounter * 16384;
        int n2 = (this.payLoadCounter + 1) * 16384;
        if (this.message.getData() == null) {
            return null;
        }
        if (n >= this.message.getLength()) {
            this.payLoadCounter = 0;
            return null;
        }
        if (n2 >= this.message.getLength()) {
            ++this.payLoadCounter;
            return this.message.getData().substring(n);
        }
        ++this.payLoadCounter;
        return this.message.getData().substring(n, n2);
    }
}

