/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sync;

import se.ericsson.cello.equipment.CbuMo;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.equipment.TimingUnitMarker;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoCanNotBeDeletedException;
import se.ericsson.cello.mao.Removable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.sync.TimingUnitMo;
import se.ericsson.cello.sync.fropxy.NssCreateTuFroRsp;
import se.ericsson.cello.sync.fropxy.NssDeleteTuFroRsp;
import se.ericsson.cello.sync.fropxy.NssGetTuAttrRsp;
import se.ericsson.cello.sync.fropxy.NssSetTuGpsOutRsp;
import se.ericsson.cello.sync.fropxy.NssSetTuHptsiOutRsp;
import se.ericsson.cello.sync.fropxy.NssTuProxy;
import se.ericsson.cello.transaction.Coordinator;

public class TimingUnitMoImpl
extends ManagedObjectBase
implements TimingUnitMo,
FroInfo,
Removable,
TimingUnitMarker {
    private static NssTuProxy tuProxy = NssTuProxy.instance();
    private static final int NSS_TU_RESULT_OK = 0;
    private static final int SYNC_NOT_USED = 0;
    private static final int SYNC_CDMA = 1;
    private static final int SYNC_WCDMA = 2;
    private MoData myData;
    private StringAttribute userLabel;
    private IntegerAttribute froId;
    private static final int MO_DATA_REVISION_2_6_1 = 1;
    private static final int MO_DATA_REVISION_3_1 = 3000;
    private static final int MO_DATA_REVISION_LATEST = 3000;

    public static TimingUnitMoImpl create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        TimingUnitMoImpl.checkParent(managedObject);
        MoAttributeValidator.checkIdentity((String)"TimingUnit", (String)string);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"TimingUnit", (int)128, (int)0);
        boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"gpsOutEnabled", (AttrList)attrList, (boolean)false, (boolean)false, (String)"TimingUnit");
        boolean bl2 = MoAttributeValidator.checkAndGetBooleanAttribute((String)"hptsiOutEnabled", (AttrList)attrList, (boolean)false, (boolean)false, (String)"TimingUnit");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"TimingUnit");
        return new TimingUnitMoImpl(managedObject, string2, string, bl, bl2, coordinator);
    }

    private TimingUnitMoImpl(ManagedObject managedObject, String string, String string2, boolean bl, boolean bl2, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "TimingUnit", string2, coordinator);
        int n = 0;
        if (managedObject.getType().equals("PlugInUnit")) {
            n = ((PlugInUnitMo)managedObject).getResourceId(coordinator);
        } else if (managedObject.getType().equals("Cbu")) {
            n = ((PlugInUnitMo)managedObject.getParent()).getResourceId(coordinator);
        } else {
            throw new ValueOutOfRangeException("Fetch piuId failed, the parent is of unknown type", "TimingUnit");
        }
        this.myData = new MoData(this.getLocalDistinguishedName(), "TimingUnit", true, coordinator);
        this.userLabel = new StringAttribute("userLabel", true, string);
        this.myData.registerPersistentAttr((Attribute)this.userLabel);
        int n2 = this.createTimingUnitFro(coordinator, n, this.getSyncModeOperation(), bl, bl2);
        this.froId = new IntegerAttribute("froId", false, n2);
        this.myData.registerPersistentAttr((Attribute)this.froId);
        tuProxy.registerForNotifications(coordinator, this, this.froId.getValue(coordinator));
        this.myData.setRevision(3000);
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public TimingUnitMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.myData = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.myData, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(3000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("froId");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.froId = (IntegerAttribute)moData.getAttribute("froId");
        tuProxy.registerForNotifications(null, this, this.froId.getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        if (this.getParent().getType().equals("PlugInUnit")) {
            this.doDelete(coordinator);
        } else if (this.getParent().getType().equals("Cbu")) {
            throw new MoCanNotBeDeletedException("TimingUnit. Delete of this MO under Cbu is possible by deleting Cbu MO.");
        }
    }

    public void doDelete(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.deleteChildren(coordinator);
        NssDeleteTuFroRsp nssDeleteTuFroRsp = tuProxy.sendNssDeleteTuFroReq(coordinator.getTransactionID(), this.froId.getValue(coordinator));
        if (nssDeleteTuFroRsp == null) {
            throw new FroNotAccessibleException("TimingUnit", "NssTuFro4");
        }
        if (nssDeleteTuFroRsp.getResult() != 0) {
            throw new FroRequestFailedException("TimingUnit", "NssTuFro4", "DeleteFroReq: " + tuProxy.getResultMsg(nssDeleteTuFroRsp.getResult()), nssDeleteTuFroRsp.getResult());
        }
        tuProxy.deregisterForNotifications(coordinator, this.froId.getValue(coordinator));
        this.myData.delete(coordinator);
        super.delete(coordinator);
    }

    private void deleteChildren(Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = null;
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            if (!managedObject.getType().equals("Program")) continue;
            managedObject.delete(coordinator);
        }
    }

    private int createTimingUnitFro(Coordinator coordinator, int n, int n2, boolean bl, boolean bl2) throws MoAccessException {
        NssCreateTuFroRsp nssCreateTuFroRsp = tuProxy.sendNssCreateTuFroReq(coordinator.getTransactionID(), n, n2, bl, bl2);
        if (nssCreateTuFroRsp == null) {
            throw new FroNotAccessibleException("TimingUnit", "NssTuFro4");
        }
        if (nssCreateTuFroRsp.getResult() != 0) {
            throw new FroRequestFailedException("TimingUnit", "NssTuFro4", "CreateFroReq: " + tuProxy.getResultMsg(nssCreateTuFroRsp.getResult()), nssCreateTuFroRsp.getResult());
        }
        return nssCreateTuFroRsp.getFroId();
    }

    public String getType() {
        return "TimingUnit";
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"TimingUnit", (int)128, (int)0);
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = coordinator == null ? 0 : coordinator.getTransactionID();
        NssGetTuAttrRsp nssGetTuAttrRsp = tuProxy.sendNssGetTuAttrReq(n, this.froId.getValue(coordinator));
        if (nssGetTuAttrRsp == null) {
            throw new FroNotAccessibleException("TimingUnit", "NssTuFro4");
        }
        if (nssGetTuAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("TimingUnit", "NssTuFro4", "GetAttrReq: " + tuProxy.getResultMsg(nssGetTuAttrRsp.getResult()), nssGetTuAttrRsp.getResult());
        }
        return nssGetTuAttrRsp.getOperationalState();
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = coordinator == null ? 0 : coordinator.getTransactionID();
        NssGetTuAttrRsp nssGetTuAttrRsp = tuProxy.sendNssGetTuAttrReq(n, this.froId.getValue(coordinator));
        if (nssGetTuAttrRsp == null) {
            throw new FroNotAccessibleException("TimingUnit", "NssTuFro4");
        }
        if (nssGetTuAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("TimingUnit", "NssTuFro4", "GetAttrReq: " + tuProxy.getResultMsg(nssGetTuAttrRsp.getResult()), nssGetTuAttrRsp.getResult());
        }
        return nssGetTuAttrRsp.getAvailabilityStatus();
    }

    public int getTuSystemClock(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getAttributesFromFro(coordinator).getTuSystemClock();
    }

    public boolean getGpsOutEnabled(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getAttributesFromFro(coordinator).getGpsOutEnabled();
    }

    public void setGpsOutEnabled(boolean bl, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssSetTuGpsOutRsp nssSetTuGpsOutRsp = tuProxy.sendNssSetTuGpsOutReq(coordinator.getTransactionID(), this.froId.getValue(coordinator), bl);
        if (nssSetTuGpsOutRsp == null) {
            throw new FroNotAccessibleException("TimingUnit", "NssTuFro4");
        }
        if (nssSetTuGpsOutRsp.getResult() != 0) {
            throw new FroRequestFailedException("TimingUnit", "NssTuFro4", "SetGpsOutReq: " + tuProxy.getResultMsg(nssSetTuGpsOutRsp.getResult()), nssSetTuGpsOutRsp.getResult());
        }
    }

    public boolean getHptsiOutEnabled(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getAttributesFromFro(coordinator).getHptsiOutEnabled();
    }

    public void setHptsiOutEnabled(boolean bl, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssSetTuHptsiOutRsp nssSetTuHptsiOutRsp = tuProxy.sendNssSetTuHptsiOutReq(coordinator.getTransactionID(), this.froId.getValue(coordinator), bl);
        if (nssSetTuHptsiOutRsp == null) {
            throw new FroNotAccessibleException("TimingUnit", "NssTuFro4");
        }
        if (nssSetTuHptsiOutRsp.getResult() != 0) {
            throw new FroRequestFailedException("TimingUnit", "NssTuFro4", "SetHptsiOutReq: " + tuProxy.getResultMsg(nssSetTuHptsiOutRsp.getResult()), nssSetTuHptsiOutRsp.getResult());
        }
    }

    private NssGetTuAttrRsp getAttributesFromFro(Coordinator coordinator) throws MoAccessException {
        int n = coordinator == null ? 0 : coordinator.getTransactionID();
        NssGetTuAttrRsp nssGetTuAttrRsp = tuProxy.sendNssGetTuAttrReq(n, this.froId.getValue(coordinator));
        if (nssGetTuAttrRsp == null) {
            throw new FroNotAccessibleException("TimingUnit", "NssTuFro4");
        }
        if (nssGetTuAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("TimingUnit", "NssTuFro4", "GetAttrReq: " + tuProxy.getResultMsg(nssGetTuAttrRsp.getResult()), nssGetTuAttrRsp.getResult());
        }
        return nssGetTuAttrRsp;
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.froId.getValue(coordinator);
    }

    private int getSyncModeOperation() throws MoAccessException {
        if (this.getParent().getType().equals("Cbu")) {
            return 2;
        }
        return 0;
    }

    private static void checkParent(ManagedObject managedObject) throws MoAccessException {
        String[] stringArray = new String[]{"Cbu", "PlugInUnit"};
        MoAttributeValidator.checkParents((ManagedObject)managedObject, (String[])stringArray);
        if (managedObject instanceof CbuMo) {
            MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"TimingUnit", (int)1);
        }
    }
}

