/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.ipsec.mom.StructIpSecCertSpec;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.security.cppsec.esa.CertInfo;
import se.ericsson.security.cppsec.esa.EsaDataVerification;
import se.ericsson.security.cppsec.esa.EsaMessageHandler;
import se.ericsson.security.cppsec.esa.IpSecCertInfo;
import se.ericsson.security.cppsec.esa.IpSecChecksums;
import se.ericsson.security.cppsec.esa.IpSecInstallation;
import se.ericsson.security.cppsec.esa.IpSecInstallationException;
import se.ericsson.security.cppsec.esa.IpSecInstallationInputException;
import se.ericsson.security.cppsec.esa.IpSecReturnVal;
import se.ericsson.security.cppsec.esa.IpSecReturnValImpl;
import se.ericsson.security.cppsec.esa.NodeIpSecHandler;
import se.ericsson.security.cppsec.esa.NodeIpSecHandlerFactory;
import se.ericsson.security.cppsec.esa.SecurityActivationException;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;
import se.ericsson.security.cppsec.esa.checksum.IpSecChecksumCalculator;
import se.ericsson.security.cppsec.esa.encryptedcontent.EncryptedContentStorage;
import se.ericsson.security.cppsec.esa.encryptedcontent.EncryptedContentStorageMgr;
import se.ericsson.security.cppsec.esa.enrollment.CertEnroller;
import se.ericsson.security.cppsec.esa.enrollment.CertEnrollerFactory;
import se.ericsson.security.cppsec.esa.enrollment.CertEnrollmentException;
import se.ericsson.security.cppsec.esa.logger.EsaMessageSender;
import se.ericsson.security.cppsec.esa.logger.EsaReportLogger;
import se.ericsson.security.cppsec.esa.model.CertFile;
import se.ericsson.security.cppsec.esa.model.IpSec;
import se.ericsson.security.cppsec.esa.model.IpSecEnrollmentData;
import se.ericsson.security.cppsec.esa.model.IpSecFiles;
import se.ericsson.security.cppsec.esa.model.MetaData;
import se.ericsson.security.cppsec.esa.model.SecConfData;
import se.ericsson.security.cppsec.esa.model.SecurityConfigurationModel;
import se.ericsson.security.cppsec.esa.model.Validators;
import se.ericsson.security.cppsec.esa.parser.IscfDataFinder;
import se.ericsson.security.cppsec.esa.wrapper.MessageLogWrapper;
import se.ericsson.security.cppsec.esa.wrapper.MessageLogWrapperFactory;

public class IpSecInstallationImpl
implements IpSecInstallation {
    private static final String FILENAME_IPSEC = "ipsecca";
    private static final String LOOPBACK_ADDRESS = "127.0.0.1";
    private static final String DUMMY_NODE_PASSWORD = "x";
    private final NodeIpSecHandler nodeIpSecHandler;
    protected Struct[] accountInfo = null;
    private final MessageLogWrapper logger = MessageLogWrapperFactory.getLogger(this.getClass());
    protected String myUsername;
    protected String myIntegrationCode;
    protected final EsaReportLogger reportLogger = EsaReportLogger.getInstance();
    private final EsaDataVerification esaDataVerification;
    protected final EncryptedContentStorageMgr encryptedContentStorageMgr;
    protected int expectedNumberOfCerts = 1;
    protected boolean doInstallLAAD = false;
    protected SecConfData securityConfData;
    private CertEnroller certEnroller;
    private EsaMessageSender messageSender;

    protected IpSecInstallationImpl(EsaMessageHandler esaMessageHandler) {
        this.reportLogger.logMessage("IpSecInstallationImpl() is called by application.");
        this.messageSender = new EsaMessageSender(esaMessageHandler);
        this.nodeIpSecHandler = NodeIpSecHandlerFactory.getNodeIpSecHandler(this.messageSender);
        this.esaDataVerification = new EsaDataVerification();
        this.encryptedContentStorageMgr = new EncryptedContentStorageMgr("ipsec");
        this.certEnroller = CertEnrollerFactory.createIpSecCertEnroller(this.messageSender);
        this.reportLogger.logMessage("IpSecInstallationImpl() gracefully returned.");
        this.reportLogger.closeLog();
        this.logger.traceReturn("IpSecInstallationImpl()");
    }

    public IpSecChecksums calculateChecksums() throws IpSecInstallationException {
        IpSecChecksumCalculator ipSecChecksumCalculator = new IpSecChecksumCalculator();
        return ipSecChecksumCalculator.calculateIpSecChecksum();
    }

    public IpSecReturnVal install(String string, String string2, String string3, String string4, String string5) throws IpSecInstallationException, IpSecInstallationInputException {
        this.nodeIpSecHandler.setIpSecMoLdn(string5);
        return this.install(string, string2, string3, string4);
    }

    public IpSecReturnVal install(String string, String string2, String string3, String string4) throws IpSecInstallationException, IpSecInstallationInputException {
        Object object;
        this.reportLogger.setSafeLogging(false);
        this.reportLogger.logMessage("IpSecInstallation.install() called by user " + string3 + ". Path to ISCF: " + string);
        this.myIntegrationCode = string2;
        this.myUsername = string3;
        this.nodeIpSecHandler.setUserName(string3);
        this.createLocalAccountInfo();
        this.verifyPreconditions(true);
        this.parseIscf(string);
        this.verifyCorrectNode(string4, this.securityConfData.getMetaData().getLogicalName());
        this.verifyIscf(this.securityConfData.getValidators(), this.securityConfData.getMetaData(), string);
        this.nodeIpSecHandler.clearPreviousIpSecConfiguration();
        IpSec ipSec = this.securityConfData.getIpSecData();
        if (ipSec != null) {
            object = ipSec.getFiles();
            IpSecEnrollmentData ipSecEnrollmentData = ipSec.getEnrollmentData();
            try {
                if (ipSecEnrollmentData != null) {
                    this.certEnroller.setEnrollmentData(ipSecEnrollmentData);
                    this.certEnroller.setIntegrationCode(this.myIntegrationCode);
                    this.certEnroller.enroll();
                } else {
                    this.reportLogger.logMessage("No ipSecEnrollment data defined. Ignoring certificate enrollment");
                }
                ArrayList arrayList = new ArrayList();
                if (object != null) {
                    this.collectTrustedCertificates(arrayList, (IpSecFiles)object);
                }
                this.installTrustedCertificates(arrayList);
                this.waitForInstallTrustedCerts();
                this.nodeIpSecHandler.setIpSecMoAttributes(ipSec);
                this.certEnroller.waitForCertEnrollment();
                this.cleanup(false);
            }
            catch (IpSecInstallationException ipSecInstallationException) {
                this.cleanup(true);
                throw new IpSecInstallationException("Exception caught during install, cleanup performed.", ipSecInstallationException);
            }
            catch (IpSecInstallationInputException ipSecInstallationInputException) {
                this.cleanup(true);
                throw new IpSecInstallationInputException("Exception caught during install, cleanup performed.", ipSecInstallationInputException);
            }
            catch (CertEnrollmentException certEnrollmentException) {
                this.cleanup(true);
                throw new IpSecInstallationException("Exception caught during install, cleanup performed.", certEnrollmentException);
            }
        } else {
            return new IpSecReturnValImpl(0);
        }
        this.reportLogger.logMessage("IPSEC: install() gracefully returned.");
        this.reportLogger.closeLog();
        this.logger.traceReturn("install()");
        object = this.buildEnrollmentCertInfo();
        return new IpSecReturnValImpl(1, (CertInfo)object);
    }

    public void reset() throws IpSecInstallationException {
        this.reportLogger.logMessage("ipsec reset() called");
        if (this.certEnroller.isEnrolling()) {
            this.messageSender.sendMessage("Certificate enrollment is currently in progress. Waiting for enrollment to finish.");
            this.reportLogger.logMessage("Waiting for cert enrollment at ipsec reset");
            try {
                this.certEnroller.waitForCertEnrollment();
            }
            catch (CertEnrollmentException certEnrollmentException) {
                this.messageSender.sendMessage("Certificate enrollment failed while waiting to reset");
            }
        }
        this.cleanup(true);
        this.reportLogger.logMessage("ipsec reset() done");
    }

    protected boolean cleanup(boolean bl) {
        this.logger.traceEnter("ipsec cleanup");
        this.reportLogger.logMessage("Cleaning up ipsec temporary data");
        boolean bl2 = true;
        this.encryptedContentStorageMgr.deleteAllFiles();
        EsaDataVerification.deleteIpsecStateFile();
        this.expectedNumberOfCerts = 1;
        if (bl) {
            try {
                this.reportLogger.logMessage("Removing installed ipsec configuration");
                this.nodeIpSecHandler.clearPreviousIpSecConfiguration();
            }
            catch (IpSecInstallationException ipSecInstallationException) {
                this.reportLogger.logMessage("Failed to clean up ipsec configuration. Exception with message:" + ipSecInstallationException.getMessage());
                this.logger.trace(2, "Failed to clean up ipsec configuration. Exception with message:" + ipSecInstallationException.getMessage());
                bl2 = false;
            }
        }
        this.myUsername = null;
        this.nodeIpSecHandler.setUserName("");
        this.myIntegrationCode = null;
        this.logger.traceReturn("IpSecInstallation.cleanup()");
        return bl2;
    }

    protected final void createLocalAccountInfo() {
        String[] stringArray = new String[]{"password", "remoteHost", "userID"};
        Object[] objectArray = new String[]{DUMMY_NODE_PASSWORD, LOOPBACK_ADDRESS, this.myUsername};
        this.accountInfo = new Struct[]{new StructImpl(stringArray, objectArray)};
    }

    protected Struct createCertStruct(CertFile certFile) throws IpSecInstallationInputException {
        Struct struct = null;
        if (certFile != null) {
            try {
                EncryptedContentStorage encryptedContentStorage = this.encryptedContentStorageMgr.createEncryptedContentStorage(certFile.getEncryptedContent(), this.myIntegrationCode, FILENAME_IPSEC);
                String string = encryptedContentStorage.decipher();
                struct = StructIpSecCertSpec.createStruct((String)string, (String)certFile.getCertSerialNumber(), (String)certFile.getCertFingerPrint());
                this.reportLogger.logMessage("Created CertStruct for IpSec with filePath: " + string + ", serialNumber: " + certFile.getCertSerialNumber() + ", certFingerprint: " + certFile.getCertFingerPrint() + ".");
            }
            catch (SecurityActivationInputException securityActivationInputException) {
                throw new IpSecInstallationInputException("Failed to create cert structs for IpSec", securityActivationInputException);
            }
        }
        return struct;
    }

    protected void createCertStructs(List list, List list2, String string) throws IpSecInstallationInputException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Struct struct = this.createCertStruct((CertFile)iterator.next());
            if (struct == null) continue;
            this.reportLogger.logMessage(string);
            list2.add(struct);
        }
    }

    protected void collectTrustedCertificates(ArrayList arrayList, IpSecFiles ipSecFiles) throws IpSecInstallationException, IpSecInstallationInputException {
        if (ipSecFiles != null) {
            this.createCertStructs(ipSecFiles.getIpSecPeerCerts(), arrayList, "Preparing to install trusted certificates for IpSec Peers.");
        }
    }

    protected void installTrustedCertificates(ArrayList arrayList) throws IpSecInstallationException, IpSecInstallationInputException {
        try {
            if (!arrayList.isEmpty()) {
                this.messageSender.sendMessage("Installing trusted certificates.");
                this.reportLogger.logMessage("IPSEC: Installing trusted certificates.");
                Struct[] structArray = arrayList.toArray(new Struct[0]);
                this.expectedNumberOfCerts = structArray.length;
                this.nodeIpSecHandler.installTrustedCertificates(structArray, this.accountInfo);
                this.messageSender.sendMessage("Installation of trusted certificates initiated.");
                this.reportLogger.logMessage("IPSEC: Installation of trusted certificates initiated.");
            }
        }
        catch (IpSecInstallationException ipSecInstallationException) {
            throw new IpSecInstallationException("Action 'InstallTrustedCertificates' failed.", ipSecInstallationException);
        }
    }

    protected void parseIscf(String string) throws IpSecInstallationInputException {
        try {
            this.messageSender.sendMessage("Starting to parse the Initial Security Configuration file.");
            IscfDataFinder iscfDataFinder = new IscfDataFinder();
            SecurityConfigurationModel securityConfigurationModel = iscfDataFinder.createModel(string);
            securityConfigurationModel.checkConsistency();
            this.securityConfData = securityConfigurationModel.getRoot();
            this.messageSender.sendMessage("Finished parsing of the Initial Security Configuration file.");
        }
        catch (SecurityActivationInputException securityActivationInputException) {
            throw new IpSecInstallationInputException("Failed to parse file ", securityActivationInputException);
        }
    }

    protected void waitForInstallTrustedCerts() throws IpSecInstallationException {
        if (this.expectedNumberOfCerts > 0) {
            this.nodeIpSecHandler.waitForInstallTrustedCerts(this.expectedNumberOfCerts);
        }
    }

    protected void verifyCorrectNode(String string, String string2) throws IpSecInstallationInputException {
        if (string != null && !string.equals(string2)) {
            throw new IpSecInstallationInputException("The node logical name does not match the logical name in ISCF.");
        }
    }

    protected void verifyIscf(Validators validators, MetaData metaData, String string) throws IpSecInstallationException, IpSecInstallationInputException {
        try {
            this.esaDataVerification.verifyIscf(string, this.myIntegrationCode, validators.getHash(), validators.getHmac(), metaData.getCreationtime(), metaData.getNotValidAfter());
        }
        catch (SecurityActivationException securityActivationException) {
            throw new IpSecInstallationException("The ISCF is not valid at this time!", securityActivationException);
        }
        catch (SecurityActivationInputException securityActivationInputException) {
            throw new IpSecInstallationInputException("The ISCF is not valid at this time!", securityActivationInputException);
        }
    }

    protected void verifyPreconditions(boolean bl) throws IpSecInstallationException, IpSecInstallationInputException {
        if (bl && (this.myIntegrationCode == null || "".equals(this.myIntegrationCode))) {
            throw new IpSecInstallationInputException("The activation code is missing.");
        }
        if (this.myUsername == null || "".equals(this.myUsername)) {
            throw new IpSecInstallationInputException("Username  is missing");
        }
        this.nodeIpSecHandler.verifyPreconditions();
    }

    protected CertInfo buildEnrollmentCertInfo() throws IpSecInstallationException {
        IpSecCertInfo ipSecCertInfo = new IpSecCertInfo();
        IpSec ipSec = this.securityConfData.getIpSecData();
        if (ipSec == null) {
            return null;
        }
        IpSecEnrollmentData ipSecEnrollmentData = ipSec.getEnrollmentData();
        if (ipSecEnrollmentData == null) {
            return null;
        }
        try {
            String string = ipSec.getType();
            int n = string.equalsIgnoreCase("OAM") ? 1 : (string.equalsIgnoreCase("Traffic") ? 2 : 0);
            Struct struct = this.nodeIpSecHandler.getIpSecCertInfo();
            String string2 = (String)struct.getValue("serialNumber");
            String string3 = (String)struct.getValue("fingerprint");
            ipSecCertInfo.setCertType(n);
            ipSecCertInfo.setCertFingerPrint(string3);
            ipSecCertInfo.setCertSerialNumber(string2);
        }
        catch (Exception exception) {
            throw new IpSecInstallationException("fault when fetching ipsec enrollment cert info", exception);
        }
        return ipSecCertInfo;
    }
}

