/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.model.elements;

import org.xml.sax.Attributes;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;
import se.ericsson.security.cppsec.esa.model.Level2ConfigSettings;
import se.ericsson.security.cppsec.esa.model.Level2Data;
import se.ericsson.security.cppsec.esa.model.Level2Files;
import se.ericsson.security.cppsec.esa.model.SecEnrollmentData;
import se.ericsson.security.cppsec.esa.model.elements.Level2ConfigSettingsElement;
import se.ericsson.security.cppsec.esa.model.elements.Level2FilesElement;
import se.ericsson.security.cppsec.esa.model.elements.SecEnrollmentDataElement;
import se.ericsson.security.cppsec.esa.parser.StackElement;

public class Level2DataElement
extends StackElement
implements Level2Data {
    public static final String LEVEL2 = "level2";
    private Level2ConfigSettingsElement level2ConfigSettings = null;
    private Level2FilesElement level2Files = null;
    private SecEnrollmentDataElement secEnrollmentData = null;

    protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
        StackElement stackElement = null;
        if ("level2ConfigSettings".equalsIgnoreCase(string2)) {
            this.level2ConfigSettings = stackElement = new Level2ConfigSettingsElement();
        } else if ("level2Files".equalsIgnoreCase(string2)) {
            stackElement = new Level2FilesElement();
            this.level2Files = (Level2FilesElement)stackElement;
        } else if ("secEnrollmentData".equalsIgnoreCase(string2)) {
            stackElement = new SecEnrollmentDataElement();
            this.secEnrollmentData = (SecEnrollmentDataElement)stackElement;
        }
        return stackElement;
    }

    public void checkConsistency() throws SecurityActivationInputException {
        if (this.level2ConfigSettings == null || this.level2Files == null || this.secEnrollmentData == null) {
            throw new SecurityActivationInputException("The Level2 element is not consistent - it must contain the Level2ConfigSettings, Level2Files, and the SecEnrollmentData elements");
        }
        this.level2ConfigSettings.checkConsistency();
        this.level2Files.checkConsistency();
        this.secEnrollmentData.checkConsistency();
    }

    public Level2ConfigSettings getLevel2Configuration() {
        return this.level2ConfigSettings;
    }

    public Level2Files getFiles() {
        return this.level2Files;
    }

    public SecEnrollmentData getEnrollmentData() {
        return this.secEnrollmentData;
    }
}

