/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.model.elements;

import org.xml.sax.Attributes;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;
import se.ericsson.security.cppsec.esa.model.IpSec;
import se.ericsson.security.cppsec.esa.model.MetaData;
import se.ericsson.security.cppsec.esa.model.SecConfData;
import se.ericsson.security.cppsec.esa.model.SecurityData;
import se.ericsson.security.cppsec.esa.model.Validators;
import se.ericsson.security.cppsec.esa.model.elements.BodyElement;
import se.ericsson.security.cppsec.esa.model.elements.ValidatorsElement;
import se.ericsson.security.cppsec.esa.parser.StackElement;

public class SecConfDataElement
extends StackElement
implements SecConfData {
    private static final String FILE_FORMAT_VERSION = "fileFormatVersion";
    public static final String SECCONFDATA = "secConfData";
    private ValidatorsElement validators;
    private String fileFormatVersion;
    private BodyElement bodyElement = null;

    protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
        StackElement stackElement = null;
        if ("body".equalsIgnoreCase(string2)) {
            this.bodyElement = stackElement = new BodyElement();
        } else if ("validators".equalsIgnoreCase(string2)) {
            this.validators = new ValidatorsElement();
            stackElement = this.validators;
        }
        return stackElement;
    }

    public void fetchAttributes(Attributes attributes) throws SecurityActivationInputException {
        this.fileFormatVersion = super.getRequiredAttribute(attributes, FILE_FORMAT_VERSION);
        this.validateAttributes();
    }

    protected void validateAttributes() throws SecurityActivationInputException {
        if (!this.fileFormatVersion.equalsIgnoreCase("1.0")) {
            throw new SecurityActivationInputException("The SecConfData attribute fileFormatVersion is invalid - " + this.fileFormatVersion);
        }
    }

    public void checkConsistency() throws SecurityActivationInputException {
        if (this.bodyElement == null) {
            throw new SecurityActivationInputException("The SecConfData element is not consistent - must contain a Body element");
        }
        this.bodyElement.checkConsistency();
        if (this.validators == null) {
            throw new SecurityActivationInputException("The SecConfData element is not consistent - must contain a Validators element");
        }
        this.validators.checkConsistency();
    }

    public String getFileFormatVersion() {
        return this.fileFormatVersion;
    }

    public IpSec getIpSecData() {
        if (this.bodyElement != null) {
            return this.bodyElement.getIpSecData();
        }
        return null;
    }

    public MetaData getMetaData() {
        if (this.bodyElement != null) {
            return this.bodyElement.getMetaData();
        }
        return null;
    }

    public SecurityData getSecurityData() {
        if (this.bodyElement != null) {
            return this.bodyElement.getSecurityData();
        }
        return null;
    }

    public Validators getValidators() {
        if (this.validators != null) {
            return this.validators;
        }
        return null;
    }
}

