/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.ssl;

import com.ibm.j9.ssl.CipherSpec;
import com.ibm.j9.ssl.SSLProtocol;
import com.ibm.oti.security.provider.X509CertImpl;
import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;

public class SessionState {
    public static final byte[] DEFAULT_PROTOCOL_VERSION = SSLProtocol.SSL_PROTOCOL_VERSION;
    private String host = null;
    byte[] sessionID;
    private final long creationTime;
    private long lastAccessTime;
    private Vector peerCertificates = new Vector(0);
    CipherSpec cipherSpec = CipherSpec.NULL_SPEC;
    private byte[] masterSecret = null;
    private boolean isResumable = true;
    byte[] protocolVersion = SSLProtocol.SSL_PROTOCOL_VERSION;
    private X509Certificate[] localCertificates;

    public SessionState(String host) {
        this.lastAccessTime = this.creationTime = System.currentTimeMillis();
        this.host = host;
        this.sessionID = host.getBytes();
    }

    public String getHostName() {
        return this.host;
    }

    public byte[] getSessionID() {
        return this.sessionID;
    }

    public byte[] getMasterSecret() throws IOException {
        if (this.masterSecret == null) {
            throw new IOException(Msg.getString("K0210"));
        }
        return this.masterSecret;
    }

    public byte[] getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersin(byte[] newVersion) {
        this.protocolVersion = newVersion;
    }

    public void setLocalCertificates(X509Certificate[] localCertificates) {
        this.localCertificates = localCertificates;
    }

    public X509Certificate[] getLocalCertificates() {
        return this.localCertificates;
    }

    void setPeerCertificates(Vector peerCertificates) {
        this.peerCertificates = new Vector(peerCertificates.size());
        Enumeration e = peerCertificates.elements();
        while (e.hasMoreElements()) {
            this.peerCertificates.addElement(e.nextElement());
        }
    }

    public X509CertImpl[] getPeerCertificates() {
        X509CertImpl[] result = new X509CertImpl[this.peerCertificates.size()];
        Enumeration e = this.peerCertificates.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            result[i++] = (X509CertImpl)e.nextElement();
        }
        return result;
    }

    void setMasterSecret(byte[] masterSecret) {
        this.masterSecret = masterSecret;
    }

    void updateLastAccessTime(long accessTime) {
        this.lastAccessTime = accessTime;
    }

    public CipherSpec getCipherSpec() {
        return this.cipherSpec;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void invalidate() {
        this.isResumable = false;
    }

    public boolean isValid() {
        return this.isResumable;
    }
}

