/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.net.www.protocol.ftp;

import com.ibm.oti.net.www.protocol.ftp.FtpURLInputStream;
import com.ibm.oti.util.Msg;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;

public class FtpURLConnection
extends URLConnection {
    Socket controlSocket;
    Socket dataSocket;
    ServerSocket acceptSocket;
    InputStream ctrlInput;
    InputStream inputStream;
    OutputStream ctrlOutput;
    private String replyCode;
    private String hostName;
    int dataPort;
    private static final int FTP_PORT = 21;
    private String PASSWORD = "";
    private String USERNAME = "anonymous";
    private static final int FTP_DATAOPEN = 125;
    private static final int FTP_OPENDATA = 150;
    private static final int FTP_OK = 200;
    private static final int FTP_USERREADY = 220;
    private static final int FTP_TRANSFEROK = 226;
    private static final int FTP_PASV = 227;
    private static final int FTP_LOGGEDIN = 230;
    private static final int FTP_FILEOK = 250;
    private static final int FTP_PASWD = 331;
    private static final int FTP_DATAERROR = 451;
    private static final int FTP_ERROR = 500;
    private static final int FTP_NOTFOUND = 550;

    protected FtpURLConnection(URL url) {
        super(url);
        this.hostName = url.getHost();
        String parse = url.getUserInfo();
        if (parse != null) {
            int split = parse.indexOf(58);
            if (split >= 0) {
                this.USERNAME = parse.substring(0, split);
                this.PASSWORD = parse.substring(split + 1);
            } else {
                this.USERNAME = parse;
            }
        }
    }

    private void cd() throws IOException {
        int idx = this.url.getFile().lastIndexOf(47);
        if (idx > 0) {
            String dir = this.url.getFile().substring(0, idx);
            this.write("CWD " + dir + "\r\n");
            int reply = this.getReply();
            if (reply != 250 && dir.length() > 0 && dir.charAt(0) == '/') {
                this.write("CWD " + dir.substring(1) + "\r\n");
                reply = this.getReply();
            }
            if (reply != 250) {
                throw new IOException(Msg.getString("K0094"));
            }
        }
    }

    public void connect() throws IOException {
        int port = this.url.getPort();
        if (port <= 0) {
            port = 21;
        }
        this.controlSocket = new Socket(this.hostName, port);
        this.connected = true;
        this.ctrlOutput = this.controlSocket.getOutputStream();
        this.ctrlInput = this.controlSocket.getInputStream();
        this.login();
        this.setType();
        if (!this.getDoInput()) {
            this.cd();
        }
        try {
            this.acceptSocket = new ServerSocket(0);
            this.dataPort = this.acceptSocket.getLocalPort();
            this.port();
            this.acceptSocket.setSoTimeout(3000);
            if (this.getDoInput()) {
                this.getFile();
            } else {
                this.sendFile();
            }
            this.dataSocket = this.acceptSocket.accept();
            this.acceptSocket.close();
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new IOException(Msg.getString("K0095"));
        }
        if (this.getDoInput()) {
            this.inputStream = new FtpURLInputStream(new BufferedInputStream(this.dataSocket.getInputStream()), this.controlSocket);
        }
    }

    public String getContentType() {
        String result = FtpURLConnection.guessContentTypeFromName(this.url.getFile());
        if (result == null) {
            return "content/unknown";
        }
        return result;
    }

    private void getFile() throws IOException {
        String file = this.url.getFile();
        this.write("RETR " + file + "\r\n");
        int reply = this.getReply();
        if (reply == 550 && file.length() > 0 && file.charAt(0) == '/') {
            this.write("RETR " + file.substring(1) + "\r\n");
            reply = this.getReply();
        }
        if (reply != 150 && reply != 226) {
            throw new FileNotFoundException(Msg.getString("K0096", reply));
        }
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.inputStream;
    }

    public Permission getPermission() throws IOException {
        int port = this.url.getPort();
        if (port <= 0) {
            port = 21;
        }
        return new SocketPermission(String.valueOf(this.hostName) + ":" + port, "connect, resolve");
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.dataSocket.getOutputStream();
    }

    private int getReply() throws IOException {
        byte[] code = new byte[3];
        this.ctrlInput.read(code, 0, code.length);
        this.replyCode = new String(code, "ISO8859_1");
        boolean multiline = false;
        if (this.ctrlInput.read() == 45) {
            multiline = true;
        }
        this.readLine();
        if (multiline) {
            while (this.readMultiLine()) {
            }
        }
        return Integer.parseInt(new String(code, "ISO8859_1"));
    }

    private void login() throws IOException {
        int reply = this.getReply();
        if (reply != 220) {
            throw new IOException(Msg.getString("K0097", this.url.getHost()));
        }
        this.write("USER " + this.USERNAME + "\r\n");
        reply = this.getReply();
        if (reply != 331 && reply != 230) {
            throw new IOException(Msg.getString("K0098", this.url.getHost()));
        }
        if (reply == 331) {
            this.write("PASS " + this.PASSWORD + "\r\n");
            reply = this.getReply();
            if (reply != 200 && reply != 220 && reply != 230) {
                throw new IOException(Msg.getString("K0098", this.url.getHost()));
            }
        }
    }

    private void port() throws IOException {
        this.write("PORT " + this.controlSocket.getLocalAddress().getHostAddress().replace('.', ',') + ',' + (this.dataPort >> 8) + ',' + (this.dataPort & 0xFF) + "\r\n");
        if (this.getReply() != 200) {
            throw new IOException(Msg.getString("K0099"));
        }
    }

    private String readLine() throws IOException {
        int c;
        StringBuffer sb = new StringBuffer();
        while ((c = this.ctrlInput.read()) != 10) {
            sb.append((char)c);
        }
        return sb.toString();
    }

    private boolean readMultiLine() throws IOException {
        String line = this.readLine();
        if (line.length() < 4) {
            return true;
        }
        return !line.substring(0, 3).equals(this.replyCode) || line.charAt(3) != ' ';
    }

    private void sendFile() throws IOException {
        this.write("STOR " + this.url.getFile().substring(this.url.getFile().lastIndexOf(47) + 1, this.url.getFile().length()) + "\r\n");
        int reply = this.getReply();
        if (reply != 150 && reply != 200 && reply != 125) {
            throw new IOException(Msg.getString("K009a"));
        }
    }

    public void setDoInput(boolean newValue) {
        if (this.connected) {
            throw new IllegalAccessError();
        }
        this.doInput = newValue;
        this.doOutput = !newValue;
    }

    public void setDoOutput(boolean newValue) {
        if (this.connected) {
            throw new IllegalAccessError();
        }
        this.doOutput = newValue;
        this.doInput = !newValue;
    }

    private void setType() throws IOException {
        this.write("TYPE I\r\n");
        if (this.getReply() != 200) {
            throw new IOException(Msg.getString("K009b"));
        }
    }

    private void write(String command) throws IOException {
        this.ctrlOutput.write(command.getBytes("ISO8859_1"));
    }
}

