/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import com.ibm.oti.security.provider.PKCS1;
import com.ibm.oti.security.provider.RSAPrivateKey;
import com.ibm.oti.security.provider.RSAPublicKey;
import com.ibm.oti.util.ASN1Decoder;
import com.ibm.oti.util.ASN1Encoder;
import com.ibm.oti.util.ASN1Exception;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.util.Arrays;

public class RSAPrivateCrtKey
extends RSAPrivateKey
implements java.security.interfaces.RSAPrivateCrtKey {
    private static final long serialVersionUID = -8013128276751145578L;
    protected BigInteger publicExponent;
    protected BigInteger p;
    protected BigInteger q;
    protected BigInteger dP;
    protected BigInteger dQ;
    protected BigInteger qInv;

    public RSAPrivateCrtKey(java.security.interfaces.RSAPrivateCrtKey key) {
        super(key.getModulus(), key.getPrivateExponent());
        this.publicExponent = key.getPublicExponent();
        this.p = key.getPrimeP();
        this.q = key.getPrimeQ();
        this.dP = key.getPrimeExponentP();
        this.dQ = key.getPrimeExponentQ();
        this.qInv = key.getCrtCoefficient();
    }

    public RSAPrivateCrtKey(RSAPrivateCrtKeySpec keySpec) {
        super(keySpec.getModulus(), keySpec.getPrivateExponent());
        this.publicExponent = keySpec.getPublicExponent();
        this.p = keySpec.getPrimeP();
        this.q = keySpec.getPrimeQ();
        this.dP = keySpec.getPrimeExponentP();
        this.dQ = keySpec.getPrimeExponentQ();
        this.qInv = keySpec.getCrtCoefficient();
    }

    public RSAPrivateCrtKey(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger p, BigInteger q, BigInteger dP, BigInteger dQ, BigInteger qInv) {
        super(modulus, privateExponent);
        this.publicExponent = publicExponent;
        this.p = p;
        this.q = q;
        this.dP = dP;
        this.dQ = dQ;
        this.qInv = qInv;
    }

    public RSAPrivateCrtKey(PKCS8EncodedKeySpec encoded) throws InvalidKeySpecException {
        this.encoded = encoded.getEncoded();
        try {
            this.decodeFromPKCS8();
        }
        catch (IllegalArgumentException e) {
            throw new InvalidKeySpecException(e.getMessage());
        }
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public BigInteger getPrimeP() {
        return this.p;
    }

    public BigInteger getPrimeQ() {
        return this.q;
    }

    public BigInteger getPrimeExponentP() {
        return this.dP;
    }

    public BigInteger getPrimeExponentQ() {
        return this.dQ;
    }

    public BigInteger getCrtCoefficient() {
        return this.qInv;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public BigInteger getModulus() {
        return this.p.multiply(this.q);
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        if (this.encoded == null) {
            this.encodeToPKCS8();
        }
        return this.encoded;
    }

    public RSAPrivateKeySpec toKeySpec() {
        return new RSAPrivateCrtKeySpec(this.modulus, this.publicExponent, this.privateExponent, this.p, this.q, this.dP, this.dQ, this.qInv);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName());
        RSAPublicKey.writeParamString(this.modulus, "modulus (n)", buffer);
        RSAPublicKey.writeParamString(this.publicExponent, "public exponent (e)", buffer);
        RSAPublicKey.writeParamString(this.privateExponent, "private exponent (d)", buffer);
        RSAPublicKey.writeParamString(this.p, "prime P (P)", buffer);
        RSAPublicKey.writeParamString(this.q, "prime Q (Q)", buffer);
        RSAPublicKey.writeParamString(this.dP, "prime exponent P (dP)", buffer);
        RSAPublicKey.writeParamString(this.dQ, "prime exponent Q (dQ)", buffer);
        RSAPublicKey.writeParamString(this.qInv, "CRT coefficient (qInv)", buffer);
        return buffer.toString();
    }

    private void encodeToPKCS8() {
        ASN1Decoder.Node[] sequence;
        ASN1Decoder.Node privateKeyType = new ASN1Decoder.Node();
        privateKeyType.type = 16;
        privateKeyType.data = sequence = new ASN1Decoder.Node[9];
        int i = 0;
        while (i < sequence.length) {
            sequence[i] = new ASN1Decoder.Node();
            sequence[i].type = 2;
            switch (i) {
                case 0: {
                    sequence[i].data = BigInteger.ZERO;
                    break;
                }
                case 1: {
                    sequence[i].data = this.modulus;
                    break;
                }
                case 2: {
                    sequence[i].data = this.publicExponent;
                    break;
                }
                case 3: {
                    sequence[i].data = this.privateExponent;
                    break;
                }
                case 4: {
                    sequence[i].data = this.p;
                    break;
                }
                case 5: {
                    sequence[i].data = this.q;
                    break;
                }
                case 6: {
                    sequence[i].data = this.dP;
                    break;
                }
                case 7: {
                    sequence[i].data = this.dQ;
                    break;
                }
                case 8: {
                    sequence[i].data = this.qInv;
                }
            }
            ++i;
        }
        byte[] encodedPrivateKeyType = ASN1Encoder.encodeNode(privateKeyType);
        ASN1Decoder.Node pkcs8Type = new ASN1Decoder.Node();
        pkcs8Type.type = 16;
        pkcs8Type.data = sequence = new ASN1Decoder.Node[3];
        sequence[0] = new ASN1Decoder.Node();
        sequence[0].type = 2;
        sequence[0].data = BigInteger.ZERO;
        sequence[1] = new ASN1Decoder.Node();
        sequence[1].type = 16;
        sequence[1].data = new ASN1Decoder.Node[2];
        ((ASN1Decoder.Node[])sequence[1].data)[0] = new ASN1Decoder.Node();
        ((ASN1Decoder.Node[])sequence[1].data)[0].type = 6;
        ((ASN1Decoder.Node[])sequence[1].data)[0].data = PKCS1.OID_RSA;
        ((ASN1Decoder.Node[])sequence[1].data)[1] = new ASN1Decoder.Node();
        ((ASN1Decoder.Node[])sequence[1].data)[1].type = 5;
        ((ASN1Decoder.Node[])sequence[1].data)[1].data = null;
        sequence[2] = new ASN1Decoder.Node();
        sequence[2].type = 4;
        sequence[2].data = encodedPrivateKeyType;
        this.encoded = ASN1Encoder.encodeNode(pkcs8Type);
    }

    protected void decodeFromPKCS8() throws IllegalArgumentException {
        try {
            ASN1Decoder decoder = new ASN1Decoder(new ByteArrayInputStream(this.encoded));
            ASN1Decoder.Node pkcs8Type = decoder.readContents();
            ASN1Decoder.Node[] sequence = (ASN1Decoder.Node[])pkcs8Type.data;
            if (!((BigInteger)sequence[0].data).equals(BigInteger.ZERO)) {
                throw new IllegalArgumentException();
            }
            int[] oid = (int[])((ASN1Decoder.Node[])sequence[1].data)[0].data;
            if (!Arrays.equals(oid, PKCS1.OID_RSA)) {
                throw new IllegalArgumentException();
            }
            byte[] encodedPrivateKeyType = (byte[])sequence[2].data;
            decoder = new ASN1Decoder(new ByteArrayInputStream(encodedPrivateKeyType));
            ASN1Decoder.Node privateKeyType = decoder.readContents();
            sequence = (ASN1Decoder.Node[])privateKeyType.data;
            int i = 0;
            while (i < sequence.length) {
                switch (i) {
                    case 0: {
                        if (((BigInteger)sequence[i].data).equals(BigInteger.ZERO)) break;
                        throw new IllegalArgumentException();
                    }
                    case 1: {
                        this.modulus = (BigInteger)sequence[i].data;
                        break;
                    }
                    case 2: {
                        this.publicExponent = (BigInteger)sequence[i].data;
                        break;
                    }
                    case 3: {
                        this.privateExponent = (BigInteger)sequence[i].data;
                        break;
                    }
                    case 4: {
                        this.p = (BigInteger)sequence[i].data;
                        break;
                    }
                    case 5: {
                        this.q = (BigInteger)sequence[i].data;
                        break;
                    }
                    case 6: {
                        this.dP = (BigInteger)sequence[i].data;
                        break;
                    }
                    case 7: {
                        this.dQ = (BigInteger)sequence[i].data;
                        break;
                    }
                    case 8: {
                        this.qInv = (BigInteger)sequence[i].data;
                    }
                }
                ++i;
            }
        }
        catch (ASN1Exception aSN1Exception) {
            throw new IllegalArgumentException();
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    protected RSAPrivateCrtKey() {
    }
}

