/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class X509CertificateChain {
    LinkedList chain = null;

    public X509CertificateChain(X509Certificate subject, Collection chainCandidates) {
        if (subject == null) {
            throw new IllegalArgumentException();
        }
        this.chain = new LinkedList();
        this.chain.add(0, subject);
        if (subject.getSubjectDN().equals(subject.getIssuerDN())) {
            return;
        }
        if (chainCandidates == null) {
            return;
        }
        Principal searchDN = subject.getIssuerDN();
        X509Certificate issuer;
        while ((issuer = this.findCertForSubject(searchDN, chainCandidates)) != null) {
            this.chain.add(issuer);
            if (issuer.getSubjectDN().equals(issuer.getIssuerDN())) {
                return;
            }
            searchDN = issuer.getIssuerDN();
        }
        return;
    }

    public Iterator iterator() {
        return this.chain.iterator();
    }

    private X509Certificate findCertForSubject(Principal searchSubject, Collection candidates) {
        Iterator i = candidates.iterator();
        while (i.hasNext()) {
            X509Certificate testCert = (X509Certificate)i.next();
            if (!testCert.getSubjectDN().equals(searchSubject)) continue;
            return testCert;
        }
        return null;
    }
}

