/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.util;

import com.ibm.oti.security.provider.PKCS7;
import com.ibm.oti.security.provider.X509CertificateChain;
import com.ibm.oti.util.ASN1Decoder;
import com.ibm.oti.util.ASN1Encoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class JarUtils {
    private JarUtils() {
    }

    public static Certificate[] verifySignature(InputStream signature, InputStream signatureBlock) throws IOException, GeneralSecurityException {
        PKCS7 pkcs7;
        Certificate[] signerCertChain = null;
        byte[] sfBytes = new byte[signature.available()];
        signature.read(sfBytes, 0, sfBytes.length);
        byte[] digitalSigBytes = new byte[signatureBlock.available()];
        signatureBlock.read(digitalSigBytes, 0, digitalSigBytes.length);
        signature.close();
        signatureBlock.close();
        try {
            pkcs7 = new PKCS7(digitalSigBytes);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return signerCertChain;
        }
        PKCS7.SignerInfo[] sInfos = pkcs7.signedData().signerInfos();
        PKCS7.SignerInfo sInfo = sInfos[0];
        Principal issuer = sInfo.getIssuer();
        BigInteger issuerSerialNumber = sInfo.getSerialNumber();
        Certificate signerCert = null;
        X509Certificate testCert = null;
        Collection certs = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            certs = cf.generateCertificates(new ByteArrayInputStream(digitalSigBytes));
            Iterator i = certs.iterator();
            while (signerCert == null && i.hasNext()) {
                testCert = (X509Certificate)i.next();
                if (!testCert.getIssuerDN().equals(issuer) || !testCert.getSerialNumber().equals(issuerSerialNumber)) continue;
                signerCert = testCert;
                break;
            }
            if (signerCert == null) {
                return signerCertChain;
            }
        }
        catch (CertificateException certificateException) {
            return signerCertChain;
        }
        Signature sig = null;
        String algorithm = sInfo.signatureName();
        try {
            if (algorithm != null) {
                sig = Signature.getInstance(algorithm);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        if (sig == null) {
            try {
                algorithm = sInfo.digestEncryptionAlgorithm();
                if (algorithm == null) {
                    return signerCertChain;
                }
                sig = Signature.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return signerCertChain;
            }
        }
        try {
            sig.initVerify(signerCert.getPublicKey());
        }
        catch (InvalidKeyException invalidKeyException) {
            return signerCertChain;
        }
        ASN1Decoder.Node[] attributeNodes = sInfo.authenticatedAttributes();
        if (attributeNodes.length > 0) {
            ASN1Decoder.Node attributeSetNode = new ASN1Decoder.Node();
            attributeSetNode.type = 17;
            attributeSetNode.data = attributeNodes;
            try {
                sig.update(ASN1Encoder.encodeNode(attributeSetNode));
            }
            catch (SignatureException signatureException) {
                return signerCertChain;
            }
        }
        try {
            sig.update(sfBytes);
        }
        catch (SignatureException signatureException) {
            return signerCertChain;
        }
        byte[] existingDigest = sInfo.contentMessageDigest();
        if (existingDigest != null) {
            try {
                MessageDigest digestAlgorithm = MessageDigest.getInstance(sInfo.digestAlgorithm());
                byte[] computedDigest = digestAlgorithm.digest(sfBytes);
                if (!Arrays.equals(existingDigest, computedDigest)) {
                    throw new SignatureException();
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return signerCertChain;
            }
        }
        if (!sig.verify(sInfo.encryptedDigest())) {
            throw new SignatureException();
        }
        if (signerCert.hasUnsupportedCriticalExtension()) {
            return signerCertChain;
        }
        X509CertificateChain certChain = new X509CertificateChain((X509Certificate)signerCert, certs);
        Vector allcerts = new Vector();
        Iterator it = certChain.iterator();
        while (it.hasNext()) {
            allcerts.add((Certificate)it.next());
        }
        signerCertChain = (Certificate[])allcerts.toArray(new Certificate[0]);
        return signerCertChain;
    }

    public static byte[] getSignatureBlockBytes(byte[] encryptedDigest, Certificate[] signerCertificateChain, String digestAlgorithm, String signatureAlgorithm) throws IOException {
        return PKCS7.getASN1DEREncoded(signerCertificateChain, digestAlgorithm, signatureAlgorithm, encryptedDigest);
    }
}

